/***********************************************************************
*  Copyright (c) 2012 Allied Telesis Holdings K. K.
*  All Rights Reserved
*  
************************************************************************/
#if !defined(_ATI_MDIO_DEFINES_H_)
#define _ATI_MDIO_DEFINES_H_

/*
 * These macros fascilitate MDIO access to PHY devices 
 * which are not mapped by the Eth. switch driver. 
 *  
 * This mechanism bypasses the mapping defined in boardparams. 
 * It is useful when a non-Ethernet PHY device is connected 
 * to the MDIO interface (for example, HPNA PHY). 
 *  
 * Instead of using the boardparams mapping, PHY ID is encoded 
 * into the offset parameter of ifreq->ifr_data in the ioctl 
 * handler. If ATI_NON_ETHSW_MAPPED_PHY_TYPE_M is set, then 
 * PHY ID is retreived using ATI_NON_ETHSW_MAPPED_PHY_ID_S and
 * ATI_NON_ETHSW_MAPPED_PHY_ID_M 
 *  
 * MDIO register is also encoded into the offset parameter of 
 * ifreq->ifr_data. ATI_PHY_REG_S specifies the shift. 
 *  
 * Here's a summary of how ifreq->ifr_data.offset is constructed:
 *  
 * Bit 31:     Always set for MDIO PHY devices. 
 * Bit 30:     Set if PHY ID is encoded in this offset and no PHY ID 
 *             lookup in the switch driver table is required. 
 * Bits 17-13: PHY ID
 * Bits 12-4:  PHY register address 
 * Bits 3-0:   Switch port ID. Not used for this type of access 
 *             because PHY ID is encoded in the offset. 
 */
#define ATI_NON_ETHSW_MAPPED_PHY_TYPE_M 0x40000000
#define ATI_NON_ETHSW_MAPPED_PHY_ID_S   13
#define ATI_NON_ETHSW_MAPPED_PHY_ID_M   0x1F
#define ATI_PHY_REG_S                   0x4

#define BCM_IS_PHY_ADDR_FLAG            0x80000000

#endif

