/*
 * $Id: stat.h,v 1.25.6.1 Broadcom SDK $
 * 
 * $Copyright: Copyright 2008 Broadcom Corporation.
 *
 * <:label-BRCM:2011:DUAL/GPL:standard
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as published by
 * the Free Software Foundation (the "GPL").
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * 
 * A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
 * writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * :>
 * 
 * DO NOT EDIT THIS FILE!
 * This file is auto-generated.
 * Edits to this file will be lost when it is regenerated.
 */

#ifndef __BCM_STAT_H__
#define __BCM_STAT_H__

/* 
 * Statistics counters.
 * 
 * Note: the following RFC 2465 MIBs are not supported:
 * 
 *   snmpIpv6IfStatsInTooBigErrors,
 *   snmpIpv6IfStatsInNoRoutes,
 *   snmpIpv6IfStatsInUnknownProtos,
 *   snmpIpv6IfStatsInTruncatedPkts,
 *   snmpIpv6IfStatsInDelivers,
 *   snmpIpv6IfStatsOutRequests,
 *   snmpIpv6IfStatsOutFragOKs,
 *   snmpIpv6IfStatsOutFragFails,
 *   snmpIpv6IfStatsOutFragCreates,
 *   snmpIpv6IfStatsReasmReqds,
 *   snmpIpv6IfStatsReasmOKs,
 *   snmpIpv6IfStatsReasmFails,
 */
typedef enum bcm_stat_val_e {
    snmpIfInOctets,                     /* RFC 1213 */
    snmpIfInUcastPkts,                  /* RFC 1213 */
    snmpIfInNUcastPkts,                 /* RFC 1213 */
    snmpIfInDiscards,                   /* RFC 1213 */
    snmpIfInErrors,                     /* RFC 1213 */
    snmpIfInUnknownProtos,              /* RFC 1213 */
    snmpIfOutOctets,                    /* RFC 1213 */
    snmpIfOutUcastPkts,                 /* RFC 1213 */
    snmpIfOutNUcastPkts,                /* RFC 1213 */
    snmpIfOutDiscards,                  /* RFC 1213 */
    snmpIfOutErrors,                    /* RFC 1213 */
    snmpIfOutQLen,                      /* RFC 1213 */
    snmpIpInReceives,                   /* RFC 1213 */
    snmpIpInHdrErrors,                  /* RFC 1213 */
    snmpIpForwDatagrams,                /* RFC 1213 */
    snmpIpInDiscards,                   /* RFC 1213 */
    snmpDot1dBasePortDelayExceededDiscards, /* RFC 1493 */
    snmpDot1dBasePortMtuExceededDiscards, /* RFC 1493 */
    snmpDot1dTpPortInFrames,            /* RFC 1493 */
    snmpDot1dTpPortOutFrames,           /* RFC 1493 */
    snmpDot1dPortInDiscards,            /* RFC 1493 */
    snmpEtherStatsDropEvents,           /* RFC 1757 (EtherStat) */
    snmpEtherStatsMulticastPkts,        /* RFC 1757 (EtherStat) */
    snmpEtherStatsBroadcastPkts,        /* RFC 1757 (EtherStat) */
    snmpEtherStatsUndersizePkts,        /* RFC 1757 (EtherStat) */
    snmpEtherStatsFragments,            /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts64Octets,         /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts65to127Octets,    /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts128to255Octets,   /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts256to511Octets,   /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts512to1023Octets,  /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts1024to1518Octets, /* RFC 1757 (EtherStat) */
    snmpEtherStatsOversizePkts,         /* RFC 1757 (EtherStat) */
    snmpEtherStatsJabbers,              /* RFC 1757 (EtherStat) */
    snmpEtherStatsOctets,               /* RFC 1757 (EtherStat) */
    snmpEtherStatsPkts,                 /* RFC 1757 (EtherStat) */
    snmpEtherStatsCollisions,           /* RFC 1757 (EtherStat) */
    snmpEtherStatsCRCAlignErrors,       /* RFC 1757 (EtherStat) */
    snmpEtherStatsTXNoErrors,           /* RFC 1757 (EtherStat) */
    snmpEtherStatsRXNoErrors,           /* RFC 1757 (EtherStat) */
    snmpDot3StatsAlignmentErrors,       /* RFC 2665 */
    snmpDot3StatsFCSErrors,             /* RFC 2665 */
    snmpDot3StatsSingleCollisionFrames, /* RFC 2665 */
    snmpDot3StatsMultipleCollisionFrames, /* RFC 2665 */
    snmpDot3StatsSQETTestErrors,        /* RFC 2665 */
    snmpDot3StatsDeferredTransmissions, /* RFC 2665 */
    snmpDot3StatsLateCollisions,        /* RFC 2665 */
    snmpDot3StatsExcessiveCollisions,   /* RFC 2665 */
    snmpDot3StatsInternalMacTransmitErrors, /* RFC 2665 */
    snmpDot3StatsCarrierSenseErrors,    /* RFC 2665 */
    snmpDot3StatsFrameTooLongs,         /* RFC 2665 */
    snmpDot3StatsInternalMacReceiveErrors, /* RFC 2665 */
    snmpDot3StatsSymbolErrors,          /* RFC 2665 */
    snmpDot3ControlInUnknownOpcodes,    /* RFC 2665 */
    snmpDot3InPauseFrames,              /* RFC 2665 */
    snmpDot3OutPauseFrames,             /* RFC 2665 */
    snmpIfHCInOctets,                   /* RFC 2233 */
    snmpIfHCInUcastPkts,                /* RFC 2233 */
    snmpIfHCInMulticastPkts,            /* RFC 2233 */
    snmpIfHCInBroadcastPkts,            /* RFC 2233 */
    snmpIfHCOutOctets,                  /* RFC 2233 */
    snmpIfHCOutUcastPkts,               /* RFC 2233 */
    snmpIfHCOutMulticastPkts,           /* RFC 2233 */
    snmpIfHCOutBroadcastPckts,          /* RFC 2233 */
    snmpIpv6IfStatsInReceives,          /* RFC 2465 */
    snmpIpv6IfStatsInHdrErrors,         /* RFC 2465 */
    snmpIpv6IfStatsInAddrErrors,        /* RFC 2465 */
    snmpIpv6IfStatsInDiscards,          /* RFC 2465 */
    snmpIpv6IfStatsOutForwDatagrams,    /* RFC 2465 */
    snmpIpv6IfStatsOutDiscards,         /* RFC 2465 */
    snmpIpv6IfStatsInMcastPkts,         /* RFC 2465 */
    snmpIpv6IfStatsOutMcastPkts,        /* RFC 2465 */
    snmpBcmIPMCBridgedPckts,            /* Broadcom-specific */
    snmpBcmIPMCRoutedPckts,             /* Broadcom-specific */
    snmpBcmIPMCInDroppedPckts,          /* Broadcom-specific */
    snmpBcmIPMCOutDroppedPckts,         /* Broadcom-specific */
    snmpBcmEtherStatsPkts1519to1522Octets, /* Broadcom-specific */
    snmpBcmEtherStatsPkts1522to2047Octets, /* Broadcom-specific */
    snmpBcmEtherStatsPkts2048to4095Octets, /* Broadcom-specific */
    snmpBcmEtherStatsPkts4095to9216Octets, /* Broadcom-specific */
    snmpBcmCustomReceive0,              /* Broadcom-specific */
    snmpBcmCustomReceive1,              /* Broadcom-specific */
    snmpBcmCustomReceive2,              /* Broadcom-specific */
    snmpBcmCustomReceive3,              /* Broadcom-specific */
    snmpBcmCustomReceive4,              /* Broadcom-specific */
    snmpBcmCustomReceive5,              /* Broadcom-specific */
    snmpBcmCustomReceive6,              /* Broadcom-specific */
    snmpBcmCustomReceive7,              /* Broadcom-specific */
    snmpBcmCustomReceive8,              /* Broadcom-specific */
    snmpBcmCustomTransmit0,             /* Broadcom-specific */
    snmpBcmCustomTransmit1,             /* Broadcom-specific */
    snmpBcmCustomTransmit2,             /* Broadcom-specific */
    snmpBcmCustomTransmit3,             /* Broadcom-specific */
    snmpBcmCustomTransmit4,             /* Broadcom-specific */
    snmpBcmCustomTransmit5,             /* Broadcom-specific */
    snmpBcmCustomTransmit6,             /* Broadcom-specific */
    snmpBcmCustomTransmit7,             /* Broadcom-specific */
    snmpBcmCustomTransmit8,             /* Broadcom-specific */
    snmpBcmCustomTransmit9,             /* Broadcom-specific */
    snmpBcmCustomTransmit10,            /* Broadcom-specific */
    snmpBcmCustomTransmit11,            /* Broadcom-specific */
    snmpBcmCustomTransmit12,            /* Broadcom-specific */
    snmpBcmCustomTransmit13,            /* Broadcom-specific */
    snmpBcmCustomTransmit14,            /* Broadcom-specific */
    snmpValCount 
} bcm_stat_val_t;

#define BCM_STAT_NAME_INITIALIZER \
{ \
    "snmpIfInOctets", \
    "snmpIfInUcastPkts", \
    "snmpIfInNUcastPkts", \
    "snmpIfInDiscards", \
    "snmpIfInErrors", \
    "snmpIfInUnknownProtos", \
    "snmpIfOutOctets", \
    "snmpIfOutUcastPkts", \
    "snmpIfOutNUcastPkts", \
    "snmpIfOutDiscards", \
    "snmpIfOutErrors", \
    "snmpIfOutQLen", \
    "snmpIpInReceives", \
    "snmpIpInHdrErrors", \
    "snmpIpForwDatagrams", \
    "snmpIpInDiscards", \
    "snmpDot1dBasePortDelayExceededDiscards", \
    "snmpDot1dBasePortMtuExceededDiscards", \
    "snmpDot1dTpPortInFrames", \
    "snmpDot1dTpPortOutFrames", \
    "snmpDot1dPortInDiscards", \
    "snmpEtherStatsDropEvents", \
    "snmpEtherStatsMulticastPkts", \
    "snmpEtherStatsBroadcastPkts", \
    "snmpEtherStatsUndersizePkts", \
    "snmpEtherStatsFragments", \
    "snmpEtherStatsPkts64Octets", \
    "snmpEtherStatsPkts65to127Octets", \
    "snmpEtherStatsPkts128to255Octets", \
    "snmpEtherStatsPkts256to511Octets", \
    "snmpEtherStatsPkts512to1023Octets", \
    "snmpEtherStatsPkts1024to1518Octets", \
    "snmpEtherStatsOversizePkts", \
    "snmpEtherStatsJabbers", \
    "snmpEtherStatsOctets", \
    "snmpEtherStatsPkts", \
    "snmpEtherStatsCollisions", \
    "snmpEtherStatsCRCAlignErrors", \
    "snmpEtherStatsTXNoErrors", \
    "snmpEtherStatsRXNoErrors", \
    "snmpDot3StatsAlignmentErrors", \
    "snmpDot3StatsFCSErrors", \
    "snmpDot3StatsSingleCollisionFrames", \
    "snmpDot3StatsMultipleCollisionFrames", \
    "snmpDot3StatsSQETTestErrors", \
    "snmpDot3StatsDeferredTransmissions", \
    "snmpDot3StatsLateCollisions", \
    "snmpDot3StatsExcessiveCollisions", \
    "snmpDot3StatsInternalMacTransmitErrors", \
    "snmpDot3StatsCarrierSenseErrors", \
    "snmpDot3StatsFrameTooLongs", \
    "snmpDot3StatsInternalMacReceiveErrors", \
    "snmpDot3StatsSymbolErrors", \
    "snmpDot3ControlInUnknownOpcodes", \
    "snmpDot3InPauseFrames", \
    "snmpDot3OutPauseFrames", \
    "snmpIfHCInOctets", \
    "snmpIfHCInUcastPkts", \
    "snmpIfHCInMulticastPkts", \
    "snmpIfHCInBroadcastPkts", \
    "snmpIfHCOutOctets", \
    "snmpIfHCOutUcastPkts", \
    "snmpIfHCOutMulticastPkts", \
    "snmpIfHCOutBroadcastPckts", \
    "snmpIpv6IfStatsInReceives", \
    "snmpIpv6IfStatsInHdrErrors", \
    "snmpIpv6IfStatsInAddrErrors", \
    "snmpIpv6IfStatsInDiscards", \
    "snmpIpv6IfStatsOutForwDatagrams", \
    "snmpIpv6IfStatsOutDiscards", \
    "snmpIpv6IfStatsInMcastPkts", \
    "snmpIpv6IfStatsOutMcastPkts", \
    "snmpBcmIPMCBridgedPckts", \
    "snmpBcmIPMCRoutedPckts", \
    "snmpBcmIPMCInDroppedPckts", \
    "snmpBcmIPMCOutDroppedPckts", \
    "snmpBcmEtherStatsPkts1519to1522Octets", \
    "snmpBcmEtherStatsPkts1522to2047Octets", \
    "snmpBcmEtherStatsPkts2048to4095Octets", \
    "snmpBcmEtherStatsPkts4095to9216Octets", \
    "snmpBcmCustomReceive0", \
    "snmpBcmCustomReceive1", \
    "snmpBcmCustomReceive2", \
    "snmpBcmCustomReceive3", \
    "snmpBcmCustomReceive4", \
    "snmpBcmCustomReceive5", \
    "snmpBcmCustomReceive6", \
    "snmpBcmCustomReceive7", \
    "snmpBcmCustomReceive8", \
    "snmpBcmCustomTransmit0", \
    "snmpBcmCustomTransmit1", \
    "snmpBcmCustomTransmit2", \
    "snmpBcmCustomTransmit3", \
    "snmpBcmCustomTransmit4", \
    "snmpBcmCustomTransmit5", \
    "snmpBcmCustomTransmit6", \
    "snmpBcmCustomTransmit7", \
    "snmpBcmCustomTransmit8", \
    "snmpBcmCustomTransmit9", \
    "snmpBcmCustomTransmit10", \
    "snmpBcmCustomTransmit11", \
    "snmpBcmCustomTransmit12", \
    "snmpBcmCustomTransmit13", \
    "snmpBcmCustomTransmit14"  \
}

/*
 * Function:
 *	bcm_stat_clear
 * Description:
 *	Clear all software counters
 * Parameters:
 *	unit - Device unit number
 *  port - Zero-based device port number
 * Returns:
 *	BCM_E_xxx
 */
extern int bcm_stat_clear(
    int unit);

/*
 * Function:
 *	bcm_stat_port_clear
 * Description:
 *	Clear all software counters of a given port
 * Parameters:
 *	unit - Device unit number
 *  port - Zero-based device port number
 * Returns:
 *	BCM_E_xxx
 */
extern int bcm_stat_port_clear(
    int unit, 
    bcm_port_t port);


/*
 * Function:
 *	bcm_stat_sync
 * Description:
 *	Synchronize software counters with the hardware
 * Parameters:
 *	unit - Device unit number
 * Returns:
 *	BCM_E_xxx
 */
extern int bcm_stat_sync(
    int unit);

/*
 * Function:
 *	bcm_stat_get
 * Description:
 *	Get the specified statistics from the device
 * Parameters:
 *	unit - Device unit number
 *  port - Zero-based device port number
 *  type - Statistics type as defomed om snmp_val_t
 *  value - Counter value 
 * Returns:
 *	BCM_E_xxx
 */
extern int bcm_stat_get(
    int unit, 
    bcm_port_t port, 
    bcm_stat_val_t type, 
    unsigned long long *value);

/*
 * Function:
 *	bcm_stat_get32
 * Description:
 *	Get the specified statistics from the device
 * Parameters:
 *	unit - Device unit number
 *  port - Zero-based device port number
 *  type - Statistics type as defomed om snmp_val_t
 *  value - Counter value 
 * Returns:
 *	BCM_E_xxx
 */
extern int bcm_stat_get32(
    int unit, 
    bcm_port_t port, 
    bcm_stat_val_t type, 
    unsigned int *value);

#endif /* __BCM_STAT_H__ */
