/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * cmdline.c: Kernel command line creation using ARCS argc/argv.
 *
 * Copyright (C) 1996 David S. Miller (dm@engr.sgi.com)
 */
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/string.h>

//#include <asm/sgialib.h>
#include <asm/bootinfo.h>

#define DEBUG_CMDLINE
//#undef DEBUG_CMDLINE

#define prom_argv(index) ((char *)(long)_prom_argv[(index)])
int prom_argc;
int *_prom_argv, *_prom_envp;
char **_prom_nvRam;

char * __init prom_getcmdline(void)
{
	return arcs_cmdline;
}

static char *ignored[] = {
	"ConsoleIn=",
	"ConsoleOut=",
	"SystemPartition=",
	"OSLoader=",
	"OSLoadPartition=",
	"OSLoadFilename=",
	"OSLoadOptions="
};

static char *used_arc[][2] = {
	{ "OSLoadPartition=", "root=" },
	{ "OSLoadOptions=", "" }
};

#if defined(ATI_BSP_PERSONALITY)
typedef struct
{
	char *startAddr;
	unsigned long length;
} tAtiReservedMemoryList;
tAtiReservedMemoryList atiMemoryList[10];
int atiMemoryListCnt=0;
#endif

static char * __init move_firmware_args(char* cp)
{
	char *s;
	int actr, i;

	actr = 1; /* Always ignore argv[0] */

	while (actr < prom_argc) {
		for(i = 0; i < ARRAY_SIZE(used_arc); i++) {
			int len = strlen(used_arc[i][0]);

			if (!strncmp(prom_argv(actr), used_arc[i][0], len)) {
			/* Ok, we want it. First append the replacement... */
				strcat(cp, used_arc[i][1]);
				cp += strlen(used_arc[i][1]);
				/* ... and now the argument */
				s = strstr(prom_argv(actr), "=");
				if (s) {
					s++;
					strcpy(cp, s);
					cp += strlen(s);
				}
				*cp++ = ' ';
				break;
			}
		}
		actr++;
	}

	return cp;
}

#if defined(ATI_BSP_PERSONALITY)
static void atiConstructReserveMem(char *mem)
{
// Construct the reserved memory map
  if (!strncmp(mem, "memmap", 6))
  {
    char *s1, *s2, *mag1, *mag2;
    char cpy[32];
    unsigned long size;
    char *addr;
    int j,k;

    strncpy(cpy, mem, sizeof(cpy));
    s1 = strstr(cpy, "=");
    s2 = strstr(s1, "$");
    if (s1 && s2)
    {
      *s2 = '\0';
      s1++;
      s2++;

      mag1 = strstr(s1, "K");
      if (!mag1)
      {
        mag1 = strstr(s1, "M");
      }
      if (!mag1)
      {
        mag1 = strstr(s1, "G");
      }

      mag2 = strstr(s2, "K");
      if (!mag2)
      {
        mag2 = strstr(s2, "M");
      }
      if (!mag2)
      {
        mag2 = strstr(s2, "G");
      }
      if (mag1 && mag2)
      {
        size = simple_strtoul(s1, NULL, 10);
        addr = (char *)simple_strtoul(s2, NULL, 10);  
        switch (*mag1)
        {
        case 'K': size = size * 1024;break;
        case 'M': size = size * 1024*1024;break;
        case 'G': size = size * 1024*1024*1024;break;
        default:break;
        }
        switch (*mag2)
        {
        case 'K': addr = (char *)((unsigned long)addr * 1024);break;
        case 'M': addr = (char *)((unsigned long)addr * 1024*1024);break;
        case 'G': addr = (char *)((unsigned long)addr * 1024*1024*1024);break;
        default:break;
        }
        // Find a spot for it in the list.
        for (j=0; j < atiMemoryListCnt; j++)
        {
          if (addr < atiMemoryList[j].startAddr)
          {
            // Shift them all down
            for (k=atiMemoryListCnt; k > j; k--)
            {
              atiMemoryList[k] = atiMemoryList[k-1];
            }
            break;
          }
        }
        atiMemoryList[j].startAddr = addr;
        atiMemoryList[j].length = size;
        if (atiMemoryListCnt < 10) atiMemoryListCnt++;
      }
    }
  }
}
#endif

void __init prom_init_cmdline(void)
{
	char *cp;
	int actr, i;

	actr = 1; /* Always ignore argv[0] */

	arcs_cmdline[0] = '\0';
	cp = arcs_cmdline;
	/*
	 * Move ARC variables to the beginning to make sure they can be
	 * overridden by later arguments.
	 */
	cp = move_firmware_args(cp);

	while (actr < prom_argc) {
		for (i = 0; i < ARRAY_SIZE(ignored); i++) {
			int len = strlen(ignored[i]);

			if (!strncmp(prom_argv(actr), ignored[i], len))
				goto pic_cont;
		}
		/* Ok, we want it. */
		strcpy(cp, prom_argv(actr));
		cp += strlen(prom_argv(actr));
		*cp++ = ' ';

#if defined(ATI_BSP_PERSONALITY)
		atiConstructReserveMem(prom_argv(actr));
#endif
	pic_cont:
		actr++;
	}

	if (cp != arcs_cmdline)		/* get rid of trailing space */
		--cp;
	*cp = '\0';

#ifdef DEBUG_CMDLINE
	printk(KERN_DEBUG "prom cmdline: %s\n", arcs_cmdline);
#endif
}
