#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/seq_file.h>
#include <linux/proc_fs.h>
#include <linux/rtnetlink.h>


static struct proc_dir_entry *br_loopprot_entry = NULL;
static int    br_loopprot_enabled = 0;

extern void loopprot_netlink_down(char* name);

void br_loopprot_update(int val)
{
    br_loopprot_enabled = val;
}

int br_loopprot_enabled_get(void)
{
    return br_loopprot_enabled;
}

//void br_loopprot_handle_netdevice_events(struct net_device *ndev, unsigned long event)
//{
//    struct net_bridge *br = NULL;
//    struct net_device *dev = NULL;
//    switch (event) {
//        case NETDEV_GOING_DOWN:
//        case NETDEV_CHANGE:
//            for(dev = first_net_device(&init_net);
//                dev;
//                dev = next_net_device(dev)) {
//                br = netdev_priv(dev);
//                if((dev->priv_flags & IFF_EBRIDGE) &&
//                   (br && br->dev->name)) {
//                  if (&br->mc_list)
//                  {
//                     loopprot_netlink_down(br->dev->name);
//                  }
//                }
//            }
//    }
//
//    return;
//}

static char loopprot_addr[] = {0x00, 0x0c, 0x25, 0x03, 0x93, 0x1c};

static inline unsigned loopprot_compare_ether_addr(const u8 *addr1, const u8 *addr2)
{
    unsigned i;

	for (i=0; i<6; i++)
    {
       if (addr1[i] != addr2[i])
       {
          return 0;
       }
    }
    return 1;
}

static int loopprot_control_filter(const unsigned char *dest)
{
   if (!loopprot_compare_ether_addr(dest, (const u8 *) &loopprot_addr))
   {   
      return 0;
   }
   else
   {   
      return 1;
   }
}

int isLoopprotMac(const unsigned char *dest)
{
   return loopprot_control_filter(dest);
}


#if 0
static void looprot_dump_buf(char *buf, int len)
{
    int i;
    printk("\n========================br_loopprot_forward START len=%d===================================\n", len);
    for(i =0; i < len; i++) 
    {
     printk("%02x", (unsigned char)buf[i]);
     if(!((i+1)%2))
         printk(" ");
     if(!((i+1)%16))
       printk("\n");
    }
    printk("\n");
    printk("=======================br_loopprot_forward END====================================\n");
}
//
// if get here, already know the destination mac is the LDF mac
//
#define ETH_LEN_AND_VLAN_SIZE 4
int br_loopprot_forward(struct net_bridge *br, 
                        struct sk_buff *skb, 
                        int forward,
                        int is_routed)
{
	int    status = 0;
//	const unsigned char *dest = eth_hdr(skb)->h_dest;


//    if ((br->loopprot_config == ENABLED) && 
//             loopprot_control_filter(dest))
//    if (loopprot_control_filter(dest))
//    {
//	if ((skb->data[13] == IPPROTO_IGMP)  &&
//	    (br->igmp_proxy || br->igmp_snooping))
//    if (skb->data[13] == IPPROTO_IGMP)

// do some packet checking here, like LLC

    looprot_dump_buf(skb->data, skb->len);
//    printk("\nbp: loopprot_process_skb data=%02x:%02x:%02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x:%02x:%02x",skb->data[0],skb->data[1],skb->data[2],skb->data[3],skb->data[4],skb->data[5],
//                                                                                                         skb->data[6],skb->data[7],skb->data[8],skb->data[9],skb->data[10],skb->data[11]);
    if ((skb->data[0+ETH_LEN_AND_VLAN_SIZE] == 0) && (skb->data[1 + ETH_LEN_AND_VLAN_SIZE] == 0) && (skb->data[2 + ETH_LEN_AND_VLAN_SIZE] == 0xe3))
       { 
    	 if(skb->dev && (skb->dev->br_port))
         {

		   skb_push(skb, ETH_HLEN);

//           looprot_dump_buf(skb->data, skb->len);
//           status = loopprot_process_skb(br, skb);
    	 }
         return(status);
//   	  }

//    printk("%ds%d) ", __LINE__, status);
    }
    return status;
}
#endif

static void *loopprot_seq_start(struct seq_file *seq, loff_t *pos)
{
	struct net_device *dev;
	loff_t offs = 0;

	rtnl_lock();
	ASSERT_RTNL();
	for_each_netdev(&init_net, dev)
    {
		if ((dev->priv_flags & IFF_EBRIDGE) &&
            (*pos == offs)) { 
            return dev;
		}
	}
	++offs;
	return NULL;
}

static void *loopprot_seq_next(struct seq_file *seq, void *v, loff_t *pos)
{
	struct net_device *dev = v;

	++*pos;
	
	for(dev = next_net_device(dev); dev; dev = next_net_device(dev)) {
   	  if(dev->priv_flags & IFF_EBRIDGE)
        {
          return dev;
        }
	}
	return NULL;
}

static int loopprot_seq_show(struct seq_file *seq, void *v)
{
  	return 0;
}

static void loopprot_seq_stop(struct seq_file *seq, void *v)
{
	rtnl_unlock();
}

static struct seq_operations loopprot_seq_ops = {
	.start = loopprot_seq_start,
	.next  = loopprot_seq_next,
	.stop  = loopprot_seq_stop,
	.show  = loopprot_seq_show,
};

static int loopprot_seq_open(struct inode *inode, struct file *file)
{
	return seq_open(file, &loopprot_seq_ops);
}

static struct file_operations br_loopprot_proc_fops = {
	.owner   = THIS_MODULE,
	.open    = loopprot_seq_open,
	.read    = seq_read,
	.llseek  = seq_lseek,
	.release = seq_release,
};

void br_loopprot_init(void)
{
	br_loopprot_entry = proc_create("loopprot", 0, init_net.proc_net,
			   &br_loopprot_proc_fops);

	if(!br_loopprot_entry) {
		printk("error while creating br_loopprot_entry proc\n");
	}
}
