/*
<:copyright-gpl 
 Copyright 2009 Allied Telesis Labs.  All Rights Reserved. 
 
 This program is free software; you can distribute it and/or modify it 
 under the terms of the GNU General Public License (Version 2) as 
 published by the Free Software Foundation. 
 
 This program is distributed in the hope it will be useful, but WITHOUT 
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
 for more details. 
 
 You should have received a copy of the GNU General Public License along 
 with this program; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place - Suite 330, Boston MA 02111-1307, USA. 
:>
*/

#include <bcm_hwdefs.h>

#define  ATI_INFO_PRODUCT_NAME_LENGTH_MAX       32
#define  ATI_INFO_HW_REVISION_LENGTH_MAX        16
#define  ATI_INFO_PART_NUMBER_LENGTH_MAX        14
#define  ATI_INFO_ECO_NUMBER_LENGTH_MAX         8
#define  ATI_INFO_DEVIATION_NUMBER_LENGTH_MAX   8
#define  ATI_INFO_SERIAL_NUMBER_LENGTH_MAX      24       
#define  ATI_INFO_DEVIATION_NUMBER_ITEM         6

#define  ATI_INFO_NVDATA_MAX_SIZE (64*ONEK)

/* Used by other time functions.  */
struct sAtiTm {
    int tm_sec;                   /* Seconds.     [0-60] (1 leap second) */
    int tm_min;                   /* Minutes.     [0-59] */
    int tm_hour;                  /* Hours.       [0-23] */
    int tm_mday;                  /* Day.         [1-31] */
    int tm_mon;                   /* Month.       [0-11] */
    int tm_year;                  /* Year - 1900.  */
    int tm_wday;                  /* Day of week. [0-6] */
    int tm_yday;                  /* Days in year.[0-365] */
    int tm_isdst;                 /* DST.         [-1/0/1]*/
};

struct sAtiInfo
{
  char product_name[ATI_INFO_PRODUCT_NAME_LENGTH_MAX];
  char hw_revision[ATI_INFO_HW_REVISION_LENGTH_MAX];
  char part_number[ATI_INFO_PART_NUMBER_LENGTH_MAX];
  char eco_number[ATI_INFO_ECO_NUMBER_LENGTH_MAX];
  char deviation_number[ATI_INFO_DEVIATION_NUMBER_ITEM][ATI_INFO_DEVIATION_NUMBER_LENGTH_MAX];
  char serial_number[ATI_INFO_SERIAL_NUMBER_LENGTH_MAX];
  struct sAtiTm production_date;
  unsigned long sw_compatibility;
};

typedef struct
{
  NVRAM_DATA bcmNvRam;
  union
  {
    char buffer[ATI_INFO_NVDATA_MAX_SIZE];
  };
} ATI_NVDATA, * PATI_NVDATA;

typedef enum 
{
  atiUlong,
  atiInt,
  atiStringInd,
  atiString,
  atiTime,
  atiEmac,
  bcmUlong,
  bcmInt,
  bcmString,
  bcmTime,
  bcmEmac
} ati_info_data_type;

typedef struct
{
    char persistentLog[1];
} tAtiPersistentLogMemoryMap;

typedef struct
{
    char resetReason[1024];
    char kernelBootStatus[1024];
    struct sPersistentLog
    { // Never change the order of this data
      char version[16];
      int start;
      int end;
      int currStart;
      unsigned CRC;
    } persistentLogDB;
    char padding[1024-sizeof(struct sPersistentLog)];
    char unused1[15*1024];
    char ubootSourceScript[128*1024];
    char unused2[110*1024];
} tAtiReservedMemoryMap;

typedef struct
{
	char *startAddr;
	unsigned long length;
} tAtiReservedMemoryList;
