/***********************************************************************
 *
 *  Copyright (c) 2006-2007  Broadcom Corporation
 *  All Rights Reserved
 *
# 
# 
# This program may be linked with other software licensed under the GPL. 
# When this happens, this program may be reproduced and distributed under 
# the terms of the GPL. 
# 
# 
# 1. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS" 
#    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR 
#    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH 
#    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND 
#    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, 
#    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
#    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE 
#    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR 
#    PERFORMANCE OF THE SOFTWARE. 
# 
# 2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR 
#    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, 
#    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY 
#    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN 
#    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; 
#    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE 
#    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS 
#    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY 
#    LIMITED REMEDY. 
#
 *
 ************************************************************************/

#ifndef __CMS_ATI_H__
#define __CMS_ATI_H__

#include "ati_copyright.h"

#define UPDATE_NAME_LENGTH   (64)
#define TFTP_FILENAME_LENGTH (255)
#define TFTP_SERVER_LENGTH   (255)

typedef enum
{
   ATI_SwImage_1 	= 0,
   ATI_SwImage_2 	= 1,
   ATI_SwImages		= 2
} ATI_RUN_SWIMAGE;

typedef enum
{
   ATI_Invalid = -1,

   /*
    * Take note: The following three tags are very easily confused with their near namesakes
    * in enum BOARD_IOCTL_ACTION. They are in fact mapped from ATI_RUN_CONFIG to BOARD_IOCTL_ACTION
    * directly in functions cmsMgm_ATIreadConfigFlashToBuf() & cmsMgm_ATIwriteValidatedBufToConfigFlash().
    */
   ATI_Config_Factory_Customer,   /* ATI_CONFIG_FACTORY_CUSTOMER */
   ATI_Config_2,                  /* ATI_CONFIG_2                */
   ATI_Config_1,                  /* ATI_CONFIG_1                */

   ATI_Auto_Config
} ATI_CONFIG_PARTITION;

typedef struct
{
   ATI_RUN_SWIMAGE ATI_Run_SwImage;	            // Software Image index to boot from
   ATI_CONFIG_PARTITION currentUsrConfigPart;	// Note: This field no longer used
                                                // (valid values: ATI_Config_1 & ATI_Config_2 *ONLY*)

   char selectedConfig[UPDATE_NAME_LENGTH+1];   // Name of the configuration we want to load at next boot
} ATI_StartupInfo;

typedef struct
{
    char          tftpFilename[TFTP_FILENAME_LENGTH+1];
    char          tftpServer[TFTP_SERVER_LENGTH+1];
    unsigned int  tftpUserCrc;
    unsigned int  tftpCrc;
    unsigned int  tftpVlan;
    unsigned int  tftpPortMask;
} ATI_SirInfo;  // Single Image Recovery Info

typedef struct
{
  int flag;
} tATI_Boolean; // General structure for a boolean value

typedef struct
{
  unsigned int size;     // Shared memory size to be added to the original one
} ATI_ExtraShm;

#define MD5_PRINTABLE       32
// These attribute keys are limited to 15 characters.
#define ATI_PSP_LABEL		     "ATI_StartupInfo"
#define ATI_PSP_DISABLE_DEFAULT_BUTTON "ATI_DisDefBtn"
#define ATI_PSP_DISABLE_USB_CONSOLE "ATI_DisUSBCon"
#define ATI_PSP_DISABLE_SFP_LOCKDOWN "ATI_DisSfpLock"
#define ATI_PSP_EXTRA_SHARED_MEMORY "ATI_ExtraShm"
#define ATI_PSP_SIR_INFO "ATI_SirInfo"
#define ATI_SLAVE_USB_CONSOLE_IPADDR "ATI_USBConIP"
#define ATI_SLAVE_USB_CONSOLE_DEFAULTIPADDR "192.168.200.1"
#define ATI_MASTER_USB_AUTHORIZED           "/sys/bus/usb/devices/usb1/authorized"
#define ATI_PSP_DISABLE_WLAN "ATI_DisWLAN"

/*
 * We define these to make sure that we use the ATI (rather than Bcm) flavour of
 * busybox utilities. In the case of some (like ping) the ATI busybox variant uses
 * line buffering (rather than block buffering) on stdout when opened via a pipe
 * (i.e. using popen), and this allows for more interactive display of command
 * output to the CLI user.
 */
#define FTP_COMMAND              "/ati/bin/busybox ftpget"
#define TFTP_COMMAND             "/ati/bin/busybox tftp"
#define PING_COMMAND             "/ati/bin/busybox ping"
#define TRACEROUTE_COMMAND       "/ati/bin/busybox traceroute"
#define RTSOL_COMMAND            "/ati/bin/rtsol"

#ifdef DMP_X_BROADCOM_COM_IPV6_1
#define PING6_COMMAND            "/ati/bin/busybox ping6"
#define TRACEROUTE6_COMMAND      "/ati/bin/busybox traceroute6"
#endif

#define TFTP_URL                 "tftp://"
#define CONFIG_FILE_EXTN         ".cfg"
#define TEXT_FILE_EXTN           ".txt"

#ifdef DESKTOP_LINUX
#define TMPFS_PATH               "./"
#define TMPFS_TMP_PATH           TMPFS_PATH "tmp"
#define TMPFS_CONFIG_PATH        TMPFS_PATH "config/"
#else
#define TMPFS_PATH               "/var/"
#define TMPFS_TMP_PATH           TMPFS_PATH "tmp/"
#define TMPFS_CONFIG_PATH        TMPFS_PATH "config/"
#endif

#define ATI_MINIMAL_CFG_NAME         "minimal"
#define ATI_BOOTSTRAP_CFG_NAME 	     "bootstrap.cfg"
#define ATI_FACTORY_CFG_NAME 	     "default.cfg"
#define ATI_DEFAULT_BUTTON_CFG_NAME  "default_button.cfg"
#define ATI_UNNAMED_CFG_NAME         "unnamed.cfg"

#define ATI_IMS_EMERGENCY_RAM        "emergency_ram"    /* emergency string contained in ATI_IMAGE_STATUS_FILE */

#define MD5SUM_NAME                  "MD5SUM"
#define CONFIG_MD5SUM_PATH           TMPFS_CONFIG_PATH MD5SUM_NAME

#define ATI_FACTORY_CFG_RO_PATH      "/etc/" ATI_FACTORY_CFG_NAME
#define ATI_FACTORY_CFG_RW_PATH      TMPFS_CONFIG_PATH ATI_FACTORY_CFG_NAME
#define ATI_BUTTON_CFG_RW_PATH       TMPFS_CONFIG_PATH ATI_DEFAULT_BUTTON_CFG_NAME

#ifdef DESKTOP_LINUX
#  define PROC_PATH             "./"
#  define PROC_NVRAM_PATH	"./"
#  define PROC_GPIO_PATH	"./"
#  define PROC_LED_PATH	        "/dev/null"
#else
#  define PROC_PATH             "/proc/"
#  define PROC_NVRAM_PATH	PROC_PATH "nvram/"
#  define PROC_GPIO_PATH	PROC_PATH "gpio/"
#  define PROC_LED_PATH	        PROC_PATH "led"
#endif

#define PROC_UPTIME_FILE        PROC_PATH "uptime"
#define PROC_ATILOG_FILE        PROC_PATH "atilog"

/*
 *  tmpfs files...
 */
#define ATI_CONFIG_LOADING_FILE      TMPFS_PATH "AtiConfigLoading"
#define ATI_CONFIG_LOADED_FILE       TMPFS_PATH "AtiConfigLoaded"
#define ATI_CONFIG_PARTITION_FILE    TMPFS_PATH "AtiUserConfigPartition"
#define ATI_SHARED_MEM_ID_FILE       TMPFS_PATH "AtiShmId"

/*
 * nvram files...
 */
#define ATI_BOOTED_TAG_FILE          PROC_NVRAM_PATH "AtiBcmTagAddr"
#define ATI_BOARD_ID_FILE            PROC_NVRAM_PATH "AtiBoardId"
#define ATI_BOOT_ADDR_FILE           PROC_NVRAM_PATH "AtiBootAddr"
#define ATI_CFE_BUILDTIME_FILE       PROC_NVRAM_PATH "AtiCfeBuildTime"
#define ATI_CFE_VERSION_FILE         PROC_NVRAM_PATH "AtiCfeVersion"
#define ATI_CLI_VERSION_FILE         PROC_NVRAM_PATH "AtiCliReleaseTag"
#define ATI_COLD_START_FILE          PROC_NVRAM_PATH "AtiColdStart"
#define ATI_CONFIG_OVERRIDE_FILE     PROC_NVRAM_PATH "AtiConfigOverride"
#define ATI_DATE_FILE                PROC_NVRAM_PATH "AtiDate"
#define ATI_DEFAULT_BUTTON_FILE      PROC_NVRAM_PATH "AtiDefaultButton"
#define ATI_ECO_NUMBER_FILE          PROC_NVRAM_PATH "AtiECONumber"
#define ATI_FEATURE_POTS_FILE        PROC_NVRAM_PATH "AtiFeaturePots"
#define ATI_FEATURE_RF_MODULE_FILE   PROC_NVRAM_PATH "AtiFeatureRFModule"
#define ATI_FEATURE_RF_MODULE_FILE2   PROC_NVRAM_PATH "AtiFeatureRfModule"
#define ATI_FEATURE_RF_MODULE_SPI_FILE  PROC_NVRAM_PATH "AtiFeatureRfModuleSpi"
#define ATI_RF_MODULE_SPI_BUS_NUM    PROC_NVRAM_PATH "AtiRfModuleSpiBusNum"
#define ATI_RF_MODULE_SPI_CS         PROC_NVRAM_PATH "AtiRfModuleSpiCs"
#define ATI_FEATURE_WIFI_FILE        PROC_NVRAM_PATH "AtiFeatureWireless"
#define ATI_FEATURE_WIFI_COUNTRIES_FILE  PROC_NVRAM_PATH "AtiFeatureWirelessRestrictedCountries"
#define ATI_REVISION_FILE            PROC_NVRAM_PATH "AtiHwRevision"
#define ATI_IMAGE1_TAG_FILE          PROC_NVRAM_PATH "AtiImage1TagAddr"
#define ATI_IMAGE2_TAG_FILE          PROC_NVRAM_PATH "AtiImage2TagAddr"
#define ATI_BASE_MAC_ADDRESS_FILE    PROC_NVRAM_PATH "AtiMacAddBase"
#define ATI_NETBOOT_FILE             PROC_NVRAM_PATH "AtiNetbootFile"
#define ATI_NO_VOICE_FILE            PROC_NVRAM_PATH "AtiNoVoice"
#define ATI_PART_NUMBER_FILE         PROC_NVRAM_PATH "AtiPartNumber"
#define ATI_PRODUCT_ID_FILE          PROC_NVRAM_PATH "AtiProductId"
#define ATI_PSI_SIZE_FILE            PROC_NVRAM_PATH "AtiPsiSize"
#define ATI_RELEASE_TAG_FILE         PROC_NVRAM_PATH "AtiReleaseTag"
#define ATI_RELEASE_TYPE_FILE        PROC_NVRAM_PATH "AtiReleaseType"
#define ATI_SERIAL_NUMBER_FILE       PROC_NVRAM_PATH "AtiSerialNumber"
#define ATI_SCRIPT_VERSION_FILE      PROC_NVRAM_PATH "AtiScriptVersion"
#define ATI_SW_VERSION_COMP_FILE     PROC_NVRAM_PATH "AtiSwVersionCompatibility"
#define ATI_STARTUP_LOG_LEVEL_FILE   PROC_NVRAM_PATH "AtiStartupLogLevel"
#define ATI_UBOOT_BUILDTIME_FILE     PROC_NVRAM_PATH "AtiUbootBuildTime"
#define ATI_UBOOT_VERSION_FILE       PROC_NVRAM_PATH "AtiUbootVersion"
#define ATI_VOIP_VERSION_FILE        PROC_NVRAM_PATH "AtiVoipReleaseTag"
#define ATI_WARM_START_FILE          PROC_NVRAM_PATH "AtiWarmStart"
#define ATI_ADJUST_HVG_VIN_OFFSET_FILE  PROC_NVRAM_PATH "AtiAdjustHvgVinOffset"
#define ATI_FEATURE_POTS_RX_GAIN_OFFSET_FILE PROC_NVRAM_PATH "AtiFeaturePotsRxGainOffset"
#define ATI_FEATURE_POTS_TX_GAIN_OFFSET_FILE PROC_NVRAM_PATH "AtiFeaturePotsTxGainOffset"
#define ATI_FEATURE_KERNEL_MIRROR_FILE       PROC_NVRAM_PATH "AtiFeatureKernelMirror"
#define ATI_RF_GPIO_ALARM_FILE       PROC_NVRAM_PATH "AtiGpioRFAlarm"
#define ATI_CTRL_RF_ENABLE_FILE      PROC_NVRAM_PATH "AtiCtrlRFEnable"
#define ATI_IMAGE_STATUS_FILE        PROC_NVRAM_PATH "AtiImageStatus"
#define ATI_EXTRA_WLAN_MEM_FILE      PROC_NVRAM_PATH "AtiExtraWlanMem"

/*
 * gpio files...
 */
#define ATI_GPIO_BATTERY_LOW_FILE     PROC_GPIO_PATH "AtiGpioBatteryLow"
#define ATI_GPIO_BATTERY_MISSING_FILE PROC_GPIO_PATH "AtiGpioBatteryMissing"
#define ATI_GPIO_BATTERY_ON_FILE      PROC_GPIO_PATH "AtiGpioBatteryOn"
#define ATI_GPIO_BATTERY_REPLACE_FILE PROC_GPIO_PATH "AtiGpioBatteryReplace"

/*
 * The following macro allows you to mark function parameters as unused (both
 * in prototypes & definitions) - stopping gcc from spewing out warnings about 
 * unused parameters. Because it mangles the parameter name, it also causes gcc 
 * to complain if you do in fact try to use the parameter. An example: 
 *  
 * void abc(const int UNUSED(junk)); 
 *  
 * void abc(const int UNUSED(junk))  
 * { 
 *    ...
 * } 
 */
#ifdef UNUSED
#elif defined(__GNUC__)
# define UNUSED(x) UNUSED_ ## x __attribute__((unused))
#elif defined(__LCLINT__)
# define UNUSED(x) /*@unused@*/ x
#else
# define UNUSED(x) x
#endif

/*
 * MDK and VLAN CTL definitions
*/
#define ATI_MDK_IO_ACCESS_FILE "/var/AtiMdkIOr"
#define ATI_CPU_PORT 8
#define PORT_NAME_PREFIX "eth"
#define Macro_vlanCtl_insertTagRule(a, b, c, d, e, f) {int ret; if ((ret=vlanCtl_insertTagRule(a,b,c,d,e,f))){cmsLog_error("%s:%d Error %d, Dev:%s", __FUNCTION__, __LINE__, ret, a);};}

#ifdef BRCM_WLAN
/*
 * Wifi system-wide constants
 */
#define WIFI_MAX_RADIOS                       1
#define WIFI_MAX_SSIDS_PER_RADIO              4
#define WIFI_MAX_SSID_LEN                    32
#define WIFI_MAX_BSSID_LEN                   17 // For a bssid string in MAC address format: 11:22:33:44:55:66
#define WIFI_TR98_MAX_WEPENCRYPTIONLEVEL_LEN 64
#define INIT_WLANINTERFACES(a,b) {unsigned cnt; for(cnt=0;cnt<WIFI_MAX_RADIOS;cnt++)(a)[cnt]=(b)[cnt];}

#ifdef DESKTOP_LINUX
#define WLAN_CONFIG_DIR              "./"
#else
#define WLAN_CONFIG_DIR              "/var/wireless/"
#endif //DESKTOP_LINUX

#define WLAN_CONFIG_FILENAME         WLAN_CONFIG_DIR "hostapd_%s.cfg"
#define WLAN_DUMP_FILENAME           WLAN_CONFIG_DIR "hostapd_%s.dump"
#define WLAN_PID_FILENAME            WLAN_CONFIG_DIR "hostapd_%s.pid"
#define WLAN_SSID_PID_FILENAME       WLAN_CONFIG_DIR "hostapd_%ss%d.pid"
#endif // BRCM_WLAN

#define MAX_SWITCH_PORT              8
#endif  /* __CMS_ATI_H__ */
