/***********************************************************************
 *
 *  Copyright (c) 2006-2010  Broadcom Corporation
 *  All Rights Reserved
 *
 * <:label-BRCM:2011:DUAL/GPL:standard
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as published by
 * the Free Software Foundation (the "GPL").
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * 
 * A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
 * writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
:>
 *
************************************************************************/

#ifndef __CMS_CRC_H__
#define __CMS_CRC_H__

/*!\file cms_crc.h
 * \brief Header file for CRC calculation functions.
 * 
 * Also includes some defines for the CRC in front of config files.
 */


/** fixed length header in front of crc checked config file */
#define CRC_CONFIG_HEADER_LENGTH 20

/** start of the CRC header */
#define CRC_CONFIG_HEADER        "<crc="

/** Initial CRC checksum value, for use in cmsCrc_getCrc32.
 * 
 * From bcmTag.h.
 */
#if !defined(ATI_PRODUCT_CONFIG)
#define ATI_PRODUCT_CONFIG
#endif
#if !defined(ATI_PRODUCT_CONFIG)
#define CRC_INITIAL_VALUE 0xffffffff 
#else
#define CRC_INITIAL_VALUE 0x00000000
#endif
/** Return the CRC32 value for the given data buffer.
 *
 * @param pdata (IN) data to calculate CRC over.
 * @param len   (IN) length of the data.
 * @param crc   (IN) initial CRC value, see CRC32_INIT_VALUE
 *
 * @return CRC32 value.
 */
UINT32 cmsCrc_getCrc32(const UINT8 *pdata, UINT32 len, UINT32 crc);


#endif

