#ifndef __MDM_OBJECT_H__
#define __MDM_OBJECT_H__


/*
 * This file is automatically generated from the data-model spreadsheet.
 * Do not modify this file directly - You will lose all your changes the
 * next time this file is generated!
 */


/*!\file mdm_object.h 
 * \brief Automatically generated header file mdm_object.h
 */


#include "cms.h"

/*! \brief Obj struct for InternetGatewayDevice.
 *
 * MDMOID_IGD 1
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only*/
    char *    deviceSummary;	/**< DeviceSummary */
    UINT32    LANDeviceNumberOfEntries;	/**< LANDeviceNumberOfEntries */
    UINT32    WANDeviceNumberOfEntries;	/**< WANDeviceNumberOfEntries */
} IGDObject;

/*! \brief _IGDObject is used internally to represent IGDObject */
typedef IGDObject _IGDObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceInfo.
 *
 * MDMOID_IGD_DEVICE_INFO 2
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    manufacturer;	/**< Manufacturer */
    char *    manufacturerOUI;	/**< ManufacturerOUI */
    char *    modelName;	/**< ModelName */
    char *    description;	/**< Description */
    char *    productClass;	/**< ProductClass */
    char *    serialNumber;	/**< SerialNumber */
    char *    hardwareVersion;	/**< HardwareVersion */
    char *    softwareVersion;	/**< SoftwareVersion */
    char *    modemFirmwareVersion;	/**< ModemFirmwareVersion */
    char *    enabledOptions;	/**< EnabledOptions */
    char *    additionalHardwareVersion;	/**< AdditionalHardwareVersion */
    char *    additionalSoftwareVersion;	/**< AdditionalSoftwareVersion */
    char *    specVersion;	/**< SpecVersion */
    char *    provisioningCode;	/**< ProvisioningCode */
    UINT32    upTime;	/**< UpTime */
    DATETIME  firstUseDate;	/**< FirstUseDate */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_NumberOfCpuThreads;	/**< X_BROADCOM_COM_NumberOfCpuThreads */
#endif
    char *    X_BROADCOM_COM_SwBuildTimestamp;	/**< X_BROADCOM_COM_SwBuildTimestamp */
    char *    X_ALLIEDTELESIS_COM_BuildType;	/**< X_ALLIEDTELESIS_COM_BuildType */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DslPhyDrvVersion;	/**< X_BROADCOM_COM_DslPhyDrvVersion */
#endif
#ifdef DMP_X_BROADCOM_COM_PSTNENDPOINT_1
    char *    X_BROADCOM_COM_VoiceServiceVersion;	/**< X_BROADCOM_COM_VoiceServiceVersion */
#endif
    char *    X_ALLIEDTELESIS_COM_VoiceServiceVersion;	/**< X_ALLIEDTELESIS_COM_VoiceServiceVersion */
    char *    X_ALLIEDTELESIS_COM_MacAddress;	/**< X_ALLIEDTELESIS_COM_MacAddress */
    char *    deviceLog;	/**< DeviceLog */
    UINT32    vendorConfigFileNumberOfEntries;	/**< VendorConfigFileNumberOfEntries */
} IGDDeviceInfoObject;

/*! \brief _IGDDeviceInfoObject is used internally to represent IGDDeviceInfoObject */
typedef IGDDeviceInfoObject _IGDDeviceInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceInfo.VendorConfigFile.{i}.
 *
 * MDMOID_VENDOR_CONFIG_FILE 3
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    char *    version;	/**< Version */
    DATETIME  date;	/**< Date */
    char *    description;	/**< Description */
} VendorConfigFileObject;

/*! \brief _VendorConfigFileObject is used internally to represent VendorConfigFileObject */
typedef VendorConfigFileObject _VendorConfigFileObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceInfo.X_ALLIEDTELESIS_COM_PowerManagement.
 *
 * MDMOID_POWER_MANAGEMENT 4
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    sysPowerOnBattery;	/**< SysPowerOnBattery */
    UBOOL8    sysPowerReplaceBattery;	/**< SysPowerReplaceBattery */
    UBOOL8    sysPowerBatteryMissing;	/**< SysPowerBatteryMissing */
    UBOOL8    sysPowerLowBattery;	/**< SysPowerLowBattery */
    UBOOL8    sysPowerManagement;	/**< SysPowerManagement */
} PowerManagementObject;

/*! \brief _PowerManagementObject is used internally to represent PowerManagementObject */
typedef PowerManagementObject _PowerManagementObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_BpaApiFlowHandle.{i}.
 *
 * MDMOID_BPA_API_FLOW_HANDLE 5
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    name;	/**< Name */
    UINT32    portNumber;	/**< PortNumber */
    UINT32    flowHandle;	/**< FlowHandle */
    UBOOL8    eth10Configured;	/**< Eth10Configured */
    UBOOL8    moca10Configured;	/**< Moca10Configured */
} BpaApiFlowHandleObject;

/*! \brief _BpaApiFlowHandleObject is used internally to represent BpaApiFlowHandleObject */
typedef BpaApiFlowHandleObject _BpaApiFlowHandleObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SyslogCfg.
 *
 * MDMOID_SYSLOG_CFG 6
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    status;	/**< Status */
    char *    option;	/**< Option */
    char *    localDisplayLevel;	/**< LocalDisplayLevel */
    char *    localLogLevel;	/**< LocalLogLevel */
    char *    remoteLogLevel;	/**< RemoteLogLevel */
    char *    serverIPAddress;	/**< ServerIPAddress */
    UINT32    serverPortNumber;	/**< ServerPortNumber */
} SyslogCfgObject;

/*! \brief _SyslogCfgObject is used internally to represent SyslogCfgObject */
typedef SyslogCfgObject _SyslogCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.
 *
 * MDMOID_APP_CFG 7
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} AppCfgObject;

/*! \brief _AppCfgObject is used internally to represent AppCfgObject */
typedef AppCfgObject _AppCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.HttpdCfg.
 *
 * MDMOID_HTTPD_CFG 8
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
#ifdef DMP_X_BROADCOM_COM_QUICKSETUP_1
    UBOOL8    quickSetupEnabled;	/**< QuickSetupEnabled */
#endif
} HttpdCfgObject;

/*! \brief _HttpdCfgObject is used internally to represent HttpdCfgObject */
typedef HttpdCfgObject _HttpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.Tr69cCfg.
 *
 * MDMOID_TR69C_CFG 9
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
#ifdef DMP_X_BROADCOM_COM_DEBUG_1
    UBOOL8    loggingSOAP;	/**< LoggingSOAP */
#endif
#ifdef DMP_X_BROADCOM_COM_SECURITY_1
    UBOOL8    connectionRequestAuthentication;	/**< ConnectionRequestAuthentication */
#endif
} Tr69cCfgObject;

/*! \brief _Tr69cCfgObject is used internally to represent Tr69cCfgObject */
typedef Tr69cCfgObject _Tr69cCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.Tr64cCfg.
 *
 * MDMOID_TR64C_CFG 10
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} Tr64cCfgObject;

/*! \brief _Tr64cCfgObject is used internally to represent Tr64cCfgObject */
typedef Tr64cCfgObject _Tr64cCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SshdCfg.
 *
 * MDMOID_SSHD_CFG 11
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} SshdCfgObject;

/*! \brief _SshdCfgObject is used internally to represent SshdCfgObject */
typedef SshdCfgObject _SshdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.TelnetdCfg.
 *
 * MDMOID_TELNETD_CFG 12
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} TelnetdCfgObject;

/*! \brief _TelnetdCfgObject is used internally to represent TelnetdCfgObject */
typedef TelnetdCfgObject _TelnetdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.ConsoledCfg.
 *
 * MDMOID_CONSOLED_CFG 13
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} ConsoledCfgObject;

/*! \brief _ConsoledCfgObject is used internally to represent ConsoledCfgObject */
typedef ConsoledCfgObject _ConsoledCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SmdCfg.
 *
 * MDMOID_SMD_CFG 14
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} SmdCfgObject;

/*! \brief _SmdCfgObject is used internally to represent SmdCfgObject */
typedef SmdCfgObject _SmdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SskCfg.
 *
 * MDMOID_SSK_CFG 15
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} SskCfgObject;

/*! \brief _SskCfgObject is used internally to represent SskCfgObject */
typedef SskCfgObject _SskCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SnmpdCfg.
 *
 * MDMOID_SNMPD_CFG 16
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} SnmpdCfgObject;

/*! \brief _SnmpdCfgObject is used internally to represent SnmpdCfgObject */
typedef SnmpdCfgObject _SnmpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.FtpdCfg.
 *
 * MDMOID_FTPD_CFG 17
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} FtpdCfgObject;

/*! \brief _FtpdCfgObject is used internally to represent FtpdCfgObject */
typedef FtpdCfgObject _FtpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.TftpdCfg.
 *
 * MDMOID_TFTPD_CFG 18
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} TftpdCfgObject;

/*! \brief _TftpdCfgObject is used internally to represent TftpdCfgObject */
typedef TftpdCfgObject _TftpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.PppdCfg.
 *
 * MDMOID_PPPD_CFG 19
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} PppdCfgObject;

/*! \brief _PppdCfgObject is used internally to represent PppdCfgObject */
typedef PppdCfgObject _PppdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.IcmpCfg.
 *
 * MDMOID_ICMP_CFG 20
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    networkAccess;	/**< NetworkAccess */
} IcmpCfgObject;

/*! \brief _IcmpCfgObject is used internally to represent IcmpCfgObject */
typedef IcmpCfgObject _IcmpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.UpnpCfg.
 *
 * MDMOID_UPNP_CFG 21
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} UpnpCfgObject;

/*! \brief _UpnpCfgObject is used internally to represent UpnpCfgObject */
typedef UpnpCfgObject _UpnpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.DnsProxyCfg.
 *
 * MDMOID_DNS_PROXY_CFG 22
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    deviceDomainName;	/**< DeviceDomainName */
    char *    deviceHostName;	/**< DeviceHostName */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} DnsProxyCfgObject;

/*! \brief _DnsProxyCfgObject is used internally to represent DnsProxyCfgObject */
typedef DnsProxyCfgObject _DnsProxyCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_CliBepCfg.
 *
 * MDMOID_CLI_BEP_CFG 23
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} CliBepCfgObject;

/*! \brief _CliBepCfgObject is used internally to represent CliBepCfgObject */
typedef CliBepCfgObject _CliBepCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_McpdCfg.
 *
 * MDMOID_MCPD_CFG 24
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} McpdCfgObject;

/*! \brief _McpdCfgObject is used internally to represent McpdCfgObject */
typedef McpdCfgObject _McpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_SntpdCfg.
 *
 * MDMOID_SNTPD_CFG 25
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} SntpdCfgObject;

/*! \brief _SntpdCfgObject is used internally to represent SntpdCfgObject */
typedef SntpdCfgObject _SntpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.DectdCfg.
 *
 * MDMOID_DECTD_CFG 26
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} DectdCfgObject;

/*! \brief _DectdCfgObject is used internally to represent DectdCfgObject */
typedef DectdCfgObject _DectdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.VectoringCfg.
 *
 * MDMOID_VECTORING_CFG 27
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} VectoringCfgObject;

/*! \brief _VectoringCfgObject is used internally to represent VectoringCfgObject */
typedef VectoringCfgObject _VectoringCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.OmcidCfg.
 *
 * MDMOID_OMCID_CFG 28
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} OmcidCfgObject;

/*! \brief _OmcidCfgObject is used internally to represent OmcidCfgObject */
typedef OmcidCfgObject _OmcidCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.OmciPmdCfg.
 *
 * MDMOID_OMCI_PMD_CFG 29
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} OmciPmdCfgObject;

/*! \brief _OmciPmdCfgObject is used internally to represent OmciPmdCfgObject */
typedef OmciPmdCfgObject _OmciPmdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_SwupdateCfg.
 *
 * MDMOID_SWUPDATE_CFG 30
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
    UINT32    dhcpTriggerDelay;	/**< DhcpTriggerDelay */
    char *    username;	/**< username */
    char *    password;	/**< password */
    char *    server;	/**< server */
    char *    path;	/**< path */
    char *    name;	/**< fileName */
} SwupdateCfgObject;

/*! \brief _SwupdateCfgObject is used internally to represent SwupdateCfgObject */
typedef SwupdateCfgObject _SwupdateCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_AccessCfg.
 *
 * MDMOID_ACCESS_CFG 31
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} AccessCfgObject;

/*! \brief _AccessCfgObject is used internally to represent AccessCfgObject */
typedef AccessCfgObject _AccessCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_HpnaCfg.
 *
 * MDMOID_HPNA_CFG 32
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} HpnaCfgObject;

/*! \brief _HpnaCfgObject is used internally to represent HpnaCfgObject */
typedef HpnaCfgObject _HpnaCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.OsgidCfg.
 *
 * MDMOID_OSGID_CFG 33
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
} OsgidCfgObject;

/*! \brief _OsgidCfgObject is used internally to represent OsgidCfgObject */
typedef OsgidCfgObject _OsgidCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_LoopDetection.
 *
 * MDMOID_LOOP_DETECTION 34
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    loggingLevel;	/**< LoggingLevel */
    char *    loggingDestination;	/**< LoggingDestination */
    UINT32    LDFInterval;	/**< LDFInterval */
    UINT32    linkDownTimeout;	/**< LinkDownTimeout */
} LoopDetectionObject;

/*! \brief _LoopDetectionObject is used internally to represent LoopDetectionObject */
typedef LoopDetectionObject _LoopDetectionObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.X_ALLIEDTELESIS_COM_HealthMonitor.
 *
 * MDMOID_HEALTH_MONITOR 35
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    voicePollInterval;	/**< VoicePollInterval */
} HealthMonitorObject;

/*! \brief _HealthMonitorObject is used internally to represent HealthMonitorObject */
typedef HealthMonitorObject _HealthMonitorObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetSwitch.
 *
 * MDMOID_ETHERNET_SWITCH 36
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    numberOfVirtualPorts;	/**< NumberOfVirtualPorts */
    UBOOL8    enableVirtualPorts;	/**< EnableVirtualPorts */
    char *    ifName;	/**< IfName */
    UBOOL8    enableFdb;	/**< EnableFdb */
    UBOOL8    enableAging;	/**< EnableAging */
    UINT32    aging;	/**< Aging */
    UBOOL8    clearFwdDatabase;	/**< ClearFwdDatabase */
    HEXBINARY  ISPQinQTPID;	/**< ISPQinQTPID */
    UBOOL8    enableQinQ;	/**< EnableQinQ */
} EthernetSwitchObject;

/*! \brief _EthernetSwitchObject is used internally to represent EthernetSwitchObject */
typedef EthernetSwitchObject _EthernetSwitchObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetSwitch.X_ALLIEDTELESIS_COM_DscpMapping.{i}.
 *
 * MDMOID_DSCP_MAPPING 37
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    X_ALLIEDTELESIS_COM_DscpValue;	/**< X_ALLIEDTELESIS_COM_DscpValue */
    SINT32    X_ALLIEDTELESIS_COM_EgressQueue;	/**< X_ALLIEDTELESIS_COM_EgressQueue */
} DscpMappingObject;

/*! \brief _DscpMappingObject is used internally to represent DscpMappingObject */
typedef DscpMappingObject _DscpMappingObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetSwitch.X_ALLIEDTELESIS_COM_PbitMapping.{i}.
 *
 * MDMOID_PBIT_MAPPING 38
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    X_ALLIEDTELESIS_COM_PbitValue;	/**< X_ALLIEDTELESIS_COM_PbitValue */
    SINT32    X_ALLIEDTELESIS_COM_EgressQueue;	/**< X_ALLIEDTELESIS_COM_EgressQueue */
} PbitMappingObject;

/*! \brief _PbitMappingObject is used internally to represent PbitMappingObject */
typedef PbitMappingObject _PbitMappingObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetSwitch.X_ALLIEDTELESIS_COM_Port.{i}.
 *
 * MDMOID_ETH_SWITCH_PORT 39
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    X_ALLIEDTELESIS_COM_IfName;	/**< X_ALLIEDTELESIS_COM_IfName */
    UINT32    X_ALLIEDTELESIS_COM_PortNumber;	/**< X_ALLIEDTELESIS_COM_PortNumber */
    UBOOL8    X_ALLIEDTELESIS_COM_AccessVlanPortMode;	/**< X_ALLIEDTELESIS_COM_AccessVlanPortMode */
} EthSwitchPortObject;

/*! \brief _EthSwitchPortObject is used internally to represent EthSwitchPortObject */
typedef EthSwitchPortObject _EthSwitchPortObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_PwrMngtCfg.
 *
 * MDMOID_PWR_MNGT 40
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    CPUSpeed;	/**< CPUSpeed */
    UBOOL8    CPUr4kWaitEn;	/**< CPUr4kWaitEn */
    UBOOL8    DRAMSelfRefreshEn;	/**< DRAMSelfRefreshEn */
    UBOOL8    DRAMAutoPDEn;	/**< DRAMAutoPDEn */
    UBOOL8    ethAutoPwrDwnEn;	/**< EthAutoPwrDwnEn */
    SINT32    ethRegisteredCount;	/**< EthRegisteredCount */
    SINT32    ethIfConnectedCount;	/**< EthIfConnectedCount */
    SINT32    USBIfRegisteredCount;	/**< USBIfRegisteredCount */
    SINT32    USBIfConnectedCount;	/**< USBIfConnectedCount */
    UBOOL8    avsEn;	/**< AvsEn */
    UBOOL8    VCTEn;	/**< VCTEn */
    UBOOL8    wifiEn;	/**< WifiEn */
    UBOOL8    ledEn;	/**< LedEn */
    UBOOL8    USBHostEn;	/**< USBHostEn */
    UBOOL8    USBDevEn;	/**< USBDevEn */
    UBOOL8    DSLEn;	/**< DSLEn */
    UBOOL8    moCAEn;	/**< MoCAEn */
    UBOOL8    GPONEn;	/**< GPONEn */
    UBOOL8    bcm6358MAC0En;	/**< bcm6358MAC0En */
    UBOOL8    bcm6358MAC1En;	/**< bcm6358MAC1En */
    UBOOL8    bcm6358EPHYEn;	/**< bcm6358EPHYEn */
    UBOOL8    bcm5325ePHY0En;	/**< bcm5325ePHY0En */
    UBOOL8    bcm5325ePHY1En;	/**< bcm5325ePHY1En */
    UBOOL8    bcm5325ePHY2En;	/**< bcm5325ePHY2En */
    UBOOL8    bcm5325ePHY3En;	/**< bcm5325ePHY3En */
    UBOOL8    bcm5325ePHY45En;	/**< bcm5325ePHY45En */
    UBOOL8    bcm6368ePHY0En;	/**< bcm6368ePHY0En */
    UBOOL8    bcm6368ePHY1En;	/**< bcm6368ePHY1En */
    UBOOL8    bcm6368ePHY2En;	/**< bcm6368ePHY2En */
    UBOOL8    bcm6368ePHY3En;	/**< bcm6368ePHY3En */
    UBOOL8    bcm6816ePHY0En;	/**< bcm6816ePHY0En */
    UBOOL8    bcm6816ePHY1En;	/**< bcm6816ePHY1En */
    UBOOL8    bcm6816ePHY2En;	/**< bcm6816ePHY2En */
    UBOOL8    bcm6816ePHY3En;	/**< bcm6816ePHY3En */
} PwrMngtObject;

/*! \brief _PwrMngtObject is used internally to represent PwrMngtObject */
typedef PwrMngtObject _PwrMngtObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_StandbyCfg.
 *
 * MDMOID_STANDBY_CFG 41
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    standbyEnable;	/**< StandbyEnable */
    char *    standbyStatusString;	/**< StandbyStatusString */
    SINT32    standbyHour;	/**< StandbyHour */
    SINT32    standbyMinutes;	/**< StandbyMinutes */
    SINT32    wakeupHour;	/**< WakeupHour */
    SINT32    wakeupMinutes;	/**< WakeupMinutes */
} StandbyCfgObject;

/*! \brief _StandbyCfgObject is used internally to represent StandbyCfgObject */
typedef StandbyCfgObject _StandbyCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceConfig.
 *
 * MDMOID_DEVICE_CONFIG 42
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    persistentData;	/**< PersistentData */
    char *    configFile;	/**< ConfigFile */
} DeviceConfigObject;

/*! \brief _DeviceConfigObject is used internally to represent DeviceConfigObject */
typedef DeviceConfigObject _DeviceConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.ManagementServer.
 *
 * MDMOID_MANAGEMENT_SERVER 43
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    URL;	/**< URL */
    char *    lastConnectedURL;	/**< LastConnectedURL */
    char *    username;	/**< Username */
    char *    password;	/**< Password */
    UBOOL8    periodicInformEnable;	/**< PeriodicInformEnable */
    UINT32    periodicInformInterval;	/**< PeriodicInformInterval */
    DATETIME  periodicInformTime;	/**< PeriodicInformTime */
    char *    parameterKey;	/**< ParameterKey */
    char *    X_BROADCOM_COM_BoundIfName;	/**< X_BROADCOM_COM_BoundIfName */
    char *    connectionRequestURL;	/**< ConnectionRequestURL */
    char *    connectionRequestUsername;	/**< ConnectionRequestUsername */
    char *    connectionRequestPassword;	/**< ConnectionRequestPassword */
    UBOOL8    upgradesManaged;	/**< UpgradesManaged */
    char *    kickURL;	/**< KickURL */
    UINT32    CWMPRetryMinimumWaitInterval;	/**< CWMPRetryMinimumWaitInterval */
    UINT32    CWMPRetryIntervalMultiplier;	/**< CWMPRetryIntervalMultiplier */
#ifdef DMP_DEVICEASSOCIATION_1
    UINT32    manageableDeviceNumberOfEntries;	/**< ManageableDeviceNumberOfEntries */
#endif
    UINT32    manageableDeviceNotificationLimit;	/**< ManageableDeviceNotificationLimit */
} ManagementServerObject;

/*! \brief _ManagementServerObject is used internally to represent ManagementServerObject */
typedef ManagementServerObject _ManagementServerObject;



/*! \brief Obj struct for InternetGatewayDevice.ManagementServer.ManageableDevice.{i}.
 *
 * MDMOID_MANAGEABLE_DEVICE 44
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    manufacturerOUI;	/**< ManufacturerOUI */
    char *    serialNumber;	/**< SerialNumber */
    char *    productClass;	/**< ProductClass */
} ManageableDeviceObject;

/*! \brief _ManageableDeviceObject is used internally to represent ManageableDeviceObject */
typedef ManageableDeviceObject _ManageableDeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.Time.
 *
 * MDMOID_TIME_SERVER_CFG 45
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    NTPServer1;	/**< NTPServer1 */
    char *    NTPServer2;	/**< NTPServer2 */
    char *    NTPServer3;	/**< NTPServer3 */
    char *    NTPServer4;	/**< NTPServer4 */
    char *    NTPServer5;	/**< NTPServer5 */
    DATETIME  currentLocalTime;	/**< CurrentLocalTime */
    char *    localTimeZone;	/**< LocalTimeZone */
    char *    localTimeZoneName;	/**< LocalTimeZoneName */
    UBOOL8    daylightSavingsUsed;	/**< DaylightSavingsUsed */
    DATETIME  daylightSavingsStart;	/**< DaylightSavingsStart */
    DATETIME  daylightSavingsEnd;	/**< DaylightSavingsEnd */
    UINT32    X_ALLIEDTELESIS_COM_PollingTime;	/**< X_ALLIEDTELESIS_COM_PollingTime */
    UINT32    X_ALLIEDTELESIS_COM_Timeout;	/**< X_ALLIEDTELESIS_COM_Timeout */
    UINT32    X_ALLIEDTELESIS_COM_Robustness;	/**< X_ALLIEDTELESIS_COM_Robustness */
    UINT32    X_ALLIEDTELESIS_COM_ServerId;	/**< X_ALLIEDTELESIS_COM_ServerId */
    char *    X_ALLIEDTELESIS_COM_Offset;	/**< X_ALLIEDTELESIS_COM_Offset */
    SINT32    X_ALLIEDTELESIS_COM_DstOn;	/**< X_ALLIEDTELESIS_COM_DstOn */
} TimeServerCfgObject;

/*! \brief _TimeServerCfgObject is used internally to represent TimeServerCfgObject */
typedef TimeServerCfgObject _TimeServerCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.
 *
 * MDMOID_L2_BRIDGING 46
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    maxBridgeEntries;	/**< MaxBridgeEntries */
    UINT32    maxFilterEntries;	/**< MaxFilterEntries */
    UINT32    maxMarkingEntries;	/**< MaxMarkingEntries */
    UINT32    bridgeNumberOfEntries;	/**< BridgeNumberOfEntries */
    UINT32    filterNumberOfEntries;	/**< FilterNumberOfEntries */
    UINT32    markingNumberOfEntries;	/**< MarkingNumberOfEntries */
    UINT32    availableInterfaceNumberOfEntries;	/**< AvailableInterfaceNumberOfEntries */
} L2BridgingObject;

/*! \brief _L2BridgingObject is used internally to represent L2BridgingObject */
typedef L2BridgingObject _L2BridgingObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.Bridge.{i}.
 *
 * MDMOID_L2_BRIDGING_ENTRY 47
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bridgeKey;	/**< BridgeKey */
    UBOOL8    bridgeEnable;	/**< BridgeEnable */
    char *    bridgeStatus;	/**< BridgeStatus */
    char *    bridgeName;	/**< BridgeName */
    UINT32    VLANID;	/**< VLANID */
    UINT32    X_ALLIEDTELESIS_COM_HWUserCnt;	/**< X_ALLIEDTELESIS_COM_HWUserCnt */
    UINT32    X_ALLIEDTELESIS_COM_SWUserCnt;	/**< X_ALLIEDTELESIS_COM_SWUserCnt */
    UINT32    X_ALLIEDTELESIS_COM_ExtUserCnt;	/**< X_ALLIEDTELESIS_COM_ExtUserCnt */
} L2BridgingEntryObject;

/*! \brief _L2BridgingEntryObject is used internally to represent L2BridgingEntryObject */
typedef L2BridgingEntryObject _L2BridgingEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.Filter.{i}.
 *
 * MDMOID_L2_BRIDGING_FILTER 48
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    filterKey;	/**< FilterKey */
    UBOOL8    filterEnable;	/**< FilterEnable */
    char *    filterStatus;	/**< FilterStatus */
    SINT32    filterBridgeReference;	/**< FilterBridgeReference */
    char *    filterInterface;	/**< FilterInterface */
    SINT32    X_BROADCOM_COM_VLANIDFilter;	/**< X_BROADCOM_COM_VLANIDFilter */
    char *    sourceMACFromVendorClassIDFilter;	/**< SourceMACFromVendorClassIDFilter */
    UBOOL8    sourceMACFromVendorClassIDFilterExclude;	/**< SourceMACFromVendorClassIDFilterExclude */
} L2BridgingFilterObject;

/*! \brief _L2BridgingFilterObject is used internally to represent L2BridgingFilterObject */
typedef L2BridgingFilterObject _L2BridgingFilterObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.AvailableInterface.{i}.
 *
 * MDMOID_L2_BRIDGING_INTF 49
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    availableInterfaceKey;	/**< AvailableInterfaceKey */
    char *    interfaceType;	/**< InterfaceType */
    char *    interfaceReference;	/**< InterfaceReference */
} L2BridgingIntfObject;

/*! \brief _L2BridgingIntfObject is used internally to represent L2BridgingIntfObject */
typedef L2BridgingIntfObject _L2BridgingIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.
 *
 * MDMOID_Q_MGMT 50
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    UINT32    maxQueues;	/**< MaxQueues */
    UINT32    maxClassificationEntries;	/**< MaxClassificationEntries */
    UINT32    classificationNumberOfEntries;	/**< ClassificationNumberOfEntries */
    UINT32    maxAppEntries;	/**< MaxAppEntries */
    UINT32    appNumberOfEntries;	/**< AppNumberOfEntries */
    UINT32    maxFlowEntries;	/**< MaxFlowEntries */
    UINT32    flowNumberOfEntries;	/**< FlowNumberOfEntries */
    UINT32    maxPolicerEntries;	/**< MaxPolicerEntries */
    UINT32    policerNumberOfEntries;	/**< PolicerNumberOfEntries */
    UINT32    maxQueueEntries;	/**< MaxQueueEntries */
    UINT32    queueNumberOfEntries;	/**< QueueNumberOfEntries */
    UINT32    defaultForwardingPolicy;	/**< DefaultForwardingPolicy */
    SINT32    defaultPolicer;	/**< DefaultPolicer */
    UINT32    defaultQueue;	/**< DefaultQueue */
    SINT32    defaultDSCPMark;	/**< DefaultDSCPMark */
    SINT32    defaultEthernetPriorityMark;	/**< DefaultEthernetPriorityMark */
    char *    availableAppList;	/**< AvailableAppList */
} QMgmtObject;

/*! \brief _QMgmtObject is used internally to represent QMgmtObject */
typedef QMgmtObject _QMgmtObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.Classification.{i}.
 *
 * MDMOID_Q_MGMT_CLASSIFICATION 51
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    classificationKey;	/**< ClassificationKey */
    UBOOL8    classificationEnable;	/**< ClassificationEnable */
    char *    classificationStatus;	/**< ClassificationStatus */
    UINT32    classificationOrder;	/**< ClassificationOrder */
    char *    classInterface;	/**< ClassInterface */
    char *    destIP;	/**< DestIP */
    char *    destMask;	/**< DestMask */
    UBOOL8    destIPExclude;	/**< DestIPExclude */
    char *    sourceIP;	/**< SourceIP */
    char *    sourceMask;	/**< SourceMask */
    UBOOL8    sourceIPExclude;	/**< SourceIPExclude */
    SINT32    protocol;	/**< Protocol */
    UBOOL8    protocolExclude;	/**< ProtocolExclude */
    SINT32    destPort;	/**< DestPort */
    SINT32    destPortRangeMax;	/**< DestPortRangeMax */
    UBOOL8    destPortExclude;	/**< DestPortExclude */
    SINT32    sourcePort;	/**< SourcePort */
    SINT32    sourcePortRangeMax;	/**< SourcePortRangeMax */
    UBOOL8    sourcePortExclude;	/**< SourcePortExclude */
    char *    sourceMACAddress;	/**< SourceMACAddress */
    char *    sourceMACMask;	/**< SourceMACMask */
    UBOOL8    sourceMACExclude;	/**< SourceMACExclude */
    char *    destMACAddress;	/**< DestMACAddress */
    char *    destMACMask;	/**< DestMACMask */
    UBOOL8    destMACExclude;	/**< DestMACExclude */
    SINT32    ethertype;	/**< Ethertype */
    UBOOL8    ethertypeExclude;	/**< EthertypeExclude */
    char *    sourceVendorClassID;	/**< SourceVendorClassID */
    UBOOL8    sourceVendorClassIDExclude;	/**< SourceVendorClassIDExclude */
    char *    sourceUserClassID;	/**< SourceUserClassID */
    UBOOL8    sourceUserClassIDExclude;	/**< SourceUserClassIDExclude */
    SINT32    DSCPCheck;	/**< DSCPCheck */
    UBOOL8    DSCPExclude;	/**< DSCPExclude */
    SINT32    DSCPMark;	/**< DSCPMark */
    SINT32    ethernetPriorityCheck;	/**< EthernetPriorityCheck */
    UBOOL8    ethernetPriorityExclude;	/**< EthernetPriorityExclude */
    SINT32    ethernetPriorityMark;	/**< EthernetPriorityMark */
    SINT32    VLANIDCheck;	/**< VLANIDCheck */
    UBOOL8    VLANIDExclude;	/**< VLANIDExclude */
    UINT32    forwardingPolicy;	/**< ForwardingPolicy */
    SINT32    classPolicer;	/**< ClassPolicer */
    SINT32    classQueue;	/**< ClassQueue */
    SINT32    classApp;	/**< ClassApp */
    SINT32    X_BROADCOM_COM_ClassRate;	/**< X_BROADCOM_COM_ClassRate */
    char *    X_BROADCOM_COM_ClassName;	/**< X_BROADCOM_COM_ClassName */
    SINT32    X_BROADCOM_COM_VLANIDTag;	/**< X_BROADCOM_COM_VLANIDTag */
    char *    X_BROADCOM_COM_egressInterface;	/**< X_BROADCOM_COM_egressInterface */
    UINT32    X_BROADCOM_COM_ClassKey;	/**< X_BROADCOM_COM_ClassKey */
} QMgmtClassificationObject;

/*! \brief _QMgmtClassificationObject is used internally to represent QMgmtClassificationObject */
typedef QMgmtClassificationObject _QMgmtClassificationObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.Policer.{i}.
 *
 * MDMOID_Q_MGMT_POLICER 52
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    policerKey;	/**< PolicerKey */
    UBOOL8    policerEnable;	/**< PolicerEnable */
    char *    policerStatus;	/**< PolicerStatus */
    UINT32    committedRate;	/**< CommittedRate */
    UINT32    committedBurstSize;	/**< CommittedBurstSize */
    UINT32    excessBurstSize;	/**< ExcessBurstSize */
    UINT32    peakRate;	/**< PeakRate */
    UINT32    peakBurstSize;	/**< PeakBurstSize */
    char *    meterType;	/**< MeterType */
    char *    possibleMeterTypes;	/**< PossibleMeterTypes */
    char *    conformingAction;	/**< ConformingAction */
    char *    partialConformingAction;	/**< PartialConformingAction */
    char *    nonConformingAction;	/**< NonConformingAction */
    UINT32    countedPackets;	/**< CountedPackets */
    UINT32    countedBytes;	/**< CountedBytes */
    char *    X_BROADCOM_COM_PolicerName;	/**< X_BROADCOM_COM_PolicerName */
} QMgmtPolicerObject;

/*! \brief _QMgmtPolicerObject is used internally to represent QMgmtPolicerObject */
typedef QMgmtPolicerObject _QMgmtPolicerObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.Queue.{i}.
 *
 * MDMOID_Q_MGMT_QUEUE 53
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    queueKey;	/**< QueueKey */
    UBOOL8    queueEnable;	/**< QueueEnable */
    char *    queueStatus;	/**< QueueStatus */
    char *    queueInterface;	/**< QueueInterface */
    UINT32    queueWeight;	/**< QueueWeight */
    UINT32    queuePrecedence;	/**< QueuePrecedence */
    char *    schedulerAlgorithm;	/**< SchedulerAlgorithm */
    SINT32    shapingRate;	/**< ShapingRate */
    UINT32    shapingBurstSize;	/**< ShapingBurstSize */
    char *    X_BROADCOM_COM_QueueName;	/**< X_BROADCOM_COM_QueueName */
    SINT32    X_BROADCOM_COM_DslLatency;	/**< X_BROADCOM_COM_DslLatency */
    SINT32    X_BROADCOM_COM_PtmPriority;	/**< X_BROADCOM_COM_PtmPriority */
    UINT32    X_BROADCOM_COM_QueueId;	/**< X_BROADCOM_COM_QueueId */
} QMgmtQueueObject;

/*! \brief _QMgmtQueueObject is used internally to represent QMgmtQueueObject */
typedef QMgmtQueueObject _QMgmtQueueObject;



/*! \brief Obj struct for InternetGatewayDevice.IPPingDiagnostics.
 *
 * MDMOID_IP_PING_DIAG 54
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    diagnosticsState;	/**< DiagnosticsState */
    char *    interface;	/**< Interface */
    char *    host;	/**< Host */
    UINT32    numberOfRepetitions;	/**< NumberOfRepetitions */
    UINT32    timeout;	/**< Timeout */
    UINT32    dataBlockSize;	/**< DataBlockSize */
    UINT32    DSCP;	/**< DSCP */
    UINT32    successCount;	/**< SuccessCount */
    UINT32    failureCount;	/**< FailureCount */
    UINT32    averageResponseTime;	/**< AverageResponseTime */
    UINT32    minimumResponseTime;	/**< MinimumResponseTime */
    UINT32    maximumResponseTime;	/**< MaximumResponseTime */
} IPPingDiagObject;

/*! \brief _IPPingDiagObject is used internally to represent IPPingDiagObject */
typedef IPPingDiagObject _IPPingDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_RFDevice.
 *
 * MDMOID_RF_DEV 55
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    present;	/**< Present */
    UBOOL8    enable;	/**< Enable */
    UBOOL8    alarm;	/**< Alarm */
    UBOOL8    signalDetected;	/**< SignalDetected */
    char *    vendorName;	/**< VendorName */
    UINT32    moduleType;	/**< ModuleType */
    char *    vendorPn;	/**< VendorPn */
    char *    vendorRev;	/**< VendorRev */
    char *    sn;	/**< Sn */
    char *    datecode;	/**< Datecode */
    UINT32    rfBandwidth;	/**< RfBandwidth */
    UINT32    rfRxWavelength;	/**< RfRxWavelength */
    UINT32    responsivity;	/**< Responsivity */
    UINT32    minRfTxPower;	/**< MinRfTxPower */
    SINT32    maxRfRxPower;	/**< MaxRfRxPower */
    SINT32    minRfRxPower;	/**< MinRfRxPower */
    SINT32    temperature;	/**< Temperature */
    UINT32    vcc;	/**< Vcc */
    UINT32    vpdmon;	/**< Vpdmon */
    UINT32    rfmon;	/**< Rfmon */
    UBOOL8    interrupt;	/**< Interrupt */
    UBOOL8    tempHiAlarm;	/**< TempHiAlarm */
    UBOOL8    tempLoAlarm;	/**< TempLoAlarm */
    UBOOL8    tempHiWarn;	/**< TempHiWarn */
    UBOOL8    tempLoWarn;	/**< TempLoWarn */
    UBOOL8    vccHiAlarm;	/**< VccHiAlarm */
    UBOOL8    vccLoAlarm;	/**< VccLoAlarm */
    UBOOL8    vccHiWarn;	/**< VccHiWarn */
    UBOOL8    vccLoWarn;	/**< VccLoWarn */
    UBOOL8    vpdmonHiAlarm;	/**< VpdmonHiAlarm */
    UBOOL8    vpdmonLoAlarm;	/**< VpdmonLoAlarm */
    UBOOL8    vpdmonHiWarn;	/**< VpdmonHiWarn */
    UBOOL8    vpdmonLoWarn;	/**< VpdmonLoWarn */
    UBOOL8    rfmonHiAlarm;	/**< RfmonHiAlarm */
    UBOOL8    rfmonLoAlarm;	/**< RfmonLoAlarm */
    UBOOL8    rfmonHiWarn;	/**< RfmonHiWarn */
    UBOOL8    rfmonLoWarn;	/**< RfmonLoWarn */
    SINT32    tempHiAlarmThld;	/**< TempHiAlarmThld */
    SINT32    tempLoAlarmThld;	/**< TempLoAlarmThld */
    SINT32    tempHiWarnThld;	/**< TempHiWarnThld */
    SINT32    tempLoWarnThld;	/**< TempLoWarnThld */
    UINT32    vccHiAlarmThld;	/**< VccHiAlarmThld */
    UINT32    vccLoAlarmThld;	/**< VccLoAlarmThld */
    UINT32    vccHiWarnThld;	/**< VccHiWarnThld */
    UINT32    vccLoWarnThld;	/**< VccLoWarnThld */
    UINT32    vpdmonHiAlarmThld;	/**< VpdmonHiAlarmThld */
    UINT32    vpdmonLoAlarmThld;	/**< VpdmonLoAlarmThld */
    SINT32    vpdmonHiWarnThld;	/**< VpdmonHiWarnThld */
    UINT32    vpdmonLoWarnThld;	/**< VpdmonLoWarnThld */
    UINT32    rfmonHiAlarmThld;	/**< RfmonHiAlarmThld */
    UINT32    rfmonLoAlarmThld;	/**< RfmonLoAlarmThld */
    UINT32    rfmonHiWarnThld;	/**< RfmonHiWarnThld */
    UINT32    rfmonLoWarnThld;	/**< RfmonLoWarnThld */
} RfDevObject;

/*! \brief _RfDevObject is used internally to represent RfDevObject */
typedef RfDevObject _RfDevObject;



/*! \brief Obj struct for InternetGatewayDevice.EponSoftwareImage.{i}.
 *
 * MDMOID_EPON_SOFTWARE_IMAGE 56
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  version;	/**< Version */
    UBOOL8    isCommitted;	/**< IsCommitted */
    UBOOL8    isActive;	/**< IsActive */
    UBOOL8    isValid;	/**< IsValid */
} EponSoftwareImageObject;

/*! \brief _EponSoftwareImageObject is used internally to represent EponSoftwareImageObject */
typedef EponSoftwareImageObject _EponSoftwareImageObject;



/*! \brief Obj struct for InternetGatewayDevice.EponSwUpgradeStatus.
 *
 * MDMOID_EPON_SW_UPGRADE_STATUS 57
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    ctcDownloadState;	/**< CtcDownloadState */
    UINT32    recentlyDownloadedPartition;	/**< RecentlyDownloadedPartition */
    UBOOL8    download3715Needed;	/**< Download3715Needed */
} EponSwUpgradeStatusObject;

/*! \brief _EponSwUpgradeStatusObject is used internally to represent EponSwUpgradeStatusObject */
typedef EponSwUpgradeStatusObject _EponSwUpgradeStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.
 *
 * MDMOID_LAN_DEV 58
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    LANEthernetInterfaceNumberOfEntries;	/**< LANEthernetInterfaceNumberOfEntries */
    UINT32    LANUSBInterfaceNumberOfEntries;	/**< LANUSBInterfaceNumberOfEntries */
    UINT32    LANWLANConfigurationNumberOfEntries;	/**< LANWLANConfigurationNumberOfEntries */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LANMocaInterfaceNumberOfEntries;	/**< X_BROADCOM_COM_LANMocaInterfaceNumberOfEntries */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    SINT32    X_ALLIEDTELESIS_COM_BridgeKey;	/**< X_ALLIEDTELESIS_COM_BridgeKey */
#endif
#ifdef DMP_X_BROADCOM_COM_EPON_1
    UINT32    X_BROADCOM_COM_LANEponInterfaceNumberOfEntries;	/**< X_BROADCOM_COM_LANEponInterfaceNumberOfEntries */
#endif
#ifdef DMP_WIFILAN_1
    UINT32    X_ALLIEDTELESIS_COM_Dot11ModeGroupNumberOfEntries;	/**< X_ALLIEDTELESIS_COM_Dot11ModeGroupNumberOfEntries */
#endif
} LanDevObject;

/*! \brief _LanDevObject is used internally to represent LanDevObject */
typedef LanDevObject _LanDevObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IgmpSnoopingConfig.
 *
 * MDMOID_IGMP_SNOOPING_CFG 59
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    mode;	/**< Mode */
} IgmpSnoopingCfgObject;

/*! \brief _IgmpSnoopingCfgObject is used internally to represent IgmpSnoopingCfgObject */
typedef IgmpSnoopingCfgObject _IgmpSnoopingCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.
 *
 * MDMOID_LAN_HOST_CFG 60
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    DHCPServerConfigurable;	/**< DHCPServerConfigurable */
    UBOOL8    DHCPServerEnable;	/**< DHCPServerEnable */
    UBOOL8    DHCPRelay;	/**< DHCPRelay */
    char *    X_BROADCOM_COM_DhcpRelayServer;	/**< X_BROADCOM_COM_DhcpRelayServer */
    char *    minAddress;	/**< MinAddress */
    char *    maxAddress;	/**< MaxAddress */
    char *    reservedAddresses;	/**< ReservedAddresses */
    char *    subnetMask;	/**< SubnetMask */
    char *    DNSServers;	/**< DNSServers */
    char *    domainName;	/**< DomainName */
    char *    IPRouters;	/**< IPRouters */
    SINT32    DHCPLeaseTime;	/**< DHCPLeaseTime */
    char *    X_ALLIEDTELESIS_COM_BootFileName;	/**< X_ALLIEDTELESIS_COM_BootFileName */
    UINT32    IPInterfaceNumberOfEntries;	/**< IPInterfaceNumberOfEntries */
    UINT32    DHCPOptionNumberOfEntries;	/**< DHCPOptionNumberOfEntries */
} LanHostCfgObject;

/*! \brief _LanHostCfgObject is used internally to represent LanHostCfgObject */
typedef LanHostCfgObject _LanHostCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.
 *
 * MDMOID_LAN_IP_INTF 61
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    IPInterfaceIPAddress;	/**< IPInterfaceIPAddress */
    char *    IPInterfaceSubnetMask;	/**< IPInterfaceSubnetMask */
    char *    IPInterfaceAddressingType;	/**< IPInterfaceAddressingType */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
    char *    X_ALLIEDTELESIS_COM_IfName;	/**< X_ALLIEDTELESIS_COM_IfName */
#ifdef DMP_X_BROADCOM_COM_SECURITY_1
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< X_BROADCOM_COM_FirewallEnabled */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DhcpConnectionStatus;	/**< X_BROADCOM_COM_DhcpConnectionStatus */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DhcpIpAddress;	/**< X_BROADCOM_COM_DhcpIpAddress */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DhcpSubnetMask;	/**< X_BROADCOM_COM_DhcpSubnetMask */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DhcpDefaultGateway;	/**< X_BROADCOM_COM_DhcpDefaultGateway */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_DhcpcPid;	/**< X_BROADCOM_COM_DhcpcPid */
#endif
} LanIpIntfObject;

/*! \brief _LanIpIntfObject is used internally to represent LanIpIntfObject */
typedef LanIpIntfObject _LanIpIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_IPv6LanIntfAddress.
 *
 * MDMOID_I_PV6_LAN_INTF_ADDR 62
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    uniqueLocalAddress;	/**< UniqueLocalAddress */
} IPv6LanIntfAddrObject;

/*! \brief _IPv6LanIntfAddrObject is used internally to represent IPv6LanIntfAddrObject */
typedef IPv6LanIntfAddrObject _IPv6LanIntfAddrObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_IPv6LanIntfAddress.DelegatedAddress.{i}.
 *
 * MDMOID_DELEGATED_ADDRESS 63
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    mode;	/**< Mode */
    char *    delegatedConnection;	/**< DelegatedConnection */
    char *    IPv6InterfaceAddress;	/**< IPv6InterfaceAddress */
} DelegatedAddressObject;

/*! \brief _DelegatedAddressObject is used internally to represent DelegatedAddressObject */
typedef DelegatedAddressObject _DelegatedAddressObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_LAN_IP_INTF_FIREWALL_EXCEPTION 64
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    filterName;	/**< FilterName */
    char *    IPVersion;	/**< IPVersion */
    char *    protocol;	/**< Protocol */
    UINT32    sourcePortStart;	/**< SourcePortStart */
    UINT32    sourcePortEnd;	/**< SourcePortEnd */
    UINT32    destinationPortStart;	/**< DestinationPortStart */
    UINT32    destinationPortEnd;	/**< DestinationPortEnd */
    char *    sourceIPAddress;	/**< SourceIPAddress */
    char *    sourceNetMask;	/**< SourceNetMask */
    char *    destinationIPAddress;	/**< DestinationIPAddress */
    char *    destinationNetMask;	/**< DestinationNetMask */
} LanIpIntfFirewallExceptionObject;

/*! \brief _LanIpIntfFirewallExceptionObject is used internally to represent LanIpIntfFirewallExceptionObject */
typedef LanIpIntfFirewallExceptionObject _LanIpIntfFirewallExceptionObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_IpFilterCfg.{i}.
 *
 * MDMOID_IP_FILTER_CFG 65
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    filterName;	/**< FilterName */
    char *    IPVersion;	/**< IPVersion */
    char *    protocol;	/**< Protocol */
    UINT32    sourcePortStart;	/**< SourcePortStart */
    UINT32    sourcePortEnd;	/**< SourcePortEnd */
    UINT32    destinationPortStart;	/**< DestinationPortStart */
    UINT32    destinationPortEnd;	/**< DestinationPortEnd */
    char *    sourceIPAddress;	/**< SourceIPAddress */
    char *    sourceNetMask;	/**< SourceNetMask */
    char *    destinationIPAddress;	/**< DestinationIPAddress */
    char *    destinationNetMask;	/**< DestinationNetMask */
} IpFilterCfgObject;

/*! \brief _IpFilterCfgObject is used internally to represent IpFilterCfgObject */
typedef IpFilterCfgObject _IpFilterCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.DHCPOption.{i}.
 *
 * MDMOID_DHCP_SERVER_OPTION 66
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    UINT32    tag;	/**< Tag */
    BASE64    value;	/**< Value */
} DHCPServerOptionObject;

/*! \brief _DHCPServerOptionObject is used internally to represent DHCPServerOptionObject */
typedef DHCPServerOptionObject _DHCPServerOptionObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.DHCPConditionalServingPool.{i}.
 *
 * MDMOID_DHCP_CONDITIONAL_SERVING 67
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    chaddr;	/**< Chaddr */
    char *    chaddrMask;	/**< ChaddrMask */
    char *    minAddress;	/**< MinAddress */
    char *    maxAddress;	/**< MaxAddress */
    char *    reservedAddresses;	/**< ReservedAddresses */
    char *    subnetMask;	/**< SubnetMask */
    char *    DNSServers;	/**< DNSServers */
    char *    domainName;	/**< DomainName */
    char *    IPRouters;	/**< IPRouters */
    SINT32    DHCPLeaseTime;	/**< DHCPLeaseTime */
} DHCPConditionalServingObject;

/*! \brief _DHCPConditionalServingObject is used internally to represent DHCPConditionalServingObject */
typedef DHCPConditionalServingObject _DHCPConditionalServingObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.
 *
 * MDMOID_I_PV6_LAN_HOST_CFG 68
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    DHCPv6ServerEnable;	/**< DHCPv6ServerEnable */
    UBOOL8    statefulDHCPv6Server;	/**< StatefulDHCPv6Server */
    char *    minInterfaceID;	/**< MinInterfaceID */
    char *    maxInterfaceID;	/**< MaxInterfaceID */
    SINT32    DHCPv6LeaseTime;	/**< DHCPv6LeaseTime */
    char *    IPv6DomainName;	/**< IPv6DomainName */
    char *    IPv6DNSConfigType;	/**< IPv6DNSConfigType */
    char *    IPv6DNSServers;	/**< IPv6DNSServers */
    char *    IPv6DNSWANConnection;	/**< IPv6DNSWANConnection */
    UBOOL8    X_ALLIEDTELESIS_COM_Dhcp6sRapidCommit;	/**< X_ALLIEDTELESIS_COM_Dhcp6sRapidCommit */
    UINT32    X_ALLIEDTELESIS_COM_Dhcp6sPreference;	/**< X_ALLIEDTELESIS_COM_Dhcp6sPreference */
    UINT32    IPv6InterfaceNumberOfEntries;	/**< IPv6InterfaceNumberOfEntries */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_ALLIEDTELESIS_COM_Dhcp6sPid;	/**< X_ALLIEDTELESIS_COM_Dhcp6sPid */
#endif
} IPv6LanHostCfgObject;

/*! \brief _IPv6LanHostCfgObject is used internally to represent IPv6LanHostCfgObject */
typedef IPv6LanHostCfgObject _IPv6LanHostCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.
 *
 * MDMOID_RADVD_CONFIG_MGT 69
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    UBOOL8    X_ALLIEDTELESIS_COM_ManagedFlag;	/**< X_ALLIEDTELESIS_COM_ManagedFlag */
    UBOOL8    X_ALLIEDTELESIS_COM_OtherFlag;	/**< X_ALLIEDTELESIS_COM_OtherFlag */
    UINT32    X_ALLIEDTELESIS_COM_RA_Interval;	/**< X_ALLIEDTELESIS_COM_RA_Interval */
    UINT32    X_ALLIEDTELESIS_COM_Min_RA_Interval;	/**< X_ALLIEDTELESIS_COM_Min_RA_Interval */
} RadvdConfigMgtObject;

/*! \brief _RadvdConfigMgtObject is used internally to represent RadvdConfigMgtObject */
typedef RadvdConfigMgtObject _RadvdConfigMgtObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.ULAPrefixInfo.
 *
 * MDMOID_ULA_PREFIX_INFO 70
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    UBOOL8    random;	/**< Random */
    char *    prefix;	/**< Prefix */
    SINT32    preferredLifeTime;	/**< PreferredLifeTime */
    SINT32    validLifeTime;	/**< ValidLifeTime */
} ULAPrefixInfoObject;

/*! \brief _ULAPrefixInfoObject is used internally to represent ULAPrefixInfoObject */
typedef ULAPrefixInfoObject _ULAPrefixInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.PrefixInformation.{i}.
 *
 * MDMOID_PREFIX_INFO 71
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    mode;	/**< Mode */
    char *    delegatedConnection;	/**< DelegatedConnection */
    char *    prefix;	/**< Prefix */
    SINT32    preferredLifeTime;	/**< PreferredLifeTime */
    SINT32    validLifeTime;	/**< ValidLifeTime */
} PrefixInfoObject;

/*! \brief _PrefixInfoObject is used internally to represent PrefixInfoObject */
typedef PrefixInfoObject _PrefixInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.X_BROADCOM_COM_MldSnoopingConfig.
 *
 * MDMOID_MLD_SNOOPING_CFG 72
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    mode;	/**< Mode */
} MldSnoopingCfgObject;

/*! \brief _MldSnoopingCfgObject is used internally to represent MldSnoopingCfgObject */
typedef MldSnoopingCfgObject _MldSnoopingCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.
 *
 * MDMOID_LAN_ETH_INTF 73
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    interfaceType;	/**< InterfaceType */
    char *    MACAddress;	/**< MACAddress */
    UBOOL8    MACAddressControlEnabled;	/**< MACAddressControlEnabled */
    char *    maxBitRate;	/**< MaxBitRate */
    char *    duplexMode;	/**< DuplexMode */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
    SINT32    X_BROADCOM_COM_EthernetPriorityMark;	/**< X_BROADCOM_COM_EthernetPriorityMark */
    SINT32    X_BROADCOM_COM_dot1qPvid;	/**< X_BROADCOM_COM_dot1qPvid */
    UINT32    X_BROADCOM_COM_VLAN_Enable;	/**< X_BROADCOM_COM_VLAN_Enable */
    char *    X_BROADCOM_COM_VLAN_TagList;	/**< X_BROADCOM_COM_VLAN_TagList */
    char *    X_ALLIEDTELESIS_COM_IfName;	/**< X_ALLIEDTELESIS_COM_IfName */
    SINT32    X_ALLIEDTELESIS_COM_VID;	/**< X_ALLIEDTELESIS_COM_VID */
    SINT32    X_ALLIEDTELESIS_COM_VIDTranslate;	/**< X_ALLIEDTELESIS_COM_VIDTranslate */
    UBOOL8    X_ALLIEDTELESIS_COM_Untagged;	/**< X_ALLIEDTELESIS_COM_Untagged */
} LanEthIntfObject;

/*! \brief _LanEthIntfObject is used internally to represent LanEthIntfObject */
typedef LanEthIntfObject _LanEthIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.X_ALLIEDTELESIS_COM_BaseInterfaceCfg.
 *
 * MDMOID_LAN_ETH_BASE_INTF_CFG 74
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    interfaceType;	/**< InterfaceType */
    char *    maxBitRate;	/**< MaxBitRate */
    char *    duplexMode;	/**< DuplexMode */
    SINT32    defaultPriority;	/**< DefaultPriority */
    UBOOL8    pauseEnable;	/**< PauseEnable */
    SINT32    egressRateLimit;	/**< EgressRateLimit */
    SINT32    ingressRateLimit;	/**< IngressRateLimit */
    char *    priorityScheme;	/**< PriorityScheme */
    UBOOL8    mirror;	/**< Mirror */
    UBOOL8    capture;	/**< Capture */
    char *    currentPortLinkSpeed;	/**< CurrentPortLinkSpeed */
    char *    currentPortLinkDuplex;	/**< CurrentPortLinkDuplex */
    char *    bitRateCapability;	/**< BitRateCapability */
    UBOOL8    jumboFrameEnable;	/**< JumboFrameEnable */
    UBOOL8    ISPQinQPort;	/**< ISPQinQPort */
    UBOOL8    protected;	/**< Protected */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    RAGuard;	/**< RAGuard */
#endif
    char *    loopDetectionAction;	/**< LoopDetectionAction */
    char *    loopDetectionStatus;	/**< LoopDetectionStatus */
    UBOOL8    loopDetectionTransition;	/**< LoopDetectionTransition */
} LanEthBaseIntfCfgObject;

/*! \brief _LanEthBaseIntfCfgObject is used internally to represent LanEthBaseIntfCfgObject */
typedef LanEthBaseIntfCfgObject _LanEthBaseIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_ETH_INTF_STATS 75
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    bytesReceived;	/**< BytesReceived */
    UINT32    packetsSent;	/**< PacketsSent */
    UINT32    packetsReceived;	/**< PacketsReceived */
    UINT32    X_BROADCOM_COM_PacketsSent;	/**< X_BROADCOM_COM_PacketsSent */
    UINT32    X_BROADCOM_COM_PacketsReceived;	/**< X_BROADCOM_COM_PacketsReceived */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< X_BROADCOM_COM_TxErrors */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< X_BROADCOM_COM_RxErrors */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< X_BROADCOM_COM_TxDrops */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< X_BROADCOM_COM_RxDrops */
} LanEthIntfStatsObject;

/*! \brief _LanEthIntfStatsObject is used internally to represent LanEthIntfStatsObject */
typedef LanEthIntfStatsObject _LanEthIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.X_ALLIEDTELESIS_COM_BaseInterfaceStat.
 *
 * MDMOID_LAN_ETH_BASE_INTF_STAT 76
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    resetStatistics;	/**< ResetStatistics */
    UINT32    ifInOctets;	/**< snmpIfInOctets */
    UINT32    ifInUcastPkts;	/**< snmpIfInUcastPkts */
    UINT32    ifInNUcastPkts;	/**< snmpIfInNUcastPkts */
    UINT32    ifInDiscards;	/**< snmpIfInDiscards */
    UINT32    ifInErrors;	/**< snmpIfInErrors */
    UINT32    ifInUnknownProtos;	/**< snmpIfInUnknownProtos */
    UINT32    ifOutOctets;	/**< snmpIfOutOctets */
    UINT32    ifOutUcastPkts;	/**< snmpIfOutUcastPkts */
    UINT32    ifOutNUcastPkts;	/**< snmpIfOutNUcastPkts */
    UINT32    ifOutDiscards;	/**< snmpIfOutDiscards */
    UINT32    ifOutErrors;	/**< snmpIfOutErrors */
    UINT32    ifOutQLen;	/**< snmpIfOutQLen */
    UINT32    ipInReceives;	/**< snmpIpInReceives */
    UINT32    ipInHdrErrors;	/**< snmpIpInHdrErrors */
    UINT32    ipForwDatagrams;	/**< snmpIpForwDatagrams */
    UINT32    ipInDiscards;	/**< snmpIpInDiscards */
    UINT32    dot1dBasePortDelayExceededDiscards;	/**< snmpDot1dBasePortDelayExceededDiscards */
    UINT32    dot1dBasePortMtuExceededDiscards;	/**< snmpDot1dBasePortMtuExceededDiscards */
    UINT32    dot1dTpPortInFrames;	/**< snmpDot1dTpPortInFrames */
    UINT32    dot1dTpPortOutFrames;	/**< snmpDot1dTpPortOutFrames */
    UINT32    dot1dPortInDiscards;	/**< snmpDot1dPortInDiscards */
    UINT32    etherStatsDropEvents;	/**< snmpEtherStatsDropEvents */
    UINT32    etherStatsMulticastPkts;	/**< snmpEtherStatsMulticastPkts */
    UINT32    etherStatsBroadcastPkts;	/**< snmpEtherStatsBroadcastPkts */
    UINT32    etherStatsUndersizePkts;	/**< snmpEtherStatsUndersizePkts */
    UINT32    etherStatsFragments;	/**< snmpEtherStatsFragments */
    UINT32    etherStatsPkts64Octets;	/**< snmpEtherStatsPkts64Octets */
    UINT32    etherStatsPkts65to127Octets;	/**< snmpEtherStatsPkts65to127Octets */
    UINT32    etherStatsPkts128to255Octets;	/**< snmpEtherStatsPkts128to255Octets */
    UINT32    etherStatsPkts256to511Octets;	/**< snmpEtherStatsPkts256to511Octets */
    UINT32    etherStatsPkts512to1023Octets;	/**< snmpEtherStatsPkts512to1023Octets */
    UINT32    etherStatsPkts1024to1518Octets;	/**< snmpEtherStatsPkts1024to1518Octets */
    UINT32    etherStatsOversizePkts;	/**< snmpEtherStatsOversizePkts */
    UINT32    etherStatsJabbers;	/**< snmpEtherStatsJabbers */
    UINT32    etherStatsOctets;	/**< snmpEtherStatsOctets */
    UINT32    etherStatsPkts;	/**< snmpEtherStatsPkts */
    UINT32    etherStatsCollisions;	/**< snmpEtherStatsCollisions */
    UINT32    etherStatsCRCAlignErrors;	/**< snmpEtherStatsCRCAlignErrors */
    UINT32    etherStatsTXNoErrors;	/**< snmpEtherStatsTXNoErrors */
    UINT32    etherStatsRXNoErrors;	/**< snmpEtherStatsRXNoErrors */
    UINT32    dot3StatsAlignmentErrors;	/**< snmpDot3StatsAlignmentErrors */
    UINT32    dot3StatsFCSErrors;	/**< snmpDot3StatsFCSErrors */
    UINT32    dot3StatsSingleCollisionFrames;	/**< snmpDot3StatsSingleCollisionFrames */
    UINT32    dot3StatsMultipleCollisionFrames;	/**< snmpDot3StatsMultipleCollisionFrames */
    UINT32    dot3StatsSQETTestErrors;	/**< snmpDot3StatsSQETTestErrors */
    UINT32    dot3StatsDeferredTransmissions;	/**< snmpDot3StatsDeferredTransmissions */
    UINT32    dot3StatsLateCollisions;	/**< snmpDot3StatsLateCollisions */
    UINT32    dot3StatsExcessiveCollisions;	/**< snmpDot3StatsExcessiveCollisions */
    UINT32    dot3StatsInternalMacTransmitErrors;	/**< snmpDot3StatsInternalMacTransmitErrors */
    UINT32    dot3StatsCarrierSenseErrors;	/**< snmpDot3StatsCarrierSenseErrors */
    UINT32    dot3StatsFrameTooLongs;	/**< snmpDot3StatsFrameTooLongs */
    UINT32    dot3StatsInternalMacReceiveErrors;	/**< snmpDot3StatsInternalMacReceiveErrors */
    UINT32    dot3StatsSymbolErrors;	/**< snmpDot3StatsSymbolErrors */
    UINT32    dot3ControlInUnknownOpcodes;	/**< snmpDot3ControlInUnknownOpcodes */
    UINT32    dot3InPauseFrames;	/**< snmpDot3InPauseFrames */
    UINT32    dot3OutPauseFrames;	/**< snmpDot3OutPauseFrames */
    UINT32    ifHCInOctets_HI;	/**< snmpIfHCInOctets_HI */
    UINT32    ifHCInOctets_LOW;	/**< snmpIfHCInOctets_LOW */
    UINT32    ifHCInUcastPkts_HI;	/**< snmpIfHCInUcastPkts_HI */
    UINT32    ifHCInUcastPkts_LOW;	/**< snmpIfHCInUcastPkts_LOW */
    UINT32    ifHCInMulticastPkts_HI;	/**< snmpIfHCInMulticastPkts_HI */
    UINT32    ifHCInMulticastPkts_LOW;	/**< snmpIfHCInMulticastPkts_LOW */
    UINT32    ifHCInBroadcastPkts_HI;	/**< snmpIfHCInBroadcastPkts_HI */
    UINT32    ifHCInBroadcastPkts_LOW;	/**< snmpIfHCInBroadcastPkts_LOW */
    UINT32    ifHCOutOctets_HI;	/**< snmpIfHCOutOctets_HI */
    UINT32    ifHCOutOctets_LOW;	/**< snmpIfHCOutOctets_LOW */
    UINT32    ifHCOutUcastPkts_HI;	/**< snmpIfHCOutUcastPkts_HI */
    UINT32    ifHCOutUcastPkts_LOW;	/**< snmpIfHCOutUcastPkts_LOW */
    UINT32    ifHCOutMulticastPkts_HI;	/**< snmpIfHCOutMulticastPkts_HI */
    UINT32    ifHCOutMulticastPkts_LOW;	/**< snmpIfHCOutMulticastPkts_LOW */
    UINT32    ifHCOutBroadcastPckts_HI;	/**< snmpIfHCOutBroadcastPckts_HI */
    UINT32    ifHCOutBroadcastPckts_LOW;	/**< snmpIfHCOutBroadcastPckts_LOW */
    UINT32    ipv6IfStatsInReceives;	/**< snmpIpv6IfStatsInReceives */
    UINT32    ipv6IfStatsInHdrErrors;	/**< snmpIpv6IfStatsInHdrErrors */
    UINT32    ipv6IfStatsInAddrErrors;	/**< snmpIpv6IfStatsInAddrErrors */
    UINT32    ipv6IfStatsInDiscards;	/**< snmpIpv6IfStatsInDiscards */
    UINT32    ipv6IfStatsOutForwDatagrams;	/**< snmpIpv6IfStatsOutForwDatagrams */
    UINT32    ipv6IfStatsOutDiscards;	/**< snmpIpv6IfStatsOutDiscards */
    UINT32    ipv6IfStatsInMcastPkts;	/**< snmpIpv6IfStatsInMcastPkts */
    UINT32    ipv6IfStatsOutMcastPkts;	/**< snmpIpv6IfStatsOutMcastPkts */
} LanEthBaseIntfStatObject;

/*! \brief _LanEthBaseIntfStatObject is used internally to represent LanEthBaseIntfStatObject */
typedef LanEthBaseIntfStatObject _LanEthBaseIntfStatObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.X_ALLIEDTELESIS_COM_FwdDatabase.
 *
 * MDMOID_LAN_FWD_DATABASE 77
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    clearFwdDatabase;	/**< ClearFwdDatabase */
    UBOOL8    clearFwdDatabaseStatic;	/**< ClearFwdDatabaseStatic */
    UINT32    fwdDatabaseCount;	/**< FwdDatabaseCount */
    char *    LANFwdDatabase;	/**< LANFwdDatabase */
} LanFwdDatabaseObject;

/*! \brief _LanFwdDatabaseObject is used internally to represent LanFwdDatabaseObject */
typedef LanFwdDatabaseObject _LanFwdDatabaseObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.X_ALLIEDTELESIS_COM_IgmpStatus.
 *
 * MDMOID_LAN_IGMP_STATUS 78
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    clearIgmpCounters;	/**< ClearIgmpCounters */
    UINT32    igmpQueryTxCount;	/**< IgmpQueryTxCount */
    UINT32    igmpGroupSpecificQueryTxCount;	/**< IgmpGroupSpecificQueryTxCount */
    UINT32    igmpV3QueryTxCount;	/**< IgmpV3QueryTxCount */
    UINT32    igmpReportTxCount;	/**< IgmpReportTxCount */
    UINT32    igmpLeaveTxCount;	/**< IgmpLeaveTxCount */
    UINT32    igmpV3ReportTxCount;	/**< IgmpV3ReportTxCount */
    UINT32    igmpQueryRxCount;	/**< IgmpQueryRxCount */
    UINT32    igmpGroupSpecificQueryRxCount;	/**< IgmpGroupSpecificQueryRxCount */
    UINT32    igmpV3QueryRxCount;	/**< IgmpV3QueryRxCount */
    UINT32    igmpReportRxCount;	/**< IgmpReportRxCount */
    UINT32    igmpLeaveRxCount;	/**< IgmpLeaveRxCount */
    UINT32    igmpV3ReportRxCount;	/**< IgmpV3ReportRxCount */
    UINT32    igmpMCastStreamCount;	/**< IgmpMCastStreamCount */
} LanIgmpStatusObject;

/*! \brief _LanIgmpStatusObject is used internally to represent LanIgmpStatusObject */
typedef LanIgmpStatusObject _LanIgmpStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.X_ALLIEDTELESIS_COM_IgmpStatus.X_ALLIED_TELESIS_IgmpMCastStream.{i}.
 *
 * MDMOID_LAN_IGMP_M_CAST_STREAM 79
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    source;	/**< Source */
    char *    group;	/**< Group */
    char *    reporter;	/**< Reporter */
    char *    reporterList;	/**< ReporterList */
    UINT32    upTime;	/**< UpTime */
    UINT32    lastJoin;	/**< LastJoin */
    UINT32    lastLeave;	/**< LastLeave */
    UINT32    expires;	/**< Expires */
} LanIgmpMCastStreamObject;

/*! \brief _LanIgmpMCastStreamObject is used internally to represent LanIgmpMCastStreamObject */
typedef LanIgmpMCastStreamObject _LanIgmpMCastStreamObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANUSBInterfaceConfig.{i}.
 *
 * MDMOID_LAN_USB_INTF 80
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    MACAddress;	/**< MACAddress */
    UBOOL8    MACAddressControlEnabled;	/**< MACAddressControlEnabled */
    char *    standard;	/**< Standard */
    char *    type;	/**< Type */
    char *    rate;	/**< Rate */
    char *    power;	/**< Power */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
} LanUsbIntfObject;

/*! \brief _LanUsbIntfObject is used internally to represent LanUsbIntfObject */
typedef LanUsbIntfObject _LanUsbIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANUSBInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_USB_INTF_STATS 81
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    bytesReceived;	/**< BytesReceived */
    UINT32    cellsSent;	/**< CellsSent */
    UINT32    cellsReceived;	/**< CellsReceived */
    UINT32    X_BROADCOM_COM_PacketsSent;	/**< X_BROADCOM_COM_PacketsSent */
    UINT32    X_BROADCOM_COM_PacketsReceived;	/**< X_BROADCOM_COM_PacketsReceived */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< X_BROADCOM_COM_TxErrors */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< X_BROADCOM_COM_RxErrors */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< X_BROADCOM_COM_TxDrops */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< X_BROADCOM_COM_RxDrops */
} LanUsbIntfStatsObject;

/*! \brief _LanUsbIntfStatsObject is used internally to represent LanUsbIntfStatsObject */
typedef LanUsbIntfStatsObject _LanUsbIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.
 *
 * MDMOID_LAN_WLAN 82
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    BSSID;	/**< BSSID */
    char *    maxBitRate;	/**< MaxBitRate */
    UINT32    channel;	/**< Channel */
    char *    SSID;	/**< SSID */
    char *    beaconType;	/**< BeaconType */
    UBOOL8    MACAddressControlEnabled;	/**< MACAddressControlEnabled */
    char *    standard;	/**< Standard */
    UINT32    WEPKeyIndex;	/**< WEPKeyIndex */
    char *    keyPassphrase;	/**< KeyPassphrase */
    char *    WEPEncryptionLevel;	/**< WEPEncryptionLevel */
    char *    basicEncryptionModes;	/**< BasicEncryptionModes */
    char *    basicAuthenticationMode;	/**< BasicAuthenticationMode */
    char *    WPAEncryptionModes;	/**< WPAEncryptionModes */
    char *    WPAAuthenticationMode;	/**< WPAAuthenticationMode */
    char *    IEEE11iEncryptionModes;	/**< IEEE11iEncryptionModes */
    char *    IEEE11iAuthenticationMode;	/**< IEEE11iAuthenticationMode */
    char *    possibleChannels;	/**< PossibleChannels */
    char *    basicDataTransmitRates;	/**< BasicDataTransmitRates */
    char *    operationalDataTransmitRates;	/**< OperationalDataTransmitRates */
    char *    possibleDataTransmitRates;	/**< PossibleDataTransmitRates */
    UBOOL8    insecureOOBAccessEnabled;	/**< InsecureOOBAccessEnabled */
    UBOOL8    beaconAdvertisementEnabled;	/**< BeaconAdvertisementEnabled */
    UBOOL8    radioEnabled;	/**< RadioEnabled */
    UBOOL8    autoRateFallBackEnabled;	/**< AutoRateFallBackEnabled */
    char *    locationDescription;	/**< LocationDescription */
    char *    regulatoryDomain;	/**< RegulatoryDomain */
    UINT32    totalPSKFailures;	/**< TotalPSKFailures */
    UINT32    totalIntegrityFailures;	/**< TotalIntegrityFailures */
    char *    channelsInUse;	/**< ChannelsInUse */
    char *    deviceOperationMode;	/**< DeviceOperationMode */
    UINT32    distanceFromRoot;	/**< DistanceFromRoot */
    char *    peerBSSID;	/**< PeerBSSID */
    char *    authenticationServiceMode;	/**< AuthenticationServiceMode */
    UINT32    totalBytesSent;	/**< TotalBytesSent */
    UINT32    totalBytesReceived;	/**< TotalBytesReceived */
    UINT32    totalPacketsSent;	/**< TotalPacketsSent */
    UINT32    totalPacketsReceived;	/**< TotalPacketsReceived */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< X_BROADCOM_COM_RxErrors */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< X_BROADCOM_COM_RxDrops */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< X_BROADCOM_COM_TxErrors */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< X_BROADCOM_COM_TxDrops */
    UINT32    totalAssociations;	/**< TotalAssociations */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
    UBOOL8    X_BROADCOM_COM_HideSSID;	/**< X_BROADCOM_COM_HideSSID */
    UBOOL8    X_ALLIEDTELESIS_COM_IsolateClients;	/**< X_ALLIEDTELESIS_COM_IsolateClients */
    SINT32    X_ALLIEDTELESIS_COM_MaxAssociations;	/**< X_ALLIEDTELESIS_COM_MaxAssociations */
    char *    X_ALLIEDTELESIS_COM_DriverVersion;	/**< X_ALLIEDTELESIS_COM_DriverVersion */
    char *    X_ALLIEDTELESIS_COM_HostapdVersion;	/**< X_ALLIEDTELESIS_COM_HostapdVersion */
    UINT32    X_ALLIEDTELESIS_COM_RadioIndex;	/**< X_ALLIEDTELESIS_COM_RadioIndex */
    UINT32    X_ALLIEDTELESIS_COM_SSIDOnRadio;	/**< X_ALLIEDTELESIS_COM_SSIDOnRadio */
    char *    X_ALLIEDTELESIS_COM_RadioDevice;	/**< X_ALLIEDTELESIS_COM_RadioDevice */
    UINT32    X_ALLIEDTELESIS_COM_SSIDIndex;	/**< X_ALLIEDTELESIS_COM_SSIDIndex */
    UBOOL8    X_ALLIEDTELESIS_COM_UserEnable;	/**< X_ALLIEDTELESIS_COM_UserEnable */
    char *    X_ALLIEDTELESIS_COM_MacAddrControl;	/**< X_ALLIEDTELESIS_COM_MacAddrControl */
    char *    X_ALLIEDTELESIS_COM_MacBlackList;	/**< X_ALLIEDTELESIS_COM_MacBlackList */
    char *    X_ALLIEDTELESIS_COM_MacWhiteList;	/**< X_ALLIEDTELESIS_COM_MacWhiteList */
    char *    X_ALLIEDTELESIS_COM_CurrentStandard;	/**< X_ALLIEDTELESIS_COM_CurrentStandard */
    char *    X_ALLIEDTELESIS_COM_IfName;	/**< X_ALLIEDTELESIS_COM_IfName */
    UBOOL8    X_ALLIEDTELESIS_COM_AutoChannelEnable;	/**< X_ALLIEDTELESIS_COM_AutoChannelEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_WirelessButtonStatus;	/**< X_ALLIEDTELESIS_COM_WirelessButtonStatus */
    UINT32    X_ALLIEDTELESIS_COM_BitRate;	/**< X_ALLIEDTELESIS_COM_BitRate */
} LanWlanObject;

/*! \brief _LanWlanObject is used internally to represent LanWlanObject */
typedef LanWlanObject _LanWlanObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.AssociatedDevice.{i}.
 *
 * MDMOID_LAN_WLAN_ASSOCIATED_DEVICE_ENTRY 83
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    associatedDeviceMACAddress;	/**< AssociatedDeviceMACAddress */
    char *    associatedDeviceIPAddress;	/**< AssociatedDeviceIPAddress */
    UBOOL8    associatedDeviceAuthenticationState;	/**< AssociatedDeviceAuthenticationState */
    char *    lastRequestedUnicastCipher;	/**< LastRequestedUnicastCipher */
    char *    lastRequestedMulticastCipher;	/**< LastRequestedMulticastCipher */
    char *    lastPMKId;	/**< LastPMKId */
    char *    lastDataTransmitRate;	/**< LastDataTransmitRate */
    UBOOL8    X_ALLIEDTELESIS_COM_Associated;	/**< X_ALLIEDTELESIS_COM_Associated */
} LanWlanAssociatedDeviceEntryObject;

/*! \brief _LanWlanAssociatedDeviceEntryObject is used internally to represent LanWlanAssociatedDeviceEntryObject */
typedef LanWlanAssociatedDeviceEntryObject _LanWlanAssociatedDeviceEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.WEPKey.{i}.
 *
 * MDMOID_LAN_WLAN_WEP_KEY 84
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    WEPKey;	/**< WEPKey */
} LanWlanWepKeyObject;

/*! \brief _LanWlanWepKeyObject is used internally to represent LanWlanWepKeyObject */
typedef LanWlanWepKeyObject _LanWlanWepKeyObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.PreSharedKey.{i}.
 *
 * MDMOID_LAN_WLAN_PRE_SHARED_KEY 85
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    preSharedKey;	/**< PreSharedKey */
    char *    keyPassphrase;	/**< KeyPassphrase */
    char *    associatedDeviceMACAddress;	/**< AssociatedDeviceMACAddress */
} LanWlanPreSharedKeyObject;

/*! \brief _LanWlanPreSharedKeyObject is used internally to represent LanWlanPreSharedKeyObject */
typedef LanWlanPreSharedKeyObject _LanWlanPreSharedKeyObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_ALLIEDTELESIS_COM_Dot11ModeGroup.{i}.
 *
 * MDMOID_DOT11_MODE_GROUP 86
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    radioIndex;	/**< RadioIndex */
    UINT32    SSIDOnRadio;	/**< SSIDOnRadio */
    UINT32    SSIDIndex;	/**< SSIDIndex */
    UINT32    WEPKeyIndex;	/**< WEPKeyIndex */
    char *    WEPKey1;	/**< WEPKey1 */
    char *    WEPKey2;	/**< WEPKey2 */
    char *    WEPKey3;	/**< WEPKey3 */
    char *    WEPKey4;	/**< WEPKey4 */
    char *    ifName;	/**< IfName */
    char *    radioDevice;	/**< RadioDevice */
    char *    currentStandard;	/**< CurrentStandard */
    UINT32    channel;	/**< Channel */
    char *    driverVersion;	/**< DriverVersion */
    char *    hostapdVersion;	/**< HostapdVersion */
    UBOOL8    radioEnabled;	/**< RadioEnabled */
    char *    possibleChannels;	/**< PossibleChannels */
    char *    regulatoryDomain;	/**< RegulatoryDomain */
    char *    WEPEncryptionLevel;	/**< WEPEncryptionLevel */
    char *    SSID;	/**< SSID */
    char *    beaconType;	/**< BeaconType */
    char *    basicEncryptionModes;	/**< BasicEncryptionModes */
    char *    WPAEncryptionModes;	/**< WPAEncryptionModes */
    char *    IEEE11iEncryptionModes;	/**< IEEE11iEncryptionModes */
    char *    basicAuthenticationMode;	/**< BasicAuthenticationMode */
    char *    WPAAuthenticationMode;	/**< WPAAuthenticationMode */
    char *    IEEE11iAuthenticationMode;	/**< IEEE11iAuthenticationMode */
    char *    macAddrControl;	/**< MacAddrControl */
    char *    macBlackList;	/**< MacBlackList */
    char *    macWhiteList;	/**< MacWhiteList */
    UBOOL8    isolateClients;	/**< IsolateClients */
    SINT32    maxAssociations;	/**< MaxAssociations */
    UBOOL8    hideSSID;	/**< HideSSID */
    char *    broadcomIfName;	/**< BroadcomIfName */
    UINT32    totalBytesSent;	/**< TotalBytesSent */
    UINT32    totalBytesReceived;	/**< TotalBytesReceived */
    UINT32    totalPacketsSent;	/**< TotalPacketsSent */
    UINT32    totalPacketsReceived;	/**< TotalPacketsReceived */
    UINT32    rxErrors;	/**< RxErrors */
    UINT32    rxDrops;	/**< RxDrops */
    UINT32    txErrors;	/**< TxErrors */
    UINT32    txDrops;	/**< TxDrops */
    char *    status;	/**< Status */
    char *    BSSID;	/**< BSSID */
    UBOOL8    vlanAttached;	/**< VlanAttached */
    UBOOL8    userEnable;	/**< UserEnable */
    UBOOL8    autoChannelEnable;	/**< AutoChannelEnable */
    UBOOL8    wirelessButtonStatus;	/**< WirelessButtonStatus */
    UINT32    bitRate;	/**< BitRate */
    char *    preSharedKey;	/**< PreSharedKey */
    char *    keyPassphrase;	/**< KeyPassphrase */
} Dot11ModeGroupObject;

/*! \brief _Dot11ModeGroupObject is used internally to represent Dot11ModeGroupObject */
typedef Dot11ModeGroupObject _Dot11ModeGroupObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANMocaInterfaceConfig.{i}.
 *
 * MDMOID_LAN_MOCA_INTF 87
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    ifName;	/**< IfName */
    char *    connectionMode;	/**< ConnectionMode */
    UINT32    loopbackConfiguration;	/**< LoopbackConfiguration */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
    char *    mocaControl;	/**< MocaControl */
    UINT32    maxFrameSize;	/**< MaxFrameSize */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
    UBOOL8    pppoeFilter;	/**< PppoeFilter */
    UINT32    networkStatus;	/**< NetworkStatus */
    char *    password;	/**< Password */
    UBOOL8    privacy;	/**< Privacy */
    UINT32    minBandwidthAlarmThreshold;	/**< MinBandwidthAlarmThreshold */
    UINT32    frequencyMask;	/**< FrequencyMask */
    UINT32    rfChannel;	/**< RfChannel */
    UINT32    lastOperationalFrequency;	/**< LastOperationalFrequency */
    UINT32    ncMode;	/**< NcMode */
    UBOOL8    autoNwSearch;	/**< AutoNwSearch */
    UBOOL8    txPwrControl;	/**< TxPwrControl */
    UINT32    continuousPowerMode;	/**< ContinuousPowerMode */
    UINT32    mcastMode;	/**< McastMode */
    UBOOL8    labMode;	/**< LabMode */
    UBOOL8    eclQTagMode;	/**< EclQTagMode */
    UINT32    maxTransmitTime;	/**< MaxTransmitTime */
    SINT32    maxTransmitPower;	/**< MaxTransmitPower */
    SINT32    snrMargin;	/**< SnrMargin */
    UINT32    outOfOrderLmo;	/**< OutOfOrderLmo */
    UBOOL8    lmoReportEnable;	/**< LmoReportEnable */
    UINT32    tabooMaskStart;	/**< TabooMaskStart */
    UINT32    tabooChannelMask;	/**< TabooChannelMask */
    UBOOL8    continuousIerrInsert;	/**< ContinuousIerrInsert */
    UBOOL8    continuousIeMapInsert;	/**< ContinuousIeMapInsert */
    UINT32    maxPktAggr;	/**< MaxPktAggr */
    UINT32    maxConstellationNode;	/**< MaxConstellationNode */
    UINT32    maxConstellation;	/**< MaxConstellation */
    UBOOL8    preferedNetworkController;	/**< PreferedNetworkController */
    UINT32    pmkExchangeInterval;	/**< PmkExchangeInterval */
    UINT32    tekExchangeInterval;	/**< TekExchangeInterval */
    UINT32    traceLevel;	/**< TraceLevel */
    UBOOL8    traceLevelRestoreDefault;	/**< TraceLevelRestoreDefault */
    UINT32    mrNonDefSeqNumber;	/**< MrNonDefSeqNumber */
    char *    initParmsString;	/**< InitParmsString */
    char *    configParmsString;	/**< ConfigParmsString */
    char *    traceParmsString;	/**< TraceParmsString */
    UBOOL8    limitedConnections;	/**< LimitedConnections */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    maxConnections;	/**< MaxConnections */
#endif
} LanMocaIntfObject;

/*! \brief _LanMocaIntfObject is used internally to represent LanMocaIntfObject */
typedef LanMocaIntfObject _LanMocaIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANMocaInterfaceConfig.{i}.Status.
 *
 * MDMOID_LAN_MOCA_INTF_STATUS 88
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    vendorId;	/**< VendorId */
    UINT32    hwVersion;	/**< HwVersion */
    UINT32    softwareVersion;	/**< SoftwareVersion */
    UINT32    driverMajorVersion;	/**< DriverMajorVersion */
    UINT32    driverMinorVersion;	/**< DriverMinorVersion */
    UINT32    driverBuildVersion;	/**< DriverBuildVersion */
    UINT32    selfMoCAVersion;	/**< SelfMoCAVersion */
    UINT32    networkVersionNumber;	/**< NetworkVersionNumber */
    UINT32    qam256Support;	/**< Qam256Support */
    UINT32    operationalStatus;	/**< OperationalStatus */
    UINT32    linkStatus;	/**< LinkStatus */
    UINT32    connectedNodes;	/**< ConnectedNodes */
    UINT32    nodeId;	/**< NodeId */
    UINT32    networkControllerNodeId;	/**< NetworkControllerNodeId */
    UINT32    upTime;	/**< UpTime */
    UINT32    linkUpTime;	/**< LinkUpTime */
    UINT32    backupNetworkControllerNodeId;	/**< BackupNetworkControllerNodeId */
    UINT32    rfChannel;	/**< RfChannel */
    UINT32    bwStatus;	/**< BwStatus */
} LanMocaIntfStatusObject;

/*! \brief _LanMocaIntfStatusObject is used internally to represent LanMocaIntfStatusObject */
typedef LanMocaIntfStatusObject _LanMocaIntfStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANMocaInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_MOCA_INTF_STATS 89
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    inUcPkts;	/**< InUcPkts */
    UINT32    inDiscardPktsEcl;	/**< InDiscardPktsEcl */
    UINT32    inDiscardPktsMac;	/**< InDiscardPktsMac */
    UINT32    inUnKnownPkts;	/**< InUnKnownPkts */
    UINT32    inMcPkts;	/**< InMcPkts */
    UINT32    inBcPkts;	/**< InBcPkts */
    UINT32    inOctetsLow;	/**< InOctetsLow */
    UINT32    outUcPkts;	/**< OutUcPkts */
    UINT32    outDiscardPkts;	/**< OutDiscardPkts */
    UINT32    outBcPkts;	/**< OutBcPkts */
    UINT32    outOctetsLow;	/**< OutOctetsLow */
    UINT32    networkControllerHandOffs;	/**< NetworkControllerHandOffs */
    UINT32    networkControllerBackups;	/**< NetworkControllerBackups */
} LanMocaIntfStatsObject;

/*! \brief _LanMocaIntfStatsObject is used internally to represent LanMocaIntfStatsObject */
typedef LanMocaIntfStatsObject _LanMocaIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANEponInterfaceConfig.{i}.
 *
 * MDMOID_LAN_EPON_INTF 90
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    ifName;	/**< IfName */
    char *    MACAddress;	/**< MACAddress */
    UBOOL8    MACAddressControlEnabled;	/**< MACAddressControlEnabled */
} LanEponIntfObject;

/*! \brief _LanEponIntfObject is used internally to represent LanEponIntfObject */
typedef LanEponIntfObject _LanEponIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANEponInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_EPON_INTF_STATS 91
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    bytesReceived;	/**< BytesReceived */
    UINT32    packetsSent;	/**< PacketsSent */
    UINT32    packetsReceived;	/**< PacketsReceived */
    UINT32    txErrors;	/**< TxErrors */
    UINT32    rxErrors;	/**< RxErrors */
    UINT32    txDrops;	/**< TxDrops */
    UINT32    rxDrops;	/**< RxDrops */
} LanEponIntfStatsObject;

/*! \brief _LanEponIntfStatsObject is used internally to represent LanEponIntfStatsObject */
typedef LanEponIntfStatsObject _LanEponIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.Hosts.
 *
 * MDMOID_LAN_HOSTS 92
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    hostNumberOfEntries;	/**< HostNumberOfEntries */
} LanHostsObject;

/*! \brief _LanHostsObject is used internally to represent LanHostsObject */
typedef LanHostsObject _LanHostsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.Hosts.Host.{i}.
 *
 * MDMOID_LAN_HOST_ENTRY 93
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    IPAddress;	/**< IPAddress */
    char *    addressSource;	/**< AddressSource */
    SINT32    leaseTimeRemaining;	/**< LeaseTimeRemaining */
    char *    MACAddress;	/**< MACAddress */
    char *    hostName;	/**< HostName */
    char *    interfaceType;	/**< InterfaceType */
    UBOOL8    active;	/**< Active */
} LanHostEntryObject;

/*! \brief _LanHostEntryObject is used internally to represent LanHostEntryObject */
typedef LanHostEntryObject _LanHostEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.
 *
 * MDMOID_WAN_DEV 94
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    WANConnectionNumberOfEntries;	/**< WANConnectionNumberOfEntries */
} WanDevObject;

/*! \brief _WanDevObject is used internally to represent WanDevObject */
typedef WanDevObject _WanDevObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANCommonInterfaceConfig.
 *
 * MDMOID_WAN_COMMON_INTF_CFG 95
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enabledForInternet;	/**< EnabledForInternet */
    char *    WANAccessType;	/**< WANAccessType */
    UINT32    layer1UpstreamMaxBitRate;	/**< Layer1UpstreamMaxBitRate */
    UINT32    layer1DownstreamMaxBitRate;	/**< Layer1DownstreamMaxBitRate */
    char *    physicalLinkStatus;	/**< PhysicalLinkStatus */
    UINT32    totalBytesSent;	/**< TotalBytesSent */
    UINT32    totalBytesReceived;	/**< TotalBytesReceived */
    UINT32    totalPacketsSent;	/**< TotalPacketsSent */
    UINT32    totalPacketsReceived;	/**< TotalPacketsReceived */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< X_BROADCOM_COM_TxErrors */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< X_BROADCOM_COM_RxErrors */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< X_BROADCOM_COM_TxDrops */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< X_BROADCOM_COM_RxDrops */
    UINT32    maximumActiveConnections;	/**< MaximumActiveConnections */
    UINT32    numberOfActiveConnections;	/**< NumberOfActiveConnections */
} WanCommonIntfCfgObject;

/*! \brief _WanCommonIntfCfgObject is used internally to represent WanCommonIntfCfgObject */
typedef WanCommonIntfCfgObject _WanCommonIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_XTM_Interface_Stats.{i}.
 *
 * MDMOID_XTM_INTERFACE_STATS 96
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    port;	/**< Port */
    char *    status;	/**< Status */
    UINT32    inOctets;	/**< InOctets */
    UINT32    outOctets;	/**< OutOctets */
    UINT32    inPackets;	/**< InPackets */
    UINT32    outPackets;	/**< OutPackets */
    UINT32    inOAMCells;	/**< InOAMCells */
    UINT32    outOAMCells;	/**< OutOAMCells */
    UINT32    inASMCells;	/**< InASMCells */
    UINT32    outASMCells;	/**< OutASMCells */
    UINT32    inPacketErrors;	/**< InPacketErrors */
    UINT32    inCellErrors;	/**< InCellErrors */
} XtmInterfaceStatsObject;

/*! \brief _XtmInterfaceStatsObject is used internally to represent XtmInterfaceStatsObject */
typedef XtmInterfaceStatsObject _XtmInterfaceStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.
 *
 * MDMOID_WAN_DSL_INTF_CFG 97
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    UBOOL8    errorSamplesAvailable;	/**< ErrorSamplesAvailable */
    char *    linkEncapsulationUsed;	/**< LinkEncapsulationUsed */
    char *    linkEncapsulationSupported;	/**< LinkEncapsulationSupported */
    char *    linkEncapsulationRequested;	/**< LinkEncapsulationRequested */
    char *    modulationType;	/**< ModulationType */
    char *    lineEncoding;	/**< LineEncoding */
    char *    dataPath;	/**< DataPath */
    UINT32    interleaveDepth;	/**< InterleaveDepth */
    SINT32    lineNumber;	/**< LineNumber */
    UINT32    upstreamCurrRate;	/**< UpstreamCurrRate */
    UINT32    downstreamCurrRate;	/**< DownstreamCurrRate */
    UINT32    X_BROADCOM_COM_UpstreamCurrRate_2;	/**< X_BROADCOM_COM_UpstreamCurrRate_2 */
    UINT32    X_BROADCOM_COM_DownstreamCurrRate_2;	/**< X_BROADCOM_COM_DownstreamCurrRate_2 */
    UINT32    upstreamMaxRate;	/**< UpstreamMaxRate */
    UINT32    downstreamMaxRate;	/**< DownstreamMaxRate */
    SINT32    upstreamNoiseMargin;	/**< UpstreamNoiseMargin */
    SINT32    downstreamNoiseMargin;	/**< DownstreamNoiseMargin */
    SINT32    upstreamAttenuation;	/**< UpstreamAttenuation */
    SINT32    downstreamAttenuation;	/**< DownstreamAttenuation */
    SINT32    upstreamPower;	/**< UpstreamPower */
    SINT32    downstreamPower;	/**< DownstreamPower */
    char *    ATURVendor;	/**< ATURVendor */
    UINT32    ATURCountry;	/**< ATURCountry */
    UINT32    ATURANSIStd;	/**< ATURANSIStd */
    UINT32    ATURANSIRev;	/**< ATURANSIRev */
    char *    ATUCVendor;	/**< ATUCVendor */
    UINT32    ATUCCountry;	/**< ATUCCountry */
    UINT32    ATUCANSIStd;	/**< ATUCANSIStd */
    UINT32    ATUCANSIRev;	/**< ATUCANSIRev */
    UINT32    totalStart;	/**< TotalStart */
    UINT32    showtimeStart;	/**< ShowtimeStart */
    UINT32    lastShowtimeStart;	/**< LastShowtimeStart */
    UINT32    currentDayStart;	/**< CurrentDayStart */
    UINT32    quarterHourStart;	/**< QuarterHourStart */
    char *    standardsSupported;	/**< StandardsSupported */
    char *    standardUsed;	/**< StandardUsed */
#ifdef DMP_VDSL2WAN_1
    char *    allowedProfiles;	/**< AllowedProfiles */
#endif
#ifdef DMP_VDSL2WAN_1
    char *    currentProfile;	/**< CurrentProfile */
#endif
#ifdef DMP_VDSL2WAN_1
    UINT32    UPBOKLE;	/**< UPBOKLE */
#endif
    SINT32    TRELLISds;	/**< TRELLISds */
    SINT32    TRELLISus;	/**< TRELLISus */
    UINT32    ACTSNRMODEds;	/**< ACTSNRMODEds */
    SINT32    ACTSNRMODEus;	/**< ACTSNRMODEus */
    UINT32    ACTUALCE;	/**< ACTUALCE */
    char *    SNRMpbds;	/**< SNRMpbds */
    char *    SNRMpbus;	/**< SNRMpbus */
    char *    X_BROADCOM_COM_AdslVersion;	/**< X_BROADCOM_COM_AdslVersion */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_AdslModulationCfg;	/**< X_BROADCOM_COM_AdslModulationCfg */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UBOOL8    X_BROADCOM_COM_ADSL2_AnnexM;	/**< X_BROADCOM_COM_ADSL2_AnnexM */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_PhoneLinePair;	/**< X_BROADCOM_COM_PhoneLinePair */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_Bitswap;	/**< X_BROADCOM_COM_Bitswap */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_SRA;	/**< X_BROADCOM_COM_SRA */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_TrellisD;	/**< X_BROADCOM_COM_TrellisD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_TrellisU;	/**< X_BROADCOM_COM_TrellisU */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_SNR;	/**< X_BROADCOM_COM_SNR */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_Bitmap;	/**< X_BROADCOM_COM_Bitmap */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_QueueSize;	/**< X_BROADCOM_COM_QueueSize */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_NumTxQueues;	/**< X_BROADCOM_COM_NumTxQueues */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamS;	/**< X_BROADCOM_COM_UpstreamS */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamS;	/**< X_BROADCOM_COM_DownstreamS */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamR;	/**< X_BROADCOM_COM_UpstreamR */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamR;	/**< X_BROADCOM_COM_DownstreamR */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamK;	/**< X_BROADCOM_COM_UpstreamK */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamK;	/**< X_BROADCOM_COM_DownstreamK */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamDelay;	/**< X_BROADCOM_COM_UpstreamDelay */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamDelay_2;	/**< X_BROADCOM_COM_UpstreamDelay_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamDelay;	/**< X_BROADCOM_COM_DownstreamDelay */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamDelay_2;	/**< X_BROADCOM_COM_DownstreamDelay_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamINP;	/**< X_BROADCOM_COM_DownstreamINP */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamINP_2;	/**< X_BROADCOM_COM_DownstreamINP_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamINP;	/**< X_BROADCOM_COM_UpstreamINP */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamINP_2;	/**< X_BROADCOM_COM_UpstreamINP_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamD;	/**< X_BROADCOM_COM_UpstreamD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamD_2;	/**< X_BROADCOM_COM_UpstreamD_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamD;	/**< X_BROADCOM_COM_DownstreamD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamD_2;	/**< X_BROADCOM_COM_DownstreamD_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamMSGc;	/**< X_BROADCOM_COM_ADSL2_UpstreamMSGc */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamMSGc_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamMSGc_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamMSGc;	/**< X_BROADCOM_COM_ADSL2_DownstreamMSGc */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamMSGc_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamMSGc_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamB;	/**< X_BROADCOM_COM_ADSL2_UpstreamB */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamB_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamB_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamB;	/**< X_BROADCOM_COM_ADSL2_DownstreamB */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamB_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamB_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamM;	/**< X_BROADCOM_COM_ADSL2_UpstreamM */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamM_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamM_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamM;	/**< X_BROADCOM_COM_ADSL2_DownstreamM */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamM_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamM_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamT;	/**< X_BROADCOM_COM_ADSL2_UpstreamT */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamT_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamT_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamT;	/**< X_BROADCOM_COM_ADSL2_DownstreamT */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamT_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamT_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamR;	/**< X_BROADCOM_COM_ADSL2_UpstreamR */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamR_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamR_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamR;	/**< X_BROADCOM_COM_ADSL2_DownstreamR */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamR_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamR_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_UpstreamS;	/**< X_BROADCOM_COM_ADSL2_UpstreamS */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_UpstreamS_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamS_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_DownstreamS;	/**< X_BROADCOM_COM_ADSL2_DownstreamS */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_DownstreamS_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamS_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamL;	/**< X_BROADCOM_COM_ADSL2_UpstreamL */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamL_2;	/**< X_BROADCOM_COM_ADSL2_UpstreamL_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamL;	/**< X_BROADCOM_COM_ADSL2_DownstreamL */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamL_2;	/**< X_BROADCOM_COM_ADSL2_DownstreamL_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8a;	/**< X_BROADCOM_COM_VDSL_8a */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8b;	/**< X_BROADCOM_COM_VDSL_8b */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8c;	/**< X_BROADCOM_COM_VDSL_8c */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8d;	/**< X_BROADCOM_COM_VDSL_8d */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_12a;	/**< X_BROADCOM_COM_VDSL_12a */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_12b;	/**< X_BROADCOM_COM_VDSL_12b */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_17a;	/**< X_BROADCOM_COM_VDSL_17a */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_30a;	/**< X_BROADCOM_COM_VDSL_30a */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_US0_8a;	/**< X_BROADCOM_COM_VDSL_US0_8a */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamI;	/**< X_BROADCOM_COM_VDSL_UpstreamI */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamI_2;	/**< X_BROADCOM_COM_VDSL_UpstreamI_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamI;	/**< X_BROADCOM_COM_VDSL_DownstreamI */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamI_2;	/**< X_BROADCOM_COM_VDSL_DownstreamI_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamN;	/**< X_BROADCOM_COM_VDSL_UpstreamN */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamN_2;	/**< X_BROADCOM_COM_VDSL_UpstreamN_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamN;	/**< X_BROADCOM_COM_VDSL_DownstreamN */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamN_2;	/**< X_BROADCOM_COM_VDSL_DownstreamN_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_LinkPowerState;	/**< X_BROADCOM_COM_LinkPowerState */
#endif
#ifdef DMP_X_BROADCOM_COM_DSLBONDING_1
    UBOOL8    X_BROADCOM_COM_EnableBonding;	/**< X_BROADCOM_COM_EnableBonding */
#endif
    UINT32    X_BROADCOM_COM_BondingLineNumber;	/**< X_BROADCOM_COM_BondingLineNumber */
#ifdef DMP_X_BROADCOM_COM_DSLBONDING_1
    char *    X_BROADCOM_COM_BondingPeerName;	/**< X_BROADCOM_COM_BondingPeerName */
#endif
    UINT32    X_BROADCOM_COM_DslCfgParam;	/**< X_BROADCOM_COM_DslCfgParam */
    SINT32    X_BROADCOM_COM_DslTrainingMarginQ4;	/**< X_BROADCOM_COM_DslTrainingMarginQ4 */
    SINT32    X_BROADCOM_COM_DslShowtimeMarginQ4;	/**< X_BROADCOM_COM_DslShowtimeMarginQ4 */
    SINT32    X_BROADCOM_COM_DslLOMTimeThldSec;	/**< X_BROADCOM_COM_DslLOMTimeThldSec */
    SINT32    X_BROADCOM_COM_DslPwmSyncClockFreq;	/**< X_BROADCOM_COM_DslPwmSyncClockFreq */
    SINT32    X_BROADCOM_COM_DslHsModeSwitchTime;	/**< X_BROADCOM_COM_DslHsModeSwitchTime */
    UINT32    X_BROADCOM_COM_DslParam;	/**< X_BROADCOM_COM_DslParam */
    UINT32    X_BROADCOM_COM_DslPhyCfg1Mask;	/**< X_BROADCOM_COM_DslPhyCfg1Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg1Value;	/**< X_BROADCOM_COM_DslPhyCfg1Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg2Mask;	/**< X_BROADCOM_COM_DslPhyCfg2Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg2Value;	/**< X_BROADCOM_COM_DslPhyCfg2Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg3Mask;	/**< X_BROADCOM_COM_DslPhyCfg3Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg3Value;	/**< X_BROADCOM_COM_DslPhyCfg3Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg4Mask;	/**< X_BROADCOM_COM_DslPhyCfg4Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg4Value;	/**< X_BROADCOM_COM_DslPhyCfg4Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg5Mask;	/**< X_BROADCOM_COM_DslPhyCfg5Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg5Value;	/**< X_BROADCOM_COM_DslPhyCfg5Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg6Mask;	/**< X_BROADCOM_COM_DslPhyCfg6Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg6Value;	/**< X_BROADCOM_COM_DslPhyCfg6Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg7Mask;	/**< X_BROADCOM_COM_DslPhyCfg7Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg7Value;	/**< X_BROADCOM_COM_DslPhyCfg7Value */
    UINT32    X_BROADCOM_COM_DslPhyCfg8Mask;	/**< X_BROADCOM_COM_DslPhyCfg8Mask */
    UINT32    X_BROADCOM_COM_DslPhyCfg8Value;	/**< X_BROADCOM_COM_DslPhyCfg8Value */
    UINT32    X_BROADCOM_COM_DslPhyUsDataRateKbps;	/**< X_BROADCOM_COM_DslPhyUsDataRateKbps */
    UINT32    X_BROADCOM_COM_DslPhyDsDataRateKbps;	/**< X_BROADCOM_COM_DslPhyDsDataRateKbps */
    UINT32    X_BROADCOM_COM_DslPhyAggrDataRateKbps;	/**< X_BROADCOM_COM_DslPhyAggrDataRateKbps */
    UINT32    X_BROADCOM_COM_DslPhyMiscCfgParam;	/**< X_BROADCOM_COM_DslPhyMiscCfgParam */
} WanDslIntfCfgObject;

/*! \brief _WanDslIntfCfgObject is used internally to represent WanDslIntfCfgObject */
typedef WanDslIntfCfgObject _WanDslIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.X_BROADCOM_COM_BertTest.
 *
 * MDMOID_WAN_BERT_TEST 98
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    bertTestMode;	/**< BertTestMode */
    UINT32    bertTestDuration;	/**< BertTestDuration */
    char *    bertTestStatus;	/**< BertTestStatus */
    UINT32    totalTime;	/**< TotalTime */
    UINT32    elapsedTime;	/**< ElapsedTime */
    UINT32    bitsTestedCntHigh;	/**< BitsTestedCntHigh */
    UINT32    bitsTestedCntLow;	/**< BitsTestedCntLow */
    UINT32    errBitsCntHigh;	/**< ErrBitsCntHigh */
    UINT32    errBitsCntLow;	/**< ErrBitsCntLow */
} WanBertTestObject;

/*! \brief _WanBertTestObject is used internally to represent WanBertTestObject */
typedef WanBertTestObject _WanBertTestObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.
 *
 * MDMOID_WAN_DSL_INTF_STATS 99
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} WanDslIntfStatsObject;

/*! \brief _WanDslIntfStatsObject is used internally to represent WanDslIntfStatsObject */
typedef WanDslIntfStatsObject _WanDslIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.Total.
 *
 * MDMOID_WAN_DSL_INTF_STATS_TOTAL 100
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable;	/**< X_BROADCOM_COM_RxRsCorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable_2;	/**< X_BROADCOM_COM_RxRsCorrectable_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable;	/**< X_BROADCOM_COM_TxRsCorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable_2;	/**< X_BROADCOM_COM_TxRsCorrectable_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable;	/**< X_BROADCOM_COM_TxRsUncorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable_2;	/**< X_BROADCOM_COM_TxRsUncorrectable_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable;	/**< X_BROADCOM_COM_RxRsUncorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable_2;	/**< X_BROADCOM_COM_RxRsUncorrectable_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsWords;	/**< X_BROADCOM_COM_TxRsWords */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsWords_2;	/**< X_BROADCOM_COM_TxRsWords_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsWords;	/**< X_BROADCOM_COM_RxRsWords */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsWords_2;	/**< X_BROADCOM_COM_RxRsWords_2 */
#endif
    UINT32    receiveBlocks;	/**< ReceiveBlocks */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ReceiveBlocks_2;	/**< X_BROADCOM_COM_ReceiveBlocks_2 */
#endif
    UINT32    transmitBlocks;	/**< TransmitBlocks */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TransmitBlocks_2;	/**< X_BROADCOM_COM_TransmitBlocks_2 */
#endif
    UINT32    cellDelin;	/**< CellDelin */
    UINT32    linkRetrain;	/**< LinkRetrain */
    UINT32    initErrors;	/**< InitErrors */
    UINT32    initTimeouts;	/**< InitTimeouts */
    UINT32    lossOfFraming;	/**< LossOfFraming */
    UINT32    erroredSecs;	/**< ErroredSecs */
    UINT32    severelyErroredSecs;	/**< SeverelyErroredSecs */
    UINT32    FECErrors;	/**< FECErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_FECErrors_2;	/**< X_BROADCOM_COM_FECErrors_2 */
#endif
    UINT32    ATUCFECErrors;	/**< ATUCFECErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATUCFECErrors_2;	/**< X_BROADCOM_COM_ATUCFECErrors_2 */
#endif
    UINT32    HECErrors;	/**< HECErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_HECErrors_2;	/**< X_BROADCOM_COM_HECErrors_2 */
#endif
    UINT32    ATUCHECErrors;	/**< ATUCHECErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATUCHECErrors_2;	/**< X_BROADCOM_COM_ATUCHECErrors_2 */
#endif
    UINT32    CRCErrors;	/**< CRCErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_CRCErrors_2;	/**< X_BROADCOM_COM_CRCErrors_2 */
#endif
    UINT32    ATUCCRCErrors;	/**< ATUCCRCErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATUCCRCErrors_2;	/**< X_BROADCOM_COM_ATUCCRCErrors_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamUas;	/**< X_BROADCOM_COM_UpstreamUas */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamUas;	/**< X_BROADCOM_COM_DownstreamUas */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamEs;	/**< X_BROADCOM_COM_UpstreamEs */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamSes;	/**< X_BROADCOM_COM_UpstreamSes */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamBitErrors;	/**< X_BROADCOM_COM_UpstreamBitErrors */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamBitErrors_2;	/**< X_BROADCOM_COM_UpstreamBitErrors_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamBitErrors;	/**< X_BROADCOM_COM_DownstreamBitErrors */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamBitErrors_2;	/**< X_BROADCOM_COM_DownstreamBitErrors_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamDataCells;	/**< X_BROADCOM_COM_UpstreamDataCells */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamDataCells_2;	/**< X_BROADCOM_COM_UpstreamDataCells_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamDataCells;	/**< X_BROADCOM_COM_DownstreamDataCells */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamDataCells_2;	/**< X_BROADCOM_COM_DownstreamDataCells_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamTotalCells;	/**< X_BROADCOM_COM_UpstreamTotalCells */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamTotalCells_2;	/**< X_BROADCOM_COM_UpstreamTotalCells_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamTotalCells;	/**< X_BROADCOM_COM_DownstreamTotalCells */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamTotalCells_2;	/**< X_BROADCOM_COM_DownstreamTotalCells_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamLCD;	/**< X_BROADCOM_COM_UpstreamLCD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamLCD_2;	/**< X_BROADCOM_COM_UpstreamLCD_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamLCD;	/**< X_BROADCOM_COM_DownstreamLCD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamLCD_2;	/**< X_BROADCOM_COM_DownstreamLCD_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamOCD;	/**< X_BROADCOM_COM_UpstreamOCD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamOCD_2;	/**< X_BROADCOM_COM_UpstreamOCD_2 */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamOCD;	/**< X_BROADCOM_COM_DownstreamOCD */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamOCD_2;	/**< X_BROADCOM_COM_DownstreamOCD_2 */
#endif
} WanDslIntfStatsTotalObject;

/*! \brief _WanDslIntfStatsTotalObject is used internally to represent WanDslIntfStatsTotalObject */
typedef WanDslIntfStatsTotalObject _WanDslIntfStatsTotalObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.Showtime.
 *
 * MDMOID_WAN_DSL_INTF_STATS_SHOWTIME 101
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable;	/**< X_BROADCOM_COM_RxRsUncorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable;	/**< X_BROADCOM_COM_TxRsUncorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable;	/**< X_BROADCOM_COM_RxRsCorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable;	/**< X_BROADCOM_COM_TxRsCorrectable */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsWords;	/**< X_BROADCOM_COM_RxRsWords */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsWords;	/**< X_BROADCOM_COM_TxRsWords */
#endif
    UINT32    receiveBlocks;	/**< ReceiveBlocks */
    UINT32    transmitBlocks;	/**< TransmitBlocks */
    UINT32    cellDelin;	/**< CellDelin */
    UINT32    linkRetrain;	/**< LinkRetrain */
    UINT32    initErrors;	/**< InitErrors */
    UINT32    initTimeouts;	/**< InitTimeouts */
    UINT32    lossOfFraming;	/**< LossOfFraming */
    UINT32    erroredSecs;	/**< ErroredSecs */
    UINT32    severelyErroredSecs;	/**< SeverelyErroredSecs */
    UINT32    FECErrors;	/**< FECErrors */
    UINT32    ATUCFECErrors;	/**< ATUCFECErrors */
    UINT32    HECErrors;	/**< HECErrors */
    UINT32    ATUCHECErrors;	/**< ATUCHECErrors */
    UINT32    CRCErrors;	/**< CRCErrors */
    UINT32    ATUCCRCErrors;	/**< ATUCCRCErrors */
} WanDslIntfStatsShowtimeObject;

/*! \brief _WanDslIntfStatsShowtimeObject is used internally to represent WanDslIntfStatsShowtimeObject */
typedef WanDslIntfStatsShowtimeObject _WanDslIntfStatsShowtimeObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.CurrentDay.
 *
 * MDMOID_WAN_DSL_INTF_STATS_CURRENT_DAY 102
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    receiveBlocks;	/**< ReceiveBlocks */
    UINT32    transmitBlocks;	/**< TransmitBlocks */
    UINT32    cellDelin;	/**< CellDelin */
    UINT32    linkRetrain;	/**< LinkRetrain */
    UINT32    initErrors;	/**< InitErrors */
    UINT32    initTimeouts;	/**< InitTimeouts */
    UINT32    lossOfFraming;	/**< LossOfFraming */
    UINT32    erroredSecs;	/**< ErroredSecs */
    UINT32    severelyErroredSecs;	/**< SeverelyErroredSecs */
    UINT32    FECErrors;	/**< FECErrors */
    UINT32    ATUCFECErrors;	/**< ATUCFECErrors */
    UINT32    HECErrors;	/**< HECErrors */
    UINT32    ATUCHECErrors;	/**< ATUCHECErrors */
    UINT32    CRCErrors;	/**< CRCErrors */
    UINT32    ATUCCRCErrors;	/**< ATUCCRCErrors */
} WanDslIntfStatsCurrentDayObject;

/*! \brief _WanDslIntfStatsCurrentDayObject is used internally to represent WanDslIntfStatsCurrentDayObject */
typedef WanDslIntfStatsCurrentDayObject _WanDslIntfStatsCurrentDayObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.QuarterHour.
 *
 * MDMOID_WAN_DSL_INTF_STATS_QUARTER_HOUR 103
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    receiveBlocks;	/**< ReceiveBlocks */
    UINT32    transmitBlocks;	/**< TransmitBlocks */
    UINT32    cellDelin;	/**< CellDelin */
    UINT32    linkRetrain;	/**< LinkRetrain */
    UINT32    initErrors;	/**< InitErrors */
    UINT32    initTimeouts;	/**< InitTimeouts */
    UINT32    lossOfFraming;	/**< LossOfFraming */
    UINT32    erroredSecs;	/**< ErroredSecs */
    UINT32    severelyErroredSecs;	/**< SeverelyErroredSecs */
    UINT32    FECErrors;	/**< FECErrors */
    UINT32    ATUCFECErrors;	/**< ATUCFECErrors */
    UINT32    HECErrors;	/**< HECErrors */
    UINT32    ATUCHECErrors;	/**< ATUCHECErrors */
    UINT32    CRCErrors;	/**< CRCErrors */
    UINT32    ATUCCRCErrors;	/**< ATUCCRCErrors */
} WanDslIntfStatsQuarterHourObject;

/*! \brief _WanDslIntfStatsQuarterHourObject is used internally to represent WanDslIntfStatsQuarterHourObject */
typedef WanDslIntfStatsQuarterHourObject _WanDslIntfStatsQuarterHourObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.TestParams.
 *
 * MDMOID_WAN_DSL_TEST_PARAMS 104
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    HLOGGds;	/**< HLOGGds */
    UINT32    HLOGGus;	/**< HLOGGus */
    char *    HLOGpsds;	/**< HLOGpsds */
    char *    HLOGpsus;	/**< HLOGpsus */
    UINT32    HLOGMTds;	/**< HLOGMTds */
    UINT32    HLOGMTus;	/**< HLOGMTus */
    UINT32    QLNGds;	/**< QLNGds */
    UINT32    QLNGus;	/**< QLNGus */
    char *    QLNpsds;	/**< QLNpsds */
    char *    QLNpsus;	/**< QLNpsus */
    UINT32    QLNMTds;	/**< QLNMTds */
    UINT32    QLNMTus;	/**< QLNMTus */
    UINT32    SNRGds;	/**< SNRGds */
    UINT32    SNRGus;	/**< SNRGus */
    char *    SNRpsds;	/**< SNRpsds */
    char *    SNRpsus;	/**< SNRpsus */
    UINT32    SNRMTds;	/**< SNRMTds */
    UINT32    SNRMTus;	/**< SNRMTus */
    char *    LATNds;	/**< LATNds */
    char *    LATNus;	/**< LATNus */
    char *    SATNds;	/**< SATNds */
    char *    SATNus;	/**< SATNus */
} WanDslTestParamsObject;

/*! \brief _WanDslTestParamsObject is used internally to represent WanDslTestParamsObject */
typedef WanDslTestParamsObject _WanDslTestParamsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.
 *
 * MDMOID_WAN_ETH_INTF 105
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    MACAddress;	/**< MACAddress */
    char *    maxBitRate;	/**< MaxBitRate */
    char *    duplexMode;	/**< DuplexMode */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
    char *    X_BROADCOM_COM_ConnectionMode;	/**< X_BROADCOM_COM_ConnectionMode */
    UBOOL8    X_BROADCOM_COM_PersistentDevice;	/**< X_BROADCOM_COM_PersistentDevice */
    UBOOL8    X_BROADCOM_COM_LimitedConnections;	/**< X_BROADCOM_COM_LimitedConnections */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    X_BROADCOM_COM_MaxConnections;	/**< X_BROADCOM_COM_MaxConnections */
#endif
} WanEthIntfObject;

/*! \brief _WanEthIntfObject is used internally to represent WanEthIntfObject */
typedef WanEthIntfObject _WanEthIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.X_BROADCOM_COM_IPv6Address.{i}.
 *
 * MDMOID_I_PV6_ADDR 106
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    scope;	/**< Scope */
    char *    IPv6Address;	/**< IPv6Address */
} IPv6AddrObject;

/*! \brief _IPv6AddrObject is used internally to represent IPv6AddrObject */
typedef IPv6AddrObject _IPv6AddrObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.X_ALLIEDTELESIS_COM_BaseInterfaceCfg.
 *
 * MDMOID_WAN_ETH_BASE_INTF_CFG 107
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ETHERNETLAN_1
    UBOOL8    enable;	/**< Enable */
#endif
#ifdef DMP_ETHERNETLAN_1
    char *    interfaceType;	/**< InterfaceType */
#endif
#ifdef DMP_ETHERNETLAN_1
    char *    maxBitRate;	/**< MaxBitRate */
#endif
#ifdef DMP_ETHERNETLAN_1
    char *    duplexMode;	/**< DuplexMode */
#endif
    SINT32    defaultPriority;	/**< DefaultPriority */
    UBOOL8    pauseEnable;	/**< PauseEnable */
    SINT32    egressRateLimit;	/**< EgressRateLimit */
    SINT32    ingressRateLimit;	/**< IngressRateLimit */
    char *    priorityScheme;	/**< PriorityScheme */
    UBOOL8    mirror;	/**< Mirror */
    UBOOL8    capture;	/**< Capture */
    char *    currentPortLinkSpeed;	/**< CurrentPortLinkSpeed */
    char *    currentPortLinkDuplex;	/**< CurrentPortLinkDuplex */
    char *    bitRateCapability;	/**< BitRateCapability */
    UBOOL8    jumboFrameEnable;	/**< JumboFrameEnable */
    UBOOL8    ISPQinQPort;	/**< ISPQinQPort */
    UBOOL8    protected;	/**< Protected */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    RAGuard;	/**< RAGuard */
#endif
} WanEthBaseIntfCfgObject;

/*! \brief _WanEthBaseIntfCfgObject is used internally to represent WanEthBaseIntfCfgObject */
typedef WanEthBaseIntfCfgObject _WanEthBaseIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.X_ALLIEDTELESIS_COM_BaseInterfaceCfg.Pluggable.
 *
 * MDMOID_WAN_ETH_BASE_INTF_CFG_PLUGGABLE 108
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    present;	/**< Present */
    char *    sfpAuditStatus;	/**< SfpAuditStatus */
    UBOOL8    supportsDdm;	/**< SupportsDdm */
    char *    vendorName;	/**< VendorName */
    char *    vendorPN;	/**< VendorPN */
    char *    deviceType;	/**< DeviceType */
    char *    serialNumber;	/**< SerialNumber */
    char *    dateCode;	/**< DateCode */
    UINT32    wavelength;	/**< Wavelength */
    UINT32    linkLengthSmfKm;	/**< LinkLengthSmfKm */
    UINT32    linkLengthSmf100m;	/**< LinkLengthSmf100m */
    UINT32    linkLength50um10m;	/**< LinkLength50um10m */
    UINT32    linkLength62dot5um10m;	/**< LinkLength62dot5um10m */
    char *    ddmCalibration;	/**< DdmCalibration */
    SINT32    ddmTemperature;	/**< DdmTemperature */
    UBOOL8    ddmTemperatureHighAlarm;	/**< DdmTemperatureHighAlarm */
    UBOOL8    ddmTemperatureLowAlarm;	/**< DdmTemperatureLowAlarm */
    UBOOL8    ddmTemperatureHighWarning;	/**< DdmTemperatureHighWarning */
    UBOOL8    ddmTemperatureLowWarning;	/**< DdmTemperatureLowWarning */
    SINT32    ddmTemperatureHighAlarmThld;	/**< DdmTemperatureHighAlarmThld */
    SINT32    ddmTemperatureLowAlarmThld;	/**< DdmTemperatureLowAlarmThld */
    SINT32    ddmTemperatureHighWarningThld;	/**< DdmTemperatureHighWarningThld */
    SINT32    ddmTemperatureLowWarningThld;	/**< DdmTemperatureLowWarningThld */
    UINT32    ddmVcc;	/**< DdmVcc */
    UBOOL8    ddmVccHighAlarm;	/**< DdmVccHighAlarm */
    UBOOL8    ddmVccLowAlarm;	/**< DdmVccLowAlarm */
    UBOOL8    ddmVccHighWarning;	/**< DdmVccHighWarning */
    UBOOL8    ddmVccLowWarning;	/**< DdmVccLowWarning */
    UINT32    ddmVccHighAlarmThld;	/**< DdmVccHighAlarmThld */
    UINT32    ddmVccLowAlarmThld;	/**< DdmVccLowAlarmThld */
    UINT32    ddmVccHighWarningThld;	/**< DdmVccHighWarningThld */
    UINT32    ddmVccLowWarningThld;	/**< DdmVccLowWarningThld */
    UINT32    ddmTxBias;	/**< DdmTxBias */
    UBOOL8    ddmTxBiasHighAlarm;	/**< DdmTxBiasHighAlarm */
    UBOOL8    ddmTxBiasLowAlarm;	/**< DdmTxBiasLowAlarm */
    UBOOL8    ddmTxBiasHighWarning;	/**< DdmTxBiasHighWarning */
    UBOOL8    ddmTxBiasLowWarning;	/**< DdmTxBiasLowWarning */
    UINT32    ddmTxBiasHighAlarmThld;	/**< DdmTxBiasHighAlarmThld */
    UINT32    ddmTxBiasLowAlarmThld;	/**< DdmTxBiasLowAlarmThld */
    UINT32    ddmTxBiasHighWarningThld;	/**< DdmTxBiasHighWarningThld */
    UINT32    ddmTxBiasLowWarningThld;	/**< DdmTxBiasLowWarningThld */
    UINT32    ddmTxPower;	/**< DdmTxPower */
    UBOOL8    ddmTxPowerHighAlarm;	/**< DdmTxPowerHighAlarm */
    UBOOL8    ddmTxPowerLowAlarm;	/**< DdmTxPowerLowAlarm */
    UBOOL8    ddmTxPowerHighWarning;	/**< DdmTxPowerHighWarning */
    UBOOL8    ddmTxPowerLowWarning;	/**< DdmTxPowerLowWarning */
    UINT32    ddmTxPowerHighAlarmThld;	/**< DdmTxPowerHighAlarmThld */
    UINT32    ddmTxPowerLowAlarmThld;	/**< DdmTxPowerLowAlarmThld */
    UINT32    ddmTxPowerHighWarningThld;	/**< DdmTxPowerHighWarningThld */
    UINT32    ddmTxPowerLowWarningThld;	/**< DdmTxPowerLowWarningThld */
    UINT32    ddmRxPower;	/**< DdmRxPower */
    UBOOL8    ddmRxPowerHighAlarm;	/**< DdmRxPowerHighAlarm */
    UBOOL8    ddmRxPowerLowAlarm;	/**< DdmRxPowerLowAlarm */
    UBOOL8    ddmRxPowerHighWarning;	/**< DdmRxPowerHighWarning */
    UBOOL8    ddmRxPowerLowWarning;	/**< DdmRxPowerLowWarning */
    UINT32    ddmRxPowerHighAlarmThld;	/**< DdmRxPowerHighAlarmThld */
    UINT32    ddmRxPowerLowAlarmThld;	/**< DdmRxPowerLowAlarmThld */
    UINT32    ddmRxPowerHighWarningThld;	/**< DdmRxPowerHighWarningThld */
    UINT32    ddmRxPowerLowWarningThld;	/**< DdmRxPowerLowWarningThld */
} WanEthBaseIntfCfgPluggableObject;

/*! \brief _WanEthBaseIntfCfgPluggableObject is used internally to represent WanEthBaseIntfCfgPluggableObject */
typedef WanEthBaseIntfCfgPluggableObject _WanEthBaseIntfCfgPluggableObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.Stats.
 *
 * MDMOID_WAN_ETH_INTF_STATS 109
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    bytesReceived;	/**< BytesReceived */
    UINT32    packetsSent;	/**< PacketsSent */
    UINT32    packetsReceived;	/**< PacketsReceived */
} WanEthIntfStatsObject;

/*! \brief _WanEthIntfStatsObject is used internally to represent WanEthIntfStatsObject */
typedef WanEthIntfStatsObject _WanEthIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.X_ALLIEDTELESIS_COM_BaseInterfaceStat.
 *
 * MDMOID_WAN_ETH_BASE_INTF_STAT 110
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    resetStatistics;	/**< ResetStatistics */
    UINT32    ifInOctets;	/**< snmpIfInOctets */
    UINT32    ifInUcastPkts;	/**< snmpIfInUcastPkts */
    UINT32    ifInNUcastPkts;	/**< snmpIfInNUcastPkts */
    UINT32    ifInDiscards;	/**< snmpIfInDiscards */
    UINT32    ifInErrors;	/**< snmpIfInErrors */
    UINT32    ifInUnknownProtos;	/**< snmpIfInUnknownProtos */
    UINT32    ifOutOctets;	/**< snmpIfOutOctets */
    UINT32    ifOutUcastPkts;	/**< snmpIfOutUcastPkts */
    UINT32    ifOutNUcastPkts;	/**< snmpIfOutNUcastPkts */
    UINT32    ifOutDiscards;	/**< snmpIfOutDiscards */
    UINT32    ifOutErrors;	/**< snmpIfOutErrors */
    UINT32    ifOutQLen;	/**< snmpIfOutQLen */
    UINT32    ipInReceives;	/**< snmpIpInReceives */
    UINT32    ipInHdrErrors;	/**< snmpIpInHdrErrors */
    UINT32    ipForwDatagrams;	/**< snmpIpForwDatagrams */
    UINT32    ipInDiscards;	/**< snmpIpInDiscards */
    UINT32    dot1dBasePortDelayExceededDiscards;	/**< snmpDot1dBasePortDelayExceededDiscards */
    UINT32    dot1dBasePortMtuExceededDiscards;	/**< snmpDot1dBasePortMtuExceededDiscards */
    UINT32    dot1dTpPortInFrames;	/**< snmpDot1dTpPortInFrames */
    UINT32    dot1dTpPortOutFrames;	/**< snmpDot1dTpPortOutFrames */
    UINT32    dot1dPortInDiscards;	/**< snmpDot1dPortInDiscards */
    UINT32    etherStatsDropEvents;	/**< snmpEtherStatsDropEvents */
    UINT32    etherStatsMulticastPkts;	/**< snmpEtherStatsMulticastPkts */
    UINT32    etherStatsBroadcastPkts;	/**< snmpEtherStatsBroadcastPkts */
    UINT32    etherStatsUndersizePkts;	/**< snmpEtherStatsUndersizePkts */
    UINT32    etherStatsFragments;	/**< snmpEtherStatsFragments */
    UINT32    etherStatsPkts64Octets;	/**< snmpEtherStatsPkts64Octets */
    UINT32    etherStatsPkts65to127Octets;	/**< snmpEtherStatsPkts65to127Octets */
    UINT32    etherStatsPkts128to255Octets;	/**< snmpEtherStatsPkts128to255Octets */
    UINT32    etherStatsPkts256to511Octets;	/**< snmpEtherStatsPkts256to511Octets */
    UINT32    etherStatsPkts512to1023Octets;	/**< snmpEtherStatsPkts512to1023Octets */
    UINT32    etherStatsPkts1024to1518Octets;	/**< snmpEtherStatsPkts1024to1518Octets */
    UINT32    etherStatsOversizePkts;	/**< snmpEtherStatsOversizePkts */
    UINT32    etherStatsJabbers;	/**< snmpEtherStatsJabbers */
    UINT32    etherStatsOctets;	/**< snmpEtherStatsOctets */
    UINT32    etherStatsPkts;	/**< snmpEtherStatsPkts */
    UINT32    etherStatsCollisions;	/**< snmpEtherStatsCollisions */
    UINT32    etherStatsCRCAlignErrors;	/**< snmpEtherStatsCRCAlignErrors */
    UINT32    etherStatsTXNoErrors;	/**< snmpEtherStatsTXNoErrors */
    UINT32    etherStatsRXNoErrors;	/**< snmpEtherStatsRXNoErrors */
    UINT32    dot3StatsAlignmentErrors;	/**< snmpDot3StatsAlignmentErrors */
    UINT32    dot3StatsFCSErrors;	/**< snmpDot3StatsFCSErrors */
    UINT32    dot3StatsSingleCollisionFrames;	/**< snmpDot3StatsSingleCollisionFrames */
    UINT32    dot3StatsMultipleCollisionFrames;	/**< snmpDot3StatsMultipleCollisionFrames */
    UINT32    dot3StatsSQETTestErrors;	/**< snmpDot3StatsSQETTestErrors */
    UINT32    dot3StatsDeferredTransmissions;	/**< snmpDot3StatsDeferredTransmissions */
    UINT32    dot3StatsLateCollisions;	/**< snmpDot3StatsLateCollisions */
    UINT32    dot3StatsExcessiveCollisions;	/**< snmpDot3StatsExcessiveCollisions */
    UINT32    dot3StatsInternalMacTransmitErrors;	/**< snmpDot3StatsInternalMacTransmitErrors */
    UINT32    dot3StatsCarrierSenseErrors;	/**< snmpDot3StatsCarrierSenseErrors */
    UINT32    dot3StatsFrameTooLongs;	/**< snmpDot3StatsFrameTooLongs */
    UINT32    dot3StatsInternalMacReceiveErrors;	/**< snmpDot3StatsInternalMacReceiveErrors */
    UINT32    dot3StatsSymbolErrors;	/**< snmpDot3StatsSymbolErrors */
    UINT32    dot3ControlInUnknownOpcodes;	/**< snmpDot3ControlInUnknownOpcodes */
    UINT32    dot3InPauseFrames;	/**< snmpDot3InPauseFrames */
    UINT32    dot3OutPauseFrames;	/**< snmpDot3OutPauseFrames */
    UINT32    ifHCInOctets_HI;	/**< snmpIfHCInOctets_HI */
    UINT32    ifHCInOctets_LOW;	/**< snmpIfHCInOctets_LOW */
    UINT32    ifHCInUcastPkts_HI;	/**< snmpIfHCInUcastPkts_HI */
    UINT32    ifHCInUcastPkts_LOW;	/**< snmpIfHCInUcastPkts_LOW */
    UINT32    ifHCInMulticastPkts_HI;	/**< snmpIfHCInMulticastPkts_HI */
    UINT32    ifHCInMulticastPkts_LOW;	/**< snmpIfHCInMulticastPkts_LOW */
    UINT32    ifHCInBroadcastPkts_HI;	/**< snmpIfHCInBroadcastPkts_HI */
    UINT32    ifHCInBroadcastPkts_LOW;	/**< snmpIfHCInBroadcastPkts_LOW */
    UINT32    ifHCOutOctets_HI;	/**< snmpIfHCOutOctets_HI */
    UINT32    ifHCOutOctets_LOW;	/**< snmpIfHCOutOctets_LOW */
    UINT32    ifHCOutUcastPkts_HI;	/**< snmpIfHCOutUcastPkts_HI */
    UINT32    ifHCOutUcastPkts_LOW;	/**< snmpIfHCOutUcastPkts_LOW */
    UINT32    ifHCOutMulticastPkts_HI;	/**< snmpIfHCOutMulticastPkts_HI */
    UINT32    ifHCOutMulticastPkts_LOW;	/**< snmpIfHCOutMulticastPkts_LOW */
    UINT32    ifHCOutBroadcastPckts_HI;	/**< snmpIfHCOutBroadcastPckts_HI */
    UINT32    ifHCOutBroadcastPckts_LOW;	/**< snmpIfHCOutBroadcastPckts_LOW */
    UINT32    ipv6IfStatsInReceives;	/**< snmpIpv6IfStatsInReceives */
    UINT32    ipv6IfStatsInHdrErrors;	/**< snmpIpv6IfStatsInHdrErrors */
    UINT32    ipv6IfStatsInAddrErrors;	/**< snmpIpv6IfStatsInAddrErrors */
    UINT32    ipv6IfStatsInDiscards;	/**< snmpIpv6IfStatsInDiscards */
    UINT32    ipv6IfStatsOutForwDatagrams;	/**< snmpIpv6IfStatsOutForwDatagrams */
    UINT32    ipv6IfStatsOutDiscards;	/**< snmpIpv6IfStatsOutDiscards */
    UINT32    ipv6IfStatsInMcastPkts;	/**< snmpIpv6IfStatsInMcastPkts */
    UINT32    ipv6IfStatsOutMcastPkts;	/**< snmpIpv6IfStatsOutMcastPkts */
} WanEthBaseIntfStatObject;

/*! \brief _WanEthBaseIntfStatObject is used internally to represent WanEthBaseIntfStatObject */
typedef WanEthBaseIntfStatObject _WanEthBaseIntfStatObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANMocaInterfaceConfig.
 *
 * MDMOID_WAN_MOCA_INTF 111
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    ifName;	/**< IfName */
    char *    connectionMode;	/**< ConnectionMode */
    UINT32    loopbackConfiguration;	/**< LoopbackConfiguration */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
    char *    mocaControl;	/**< MocaControl */
    UINT32    maxFrameSize;	/**< MaxFrameSize */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
    UBOOL8    pppoeFilter;	/**< PppoeFilter */
    UINT32    networkStatus;	/**< NetworkStatus */
    char *    password;	/**< Password */
    UBOOL8    privacy;	/**< Privacy */
    UINT32    minBandwidthAlarmThreshold;	/**< MinBandwidthAlarmThreshold */
    UINT32    frequencyMask;	/**< FrequencyMask */
    UINT32    rfChannel;	/**< RfChannel */
    UINT32    lastOperationalFrequency;	/**< LastOperationalFrequency */
    UINT32    ncMode;	/**< NcMode */
    UBOOL8    autoNwSearch;	/**< AutoNwSearch */
    UBOOL8    txPwrControl;	/**< TxPwrControl */
    UINT32    continuousPowerMode;	/**< ContinuousPowerMode */
    UINT32    mcastMode;	/**< McastMode */
    UBOOL8    labMode;	/**< LabMode */
    UBOOL8    eclQTagMode;	/**< EclQTagMode */
    UINT32    maxTransmitTime;	/**< MaxTransmitTime */
    SINT32    maxTransmitPower;	/**< MaxTransmitPower */
    SINT32    snrMargin;	/**< SnrMargin */
    UINT32    outOfOrderLmo;	/**< OutOfOrderLmo */
    UBOOL8    lmoReportEnable;	/**< LmoReportEnable */
    UINT32    tabooMaskStart;	/**< TabooMaskStart */
    UINT32    tabooChannelMask;	/**< TabooChannelMask */
    UBOOL8    continuousIerrInsert;	/**< ContinuousIerrInsert */
    UBOOL8    continuousIeMapInsert;	/**< ContinuousIeMapInsert */
    UINT32    maxPktAggr;	/**< MaxPktAggr */
    UINT32    maxConstellationNode;	/**< MaxConstellationNode */
    UINT32    maxConstellation;	/**< MaxConstellation */
    UBOOL8    preferedNetworkController;	/**< PreferedNetworkController */
    UINT32    pmkExchangeInterval;	/**< PmkExchangeInterval */
    UINT32    tekExchangeInterval;	/**< TekExchangeInterval */
    UINT32    traceLevel;	/**< TraceLevel */
    UBOOL8    traceLevelRestoreDefault;	/**< TraceLevelRestoreDefault */
    UINT32    mrNonDefSeqNumber;	/**< MrNonDefSeqNumber */
    char *    initParmsString;	/**< InitParmsString */
    char *    configParmsString;	/**< ConfigParmsString */
    char *    traceParmsString;	/**< TraceParmsString */
    UBOOL8    persistentDevice;	/**< PersistentDevice */
    UBOOL8    limitedConnections;	/**< LimitedConnections */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    maxConnections;	/**< MaxConnections */
#endif
} WanMocaIntfObject;

/*! \brief _WanMocaIntfObject is used internally to represent WanMocaIntfObject */
typedef WanMocaIntfObject _WanMocaIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANMocaInterfaceConfig.Status.
 *
 * MDMOID_WAN_MOCA_INTF_STATUS 112
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    vendorId;	/**< VendorId */
    UINT32    hwVersion;	/**< HwVersion */
    UINT32    softwareVersion;	/**< SoftwareVersion */
    UINT32    driverMajorVersion;	/**< DriverMajorVersion */
    UINT32    driverMinorVersion;	/**< DriverMinorVersion */
    UINT32    driverBuildVersion;	/**< DriverBuildVersion */
    UINT32    selfMoCAVersion;	/**< SelfMoCAVersion */
    UINT32    networkVersionNumber;	/**< NetworkVersionNumber */
    UINT32    qam256Support;	/**< Qam256Support */
    UINT32    operationalStatus;	/**< OperationalStatus */
    UINT32    linkStatus;	/**< LinkStatus */
    UINT32    connectedNodes;	/**< ConnectedNodes */
    UINT32    nodeId;	/**< NodeId */
    UINT32    networkControllerNodeId;	/**< NetworkControllerNodeId */
    UINT32    upTime;	/**< UpTime */
    UINT32    linkUpTime;	/**< LinkUpTime */
    UINT32    backupNetworkControllerNodeId;	/**< BackupNetworkControllerNodeId */
    UINT32    rfChannel;	/**< RfChannel */
    UINT32    bwStatus;	/**< BwStatus */
} WanMocaIntfStatusObject;

/*! \brief _WanMocaIntfStatusObject is used internally to represent WanMocaIntfStatusObject */
typedef WanMocaIntfStatusObject _WanMocaIntfStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANMocaInterfaceConfig.Stats.
 *
 * MDMOID_WAN_MOCA_INTF_STATS 113
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    inUcPkts;	/**< InUcPkts */
    UINT32    inDiscardPktsEcl;	/**< InDiscardPktsEcl */
    UINT32    inDiscardPktsMac;	/**< InDiscardPktsMac */
    UINT32    inUnKnownPkts;	/**< InUnKnownPkts */
    UINT32    inMcPkts;	/**< InMcPkts */
    UINT32    inBcPkts;	/**< InBcPkts */
    UINT32    inOctetsLow;	/**< InOctetsLow */
    UINT32    outUcPkts;	/**< OutUcPkts */
    UINT32    outDiscardPkts;	/**< OutDiscardPkts */
    UINT32    outBcPkts;	/**< OutBcPkts */
    UINT32    outOctetsLow;	/**< OutOctetsLow */
    UINT32    networkControllerHandOffs;	/**< NetworkControllerHandOffs */
    UINT32    networkControllerBackups;	/**< NetworkControllerBackups */
} WanMocaIntfStatsObject;

/*! \brief _WanMocaIntfStatsObject is used internally to represent WanMocaIntfStatsObject */
typedef WanMocaIntfStatsObject _WanMocaIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_EponInterfaceConfig.
 *
 * MDMOID_WAN_EPON_INTF 114
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    MACAddress;	/**< MACAddress */
    char *    maxBitRate;	/**< MaxBitRate */
    char *    duplexMode;	/**< DuplexMode */
    char *    ifName;	/**< IfName */
    char *    connectionMode;	/**< ConnectionMode */
    UBOOL8    persistentDevice;	/**< PersistentDevice */
    UBOOL8    limitedConnections;	/**< LimitedConnections */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    maxConnections;	/**< MaxConnections */
#endif
} WanEponIntfObject;

/*! \brief _WanEponIntfObject is used internally to represent WanEponIntfObject */
typedef WanEponIntfObject _WanEponIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_EponInterfaceConfig.Stats.
 *
 * MDMOID_WAN_EPON_INTF_STATS 115
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    bytesReceived;	/**< BytesReceived */
    UINT32    packetsSent;	/**< PacketsSent */
    UINT32    packetsReceived;	/**< PacketsReceived */
} WanEponIntfStatsObject;

/*! \brief _WanEponIntfStatsObject is used internally to represent WanEponIntfStatsObject */
typedef WanEponIntfStatsObject _WanEponIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_L2tpAcIntfConfig.
 *
 * MDMOID_L2TP_AC_INTF_CONFIG 116
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    tunnelName;	/**< TunnelName */
    char *    lnsIpAddress;	/**< LnsIpAddress */
    char *    intfStatus;	/**< IntfStatus */
    UINT32    tunnelId;	/**< TunnelId */
} L2tpAcIntfConfigObject;

/*! \brief _L2tpAcIntfConfigObject is used internally to represent L2tpAcIntfConfigObject */
typedef L2tpAcIntfConfigObject _L2tpAcIntfConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANPonInterfaceConfig.
 *
 * MDMOID_WAN_PON_INTF 117
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    ponType;	/**< PonType */
} WanPonIntfObject;

/*! \brief _WanPonIntfObject is used internally to represent WanPonIntfObject */
typedef WanPonIntfObject _WanPonIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANPonInterfaceConfig.Stats.
 *
 * MDMOID_WAN_PON_INTF_STATUS 118
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    byteReceived;	/**< ByteReceived */
    UINT32    packetsSent;	/**< PacketsSent */
    UINT32    packetsReceived;	/**< PacketsReceived */
} WanPonIntfStatusObject;

/*! \brief _WanPonIntfStatusObject is used internally to represent WanPonIntfStatusObject */
typedef WanPonIntfStatusObject _WanPonIntfStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLDiagnostics.
 *
 * MDMOID_WAN_DSL_DIAG 119
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    loopDiagnosticsState;	/**< LoopDiagnosticsState */
    SINT32    ACTPSDds;	/**< ACTPSDds */
    SINT32    ACTPSDus;	/**< ACTPSDus */
    SINT32    ACTATPds;	/**< ACTATPds */
    SINT32    ACTATPus;	/**< ACTATPus */
    SINT32    HLINSCds;	/**< HLINSCds */
    char *    HLINpsds;	/**< HLINpsds */
    char *    QLNpsds;	/**< QLNpsds */
    char *    SNRpsds;	/**< SNRpsds */
    char *    BITSpsds;	/**< BITSpsds */
    char *    GAINSpsds;	/**< GAINSpsds */
    SINT32    HLINSCus;	/**< HLINSCus */
    SINT32    HLINGds;	/**< HLINGds */
    UINT32    HLINGus;	/**< HLINGus */
    char *    HLINpsus;	/**< HLINpsus */
    UINT32    HLOGGds;	/**< HLOGGds */
    UINT32    HLOGGus;	/**< HLOGGus */
    char *    HLOGpsds;	/**< HLOGpsds */
    char *    HLOGpsus;	/**< HLOGpsus */
    UINT32    HLOGMTds;	/**< HLOGMTds */
    UINT32    HLOGMTus;	/**< HLOGMTus */
    UINT32    QLNGds;	/**< QLNGds */
    UINT32    QLNGus;	/**< QLNGus */
    char *    QLNpsus;	/**< QLNpsus */
    UINT32    QLNMTds;	/**< QLNMTds */
    UINT32    QLNMTus;	/**< QLNMTus */
    UINT32    SNRGds;	/**< SNRGds */
    UINT32    SNRGus;	/**< SNRGus */
    char *    SNRpsus;	/**< SNRpsus */
    UINT32    SNRMTds;	/**< SNRMTds */
    UINT32    SNRMTus;	/**< SNRMTus */
    char *    LATNpbds;	/**< LATNpbds */
    char *    LATNpbus;	/**< LATNpbus */
    char *    SATNds;	/**< SATNds */
    char *    SATNus;	/**< SATNus */
} WanDslDiagObject;

/*! \brief _WanDslDiagObject is used internally to represent WanDslDiagObject */
typedef WanDslDiagObject _WanDslDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANDSLDiagnostics.
 *
 * MDMOID_WAN_DSL_PROPRIETARY_DIAG 120
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} WanDslProprietaryDiagObject;

/*! \brief _WanDslProprietaryDiagObject is used internally to represent WanDslProprietaryDiagObject */
typedef WanDslProprietaryDiagObject _WanDslProprietaryDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANDSLDiagnostics.PeakLineNoise.
 *
 * MDMOID_WAN_DSL_DIAG_PLN 121
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    diagnosticState;	/**< DiagnosticState */
    char *    PLNThldBB;	/**< PLNThldBB */
    char *    PLNThldPerTone;	/**< PLNThldPerTone */
    UINT32    PLNDurationNbBins;	/**< PLNDurationNbBins */
    char *    PLNDurationBins;	/**< PLNDurationBins */
    UINT32    PLNIntrArvNbBins;	/**< PLNIntrArvNbBins */
    char *    PLNIntrArvlBins;	/**< PLNIntrArvlBins */
    char *    PLNValueps;	/**< PLNValueps */
    char *    PLNThldCntps;	/**< PLNThldCntps */
    char *    PLNDurationHist;	/**< PLNDurationHist */
    char *    PLNIntrArvlHist;	/**< PLNIntrArvlHist */
    UINT32    PLNPerToneCounter;	/**< PLNPerToneCounter */
    UINT32    PLNBBCounter;	/**< PLNBBCounter */
} WanDslDiagPlnObject;

/*! \brief _WanDslDiagPlnObject is used internally to represent WanDslDiagPlnObject */
typedef WanDslDiagPlnObject _WanDslDiagPlnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANDSLDiagnostics.NonLinearity.
 *
 * MDMOID_WAN_DSL_DIAG_NON_LINEARITY 122
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    maxCriticalDistNoise;	/**< MaxCriticalDistNoise */
    UINT32    distAffectedBits;	/**< DistAffectedBits */
    char *    distNoisedB;	/**< DistNoisedB */
} WanDslDiagNonLinearityObject;

/*! \brief _WanDslDiagNonLinearityObject is used internally to represent WanDslDiagNonLinearityObject */
typedef WanDslDiagNonLinearityObject _WanDslDiagNonLinearityObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.
 *
 * MDMOID_WAN_CONN_DEVICE 123
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    WANIPConnectionNumberOfEntries;	/**< WANIPConnectionNumberOfEntries */
    UINT32    WANPPPConnectionNumberOfEntries;	/**< WANPPPConnectionNumberOfEntries */
} WanConnDeviceObject;

/*! \brief _WanConnDeviceObject is used internally to represent WanConnDeviceObject */
typedef WanConnDeviceObject _WanConnDeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANATMF4EndToEndLoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM_F4_END_TO_END_LOOPBACK_DIAG 124
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    diagnosticsState;	/**< DiagnosticsState */
    UINT32    numberOfRepetitions;	/**< NumberOfRepetitions */
    UINT32    timeout;	/**< Timeout */
    UINT32    successCount;	/**< SuccessCount */
    UINT32    failureCount;	/**< FailureCount */
    UINT32    averageResponseTime;	/**< AverageResponseTime */
    UINT32    minimumResponseTime;	/**< MinimumResponseTime */
    UINT32    maximumResponseTime;	/**< MaximumResponseTime */
} WanAtmF4EndToEndLoopbackDiagObject;

/*! \brief _WanAtmF4EndToEndLoopbackDiagObject is used internally to represent WanAtmF4EndToEndLoopbackDiagObject */
typedef WanAtmF4EndToEndLoopbackDiagObject _WanAtmF4EndToEndLoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANATMF4LoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM_F4_LOOPBACK_DIAG 125
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    diagnosticsState;	/**< DiagnosticsState */
    UINT32    numberOfRepetitions;	/**< NumberOfRepetitions */
    UINT32    timeout;	/**< Timeout */
    UINT32    successCount;	/**< SuccessCount */
    UINT32    failureCount;	/**< FailureCount */
    UINT32    averageResponseTime;	/**< AverageResponseTime */
    UINT32    minimumResponseTime;	/**< MinimumResponseTime */
    UINT32    maximumResponseTime;	/**< MaximumResponseTime */
} WanAtmF4LoopbackDiagObject;

/*! \brief _WanAtmF4LoopbackDiagObject is used internally to represent WanAtmF4LoopbackDiagObject */
typedef WanAtmF4LoopbackDiagObject _WanAtmF4LoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANATMF5EndToEndLoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM_F5_END_TO_END_LOOPBACK_DIAG 126
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    diagnosticsState;	/**< DiagnosticsState */
    UINT32    numberOfRepetitions;	/**< NumberOfRepetitions */
    UINT32    timeout;	/**< Timeout */
    UINT32    successCount;	/**< SuccessCount */
    UINT32    failureCount;	/**< FailureCount */
    UINT32    averageResponseTime;	/**< AverageResponseTime */
    UINT32    minimumResponseTime;	/**< MinimumResponseTime */
    UINT32    maximumResponseTime;	/**< MaximumResponseTime */
} WanAtmF5EndToEndLoopbackDiagObject;

/*! \brief _WanAtmF5EndToEndLoopbackDiagObject is used internally to represent WanAtmF5EndToEndLoopbackDiagObject */
typedef WanAtmF5EndToEndLoopbackDiagObject _WanAtmF5EndToEndLoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANGPONLinkConfig.
 *
 * MDMOID_WAN_GPON_LINK_CFG 127
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    linkStatus;	/**< LinkStatus */
    UINT32    portID;	/**< PortID */
    SINT32    direction;	/**< Direction */
    char *    connectionMode;	/**< ConnectionMode */
    char *    ifName;	/**< IfName */
} WanGponLinkCfgObject;

/*! \brief _WanGponLinkCfgObject is used internally to represent WanGponLinkCfgObject */
typedef WanGponLinkCfgObject _WanGponLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANEPONLinkConfig.
 *
 * MDMOID_WAN_EPON_LINK_CFG 128
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
} WanEponLinkCfgObject;

/*! \brief _WanEponLinkCfgObject is used internally to represent WanEponLinkCfgObject */
typedef WanEponLinkCfgObject _WanEponLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANDSLLinkConfig.
 *
 * MDMOID_WAN_DSL_LINK_CFG 129
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    linkStatus;	/**< LinkStatus */
    char *    linkType;	/**< LinkType */
    UBOOL8    autoConfig;	/**< AutoConfig */
    char *    modulationType;	/**< ModulationType */
    char *    destinationAddress;	/**< DestinationAddress */
    char *    ATMEncapsulation;	/**< ATMEncapsulation */
    char *    ATMAAL;	/**< ATMAAL */
    UINT32    ATMTransmittedBlocks;	/**< ATMTransmittedBlocks */
    UINT32    ATMReceivedBlocks;	/**< ATMReceivedBlocks */
    char *    ATMQoS;	/**< ATMQoS */
    UINT32    ATMPeakCellRate;	/**< ATMPeakCellRate */
    UINT32    ATMMaximumBurstSize;	/**< ATMMaximumBurstSize */
    UINT32    ATMSustainableCellRate;	/**< ATMSustainableCellRate */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATMMinimumCellRate;	/**< X_BROADCOM_COM_ATMMinimumCellRate */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UBOOL8    X_BROADCOM_COM_ATMEnbQos;	/**< X_BROADCOM_COM_ATMEnbQos */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_GrpScheduler;	/**< X_BROADCOM_COM_GrpScheduler */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_GrpWeight;	/**< X_BROADCOM_COM_GrpWeight */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_GrpPrecedence;	/**< X_BROADCOM_COM_GrpPrecedence */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_SchedulerAlgorithm;	/**< X_BROADCOM_COM_SchedulerAlgorithm */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_QueueWeight;	/**< X_BROADCOM_COM_QueueWeight */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_QueuePrecedence;	/**< X_BROADCOM_COM_QueuePrecedence */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ATMStatus;	/**< X_BROADCOM_COM_ATMStatus */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATMInterfaceId;	/**< X_BROADCOM_COM_ATMInterfaceId */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_MacAddress;	/**< X_BROADCOM_COM_MacAddress */
#endif
    UINT32    AAL5CRCErrors;	/**< AAL5CRCErrors */
    UINT32    ATMCRCErrors;	/**< ATMCRCErrors */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ConnectionMode;	/**< X_BROADCOM_COM_ConnectionMode */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
#endif
} WanDslLinkCfgObject;

/*! \brief _WanDslLinkCfgObject is used internally to represent WanDslLinkCfgObject */
typedef WanDslLinkCfgObject _WanDslLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANDSLLinkConfig.X_BROADCOM_COM_ATM_PARMS.
 *
 * MDMOID_WAN_DSL_ATM_PARAMS 130
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    ATMFreeCellQSize;	/**< ATMFreeCellQSize */
    UINT32    ATMFreePacketQSize;	/**< ATMFreePacketQSize */
    UINT32    ATMFreePacketQBufferSize;	/**< ATMFreePacketQBufferSize */
    UINT32    ATMFreePacketQBufferOffset;	/**< ATMFreePacketQBufferOffset */
    UINT32    ATMReceiveCellQSize;	/**< ATMReceiveCellQSize */
    UINT32    ATMReceivePacketQSize;	/**< ATMReceivePacketQSize */
    UINT32    ATMTransmitFifoPriority;	/**< ATMTransmitFifoPriority */
    UINT32    ATMAal5CpcsMaxSduLength;	/**< ATMAal5CpcsMaxSduLength */
    UINT32    ATMAal2SscsMaxSsarSduLength;	/**< ATMAal2SscsMaxSsarSduLength */
} WanDslAtmParamsObject;

/*! \brief _WanDslAtmParamsObject is used internally to represent WanDslAtmParamsObject */
typedef WanDslAtmParamsObject _WanDslAtmParamsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANATMF5LoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM5_LOOPBACK_DIAG 131
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    diagnosticsState;	/**< DiagnosticsState */
    UINT32    numberOfRepetitions;	/**< NumberOfRepetitions */
    UINT32    timeout;	/**< Timeout */
    UINT32    successCount;	/**< SuccessCount */
    UINT32    failureCount;	/**< FailureCount */
    UINT32    averageResponseTime;	/**< AverageResponseTime */
    UINT32    minimumResponseTime;	/**< MinimumResponseTime */
    UINT32    maximumResponseTime;	/**< MaximumResponseTime */
} WanAtm5LoopbackDiagObject;

/*! \brief _WanAtm5LoopbackDiagObject is used internally to represent WanAtm5LoopbackDiagObject */
typedef WanAtm5LoopbackDiagObject _WanAtm5LoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPTMLinkConfig.
 *
 * MDMOID_WAN_PTM_LINK_CFG 132
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    linkStatus;	/**< LinkStatus */
    char *    MACAddress;	/**< MACAddress */
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_PTMPortId;	/**< X_BROADCOM_COM_PTMPortId */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UBOOL8    X_BROADCOM_COM_PTMPriorityLow;	/**< X_BROADCOM_COM_PTMPriorityLow */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UBOOL8    X_BROADCOM_COM_PTMPriorityHigh;	/**< X_BROADCOM_COM_PTMPriorityHigh */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UBOOL8    X_BROADCOM_COM_PTMEnbQos;	/**< X_BROADCOM_COM_PTMEnbQos */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_GrpScheduler;	/**< X_BROADCOM_COM_GrpScheduler */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_GrpWeight;	/**< X_BROADCOM_COM_GrpWeight */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_GrpPrecedence;	/**< X_BROADCOM_COM_GrpPrecedence */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_SchedulerAlgorithm;	/**< X_BROADCOM_COM_SchedulerAlgorithm */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_QueueWeight;	/**< X_BROADCOM_COM_QueueWeight */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_QueuePrecedence;	/**< X_BROADCOM_COM_QueuePrecedence */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_ConnectionMode;	/**< X_BROADCOM_COM_ConnectionMode */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    SINT32    X_BROADCOM_COM_QueueShapingRate;	/**< X_BROADCOM_COM_QueueShapingRate */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_QueueShapingBurstSize;	/**< X_BROADCOM_COM_QueueShapingBurstSize */
#endif
} WanPtmLinkCfgObject;

/*! \brief _WanPtmLinkCfgObject is used internally to represent WanPtmLinkCfgObject */
typedef WanPtmLinkCfgObject _WanPtmLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANEthernetLinkConfig.
 *
 * MDMOID_WAN_ETH_LINK_CFG 133
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    ethernetLinkStatus;	/**< EthernetLinkStatus */
} WanEthLinkCfgObject;

/*! \brief _WanEthLinkCfgObject is used internally to represent WanEthLinkCfgObject */
typedef WanEthLinkCfgObject _WanEthLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_L2tpAcLinkConfig.
 *
 * MDMOID_L2TP_AC_LINK_CONFIG 134
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    sessionName;	/**< SessionName */
    char *    connectionMode;	/**< ConnectionMode */
    char *    linkStatus;	/**< LinkStatus */
    UINT32    sessionId;	/**< SessionId */
    char *    ifName;	/**< IfName */
} L2tpAcLinkConfigObject;

/*! \brief _L2tpAcLinkConfigObject is used internally to represent L2tpAcLinkConfigObject */
typedef L2tpAcLinkConfigObject _L2tpAcLinkConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.
 *
 * MDMOID_WAN_IP_CONN 135
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    connectionStatus;	/**< ConnectionStatus */
    char *    possibleConnectionTypes;	/**< PossibleConnectionTypes */
    char *    connectionType;	/**< ConnectionType */
    char *    name;	/**< Name */
    UINT32    uptime;	/**< Uptime */
    char *    lastConnectionError;	/**< LastConnectionError */
    UBOOL8    NATEnabled;	/**< NATEnabled */
    UBOOL8    X_BROADCOM_COM_FullconeNATEnabled;	/**< X_BROADCOM_COM_FullconeNATEnabled */
    char *    addressingType;	/**< AddressingType */
    char *    externalIPAddress;	/**< ExternalIPAddress */
    char *    subnetMask;	/**< SubnetMask */
    char *    defaultGateway;	/**< DefaultGateway */
    UINT32    X_ALLIEDTELESIS_COM_DHCP_LeaseDuration;	/**< X_ALLIEDTELESIS_COM_DHCP_LeaseDuration */
    UINT32    X_ALLIEDTELESIS_COM_DHCP_LeaseStartTime;	/**< X_ALLIEDTELESIS_COM_DHCP_LeaseStartTime */
    UINT32    X_ALLIEDTELESIS_COM_DHCP_LeaseTime;	/**< X_ALLIEDTELESIS_COM_DHCP_LeaseTime */
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< X_BROADCOM_COM_FirewallEnabled */
    UBOOL8    X_BROADCOM_COM_IGMPEnabled;	/**< X_BROADCOM_COM_IGMPEnabled */
#ifdef DMP_X_BROADCOM_COM_GPONWAN_1
    UBOOL8    X_BROADCOM_COM_NoMcastVlanFilter;	/**< X_BROADCOM_COM_NoMcastVlanFilter */
#endif
    UBOOL8    DNSEnabled;	/**< DNSEnabled */
    UBOOL8    DNSOverrideAllowed;	/**< DNSOverrideAllowed */
    char *    DNSServers;	/**< DNSServers */
    char *    X_ALLIEDTELESIS_COM_DNSDomainName;	/**< X_ALLIEDTELESIS_COM_DNSDomainName */
    UBOOL8    X_ALLIEDTELESIS_COM_DNSProxyEnabled;	/**< X_ALLIEDTELESIS_COM_DNSProxyEnabled */
    UBOOL8    X_ALLIEDTELESIS_COM_DNSProxyOverrideAllowed;	/**< X_ALLIEDTELESIS_COM_DNSProxyOverrideAllowed */
    char *    X_ALLIEDTELESIS_COM_DNSProxyServers;	/**< X_ALLIEDTELESIS_COM_DNSProxyServers */
    UINT32    maxMTUSize;	/**< MaxMTUSize */
    char *    MACAddress;	/**< MACAddress */
    UBOOL8    MACAddressOverride;	/**< MACAddressOverride */
    char *    connectionTrigger;	/**< ConnectionTrigger */
    char *    routeProtocolRx;	/**< RouteProtocolRx */
    char *    X_BROADCOM_COM_RipOperationMode;	/**< X_BROADCOM_COM_RipOperationMode */
    char *    X_BROADCOM_COM_RipDebugMode;	/**< X_BROADCOM_COM_RipDebugMode */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
    SINT32    X_BROADCOM_COM_ConnectionId;	/**< X_BROADCOM_COM_ConnectionId */
    UINT32    X_BROADCOM_COM_DhcpcPid;	/**< X_BROADCOM_COM_DhcpcPid */
    SINT32    X_BROADCOM_COM_VlanMux8021p;	/**< X_BROADCOM_COM_VlanMux8021p */
    SINT32    X_BROADCOM_COM_VlanMuxID;	/**< X_BROADCOM_COM_VlanMuxID */
    SINT32    X_ALLIEDTELESIS_COM_VIDTranslate;	/**< X_ALLIEDTELESIS_COM_VIDTranslate */
    UBOOL8    X_ALLIEDTELESIS_COM_Untagged;	/**< X_ALLIEDTELESIS_COM_Untagged */
    SINT32    X_ALLIEDTELESIS_COM_InterfaceInstance;	/**< X_ALLIEDTELESIS_COM_InterfaceInstance */
    UINT32    portMappingNumberOfEntries;	/**< PortMappingNumberOfEntries */
    UBOOL8    X_ALLIEDTELESIS_COM_BroadcastFlag;	/**< X_ALLIEDTELESIS_COM_BroadcastFlag */
    UBOOL8    X_ALLIEDTELESIS_COM_DHCP_Restart;	/**< X_ALLIEDTELESIS_COM_DHCP_Restart */
    UBOOL8    X_ALLIEDTELESIS_COM_Op15Enabled;	/**< X_ALLIEDTELESIS_COM_Op15Enabled */
    char *    X_BROADCOM_COM_Op60VenderID;	/**< X_BROADCOM_COM_Op60VenderID */
    char *    X_BROADCOM_COM_Op61DUID;	/**< X_BROADCOM_COM_Op61DUID */
    char *    X_BROADCOM_COM_Op61IAID;	/**< X_BROADCOM_COM_Op61IAID */
    char *    X_ALLIEDTELESIS_COM_Op61Identifier;	/**< X_ALLIEDTELESIS_COM_Op61Identifier */
    UBOOL8    X_ALLIEDTELESIS_COM_Op121Enabled;	/**< X_ALLIEDTELESIS_COM_Op121Enabled */
    UBOOL8    X_ALLIEDTELESIS_COM_ClasslessRouteListReceived;	/**< X_ALLIEDTELESIS_COM_ClasslessRouteListReceived */
    UBOOL8    X_BROADCOM_COM_Op125Enabled;	/**< X_BROADCOM_COM_Op125Enabled */
    UBOOL8    X_BROADCOM_COM_IPv6Enabled;	/**< X_BROADCOM_COM_IPv6Enabled */
    UBOOL8    X_BROADCOM_COM_IPv4Enabled;	/**< X_BROADCOM_COM_IPv4Enabled */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_UnnumberedModel;	/**< X_BROADCOM_COM_UnnumberedModel */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6ConnStatus;	/**< X_BROADCOM_COM_IPv6ConnStatus */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6AddressingType;	/**< X_BROADCOM_COM_IPv6AddressingType */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForAddress;	/**< X_BROADCOM_COM_Dhcp6cForAddress */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForPrefixDelegation;	/**< X_BROADCOM_COM_Dhcp6cForPrefixDelegation */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_ExternalIPv6Address;	/**< X_BROADCOM_COM_ExternalIPv6Address */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_DefaultIPv6Gateway;	/**< X_BROADCOM_COM_DefaultIPv6Gateway */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DNSServers;	/**< X_BROADCOM_COM_IPv6DNSServers */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DomainName;	/**< X_BROADCOM_COM_IPv6DomainName */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_IPv6PrefixDelegationEnabled;	/**< X_BROADCOM_COM_IPv6PrefixDelegationEnabled */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6SitePrefix;	/**< X_BROADCOM_COM_IPv6SitePrefix */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixPltime;	/**< X_BROADCOM_COM_IPv6SitePrefixPltime */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixVltime;	/**< X_BROADCOM_COM_IPv6SitePrefixVltime */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UINT32    X_BROADCOM_COM_Dhcp6cPid;	/**< X_BROADCOM_COM_Dhcp6cPid */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_MLDEnabled;	/**< X_BROADCOM_COM_MLDEnabled */
#endif
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UBOOL8    X_BROADCOM_COM_LastConnected;	/**< X_BROADCOM_COM_LastConnected */
#endif
    char *    X_ALLIEDTELESIS_COM_UpnpEnabled;	/**< X_ALLIEDTELESIS_COM_UpnpEnabled */
} WanIpConnObject;

/*! \brief _WanIpConnObject is used internally to represent WanIpConnObject */
typedef WanIpConnObject _WanIpConnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.PortMapping.{i}.
 *
 * MDMOID_WAN_IP_CONN_PORTMAPPING 136
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    portMappingEnabled;	/**< PortMappingEnabled */
    UINT32    portMappingLeaseDuration;	/**< PortMappingLeaseDuration */
    UINT32    X_BROADCOM_COM_ExpiryTime;	/**< X_BROADCOM_COM_ExpiryTime */
    char *    remoteHost;	/**< RemoteHost */
    UINT32    externalPort;	/**< ExternalPort */
    UINT32    X_BROADCOM_COM_ExternalPortEnd;	/**< X_BROADCOM_COM_ExternalPortEnd */
    UINT32    internalPort;	/**< InternalPort */
    UINT32    X_BROADCOM_COM_InternalPortEnd;	/**< X_BROADCOM_COM_InternalPortEnd */
    char *    portMappingProtocol;	/**< PortMappingProtocol */
    char *    internalClient;	/**< InternalClient */
    char *    portMappingDescription;	/**< PortMappingDescription */
    char *    X_BROADCOM_COM_AppName;	/**< X_BROADCOM_COM_AppName */
} WanIpConnPortmappingObject;

/*! \brief _WanIpConnPortmappingObject is used internally to represent WanIpConnPortmappingObject */
typedef WanIpConnPortmappingObject _WanIpConnPortmappingObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_PortTriggering.{i}.
 *
 * MDMOID_WAN_IP_CONN_PORT_TRIGGERING 137
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    name;	/**< Name */
    char *    triggerProtocol;	/**< TriggerProtocol */
    char *    openProtocol;	/**< OpenProtocol */
    UINT32    triggerPortStart;	/**< TriggerPortStart */
    UINT32    triggerPortEnd;	/**< TriggerPortEnd */
    UINT32    openPortStart;	/**< OpenPortStart */
    UINT32    openPortEnd;	/**< OpenPortEnd */
} WanIpConnPortTriggeringObject;

/*! \brief _WanIpConnPortTriggeringObject is used internally to represent WanIpConnPortTriggeringObject */
typedef WanIpConnPortTriggeringObject _WanIpConnPortTriggeringObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_WAN_IP_CONN_FIREWALL_EXCEPTION 138
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    filterName;	/**< FilterName */
    char *    IPVersion;	/**< IPVersion */
    char *    protocol;	/**< Protocol */
    UINT32    sourcePortStart;	/**< SourcePortStart */
    UINT32    sourcePortEnd;	/**< SourcePortEnd */
    UINT32    destinationPortStart;	/**< DestinationPortStart */
    UINT32    destinationPortEnd;	/**< DestinationPortEnd */
    char *    sourceIPAddress;	/**< SourceIPAddress */
    char *    sourceNetMask;	/**< SourceNetMask */
    char *    destinationIPAddress;	/**< DestinationIPAddress */
    char *    destinationNetMask;	/**< DestinationNetMask */
} WanIpConnFirewallExceptionObject;

/*! \brief _WanIpConnFirewallExceptionObject is used internally to represent WanIpConnFirewallExceptionObject */
typedef WanIpConnFirewallExceptionObject _WanIpConnFirewallExceptionObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_MacFilterObj.
 *
 * MDMOID_MAC_FILTER 139
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    policy;	/**< Policy */
} MacFilterObject;

/*! \brief _MacFilterObject is used internally to represent MacFilterObject */
typedef MacFilterObject _MacFilterObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_MacFilterObj.X_BROADCOM_COM_MacFilterCfg.{i}.
 *
 * MDMOID_MAC_FILTER_CFG 140
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    protocol;	/**< Protocol */
    char *    direction;	/**< Direction */
    char *    sourceMAC;	/**< SourceMAC */
    char *    destinationMAC;	/**< DestinationMAC */
} MacFilterCfgObject;

/*! \brief _MacFilterCfgObject is used internally to represent MacFilterCfgObject */
typedef MacFilterCfgObject _MacFilterCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_ALLIEDTELESIS_COM_FwdDatabase.
 *
 * MDMOID_WAN_FWD_DATABASE 141
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    clearFwdDatabase;	/**< ClearFwdDatabase */
    UBOOL8    clearFwdDatabaseStatic;	/**< ClearFwdDatabaseStatic */
    UINT32    fwdDatabaseCount;	/**< FwdDatabaseCount */
    char *    wanFwdDatabase;	/**< WanFwdDatabase */
} WanFwdDatabaseObject;

/*! \brief _WanFwdDatabaseObject is used internally to represent WanFwdDatabaseObject */
typedef WanFwdDatabaseObject _WanFwdDatabaseObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_ALLIEDTELESIS_COM_IgmpStatus.
 *
 * MDMOID_WAN_IGMP_STATUS 142
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    clearIgmpCounters;	/**< ClearIgmpCounters */
    UINT32    igmpQueryTxCount;	/**< IgmpQueryTxCount */
    UINT32    igmpGroupSpecificQueryTxCount;	/**< IgmpGroupSpecificQueryTxCount */
    UINT32    igmpV3QueryTxCount;	/**< IgmpV3QueryTxCount */
    UINT32    igmpReportTxCount;	/**< IgmpReportTxCount */
    UINT32    igmpLeaveTxCount;	/**< IgmpLeaveTxCount */
    UINT32    igmpV3ReportTxCount;	/**< IgmpV3ReportTxCount */
    UINT32    igmpQueryRxCount;	/**< IgmpQueryRxCount */
    UINT32    igmpGroupSpecificQueryRxCount;	/**< IgmpGroupSpecificQueryRxCount */
    UINT32    igmpV3QueryRxCount;	/**< IgmpV3QueryRxCount */
    UINT32    igmpReportRxCount;	/**< IgmpReportRxCount */
    UINT32    igmpLeaveRxCount;	/**< IgmpLeaveRxCount */
    UINT32    igmpV3ReportRxCount;	/**< IgmpV3ReportRxCount */
    UINT32    igmpMCastStreamCount;	/**< IgmpMCastStreamCount */
} WanIgmpStatusObject;

/*! \brief _WanIgmpStatusObject is used internally to represent WanIgmpStatusObject */
typedef WanIgmpStatusObject _WanIgmpStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_ALLIEDTELESIS_COM_IgmpStatus.X_ALLIED_TELESIS_IgmpMCastStream.{i}.
 *
 * MDMOID_WAN_IGMP_M_CAST_STREAM 143
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    source;	/**< Source */
    char *    group;	/**< Group */
    char *    reporter;	/**< Reporter */
    char *    reporterList;	/**< ReporterList */
    UINT32    upTime;	/**< UpTime */
    UINT32    lastJoin;	/**< LastJoin */
    UINT32    lastLeave;	/**< LastLeave */
    UINT32    expires;	/**< Expires */
} WanIgmpMCastStreamObject;

/*! \brief _WanIgmpMCastStreamObject is used internally to represent WanIgmpMCastStreamObject */
typedef WanIgmpMCastStreamObject _WanIgmpMCastStreamObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.Stats.
 *
 * MDMOID_WAN_IP_CONN_STATS 144
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< X_BROADCOM_COM_RxDrops */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< X_BROADCOM_COM_TxDrops */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< X_BROADCOM_COM_RxErrors */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< X_BROADCOM_COM_TxErrors */
    UINT32    ethernetBytesSent;	/**< EthernetBytesSent */
    UINT32    ethernetBytesReceived;	/**< EthernetBytesReceived */
    UINT32    ethernetPacketsSent;	/**< EthernetPacketsSent */
    UINT32    ethernetPacketsReceived;	/**< EthernetPacketsReceived */
} WanIpConnStatsObject;

/*! \brief _WanIpConnStatsObject is used internally to represent WanIpConnStatsObject */
typedef WanIpConnStatsObject _WanIpConnStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_ALLIEDTELESIS_COM_WANIPV6Connection.{i}.
 *
 * MDMOID_WAN_IPV6_CONN 145
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    ifName;	/**< IfName */
    UBOOL8    enable;	/**< Enable */
    char *    connectionStatus;	/**< ConnectionStatus */
    char *    addressingType;	/**< AddressingType */
    char *    externalIPv6Address;	/**< ExternalIPv6Address */
    UBOOL8    disable_IPv6;	/**< Disable_IPv6 */
    UBOOL8    mldEnabled;	/**< MldEnabled */
    char *    IPv6AddressPrefixName;	/**< IPv6AddressPrefixName */
    UINT32    IPv6AddressPrefixSLA;	/**< IPv6AddressPrefixSLA */
    UINT32    dhcp6cPid;	/**< Dhcp6cPid */
    char *    IPv6DNSServers;	/**< IPv6DNSServers */
    char *    DNSDomainName;	/**< DNSDomainName */
    UBOOL8    dhcp6cRequestRapidCommit;	/**< Dhcp6cRequestRapidCommit */
    UBOOL8    dhcp6cRequestDnsServers;	/**< Dhcp6cRequestDnsServers */
    UBOOL8    dhcp6cRequestDomainList;	/**< Dhcp6cRequestDomainList */
    UINT32    DADTransmits;	/**< DADTransmits */
    UINT32    RSDelay;	/**< RSDelay */
    UINT32    RSInterval;	/**< RSInterval */
    UINT32    RSAttempts;	/**< RSAttempts */
    UINT32    maxDelegatedPrefixes;	/**< MaxDelegatedPrefixes */
    UINT32    delegatedPrefixNumberOfEntries;	/**< DelegatedPrefixNumberOfEntries */
} WanIpv6ConnObject;

/*! \brief _WanIpv6ConnObject is used internally to represent WanIpv6ConnObject */
typedef WanIpv6ConnObject _WanIpv6ConnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_ALLIEDTELESIS_COM_WANIPV6Connection.{i}.IPv6IfAddress.{i}.
 *
 * MDMOID_I_PV6_IF_ADDRESS 146
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    scope;	/**< Scope */
    char *    address;	/**< Address */
} IPv6IfAddressObject;

/*! \brief _IPv6IfAddressObject is used internally to represent IPv6IfAddressObject */
typedef IPv6IfAddressObject _IPv6IfAddressObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_ALLIEDTELESIS_COM_WANIPV6Connection.{i}.DelegatedPrefix.{i}.
 *
 * MDMOID_DELEGATED_PREFIX 147
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    char *    hint;	/**< Hint */
    char *    prefix;	/**< Prefix */
    SINT32    pltime;	/**< Pltime */
    SINT32    vltime;	/**< Vltime */
} DelegatedPrefixObject;

/*! \brief _DelegatedPrefixObject is used internally to represent DelegatedPrefixObject */
typedef DelegatedPrefixObject _DelegatedPrefixObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.
 *
 * MDMOID_WAN_PPP_CONN 148
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    connectionStatus;	/**< ConnectionStatus */
    char *    possibleConnectionTypes;	/**< PossibleConnectionTypes */
    char *    connectionType;	/**< ConnectionType */
    char *    name;	/**< Name */
    UINT32    uptime;	/**< Uptime */
    char *    lastConnectionError;	/**< LastConnectionError */
    UINT32    idleDisconnectTime;	/**< IdleDisconnectTime */
    UBOOL8    RSIPAvailable;	/**< RSIPAvailable */
    UBOOL8    NATEnabled;	/**< NATEnabled */
    UBOOL8    X_BROADCOM_COM_FullconeNATEnabled;	/**< X_BROADCOM_COM_FullconeNATEnabled */
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< X_BROADCOM_COM_FirewallEnabled */
    UBOOL8    X_BROADCOM_COM_IGMPEnabled;	/**< X_BROADCOM_COM_IGMPEnabled */
#ifdef DMP_X_BROADCOM_COM_GPONWAN_1
    UBOOL8    X_BROADCOM_COM_NoMcastVlanFilter;	/**< X_BROADCOM_COM_NoMcastVlanFilter */
#endif
    char *    username;	/**< Username */
    char *    password;	/**< Password */
    char *    PPPEncryptionProtocol;	/**< PPPEncryptionProtocol */
    char *    PPPCompressionProtocol;	/**< PPPCompressionProtocol */
    char *    PPPAuthenticationProtocol;	/**< PPPAuthenticationProtocol */
    UINT32    X_BROADCOM_COM_ConnectionEstablishedTime;	/**< X_BROADCOM_COM_ConnectionEstablishedTime */
    UBOOL8    X_BROADCOM_COM_IPExtension;	/**< X_BROADCOM_COM_IPExtension */
    UBOOL8    X_BROADCOM_COM_UseStaticIPAddress;	/**< X_BROADCOM_COM_UseStaticIPAddress */
    char *    X_BROADCOM_COM_LocalIPAddress;	/**< X_BROADCOM_COM_LocalIPAddress */
    SINT32    X_BROADCOM_COM_ConnectionId;	/**< X_BROADCOM_COM_ConnectionId */
    UINT32    X_BROADCOM_COM_PppdPid;	/**< X_BROADCOM_COM_PppdPid */
    char *    X_BROADCOM_COM_IfName;	/**< X_BROADCOM_COM_IfName */
    char *    X_BROADCOM_COM_DefaultGateway;	/**< X_BROADCOM_COM_DefaultGateway */
    UBOOL8    X_BROADCOM_COM_Enable_Debug;	/**< X_BROADCOM_COM_Enable_Debug */
    UBOOL8    X_BROADCOM_COM_AddPppToBridge;	/**< X_BROADCOM_COM_AddPppToBridge */
    SINT32    X_BROADCOM_COM_VlanMux8021p;	/**< X_BROADCOM_COM_VlanMux8021p */
    SINT32    X_BROADCOM_COM_VlanMuxID;	/**< X_BROADCOM_COM_VlanMuxID */
    char *    X_BROADCOM_COM_UserRequest;	/**< X_BROADCOM_COM_UserRequest */
    char *    externalIPAddress;	/**< ExternalIPAddress */
    char *    remoteIPAddress;	/**< RemoteIPAddress */
    UINT32    currentMRUSize;	/**< CurrentMRUSize */
    UBOOL8    DNSEnabled;	/**< DNSEnabled */
    UBOOL8    DNSOverrideAllowed;	/**< DNSOverrideAllowed */
    char *    DNSServers;	/**< DNSServers */
    char *    MACAddress;	/**< MACAddress */
    UBOOL8    MACAddressOverride;	/**< MACAddressOverride */
    char *    transportType;	/**< TransportType */
    char *    PPPoEServiceName;	/**< PPPoEServiceName */
    char *    connectionTrigger;	/**< ConnectionTrigger */
    char *    routeProtocolRx;	/**< RouteProtocolRx */
    UINT32    PPPLCPEcho;	/**< PPPLCPEcho */
    UINT32    PPPLCPEchoRetry;	/**< PPPLCPEchoRetry */
    UINT32    portMappingNumberOfEntries;	/**< PortMappingNumberOfEntries */
    UBOOL8    X_BROADCOM_COM_IPv6Enabled;	/**< X_BROADCOM_COM_IPv6Enabled */
    UBOOL8    X_BROADCOM_COM_IPv4Enabled;	/**< X_BROADCOM_COM_IPv4Enabled */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_UnnumberedModel;	/**< X_BROADCOM_COM_UnnumberedModel */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6ConnStatus;	/**< X_BROADCOM_COM_IPv6ConnStatus */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_IPv6PppUp;	/**< X_BROADCOM_COM_IPv6PppUp */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6AddressingType;	/**< X_BROADCOM_COM_IPv6AddressingType */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForAddress;	/**< X_BROADCOM_COM_Dhcp6cForAddress */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForPrefixDelegation;	/**< X_BROADCOM_COM_Dhcp6cForPrefixDelegation */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_ExternalIPv6Address;	/**< X_BROADCOM_COM_ExternalIPv6Address */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_DefaultIPv6Gateway;	/**< X_BROADCOM_COM_DefaultIPv6Gateway */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DNSServers;	/**< X_BROADCOM_COM_IPv6DNSServers */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DomainName;	/**< X_BROADCOM_COM_IPv6DomainName */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_IPv6PrefixDelegationEnabled;	/**< X_BROADCOM_COM_IPv6PrefixDelegationEnabled */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6SitePrefix;	/**< X_BROADCOM_COM_IPv6SitePrefix */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixPltime;	/**< X_BROADCOM_COM_IPv6SitePrefixPltime */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixVltime;	/**< X_BROADCOM_COM_IPv6SitePrefixVltime */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UINT32    X_BROADCOM_COM_Dhcp6cPid;	/**< X_BROADCOM_COM_Dhcp6cPid */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_MLDEnabled;	/**< X_BROADCOM_COM_MLDEnabled */
#endif
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UBOOL8    X_BROADCOM_COM_LastConnected;	/**< X_BROADCOM_COM_LastConnected */
#endif
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UBOOL8    X_BROADCOM_COM_StopPppD;	/**< X_BROADCOM_COM_StopPppD */
#endif
    char *    X_ALLIEDTELESIS_COM_UpnpEnabled;	/**< X_ALLIEDTELESIS_COM_UpnpEnabled */
} WanPppConnObject;

/*! \brief _WanPppConnObject is used internally to represent WanPppConnObject */
typedef WanPppConnObject _WanPppConnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.PortMapping.{i}.
 *
 * MDMOID_WAN_PPP_CONN_PORTMAPPING 149
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    portMappingEnabled;	/**< PortMappingEnabled */
    UINT32    X_BROADCOM_COM_ExpiryTime;	/**< X_BROADCOM_COM_ExpiryTime */
    UINT32    portMappingLeaseDuration;	/**< PortMappingLeaseDuration */
    char *    remoteHost;	/**< RemoteHost */
    UINT32    externalPort;	/**< ExternalPort */
    UINT32    X_BROADCOM_COM_ExternalPortEnd;	/**< X_BROADCOM_COM_ExternalPortEnd */
    UINT32    internalPort;	/**< InternalPort */
    UINT32    X_BROADCOM_COM_InternalPortEnd;	/**< X_BROADCOM_COM_InternalPortEnd */
    char *    portMappingProtocol;	/**< PortMappingProtocol */
    char *    internalClient;	/**< InternalClient */
    char *    portMappingDescription;	/**< PortMappingDescription */
    char *    X_BROADCOM_COM_AppName;	/**< X_BROADCOM_COM_AppName */
} WanPppConnPortmappingObject;

/*! \brief _WanPppConnPortmappingObject is used internally to represent WanPppConnPortmappingObject */
typedef WanPppConnPortmappingObject _WanPppConnPortmappingObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.X_BROADCOM_COM_PortTriggering.{i}.
 *
 * MDMOID_WAN_PPP_CONN_PORT_TRIGGERING 150
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    name;	/**< Name */
    char *    triggerProtocol;	/**< TriggerProtocol */
    char *    openProtocol;	/**< OpenProtocol */
    UINT32    triggerPortStart;	/**< TriggerPortStart */
    UINT32    triggerPortEnd;	/**< TriggerPortEnd */
    UINT32    openPortStart;	/**< OpenPortStart */
    UINT32    openPortEnd;	/**< OpenPortEnd */
} WanPppConnPortTriggeringObject;

/*! \brief _WanPppConnPortTriggeringObject is used internally to represent WanPppConnPortTriggeringObject */
typedef WanPppConnPortTriggeringObject _WanPppConnPortTriggeringObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_WAN_PPP_CONN_FIREWALL_EXCEPTION 151
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    filterName;	/**< FilterName */
    char *    IPVersion;	/**< IPVersion */
    char *    protocol;	/**< Protocol */
    UINT32    sourcePortStart;	/**< SourcePortStart */
    UINT32    sourcePortEnd;	/**< SourcePortEnd */
    UINT32    destinationPortStart;	/**< DestinationPortStart */
    UINT32    destinationPortEnd;	/**< DestinationPortEnd */
    char *    sourceIPAddress;	/**< SourceIPAddress */
    char *    sourceNetMask;	/**< SourceNetMask */
    char *    destinationIPAddress;	/**< DestinationIPAddress */
    char *    destinationNetMask;	/**< DestinationNetMask */
} WanPppConnFirewallExceptionObject;

/*! \brief _WanPppConnFirewallExceptionObject is used internally to represent WanPppConnFirewallExceptionObject */
typedef WanPppConnFirewallExceptionObject _WanPppConnFirewallExceptionObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.Stats.
 *
 * MDMOID_WAN_PPP_CONN_STATS 152
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< X_BROADCOM_COM_RxDrops */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< X_BROADCOM_COM_TxDrops */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< X_BROADCOM_COM_RxErrors */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< X_BROADCOM_COM_TxErrors */
    UINT32    ethernetBytesSent;	/**< EthernetBytesSent */
    UINT32    ethernetBytesReceived;	/**< EthernetBytesReceived */
    UINT32    ethernetPacketsSent;	/**< EthernetPacketsSent */
    UINT32    ethernetPacketsReceived;	/**< EthernetPacketsReceived */
} WanPppConnStatsObject;

/*! \brief _WanPppConnStatsObject is used internally to represent WanPppConnStatsObject */
typedef WanPppConnStatsObject _WanPppConnStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer3Forwarding.
 *
 * MDMOID_L3_FORWARDING 153
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    defaultConnectionService;	/**< DefaultConnectionService */
    UINT32    forwardNumberOfEntries;	/**< ForwardNumberOfEntries */
    char *    X_BROADCOM_COM_DefaultConnectionServices;	/**< X_BROADCOM_COM_DefaultConnectionServices */
    char *    X_BROADCOM_COM_ActiveDefaultGateway;	/**< X_BROADCOM_COM_ActiveDefaultGateway */
    UINT32    X_ALLIEDTELESIS_COM_SskPid;	/**< X_ALLIEDTELESIS_COM_SskPid */
} L3ForwardingObject;

/*! \brief _L3ForwardingObject is used internally to represent L3ForwardingObject */
typedef L3ForwardingObject _L3ForwardingObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer3Forwarding.Forwarding.{i}.
 *
 * MDMOID_L3_FORWARDING_ENTRY 154
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    UBOOL8    X_ALLIEDTELESIS_COM_StaticRoute;	/**< X_ALLIEDTELESIS_COM_StaticRoute */
    char *    X_ALLIEDTELESIS_COM_RequestingInterface;	/**< X_ALLIEDTELESIS_COM_RequestingInterface */
    char *    type;	/**< Type */
    char *    X_BROADCOM_COM_PolicyRoutingName;	/**< X_BROADCOM_COM_PolicyRoutingName */
    char *    destIPAddress;	/**< DestIPAddress */
    char *    destSubnetMask;	/**< DestSubnetMask */
    char *    sourceIPAddress;	/**< SourceIPAddress */
    char *    sourceSubnetMask;	/**< SourceSubnetMask */
    char *    X_BROADCOM_COM_SourceIfName;	/**< X_BROADCOM_COM_SourceIfName */
#ifdef DMP_QOS_1
    SINT32    forwardingPolicy;	/**< ForwardingPolicy */
#endif
    char *    gatewayIPAddress;	/**< GatewayIPAddress */
    char *    interface;	/**< Interface */
    SINT32    forwardingMetric;	/**< ForwardingMetric */
    UINT32    MTU;	/**< MTU */
} L3ForwardingEntryObject;

/*! \brief _L3ForwardingEntryObject is used internally to represent L3ForwardingEntryObject */
typedef L3ForwardingEntryObject _L3ForwardingEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPv6Layer3Forwarding.
 *
 * MDMOID_I_PV6_L3_FORWARDING 155
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    defaultConnectionService;	/**< DefaultConnectionService */
    UINT32    forwardNumberOfEntries;	/**< ForwardNumberOfEntries */
    UBOOL8    X_ALLIEDTELESIS_COM_Enabled;	/**< X_ALLIEDTELESIS_COM_Enabled */
} IPv6L3ForwardingObject;

/*! \brief _IPv6L3ForwardingObject is used internally to represent IPv6L3ForwardingObject */
typedef IPv6L3ForwardingObject _IPv6L3ForwardingObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPv6Layer3Forwarding.IPv6Forwarding.{i}.
 *
 * MDMOID_I_PV6_L3_FORWARDING_ENTRY 156
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    type;	/**< Type */
    char *    policyRoutingName;	/**< PolicyRoutingName */
    char *    destIPv6Address;	/**< DestIPv6Address */
    char *    sourceIPv6Address;	/**< SourceIPv6Address */
    char *    sourceIfName;	/**< SourceIfName */
    SINT32    forwardingPolicy;	/**< ForwardingPolicy */
    char *    gatewayIPv6Address;	/**< GatewayIPv6Address */
    char *    interface;	/**< Interface */
    SINT32    forwardingMetric;	/**< ForwardingMetric */
    UINT32    MTU;	/**< MTU */
} IPv6L3ForwardingEntryObject;

/*! \brief _IPv6L3ForwardingEntryObject is used internally to represent IPv6L3ForwardingEntryObject */
typedef IPv6L3ForwardingEntryObject _IPv6L3ForwardingEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.
 *
 * MDMOID_SERVICES 157
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} ServicesObject;

/*! \brief _ServicesObject is used internally to represent ServicesObject */
typedef ServicesObject _ServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.
 *
 * MDMOID_STORAGE_SERVICE 158
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    UINT32    physicalMediumNumberOfEntries;	/**< PhysicalMediumNumberOfEntries */
    UINT32    logicalVolumeNumberOfEntries;	/**< LogicalVolumeNumberOfEntries */
    UINT32    userAccountNumberOfEntries;	/**< UserAccountNumberOfEntries */
} StorageServiceObject;

/*! \brief _StorageServiceObject is used internally to represent StorageServiceObject */
typedef StorageServiceObject _StorageServiceObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.UserAccount.{i}.
 *
 * MDMOID_USER_ACCOUNT 159
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    username;	/**< Username */
    char *    password;	/**< Password */
    char *    X_BROADCOM_volumeName;	/**< X_BROADCOM_volumeName */
} UserAccountObject;

/*! \brief _UserAccountObject is used internally to represent UserAccountObject */
typedef UserAccountObject _UserAccountObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.Capabilites.
 *
 * MDMOID_CAPABILITES 160
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    FTPCapable;	/**< FTPCapable */
    UBOOL8    SFTPCapable;	/**< SFTPCapable */
    UBOOL8    HTTPCapable;	/**< HTTPCapable */
    UBOOL8    HTTPSCapable;	/**< HTTPSCapable */
    UBOOL8    HTTPWritable;	/**< HTTPWritable */
    char *    supportedNetworkProtocols;	/**< SupportedNetworkProtocols */
    char *    supportedFileSystemTypes;	/**< SupportedFileSystemTypes */
    UBOOL8    volumeEncryptionCapable;	/**< VolumeEncryptionCapable */
} CapabilitesObject;

/*! \brief _CapabilitesObject is used internally to represent CapabilitesObject */
typedef CapabilitesObject _CapabilitesObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.NetInfo.
 *
 * MDMOID_NETWORK_INFO 161
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    hostName;	/**< HostName */
    char *    domainName;	/**< DomainName */
} NetworkInfoObject;

/*! \brief _NetworkInfoObject is used internally to represent NetworkInfoObject */
typedef NetworkInfoObject _NetworkInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.NetworkServer.
 *
 * MDMOID_NETWORK_SERVER 162
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    AFPEnable;	/**< AFPEnable */
    UBOOL8    NFSEnable;	/**< NFSEnable */
    UBOOL8    SMBEnable;	/**< SMBEnable */
    UBOOL8    networkProtocolAuthReq;	/**< NetworkProtocolAuthReq */
} NetworkServerObject;

/*! \brief _NetworkServerObject is used internally to represent NetworkServerObject */
typedef NetworkServerObject _NetworkServerObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.PhysicalMedium.{i}.
 *
 * MDMOID_PHYSICAL_MEDIUM 163
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    char *    connectionType;	/**< ConnectionType */
    UBOOL8    removable;	/**< Removable */
    UINT32    capacity;	/**< Capacity */
    char *    status;	/**< Status */
} PhysicalMediumObject;

/*! \brief _PhysicalMediumObject is used internally to represent PhysicalMediumObject */
typedef PhysicalMediumObject _PhysicalMediumObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.LogicalVolume.{i}.
 *
 * MDMOID_LOGICAL_VOLUME 164
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    char *    status;	/**< Status */
    UBOOL8    enable;	/**< Enable */
    char *    physicalReference;	/**< PhysicalReference */
    char *    fileSystem;	/**< FileSystem */
    UINT32    capacity;	/**< Capacity */
    UINT32    usedSpace;	/**< UsedSpace */
    UBOOL8    encrypted;	/**< Encrypted */
    UINT32    folderNumberOfEntries;	/**< FolderNumberOfEntries */
} LogicalVolumeObject;

/*! \brief _LogicalVolumeObject is used internally to represent LogicalVolumeObject */
typedef LogicalVolumeObject _LogicalVolumeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.LogicalVolume.{i}.Folder.{i}.
 *
 * MDMOID_FOLDER 165
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    UBOOL8    enable;	/**< Enable */
    UINT32    userAccountAccess;	/**< UserAccountAccess */
} FolderObject;

/*! \brief _FolderObject is used internally to represent FolderObject */
typedef FolderObject _FolderObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.
 *
 * MDMOID_VOICE 166
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    voiceProfileNumberOfEntries;	/**< VoiceProfileNumberOfEntries */
} VoiceObject;

/*! \brief _VoiceObject is used internally to represent VoiceObject */
typedef VoiceObject _VoiceObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_ALLIEDTELESIS_COM_Trace.
 *
 * MDMOID_VOICE_TRACE 167
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    level;	/**< Level */
    char *    display;	/**< Display */
    char *    verb;	/**< Verb */
} VoiceTraceObject;

/*! \brief _VoiceTraceObject is used internally to represent VoiceTraceObject */
typedef VoiceTraceObject _VoiceTraceObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_ALLIEDTELESIS_COM_Trace.Enable.
 *
 * MDMOID_VOICE_TRACE_ENABLE 168
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    aep;	/**< Aep */
    UBOOL8    ca;	/**< Ca */
    UBOOL8    config;	/**< Config */
    UBOOL8    drv;	/**< Drv */
    UBOOL8    drvTones;	/**< DrvTones */
    UBOOL8    eps;	/**< Eps */
    UBOOL8    gwa;	/**< Gwa */
    UBOOL8    mep;	/**< Mep */
    UBOOL8    mgcp;	/**< Mgcp */
    UBOOL8    mgcpEvent;	/**< MgcpEvent */
    UBOOL8    mgcpMsg;	/**< MgcpMsg */
    UBOOL8    sdp;	/**< Sdp */
    UBOOL8    sep;	/**< Sep */
    UBOOL8    sigcon;	/**< Sigcon */
    UBOOL8    sip;	/**< Sip */
    UBOOL8    sipEvent;	/**< SipEvent */
    UBOOL8    sipMsg;	/**< SipMsg */
    UBOOL8    ssl;	/**< Ssl */
    UBOOL8    vrg;	/**< Vrg */
} VoiceTraceEnableObject;

/*! \brief _VoiceTraceEnableObject is used internally to represent VoiceTraceEnableObject */
typedef VoiceTraceEnableObject _VoiceTraceEnableObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.
 *
 * MDMOID_VOICE_CAP 169
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    maxProfileCount;	/**< MaxProfileCount */
    UINT32    maxLineCount;	/**< MaxLineCount */
    UINT32    maxSessionsPerLine;	/**< MaxSessionsPerLine */
    UINT32    maxSessionCount;	/**< MaxSessionCount */
    char *    signalingProtocols;	/**< SignalingProtocols */
    char *    regions;	/**< Regions */
    UBOOL8    RTCP;	/**< RTCP */
    UBOOL8    SRTP;	/**< SRTP */
    UBOOL8    RTPRedundancy;	/**< RTPRedundancy */
    UBOOL8    DSCPCoupled;	/**< DSCPCoupled */
    UBOOL8    ethernetTaggingCoupled;	/**< EthernetTaggingCoupled */
    UBOOL8    PSTNSoftSwitchOver;	/**< PSTNSoftSwitchOver */
    UBOOL8    faxT38;	/**< FaxT38 */
    UBOOL8    faxPassThrough;	/**< FaxPassThrough */
    UBOOL8    modemPassThrough;	/**< ModemPassThrough */
    UBOOL8    toneGeneration;	/**< ToneGeneration */
    UBOOL8    ringGeneration;	/**< RingGeneration */
    UBOOL8    digitMap;	/**< DigitMap */
    UBOOL8    numberingPlan;	/**< NumberingPlan */
    UBOOL8    buttonMap;	/**< ButtonMap */
    UBOOL8    voicePortTests;	/**< VoicePortTests */
    SINT32    X_ALLIEDTELESIS_COM_MaxCodecCount;	/**< X_ALLIEDTELESIS_COM_MaxCodecCount */
} VoiceCapObject;

/*! \brief _VoiceCapObject is used internally to represent VoiceCapObject */
typedef VoiceCapObject _VoiceCapObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.SIP.
 *
 * MDMOID_VOICE_CAP_SIP 170
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    role;	/**< Role */
    char *    extensions;	/**< Extensions */
    char *    transports;	/**< Transports */
    char *    URISchemes;	/**< URISchemes */
    UBOOL8    eventSubscription;	/**< EventSubscription */
    UBOOL8    responseMap;	/**< ResponseMap */
} VoiceCapSipObject;

/*! \brief _VoiceCapSipObject is used internally to represent VoiceCapSipObject */
typedef VoiceCapSipObject _VoiceCapSipObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.MGCP.
 *
 * MDMOID_VOICE_CAP_MGCP 171
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    extensions;	/**< Extensions */
} VoiceCapMgcpObject;

/*! \brief _VoiceCapMgcpObject is used internally to represent VoiceCapMgcpObject */
typedef VoiceCapMgcpObject _VoiceCapMgcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.Codecs.{i}.
 *
 * MDMOID_VOICE_CAP_CODECS 172
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    entryID;	/**< EntryID */
    char *    codec;	/**< Codec */
    UINT32    bitRate;	/**< BitRate */
    char *    packetizationPeriod;	/**< PacketizationPeriod */
    UBOOL8    silenceSuppression;	/**< SilenceSuppression */
} VoiceCapCodecsObject;

/*! \brief _VoiceCapCodecsObject is used internally to represent VoiceCapCodecsObject */
typedef VoiceCapCodecsObject _VoiceCapCodecsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.
 *
 * MDMOID_VOICE_PROF 173
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    enable;	/**< Enable */
    UBOOL8    reset;	/**< Reset */
    UINT32    numberOfLines;	/**< NumberOfLines */
    char *    name;	/**< Name */
    char *    signalingProtocol;	/**< SignalingProtocol */
    UINT32    maxSessions;	/**< MaxSessions */
    char *    DTMFMethod;	/**< DTMFMethod */
    char *    region;	/**< Region */
    char *    digitMap;	/**< DigitMap */
    UBOOL8    digitMapEnable;	/**< DigitMapEnable */
    char *    faxPassThrough;	/**< FaxPassThrough */
    char *    modemPassThrough;	/**< ModemPassThrough */
    UBOOL8    X_ALLIEDTELESIS_COM_NamedTelephoneEventEnable;	/**< X_ALLIEDTELESIS_COM_NamedTelephoneEventEnable */
} VoiceProfObject;

/*! \brief _VoiceProfObject is used internally to represent VoiceProfObject */
typedef VoiceProfObject _VoiceProfObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.
 *
 * MDMOID_VOICE_PROF_SIP 174
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    proxyServer;	/**< ProxyServer */
    UINT32    proxyServerPort;	/**< ProxyServerPort */
    char *    registrarServer;	/**< RegistrarServer */
    UINT32    registrarServerPort;	/**< RegistrarServerPort */
    char *    userAgentDomain;	/**< UserAgentDomain */
    UINT32    userAgentPort;	/**< UserAgentPort */
    UINT32    registrationPeriod;	/**< RegistrationPeriod */
    UINT32    timerT1;	/**< TimerT1 */
    UINT32    timerT2;	/**< TimerT2 */
    UINT32    timerB;	/**< TimerB */
    UINT32    timerF;	/**< TimerF */
    UINT32    registerRetryInterval;	/**< RegisterRetryInterval */
    UINT32    DSCPMark;	/**< DSCPMark */
    UINT32    SIPEventSubscribeNumberOfElements;	/**< SIPEventSubscribeNumberOfElements */
    char *    X_ALLIEDTELESIS_COM_IpInterface;	/**< X_ALLIEDTELESIS_COM_IpInterface */
    UBOOL8    X_ALLIEDTELESIS_COM_IntCallControl;	/**< X_ALLIEDTELESIS_COM_IntCallControl */
    UBOOL8    X_ALLIEDTELESIS_COM_MWISubscriptionService;	/**< X_ALLIEDTELESIS_COM_MWISubscriptionService */
    char *    X_ALLIEDTELESIS_COM_MWISubscriptionMethod;	/**< X_ALLIEDTELESIS_COM_MWISubscriptionMethod */
    UBOOL8    X_ALLIEDTELESIS_COM_Auth_WWW;	/**< X_ALLIEDTELESIS_COM_Auth_WWW */
    UBOOL8    X_ALLIEDTELESIS_COM_Auth_Proxy;	/**< X_ALLIEDTELESIS_COM_Auth_Proxy */
    char *    X_ALLIEDTELESIS_COM_ProxyServer2;	/**< X_ALLIEDTELESIS_COM_ProxyServer2 */
    UINT32    X_ALLIEDTELESIS_COM_ProxyServerPort2;	/**< X_ALLIEDTELESIS_COM_ProxyServerPort2 */
    char *    X_ALLIEDTELESIS_COM_RegistrarServer2;	/**< X_ALLIEDTELESIS_COM_RegistrarServer2 */
    UINT32    X_ALLIEDTELESIS_COM_RegistrarServerPort2;	/**< X_ALLIEDTELESIS_COM_RegistrarServerPort2 */
    UINT32    X_ALLIEDTELESIS_COM_ActiveRegistrarServer;	/**< X_ALLIEDTELESIS_COM_ActiveRegistrarServer */
    UINT32    X_ALLIEDTELESIS_COM_ActiveProxyServer;	/**< X_ALLIEDTELESIS_COM_ActiveProxyServer */
    UBOOL8    X_ALLIEDTELESIS_COM_100RelSupport;	/**< X_ALLIEDTELESIS_COM_100RelSupport */
} VoiceProfSipObject;

/*! \brief _VoiceProfSipObject is used internally to represent VoiceProfSipObject */
typedef VoiceProfSipObject _VoiceProfSipObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.X_ALLIEDTELESIS_COM_Fdb.
 *
 * MDMOID_VOICE_PROF_SIP_FDB 175
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    numberOfEntries;	/**< NumberOfEntries */
} VoiceProfSipFdbObject;

/*! \brief _VoiceProfSipFdbObject is used internally to represent VoiceProfSipFdbObject */
typedef VoiceProfSipFdbObject _VoiceProfSipFdbObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.X_ALLIEDTELESIS_COM_Fdb.List.{i}.
 *
 * MDMOID_VOICE_PROF_SIP_FDB_LIST 176
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    entryId;	/**< EntryId */
    char *    digitMap;	/**< DigitMap */
    char *    domain;	/**< Domain */
    char *    contact;	/**< Contact */
    UBOOL8    proxy;	/**< Proxy */
} VoiceProfSipFdbListObject;

/*! \brief _VoiceProfSipFdbListObject is used internally to represent VoiceProfSipFdbListObject */
typedef VoiceProfSipFdbListObject _VoiceProfSipFdbListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.X_ALLIEDTELESIS_COM_AlertInfoMap.
 *
 * MDMOID_VOICE_PROF_SIP_ALERT_INFO_MAP 177
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    numberOfPreconfiguredEntries;	/**< NumberOfPreconfiguredEntries */
    SINT32    numberOfEntries;	/**< NumberOfEntries */
} VoiceProfSipAlertInfoMapObject;

/*! \brief _VoiceProfSipAlertInfoMapObject is used internally to represent VoiceProfSipAlertInfoMapObject */
typedef VoiceProfSipAlertInfoMapObject _VoiceProfSipAlertInfoMapObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.X_ALLIEDTELESIS_COM_AlertInfoMap.List.{i}.
 *
 * MDMOID_VOICE_PROF_SIP_ALERT_INFO_MAP_LIST 178
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    pattern;	/**< Pattern */
    char *    alertText;	/**< AlertText */
} VoiceProfSipAlertInfoMapListObject;

/*! \brief _VoiceProfSipAlertInfoMapListObject is used internally to represent VoiceProfSipAlertInfoMapListObject */
typedef VoiceProfSipAlertInfoMapListObject _VoiceProfSipAlertInfoMapListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.MGCP.
 *
 * MDMOID_VOICE_PROF_MGCP 179
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    callAgent1;	/**< CallAgent1 */
    UINT32    callAgentPort1;	/**< CallAgentPort1 */
    char *    callAgent2;	/**< CallAgent2 */
    UINT32    callAgentPort2;	/**< CallAgentPort2 */
    UINT32    retranIntervalTimer;	/**< RetranIntervalTimer */
    UINT32    maxRetranCount;	/**< MaxRetranCount */
    char *    registerMode;	/**< RegisterMode */
    UINT32    localPort;	/**< LocalPort */
    char *    domain;	/**< Domain */
    UINT32    DSCPMark;	/**< DSCPMark */
    UBOOL8    allowPiggybackEvents;	/**< AllowPiggybackEvents */
    UBOOL8    sendRSIPImmediately;	/**< SendRSIPImmediately */
    char *    X_ALLIEDTELESIS_COM_IpInterface;	/**< X_ALLIEDTELESIS_COM_IpInterface */
    char *    X_ALLIEDTELESIS_COM_HeartBeatMode;	/**< X_ALLIEDTELESIS_COM_HeartBeatMode */
    char *    X_ALLIEDTELESIS_COM_HeartBeatMasterPort;	/**< X_ALLIEDTELESIS_COM_HeartBeatMasterPort */
    UINT32    X_ALLIEDTELESIS_COM_HeartBeatRefreshTime;	/**< X_ALLIEDTELESIS_COM_HeartBeatRefreshTime */
    UBOOL8    X_ALLIEDTELESIS_COM_LcsEnable;	/**< X_ALLIEDTELESIS_COM_LcsEnable */
    UINT32    X_ALLIEDTELESIS_COM_LcsChangeStateLength;	/**< X_ALLIEDTELESIS_COM_LcsChangeStateLength */
    char *    X_ALLIEDTELESIS_COM_NteMode;	/**< X_ALLIEDTELESIS_COM_NteMode */
    UBOOL8    X_ALLIEDTELESIS_COM_Persistent_OnHook;	/**< X_ALLIEDTELESIS_COM_Persistent_OnHook */
    UBOOL8    X_ALLIEDTELESIS_COM_Persistent_OffHook;	/**< X_ALLIEDTELESIS_COM_Persistent_OffHook */
    UBOOL8    X_ALLIEDTELESIS_COM_Persistent_HookFlash;	/**< X_ALLIEDTELESIS_COM_Persistent_HookFlash */
    UBOOL8    X_ALLIEDTELESIS_COM_Persistent_Digits;	/**< X_ALLIEDTELESIS_COM_Persistent_Digits */
} VoiceProfMgcpObject;

/*! \brief _VoiceProfMgcpObject is used internally to represent VoiceProfMgcpObject */
typedef VoiceProfMgcpObject _VoiceProfMgcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.RTP.
 *
 * MDMOID_VOICE_PROF_RTP 180
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    localPortMin;	/**< LocalPortMin */
    UINT32    localPortMax;	/**< LocalPortMax */
    UINT32    DSCPMark;	/**< DSCPMark */
    UINT32    telephoneEventPayloadType;	/**< TelephoneEventPayloadType */
    UINT32    X_ALLIEDTELESIS_COM_SessionTimeOutLimit;	/**< X_ALLIEDTELESIS_COM_SessionTimeOutLimit */
    UBOOL8    X_ALLIEDTELESIS_COM_DiscardRtpUnknownRemote;	/**< X_ALLIEDTELESIS_COM_DiscardRtpUnknownRemote */
    UBOOL8    X_ALLIEDTELESIS_COM_DiscardRtpUnknownSrc;	/**< X_ALLIEDTELESIS_COM_DiscardRtpUnknownSrc */
} VoiceProfRtpObject;

/*! \brief _VoiceProfRtpObject is used internally to represent VoiceProfRtpObject */
typedef VoiceProfRtpObject _VoiceProfRtpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.RTP.RTCP.
 *
 * MDMOID_VOICE_PROF_RTP_RTCP 181
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
} VoiceProfRtpRtcpObject;

/*! \brief _VoiceProfRtpRtcpObject is used internally to represent VoiceProfRtpRtcpObject */
typedef VoiceProfRtpRtcpObject _VoiceProfRtpRtcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.NumberingPlan.
 *
 * MDMOID_VOICE_PROF_NUMBERING_PLAN 182
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    prefixInfoMaxEntries;	/**< PrefixInfoMaxEntries */
    UINT32    prefixInfoNumberOfEntries;	/**< PrefixInfoNumberOfEntries */
} VoiceProfNumberingPlanObject;

/*! \brief _VoiceProfNumberingPlanObject is used internally to represent VoiceProfNumberingPlanObject */
typedef VoiceProfNumberingPlanObject _VoiceProfNumberingPlanObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.NumberingPlan.PrefixInfo.{i}.
 *
 * MDMOID_VOICE_PROF_NUMBERING_PLAN_PREFIX_INFO 183
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    prefixRange;	/**< PrefixRange */
    char *    facilityAction;	/**< FacilityAction */
} VoiceProfNumberingPlanPrefixInfoObject;

/*! \brief _VoiceProfNumberingPlanPrefixInfoObject is used internally to represent VoiceProfNumberingPlanPrefixInfoObject */
typedef VoiceProfNumberingPlanPrefixInfoObject _VoiceProfNumberingPlanPrefixInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.NumberingPlan.PrefixInfo.{i}.X_ALLIEDTELESIS_COM_Prefix.{i}.
 *
 * MDMOID_VOICE_PROF_NUMBERING_PLAN_PREFIX_INFO_PREFIX 184
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    actionString;	/**< ActionString */
    UINT32    rule;	/**< Rule */
    UINT32    precedence;	/**< Precedence */
    char *    actionMode;	/**< ActionMode */
} VoiceProfNumberingPlanPrefixInfoPrefixObject;

/*! \brief _VoiceProfNumberingPlanPrefixInfoPrefixObject is used internally to represent VoiceProfNumberingPlanPrefixInfoPrefixObject */
typedef VoiceProfNumberingPlanPrefixInfoPrefixObject _VoiceProfNumberingPlanPrefixInfoPrefixObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.FaxT38.
 *
 * MDMOID_VOICE_PROF_FAX_T38 185
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
} VoiceProfFaxT38Object;

/*! \brief _VoiceProfFaxT38Object is used internally to represent VoiceProfFaxT38Object */
typedef VoiceProfFaxT38Object _VoiceProfFaxT38Object;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.
 *
 * MDMOID_VOICE_LINE 186
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    callState;	/**< CallState */
#ifdef DMP_TAENDPOINT_1
    char *    phyReferenceList;	/**< PhyReferenceList */
#endif
    char *    X_ALLIEDTELESIS_COM_DisconnectProcedure;	/**< X_ALLIEDTELESIS_COM_DisconnectProcedure */
} VoiceLineObject;

/*! \brief _VoiceLineObject is used internally to represent VoiceLineObject */
typedef VoiceLineObject _VoiceLineObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.SIP.
 *
 * MDMOID_VOICE_LINE_SIP 187
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    authUserName;	/**< AuthUserName */
    char *    authPassword;	/**< AuthPassword */
    char *    URI;	/**< URI */
    UINT32    SIPEventSubscribeNumberOfElements;	/**< SIPEventSubscribeNumberOfElements */
    char *    X_ALLIEDTELESIS_COM_RegUsername;	/**< X_ALLIEDTELESIS_COM_RegUsername */
} VoiceLineSipObject;

/*! \brief _VoiceLineSipObject is used internally to represent VoiceLineSipObject */
typedef VoiceLineSipObject _VoiceLineSipObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.MGCP.
 *
 * MDMOID_VOICE_LINE_MGCP 188
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    lineName;	/**< LineName */
    char *    X_ALLIEDTELESIS_COM_ActiveCallAgent;	/**< X_ALLIEDTELESIS_COM_ActiveCallAgent */
} VoiceLineMgcpObject;

/*! \brief _VoiceLineMgcpObject is used internally to represent VoiceLineMgcpObject */
typedef VoiceLineMgcpObject _VoiceLineMgcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.CallingFeatures.
 *
 * MDMOID_VOICE_LINE_CALLING_FEATURES 189
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    callerIDEnable;	/**< CallerIDEnable */
    UBOOL8    callWaitingEnable;	/**< CallWaitingEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_CallWaitingActive;	/**< X_ALLIEDTELESIS_COM_CallWaitingActive */
    UINT32    maxSessions;	/**< MaxSessions */
    UBOOL8    callForwardUnconditionalEnable;	/**< CallForwardUnconditionalEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_CallForwardUnconditionalActive;	/**< X_ALLIEDTELESIS_COM_CallForwardUnconditionalActive */
    char *    callForwardUnconditionalNumber;	/**< CallForwardUnconditionalNumber */
    UBOOL8    callForwardOnBusyEnable;	/**< CallForwardOnBusyEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_CallForwardOnBusyActive;	/**< X_ALLIEDTELESIS_COM_CallForwardOnBusyActive */
    char *    callForwardOnBusyNumber;	/**< CallForwardOnBusyNumber */
    UBOOL8    callForwardOnNoAnswerEnable;	/**< CallForwardOnNoAnswerEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_CallForwardOnNoAnswerActive;	/**< X_ALLIEDTELESIS_COM_CallForwardOnNoAnswerActive */
    char *    callForwardOnNoAnswerNumber;	/**< CallForwardOnNoAnswerNumber */
    UINT32    callForwardOnNoAnswerRingCount;	/**< CallForwardOnNoAnswerRingCount */
    UBOOL8    MWIEnable;	/**< MWIEnable */
    UBOOL8    messageWaiting;	/**< MessageWaiting */
    UBOOL8    X_ALLIEDTELESIS_COM_CallWaitCallerIDEnable;	/**< X_ALLIEDTELESIS_COM_CallWaitCallerIDEnable */
    char *    X_ALLIEDTELESIS_COM_CallerIDStandard;	/**< X_ALLIEDTELESIS_COM_CallerIDStandard */
    char *    X_ALLIEDTELESIS_COM_CallerIDMechanism;	/**< X_ALLIEDTELESIS_COM_CallerIDMechanism */
    char *    X_ALLIEDTELESIS_COM_CallerIDTiming;	/**< X_ALLIEDTELESIS_COM_CallerIDTiming */
    char *    X_ALLIEDTELESIS_COM_CallerIDSignal;	/**< X_ALLIEDTELESIS_COM_CallerIDSignal */
    UBOOL8    X_ALLIEDTELESIS_COM_CallerIDRestrictionEnable;	/**< X_ALLIEDTELESIS_COM_CallerIDRestrictionEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_CallerIDRestrictionActive;	/**< X_ALLIEDTELESIS_COM_CallerIDRestrictionActive */
    char *    X_ALLIEDTELESIS_COM_CallerIDRestrictionDefault;	/**< X_ALLIEDTELESIS_COM_CallerIDRestrictionDefault */
    UBOOL8    X_ALLIEDTELESIS_COM_CallHoldEnable;	/**< X_ALLIEDTELESIS_COM_CallHoldEnable */
    char *    X_ALLIEDTELESIS_COM_WarmLineEnable;	/**< X_ALLIEDTELESIS_COM_WarmLineEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_WMLEnable;	/**< X_ALLIEDTELESIS_COM_WMLEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_WarmLineActive;	/**< X_ALLIEDTELESIS_COM_WarmLineActive */
    char *    X_ALLIEDTELESIS_COM_WarmLineNumber;	/**< X_ALLIEDTELESIS_COM_WarmLineNumber */
    UINT32    X_ALLIEDTELESIS_COM_WarmLineTimeout;	/**< X_ALLIEDTELESIS_COM_WarmLineTimeout */
    UBOOL8    X_ALLIEDTELESIS_COM_CallForwardExternalEnable;	/**< X_ALLIEDTELESIS_COM_CallForwardExternalEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_SupSvcPrefixEnable;	/**< X_ALLIEDTELESIS_COM_SupSvcPrefixEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_ACTransferEnable;	/**< X_ALLIEDTELESIS_COM_ACTransferEnable */
    UBOOL8    X_ALLIEDTELESIS_COM_BCTransferEnable;	/**< X_ALLIEDTELESIS_COM_BCTransferEnable */
    UINT32    X_ALLIEDTELESIS_COM_PfxRuleIdent;	/**< X_ALLIEDTELESIS_COM_PfxRuleIdent */
} VoiceLineCallingFeaturesObject;

/*! \brief _VoiceLineCallingFeaturesObject is used internally to represent VoiceLineCallingFeaturesObject */
typedef VoiceLineCallingFeaturesObject _VoiceLineCallingFeaturesObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.VoiceProcessing.
 *
 * MDMOID_VOICE_LINE_PROCESSING 190
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    transmitGain;	/**< TransmitGain */
    SINT32    receiveGain;	/**< ReceiveGain */
    UBOOL8    echoCancellationEnable;	/**< EchoCancellationEnable */
    UBOOL8    echoCancellationInUse;	/**< EchoCancellationInUse */
    UINT32    echoCancellationTail;	/**< EchoCancellationTail */
    char *    X_ALLIEDTELESIS_COM_InterdigitTimerStd;	/**< X_ALLIEDTELESIS_COM_InterdigitTimerStd */
    char *    X_ALLIEDTELESIS_COM_FirstDigitTimerStd;	/**< X_ALLIEDTELESIS_COM_FirstDigitTimerStd */
    UINT32    X_ALLIEDTELESIS_COM_OffHookTime;	/**< X_ALLIEDTELESIS_COM_OffHookTime */
    UINT32    X_ALLIEDTELESIS_COM_FlashHookTime;	/**< X_ALLIEDTELESIS_COM_FlashHookTime */
    UINT32    X_ALLIEDTELESIS_COM_OnHookTime;	/**< X_ALLIEDTELESIS_COM_OnHookTime */
    UINT32    X_ALLIEDTELESIS_COM_JitterDelay;	/**< X_ALLIEDTELESIS_COM_JitterDelay */
    char *    X_ALLIEDTELESIS_COM_JitterMode;	/**< X_ALLIEDTELESIS_COM_JitterMode */
    UINT32    X_ALLIEDTELESIS_COM_AlertingTimeOut;	/**< X_ALLIEDTELESIS_COM_AlertingTimeOut */
    char *    X_ALLIEDTELESIS_COM_DialMode;	/**< X_ALLIEDTELESIS_COM_DialMode */
} VoiceLineProcessingObject;

/*! \brief _VoiceLineProcessingObject is used internally to represent VoiceLineProcessingObject */
typedef VoiceLineProcessingObject _VoiceLineProcessingObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Codec.
 *
 * MDMOID_VOICE_LINE_CODEC 191
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    transmitCodec;	/**< TransmitCodec */
    char *    receiveCodec;	/**< ReceiveCodec */
    UINT32    transmitBitRate;	/**< TransmitBitRate */
    UINT32    receiveBitRate;	/**< ReceiveBitRate */
    UBOOL8    transmitSilenceSuppression;	/**< TransmitSilenceSuppression */
    UBOOL8    receiveSilenceSuppression;	/**< ReceiveSilenceSuppression */
    UINT32    transmitPacketizationPeriod;	/**< TransmitPacketizationPeriod */
    SINT32    X_ALLIEDTELESIS_COM_CodecCount;	/**< X_ALLIEDTELESIS_COM_CodecCount */
} VoiceLineCodecObject;

/*! \brief _VoiceLineCodecObject is used internally to represent VoiceLineCodecObject */
typedef VoiceLineCodecObject _VoiceLineCodecObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Codec.List.{i}.
 *
 * MDMOID_VOICE_LINE_CODEC_LIST 192
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    entryID;	/**< EntryID */
    char *    codec;	/**< Codec */
    UINT32    bitRate;	/**< BitRate */
    char *    packetizationPeriod;	/**< PacketizationPeriod */
    UBOOL8    silenceSuppression;	/**< SilenceSuppression */
    UBOOL8    enable;	/**< Enable */
    UINT32    priority;	/**< Priority */
} VoiceLineCodecListObject;

/*! \brief _VoiceLineCodecListObject is used internally to represent VoiceLineCodecListObject */
typedef VoiceLineCodecListObject _VoiceLineCodecListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Session.{i}.
 *
 * MDMOID_VOICE_LINE_SESSION 193
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    sessionStartTime;	/**< SessionStartTime */
    UINT32    sessionDuration;	/**< SessionDuration */
    char *    farEndIPAddress;	/**< FarEndIPAddress */
    UINT32    farEndUDPPort;	/**< FarEndUDPPort */
    UINT32    localUDPPort;	/**< LocalUDPPort */
} VoiceLineSessionObject;

/*! \brief _VoiceLineSessionObject is used internally to represent VoiceLineSessionObject */
typedef VoiceLineSessionObject _VoiceLineSessionObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Stats.
 *
 * MDMOID_VOICE_LINE_STATS 194
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    resetStatistics;	/**< ResetStatistics */
    UINT32    packetsSent;	/**< PacketsSent */
    UINT32    packetsReceived;	/**< PacketsReceived */
    UINT32    bytesSent;	/**< BytesSent */
    UINT32    bytesReceived;	/**< BytesReceived */
    UINT32    packetsLost;	/**< PacketsLost */
    UINT32    overruns;	/**< Overruns */
    UINT32    underruns;	/**< Underruns */
    UINT32    incomingCallsReceived;	/**< IncomingCallsReceived */
    UINT32    incomingCallsAnswered;	/**< IncomingCallsAnswered */
    UINT32    incomingCallsConnected;	/**< IncomingCallsConnected */
    UINT32    incomingCallsFailed;	/**< IncomingCallsFailed */
    UINT32    outgoingCallsAttempted;	/**< OutgoingCallsAttempted */
    UINT32    outgoingCallsAnswered;	/**< OutgoingCallsAnswered */
    UINT32    outgoingCallsConnected;	/**< OutgoingCallsConnected */
    UINT32    outgoingCallsFailed;	/**< OutgoingCallsFailed */
    UINT32    callsDropped;	/**< CallsDropped */
    UINT32    totalCallTime;	/**< TotalCallTime */
} VoiceLineStatsObject;

/*! \brief _VoiceLineStatsObject is used internally to represent VoiceLineStatsObject */
typedef VoiceLineStatsObject _VoiceLineStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.PhyInterface.{i}.
 *
 * MDMOID_VOICE_PHY_INTF 195
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    phyPort;	/**< PhyPort */
    UINT32    interfaceID;	/**< InterfaceID */
    char *    description;	/**< Description */
} VoicePhyIntfObject;

/*! \brief _VoicePhyIntfObject is used internally to represent VoicePhyIntfObject */
typedef VoicePhyIntfObject _VoicePhyIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.PhyInterface.{i}.Tests.
 *
 * MDMOID_VOICE_PHY_INTF_TESTS 196
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    testState;	/**< TestState */
    char *    testSelector;	/**< TestSelector */
    UBOOL8    phoneConnectivity;	/**< PhoneConnectivity */
    UBOOL8    X_ALLIEDTELESIS_COM_TestForced;	/**< X_ALLIEDTELESIS_COM_TestForced */
} VoicePhyIntfTestsObject;

/*! \brief _VoicePhyIntfTestsObject is used internally to represent VoicePhyIntfTestsObject */
typedef VoicePhyIntfTestsObject _VoicePhyIntfTestsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.PhyInterface.{i}.Tests.X_ALLIEDTELESIS_COM_PhoneMlt.
 *
 * MDMOID_VOICE_PHY_INTF_TESTS_PHONE_MLT 197
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    hazVoltsACTip;	/**< HazVoltsACTip */
    char *    hazVoltsACTipRes;	/**< HazVoltsACTipRes */
    SINT32    hazVoltsDCTip;	/**< HazVoltsDCTip */
    char *    hazVoltsDCTipRes;	/**< HazVoltsDCTipRes */
    SINT32    hazVoltsACRing;	/**< HazVoltsACRing */
    char *    hazVoltsACRingRes;	/**< HazVoltsACRingRes */
    SINT32    hazVoltsDCRing;	/**< HazVoltsDCRing */
    char *    hazVoltsDCRingRes;	/**< HazVoltsDCRingRes */
    SINT32    hazVoltsACTipRing;	/**< HazVoltsACTipRing */
    char *    hazVoltsACTipRingRes;	/**< HazVoltsACTipRingRes */
    SINT32    hazVoltsDCTipRing;	/**< HazVoltsDCTipRing */
    char *    hazVoltsDCTipRingRes;	/**< HazVoltsDCTipRingRes */
    SINT32    FEMFVoltsACTip;	/**< FEMFVoltsACTip */
    char *    FEMFVoltsACTipRes;	/**< FEMFVoltsACTipRes */
    SINT32    FEMFVoltsDCTip;	/**< FEMFVoltsDCTip */
    char *    FEMFVoltsDCTipRes;	/**< FEMFVoltsDCTipRes */
    SINT32    FEMFVoltsACRing;	/**< FEMFVoltsACRing */
    char *    FEMFVoltsACRingRes;	/**< FEMFVoltsACRingRes */
    SINT32    FEMFVoltsDCRing;	/**< FEMFVoltsDCRing */
    char *    FEMFVoltsDCRingRes;	/**< FEMFVoltsDCRingRes */
    SINT32    FEMFVoltsACTipRing;	/**< FEMFVoltsACTipRing */
    char *    FEMFVoltsACTipRingRes;	/**< FEMFVoltsACTipRingRes */
    SINT32    FEMFVoltsDCTipRing;	/**< FEMFVoltsDCTipRing */
    char *    FEMFVoltsDCTipRingRes;	/**< FEMFVoltsDCTipRingRes */
    SINT32    tipGndImpedance;	/**< TipGndImpedance */
    char *    tipGndImpedanceRes;	/**< TipGndImpedanceRes */
    SINT32    ringGndImpedance;	/**< RingGndImpedance */
    char *    ringGndImpedanceRes;	/**< RingGndImpedanceRes */
    SINT32    tipRingImpedance;	/**< TipRingImpedance */
    char *    tipRingImpedanceRes;	/**< TipRingImpedanceRes */
    SINT32    REN;	/**< REN */
    char *    RENRes;	/**< RENRes */
    UBOOL8    isOnHook;	/**< IsOnHook */
    char *    isOnHookRes;	/**< IsOnHookRes */
} VoicePhyIntfTestsPhoneMltObject;

/*! \brief _VoicePhyIntfTestsPhoneMltObject is used internally to represent VoicePhyIntfTestsPhoneMltObject */
typedef VoicePhyIntfTestsPhoneMltObject _VoicePhyIntfTestsPhoneMltObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SnmpCfg.
 *
 * MDMOID_SNMP_CFG 198
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    status;	/**< Status */
    char *    ROCommunity;	/**< ROCommunity */
    char *    RWCommunity;	/**< RWCommunity */
    char *    sysName;	/**< SysName */
    char *    sysLocation;	/**< SysLocation */
    char *    sysContact;	/**< SysContact */
    char *    trapIPAddress;	/**< TrapIPAddress */
    UINT32    X_ALLIEDTELESIS_COM_SnmpStartupDelay;	/**< X_ALLIEDTELESIS_COM_SnmpStartupDelay */
    UINT32    X_ALLIEDTELESIS_COM_WanUpTrapDelay;	/**< X_ALLIEDTELESIS_COM_WanUpTrapDelay */
} SnmpCfgObject;

/*! \brief _SnmpCfgObject is used internally to represent SnmpCfgObject */
typedef SnmpCfgObject _SnmpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SecDmzHostCfg.
 *
 * MDMOID_SEC_DMZ_HOST_CFG 199
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    IPAddress;	/**< IPAddress */
} SecDmzHostCfgObject;

/*! \brief _SecDmzHostCfgObject is used internally to represent SecDmzHostCfgObject */
typedef SecDmzHostCfgObject _SecDmzHostCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AccessTimeRestriction.{i}.
 *
 * MDMOID_ACCESS_TIME_RESTRICTION 200
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    username;	/**< Username */
    char *    startTime;	/**< StartTime */
    char *    endTime;	/**< EndTime */
    char *    days;	/**< Days */
    char *    MACAddress;	/**< MACAddress */
} AccessTimeRestrictionObject;

/*! \brief _AccessTimeRestrictionObject is used internally to represent AccessTimeRestrictionObject */
typedef AccessTimeRestrictionObject _AccessTimeRestrictionObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_UrlFilterCfg.
 *
 * MDMOID_URL_FILTER_CFG 201
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    excludeMode;	/**< ExcludeMode */
} UrlFilterCfgObject;

/*! \brief _UrlFilterCfgObject is used internally to represent UrlFilterCfgObject */
typedef UrlFilterCfgObject _UrlFilterCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_UrlFilterCfg.X_BROADCOM_COM_UrlFilterListCfgObj.{i}.
 *
 * MDMOID_URL_FILTER_LIST 202
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    urlAddress;	/**< UrlAddress */
    UINT32    portNumber;	/**< PortNumber */
} UrlFilterListObject;

/*! \brief _UrlFilterListObject is used internally to represent UrlFilterListObject */
typedef UrlFilterListObject _UrlFilterListObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DDnsCfg.{i}.
 *
 * MDMOID_D_DNS_CFG 203
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    methodName;	/**< MethodName */
    char *    fullyQualifiedDomainName;	/**< FullyQualifiedDomainName */
    char *    userName;	/**< UserName */
    char *    password;	/**< Password */
    char *    ifName;	/**< IfName */
    char *    providerName;	/**< ProviderName */
    char *    providerUrl;	/**< ProviderUrl */
} DDnsCfgObject;

/*! \brief _DDnsCfgObject is used internally to represent DDnsCfgObject */
typedef DDnsCfgObject _DDnsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPPCfg.
 *
 * MDMOID_IPP_CFG 204
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    make;	/**< Make */
    char *    device;	/**< Device */
    char *    name;	/**< Name */
} IppCfgObject;

/*! \brief _IppCfgObject is used internally to represent IppCfgObject */
typedef IppCfgObject _IppCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DLNA.
 *
 * MDMOID_DLNA 205
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} DlnaObject;

/*! \brief _DlnaObject is used internally to represent DlnaObject */
typedef DlnaObject _DlnaObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DLNA.DmsCfg.
 *
 * MDMOID_DMS_CFG 206
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    mediaPath;	/**< MediaPath */
    UINT32    brKey;	/**< BrKey */
} DmsCfgObject;

/*! \brief _DmsCfgObject is used internally to represent DmsCfgObject */
typedef DmsCfgObject _DmsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DebugPortMirroringCfg.{i}.
 *
 * MDMOID_WAN_DEBUG_PORT_MIRRORING_CFG 207
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    monitorInterface;	/**< MonitorInterface */
    char *    mirrorInterface;	/**< MirrorInterface */
    UBOOL8    direction;	/**< Direction */
    UBOOL8    status;	/**< Status */
#ifdef DMP_X_ITU_ORG_GPON_1
    HEXBINARY  gemPortMaskArray;	/**< GemPortMaskArray */
#endif
} WanDebugPortMirroringCfgObject;

/*! \brief _WanDebugPortMirroringCfgObject is used internally to represent WanDebugPortMirroringCfgObject */
typedef WanDebugPortMirroringCfgObject _WanDebugPortMirroringCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPSecCfg.{i}.
 *
 * MDMOID_IP_SEC_CFG 208
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    entryID;	/**< EntryID */
    UBOOL8    enable;	/**< Enable */
    char *    connName;	/**< ConnName */
    char *    tunMode;	/**< TunMode */
    char *    remoteGWAddress;	/**< RemoteGWAddress */
    char *    localRangeLo;	/**< LocalRangeLo */
    char *    localRangeHi;	/**< LocalRangeHi */
    char *    localIPMode;	/**< LocalIPMode */
    char *    localIPAddress;	/**< LocalIPAddress */
    char *    localMask;	/**< LocalMask */
    char *    remoteRangeLo;	/**< RemoteRangeLo */
    char *    remoteRangeHi;	/**< RemoteRangeHi */
    char *    remoteIPMode;	/**< RemoteIPMode */
    char *    remoteIPAddress;	/**< RemoteIPAddress */
    char *    remoteMask;	/**< RemoteMask */
    char *    keyExM;	/**< KeyExM */
    char *    authM;	/**< AuthM */
    char *    PSK;	/**< PSK */
    char *    certificateName;	/**< CertificateName */
    char *    perfectFSEn;	/**< PerfectFSEn */
    char *    manualEncryptionAlgo;	/**< ManualEncryptionAlgo */
    char *    manualEncryptionKey;	/**< ManualEncryptionKey */
    char *    manualAuthAlgo;	/**< ManualAuthAlgo */
    char *    manualAthKey;	/**< ManualAthKey */
    char *    SPI;	/**< SPI */
    char *    ph1Mode;	/**< Ph1Mode */
    char *    ph1EncryptionAlo;	/**< Ph1EncryptionAlo */
    char *    ph1IntegrityAlgo;	/**< Ph1IntegrityAlgo */
    char *    ph1DHGroup;	/**< Ph1DHGroup */
    UINT32    ph1KeyTime;	/**< Ph1KeyTime */
    char *    ph2Mode;	/**< Ph2Mode */
    char *    ph2EncryptionAlo;	/**< Ph2EncryptionAlo */
    char *    ph2IntegrityAlgo;	/**< Ph2IntegrityAlgo */
    char *    ph2DHGroup;	/**< Ph2DHGroup */
    UINT32    ph2KeyTime;	/**< Ph2KeyTime */
} IPSecCfgObject;

/*! \brief _IPSecCfgObject is used internally to represent IPSecCfgObject */
typedef IPSecCfgObject _IPSecCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_CertificateCfg.{i}.
 *
 * MDMOID_CERTIFICATE_CFG 209
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    char *    subject;	/**< Subject */
    char *    type;	/**< Type */
    char *    password;	/**< Password */
    char *    content;	/**< Content */
    char *    privKey;	/**< PrivKey */
    char *    reqPub;	/**< ReqPub */
    UINT32    refCount;	/**< RefCount */
} CertificateCfgObject;

/*! \brief _CertificateCfgObject is used internally to represent CertificateCfgObject */
typedef CertificateCfgObject _CertificateCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_NetworkConfig.
 *
 * MDMOID_NETWORK_CONFIG 210
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    DNSIfName;	/**< DNSIfName */
    char *    DNSServers;	/**< DNSServers */
    char *    activeDNSServers;	/**< ActiveDNSServers */
    char *    DNSProxyIfName;	/**< DNSProxyIfName */
    char *    DNSProxyServers;	/**< DNSProxyServers */
    char *    activeDNSProxyServers;	/**< ActiveDNSProxyServers */
    UBOOL8    enableAdvancedDMZ;	/**< EnableAdvancedDMZ */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_ALLIEDTELESIS_COM_IPv6DNSServers;	/**< X_ALLIEDTELESIS_COM_IPv6DNSServers */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_ALLIEDTELESIS_COM_IPv6ActiveDNSServers;	/**< X_ALLIEDTELESIS_COM_IPv6ActiveDNSServers */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_ALLIEDTELESIS_COM_IPv6DNSIfName;	/**< X_ALLIEDTELESIS_COM_IPv6DNSIfName */
#endif
    char *    X_ALLIEDTELESIS_COM_DomainSearchList;	/**< X_ALLIEDTELESIS_COM_DomainSearchList */
} NetworkConfigObject;

/*! \brief _NetworkConfigObject is used internally to represent NetworkConfigObject */
typedef NetworkConfigObject _NetworkConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_InterfaceControl.
 *
 * MDMOID_INTERFACE_CONTROL 211
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    ifName;	/**< IfName */
    UBOOL8    moveToWANSide;	/**< MoveToWANSide */
    UBOOL8    moveToLANSide;	/**< MoveToLANSide */
} InterfaceControlObject;

/*! \brief _InterfaceControlObject is used internally to represent InterfaceControlObject */
typedef InterfaceControlObject _InterfaceControlObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_P8021agCfg.
 *
 * MDMOID_P8021AG_CFG 212
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    MDLevel;	/**< MDLevel */
} P8021agCfgObject;

/*! \brief _P8021agCfgObject is used internally to represent P8021agCfgObject */
typedef P8021agCfgObject _P8021agCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IGMPCfg.
 *
 * MDMOID_IGMP_CFG 213
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    igmpVer;	/**< IgmpVer */
    UINT32    igmpQI;	/**< IgmpQI */
    UINT32    igmpQRI;	/**< IgmpQRI */
    UINT32    igmpLMQI;	/**< IgmpLMQI */
    UINT32    igmpRV;	/**< IgmpRV */
    UINT32    igmpMaxGroups;	/**< IgmpMaxGroups */
    UINT32    igmpMaxSources;	/**< IgmpMaxSources */
    UINT32    igmpMaxMembers;	/**< IgmpMaxMembers */
    UBOOL8    igmpFastLeaveEnable;	/**< IgmpFastLeaveEnable */
    UBOOL8    igmpLan2LanMulticastEnable;	/**< IgmpLan2LanMulticastEnable */
    UBOOL8    igmpJoinImmediate;	/**< IgmpJoinImmediate */
    char *    igmpBridgeIfNames;	/**< IgmpBridgeIfNames */
    char *    igmpMcastIfNames;	/**< IgmpMcastIfNames */
    UBOOL8    X_ALLIEDTELESIS_COM_IgmpSnoopOnly;	/**< X_ALLIEDTELESIS_COM_IgmpSnoopOnly */
} IgmpCfgObject;

/*! \brief _IgmpCfgObject is used internally to represent IgmpCfgObject */
typedef IgmpCfgObject _IgmpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_MLDCfg.
 *
 * MDMOID_MLD_CFG 214
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    mldVer;	/**< MldVer */
    UINT32    mldQI;	/**< MldQI */
    UINT32    mldQRI;	/**< MldQRI */
    UINT32    mldLMQI;	/**< MldLMQI */
    UINT32    mldRV;	/**< MldRV */
    UINT32    mldMaxGroups;	/**< MldMaxGroups */
    UINT32    mldMaxSources;	/**< MldMaxSources */
    UINT32    mldMaxMembers;	/**< MldMaxMembers */
    UBOOL8    mldFastLeaveEnable;	/**< MldFastLeaveEnable */
    UBOOL8    mldLan2LanMulticastEnable;	/**< MldLan2LanMulticastEnable */
} MldCfgObject;

/*! \brief _MldCfgObject is used internally to represent MldCfgObject */
typedef MldCfgObject _MldCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPTunnel.{i}.
 *
 * MDMOID_IP_TUNNEL 215
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    activated;	/**< Activated */
    char *    tunnelName;	/**< TunnelName */
    SINT32    tunnelCounter;	/**< TunnelCounter */
    char *    mode;	/**< Mode */
    char *    associatedWanIfName;	/**< AssociatedWanIfName */
    char *    associatedLanIfName;	/**< AssociatedLanIfName */
} IPTunnelObject;

/*! \brief _IPTunnelObject is used internally to represent IPTunnelObject */
typedef IPTunnelObject _IPTunnelObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPTunnel.{i}.V4inV6Tunnel.{i}.
 *
 * MDMOID_IPV4IN_IPV6_TUNNEL 216
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    connStatus;	/**< ConnStatus */
    char *    mechanism;	/**< Mechanism */
    UBOOL8    dynamic;	/**< Dynamic */
    char *    remoteIpv6Address;	/**< RemoteIpv6Address */
} Ipv4inIpv6TunnelObject;

/*! \brief _Ipv4inIpv6TunnelObject is used internally to represent Ipv4inIpv6TunnelObject */
typedef Ipv4inIpv6TunnelObject _Ipv4inIpv6TunnelObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPTunnel.{i}.V6inV4Tunnel.{i}.
 *
 * MDMOID_IPV6IN_IPV4_TUNNEL 217
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    connStatus;	/**< ConnStatus */
    char *    mechanism;	/**< Mechanism */
    UBOOL8    dynamic;	/**< Dynamic */
    SINT32    ipv4MaskLen;	/**< Ipv4MaskLen */
    char *    prefix;	/**< Prefix */
    char *    borderRelayAddress;	/**< BorderRelayAddress */
} Ipv6inIpv4TunnelObject;

/*! \brief _Ipv6inIpv4TunnelObject is used internally to represent Ipv6inIpv4TunnelObject */
typedef Ipv6inIpv4TunnelObject _Ipv6inIpv4TunnelObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.
 *
 * MDMOID_ITU_T_ORG 218
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} ItuTOrgObject;

/*! \brief _ItuTOrgObject is used internally to represent ItuTOrgObject */
typedef ItuTOrgObject _ItuTOrgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.
 *
 * MDMOID_G_984_4 219
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} G_984_4Object;

/*! \brief _G_984_4Object is used internally to represent G_984_4Object */
typedef G_984_4Object _G_984_4Object;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.
 *
 * MDMOID_EQUIPMENT_MANAGEMENT 220
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} EquipmentManagementObject;

/*! \brief _EquipmentManagementObject is used internally to represent EquipmentManagementObject */
typedef EquipmentManagementObject _EquipmentManagementObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.OntG.
 *
 * MDMOID_ONT_G 221
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  vendorId;	/**< VendorId */
    HEXBINARY  version;	/**< Version */
    HEXBINARY  serialNumber;	/**< SerialNumber */
    UINT32    trafficManagementOption;	/**< TrafficManagementOption */
    UINT32    vpVcCrossConnectionOption;	/**< VpVcCrossConnectionOption */
    UBOOL8    batteryBackup;	/**< BatteryBackup */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
} OntGObject;

/*! \brief _OntGObject is used internally to represent OntGObject */
typedef OntGObject _OntGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.Ont2G.
 *
 * MDMOID_ONT2_G 222
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  equipmentId;	/**< EquipmentId */
    UINT32    omccVersion;	/**< OmccVersion */
    UINT32    vendorProductCode;	/**< VendorProductCode */
    UINT32    securityCapability;	/**< SecurityCapability */
    UINT32    securityMode;	/**< SecurityMode */
    UINT32    totalPriorityQueueNumber;	/**< TotalPriorityQueueNumber */
    UINT32    totalTrafficSchedulerNumber;	/**< TotalTrafficSchedulerNumber */
    UINT32    mode;	/**< Mode */
    UINT32    totalGemPortIdNumber;	/**< TotalGemPortIdNumber */
    UINT32    sysUpTime;	/**< SysUpTime */
    UINT32    connectivityCapability;	/**< ConnectivityCapability */
    UINT32    currentConnectivityMode;	/**< CurrentConnectivityMode */
    UINT32    qosConfigFlexibiltiy;	/**< QosConfigFlexibiltiy */
} Ont2GObject;

/*! \brief _Ont2GObject is used internally to represent Ont2GObject */
typedef Ont2GObject _Ont2GObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.OntData.
 *
 * MDMOID_ONT_DATA 223
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    mibDataSync;	/**< MibDataSync */
} OntDataObject;

/*! \brief _OntDataObject is used internally to represent OntDataObject */
typedef OntDataObject _OntDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.SoftwareImage.{i}.
 *
 * MDMOID_SOFTWARE_IMAGE 224
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  version;	/**< Version */
    UBOOL8    isCommitted;	/**< IsCommitted */
    UBOOL8    isActive;	/**< IsActive */
    UBOOL8    isValid;	/**< IsValid */
} SoftwareImageObject;

/*! \brief _SoftwareImageObject is used internally to represent SoftwareImageObject */
typedef SoftwareImageObject _SoftwareImageObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.CardHolder.{i}.
 *
 * MDMOID_CARD_HOLDER 225
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    actualPlugInUnitType;	/**< ActualPlugInUnitType */
    UINT32    expectedPlugInUnitType;	/**< ExpectedPlugInUnitType */
    UINT32    expectedPortCount;	/**< ExpectedPortCount */
    HEXBINARY  expectedEquipmentId;	/**< ExpectedEquipmentId */
    HEXBINARY  actualEquipmentId;	/**< ActualEquipmentId */
    UINT32    protectionProfilePointer;	/**< ProtectionProfilePointer */
    UINT32    invokeProtectionSwitch;	/**< InvokeProtectionSwitch */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
} CardHolderObject;

/*! \brief _CardHolderObject is used internally to represent CardHolderObject */
typedef CardHolderObject _CardHolderObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.CircuitPack.{i}.
 *
 * MDMOID_CIRCUIT_PACK 226
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    type;	/**< Type */
    UINT32    numberOfPorts;	/**< NumberOfPorts */
    HEXBINARY  serialNumber;	/**< SerialNumber */
    HEXBINARY  version;	/**< Version */
    HEXBINARY  vendorId;	/**< VendorId */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
    UINT32    bridgedIpInd;	/**< BridgedIpInd */
    HEXBINARY  equipmentId;	/**< EquipmentId */
    UINT32    cardConfiguration;	/**< CardConfiguration */
    UINT32    totalTcontBufferNumber;	/**< TotalTcontBufferNumber */
    UINT32    totalPriorityQueueNumber;	/**< TotalPriorityQueueNumber */
    UINT32    totalTrafficSchedulerNumber;	/**< TotalTrafficSchedulerNumber */
    UINT32    powerShedOverride;	/**< PowerShedOverride */
} CircuitPackObject;

/*! \brief _CircuitPackObject is used internally to represent CircuitPackObject */
typedef CircuitPackObject _CircuitPackObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.PowerShedding.{i}.
 *
 * MDMOID_POWER_SHEDDING 227
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    restorePowerTimerResetInterval;	/**< RestorePowerTimerResetInterval */
    UINT32    dataClassSheddingInterval;	/**< DataClassSheddingInterval */
    UINT32    voiceClassSheddingInterval;	/**< VoiceClassSheddingInterval */
    UINT32    videoOverlayClassSheddingInterval;	/**< VideoOverlayClassSheddingInterval */
    UINT32    videoReturnClassSheddingInterval;	/**< VideoReturnClassSheddingInterval */
    UINT32    dslClassSheddingInterval;	/**< DslClassSheddingInterval */
    UINT32    atmClassSheddingInterval;	/**< AtmClassSheddingInterval */
    UINT32    cesClassSheddingInterval;	/**< CesClassSheddingInterval */
    UINT32    frameClassSheddingInterval;	/**< FrameClassSheddingInterval */
    UINT32    sonetClassSheddingInterval;	/**< SonetClassSheddingInterval */
    UINT32    sheddingStatus;	/**< SheddingStatus */
} PowerSheddingObject;

/*! \brief _PowerSheddingObject is used internally to represent PowerSheddingObject */
typedef PowerSheddingObject _PowerSheddingObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EquipmentManagement.PortMappingPackageG.{i}.
 *
 * MDMOID_PORT_MAPPING_PACKAGE_G 228
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    maxPorts;	/**< MaxPorts */
    HEXBINARY  portList1;	/**< PortList1 */
    HEXBINARY  portList2;	/**< PortList2 */
    HEXBINARY  portList3;	/**< PortList3 */
    HEXBINARY  portList4;	/**< PortList4 */
    HEXBINARY  portList5;	/**< PortList5 */
    HEXBINARY  portList6;	/**< PortList6 */
    HEXBINARY  portList7;	/**< PortList7 */
    HEXBINARY  portList8;	/**< PortList8 */
} PortMappingPackageGObject;

/*! \brief _PortMappingPackageGObject is used internally to represent PortMappingPackageGObject */
typedef PortMappingPackageGObject _PortMappingPackageGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.
 *
 * MDMOID_ANI_MANAGEMENT 229
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} AniManagementObject;

/*! \brief _AniManagementObject is used internally to represent AniManagementObject */
typedef AniManagementObject _AniManagementObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.AniG.{i}.
 *
 * MDMOID_ANI_G 230
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UBOOL8    srIndication;	/**< SrIndication */
    UINT32    totalTcontNumber;	/**< TotalTcontNumber */
    UINT32    gemBlockLength;	/**< GemBlockLength */
    UINT32    piggybackDbaReporting;	/**< PiggybackDbaReporting */
    UINT32    wholeOnuDbaReporting;	/**< WholeOnuDbaReporting */
    UINT32    sfThreshold;	/**< SfThreshold */
    UINT32    sdThreshold;	/**< SdThreshold */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
    UINT32    opticalSignalLevel;	/**< OpticalSignalLevel */
    UINT32    lowerOptivalThreshold;	/**< LowerOptivalThreshold */
    UINT32    upperOptivalThreshold;	/**< UpperOptivalThreshold */
    UINT32    ontResponseTime;	/**< OntResponseTime */
    UINT32    transmitOpticalLevel;	/**< TransmitOpticalLevel */
    UINT32    lowerTransmitPowerThreshold;	/**< LowerTransmitPowerThreshold */
    UINT32    upperTransmitPowerThreshold;	/**< UpperTransmitPowerThreshold */
} AniGObject;

/*! \brief _AniGObject is used internally to represent AniGObject */
typedef AniGObject _AniGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.TCont.{i}.
 *
 * MDMOID_T_CONT 231
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    allocId;	/**< AllocId */
    UINT32    modeIndicator;	/**< ModeIndicator */
    UINT32    policy;	/**< Policy */
} TContObject;

/*! \brief _TContObject is used internally to represent TContObject */
typedef TContObject _TContObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.GemPortNetworkCtp.{i}.
 *
 * MDMOID_GEM_PORT_NETWORK_CTP 232
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    portIdValue;	/**< PortIdValue */
    UINT32    TContPointer;	/**< TContPointer */
    UINT32    direction;	/**< Direction */
    UINT32    upstreamTrafficManagementPointer;	/**< UpstreamTrafficManagementPointer */
    UINT32    upstreamTrafficDescriptorProfilePointer;	/**< UpstreamTrafficDescriptorProfilePointer */
    UINT32    uniCounter;	/**< UniCounter */
    UINT32    downstreamPriorityQueuePointer;	/**< DownstreamPriorityQueuePointer */
    UINT32    encryptionState;	/**< EncryptionState */
    UINT32    downstreamTrafficDescriptorProfilePointerr;	/**< DownstreamTrafficDescriptorProfilePointerr */
} GemPortNetworkCtpObject;

/*! \brief _GemPortNetworkCtpObject is used internally to represent GemPortNetworkCtpObject */
typedef GemPortNetworkCtpObject _GemPortNetworkCtpObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.GemInterworkingTp.{i}.
 *
 * MDMOID_GEM_INTERWORKING_TP 233
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    gemPortNetworkCtpConnPointer;	/**< GemPortNetworkCtpConnPointer */
    UINT32    interworkingOption;	/**< InterworkingOption */
    UINT32    serviceProfilePointer;	/**< ServiceProfilePointer */
    UINT32    interworkingTermPointPointer;	/**< InterworkingTermPointPointer */
    UINT32    pptpCounter;	/**< PptpCounter */
    UINT32    operationalState;	/**< OperationalState */
    UINT32    galProfilePointer;	/**< GalProfilePointer */
    UINT32    galLoopbackConfiguration;	/**< GalLoopbackConfiguration */
} GemInterworkingTpObject;

/*! \brief _GemInterworkingTpObject is used internally to represent GemInterworkingTpObject */
typedef GemInterworkingTpObject _GemInterworkingTpObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.MulticastGemInterworkingTp.{i}.
 *
 * MDMOID_MULTICAST_GEM_INTERWORKING_TP 234
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    gemPortNetworkCtpConnPointer;	/**< GemPortNetworkCtpConnPointer */
    UINT32    interworkingOption;	/**< InterworkingOption */
    UINT32    serviceProfilePointer;	/**< ServiceProfilePointer */
    UINT32    interworkingTermPointPointer;	/**< InterworkingTermPointPointer */
    UINT32    pptpCounter;	/**< PptpCounter */
    UINT32    operationalState;	/**< OperationalState */
    UINT32    galProfilePointer;	/**< GalProfilePointer */
    UINT32    galLoopbackConfiguration;	/**< GalLoopbackConfiguration */
    HEXBINARY  multicastAddressField;	/**< MulticastAddressField */
} MulticastGemInterworkingTpObject;

/*! \brief _MulticastGemInterworkingTpObject is used internally to represent MulticastGemInterworkingTpObject */
typedef MulticastGemInterworkingTpObject _MulticastGemInterworkingTpObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.MulticastGemInterworkingTp.{i}.MulticastAddressTable.{i}.
 *
 * MDMOID_GEM_INTERWORKING_TP_MULTICAST_ADDRESS_TABLE 235
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  multicastAddressEntry;	/**< MulticastAddressEntry */
} GemInterworkingTpMulticastAddressTableObject;

/*! \brief _GemInterworkingTpMulticastAddressTableObject is used internally to represent GemInterworkingTpMulticastAddressTableObject */
typedef GemInterworkingTpMulticastAddressTableObject _GemInterworkingTpMulticastAddressTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.GemPortPmHistoryData.{i}.
 *
 * MDMOID_GEM_PORT_PM_HISTORY_DATA 236
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    transmittedGEMFrames;	/**< TransmittedGEMFrames */
    UINT32    receivedGEMFrames;	/**< ReceivedGEMFrames */
    UINT64    receivedPayloadBytes;	/**< ReceivedPayloadBytes */
    UINT64    transmittedPayloadBytes;	/**< TransmittedPayloadBytes */
} GemPortPmHistoryDataObject;

/*! \brief _GemPortPmHistoryDataObject is used internally to represent GemPortPmHistoryDataObject */
typedef GemPortPmHistoryDataObject _GemPortPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.GalEthernetProfile.{i}.
 *
 * MDMOID_GAL_ETHERNET_PROFILE 237
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    maximumGemPayloadSize;	/**< MaximumGemPayloadSize */
} GalEthernetProfileObject;

/*! \brief _GalEthernetProfileObject is used internally to represent GalEthernetProfileObject */
typedef GalEthernetProfileObject _GalEthernetProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.GalEthernetPmHistoryData.{i}.
 *
 * MDMOID_GAL_ETHERNET_PM_HISTORY_DATA 238
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    discardedFrames;	/**< DiscardedFrames */
} GalEthernetPmHistoryDataObject;

/*! \brief _GalEthernetPmHistoryDataObject is used internally to represent GalEthernetPmHistoryDataObject */
typedef GalEthernetPmHistoryDataObject _GalEthernetPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.AniManagement.FecPmHistoryData.{i}.
 *
 * MDMOID_FEC_PM_HISTORY_DATA 239
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    correctedBytes;	/**< CorrectedBytes */
    UINT32    correctedCodeWords;	/**< CorrectedCodeWords */
    UINT32    uncorrectedCodeWords;	/**< UncorrectedCodeWords */
    UINT32    totalCodeWords;	/**< TotalCodeWords */
    UINT32    fecSeconds;	/**< FecSeconds */
} FecPmHistoryDataObject;

/*! \brief _FecPmHistoryDataObject is used internally to represent FecPmHistoryDataObject */
typedef FecPmHistoryDataObject _FecPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.
 *
 * MDMOID_LAYER2_DATA_SERVICES 240
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} Layer2DataServicesObject;

/*! \brief _Layer2DataServicesObject is used internally to represent Layer2DataServicesObject */
typedef Layer2DataServicesObject _Layer2DataServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgeServiceProfile.{i}.
 *
 * MDMOID_MAC_BRIDGE_SERVICE_PROFILE 241
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UBOOL8    spanningTree;	/**< SpanningTree */
    UBOOL8    learning;	/**< Learning */
    UBOOL8    portBridging;	/**< PortBridging */
    UINT32    priority;	/**< Priority */
    UINT32    maxAge;	/**< MaxAge */
    UINT32    helloTime;	/**< HelloTime */
    UINT32    forwardDelay;	/**< ForwardDelay */
    UBOOL8    unknownMacAddressDiscard;	/**< UnknownMacAddressDiscard */
    UINT32    macLearningDepth;	/**< MacLearningDepth */
    UINT32    dynamicFilteringAgeingTime;	/**< DynamicFilteringAgeingTime */
} MacBridgeServiceProfileObject;

/*! \brief _MacBridgeServiceProfileObject is used internally to represent MacBridgeServiceProfileObject */
typedef MacBridgeServiceProfileObject _MacBridgeServiceProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.X_BROADCOM_COM_MacBridgeServiceProfile.{i}.
 *
 * MDMOID_BC_MAC_BRIDGE_SERVICE_PROFILE 242
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    char *    bridgeName;	/**< BridgeName */
} BCM_MacBridgeServiceProfileObject;

/*! \brief _BCM_MacBridgeServiceProfileObject is used internally to represent BCM_MacBridgeServiceProfileObject */
typedef BCM_MacBridgeServiceProfileObject _BCM_MacBridgeServiceProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgeConfigData.{i}.
 *
 * MDMOID_MAC_BRIDGE_CONFIG_DATA 243
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  macAddress;	/**< MacAddress */
    UINT32    priority;	/**< Priority */
    HEXBINARY  designatedRoot;	/**< DesignatedRoot */
    UINT32    rootPathCost;	/**< RootPathCost */
    UINT32    portCount;	/**< PortCount */
    UINT32    rootPortNum;	/**< RootPortNum */
    UINT32    helloTime;	/**< HelloTime */
    UINT32    forwardDelay;	/**< ForwardDelay */
} MacBridgeConfigDataObject;

/*! \brief _MacBridgeConfigDataObject is used internally to represent MacBridgeConfigDataObject */
typedef MacBridgeConfigDataObject _MacBridgeConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePmHistoryData.{i}.
 *
 * MDMOID_MAC_BRIDGE_PM_HISTORY_DATA 244
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    learningEntryDiscardCounter;	/**< LearningEntryDiscardCounter */
} MacBridgePmHistoryDataObject;

/*! \brief _MacBridgePmHistoryDataObject is used internally to represent MacBridgePmHistoryDataObject */
typedef MacBridgePmHistoryDataObject _MacBridgePmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortConfigData.{i}.
 *
 * MDMOID_MAC_BRIDGE_PORT_CONFIG_DATA 245
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    bridgeId;	/**< BridgeId */
    UINT32    portNum;	/**< PortNum */
    UINT32    tpType;	/**< TpType */
    UINT32    tpPointer;	/**< TpPointer */
    UINT32    priority;	/**< Priority */
    UINT32    pathCost;	/**< PathCost */
    UBOOL8    spanningTree;	/**< SpanningTree */
    UINT32    encapMethod;	/**< EncapMethod */
    UINT32    lanFcs;	/**< LanFcs */
    HEXBINARY  macAddress;	/**< MacAddress */
    UINT32    outTdPointer;	/**< OutTdPointer */
    UINT32    inTdPointer;	/**< InTdPointer */
    UINT32    macLearningDepth;	/**< MacLearningDepth */
} MacBridgePortConfigDataObject;

/*! \brief _MacBridgePortConfigDataObject is used internally to represent MacBridgePortConfigDataObject */
typedef MacBridgePortConfigDataObject _MacBridgePortConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortDesignationData.{i}.
 *
 * MDMOID_MAC_BRIDGE_PORT_DESIGNATION_DATA 246
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  designatedBridgeRootCostPort;	/**< DesignatedBridgeRootCostPort */
    UINT32    portState;	/**< PortState */
} MacBridgePortDesignationDataObject;

/*! \brief _MacBridgePortDesignationDataObject is used internally to represent MacBridgePortDesignationDataObject */
typedef MacBridgePortDesignationDataObject _MacBridgePortDesignationDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortFilterTableData.{i}.
 *
 * MDMOID_MAC_BRIDGE_PORT_FILTER_TABLE_DATA 247
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  macFilterTable;	/**< MacFilterTable */
} MacBridgePortFilterTableDataObject;

/*! \brief _MacBridgePortFilterTableDataObject is used internally to represent MacBridgePortFilterTableDataObject */
typedef MacBridgePortFilterTableDataObject _MacBridgePortFilterTableDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortFilterTableData.{i}.MacFilterTable.{i}.
 *
 * MDMOID_MAC_FILTER_TABLE 248
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  macFilterEntry;	/**< MacFilterEntry */
} MacFilterTableObject;

/*! \brief _MacFilterTableObject is used internally to represent MacFilterTableObject */
typedef MacFilterTableObject _MacFilterTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortFilterPreAssignTable.{i}.
 *
 * MDMOID_MAC_BRIDGE_PORT_FILTER_PRE_ASSIGN_TABLE 249
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    ipv4MulticastFilter;	/**< Ipv4MulticastFilter */
    UINT32    ipv6MulticastFilter;	/**< Ipv6MulticastFilter */
    UINT32    ipv4BroadcastFilter;	/**< Ipv4BroadcastFilter */
    UINT32    rarpFilter;	/**< RarpFilter */
    UINT32    ipxFilter;	/**< IpxFilter */
    UINT32    netBeuiFilter;	/**< NetBeuiFilter */
    UINT32    appleTalkFilter;	/**< AppleTalkFilter */
    UINT32    bridgeFilter;	/**< BridgeFilter */
    UINT32    arpFilter;	/**< ArpFilter */
    UINT32    pppoeFilter;	/**< PppoeFilter */
} MacBridgePortFilterPreAssignTableObject;

/*! \brief _MacBridgePortFilterPreAssignTableObject is used internally to represent MacBridgePortFilterPreAssignTableObject */
typedef MacBridgePortFilterPreAssignTableObject _MacBridgePortFilterPreAssignTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortBridgeTableData.{i}.
 *
 * MDMOID_MAC_BRIDGE_PORT_BRIDGE_TABLE_DATA 250
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  bridgeTable;	/**< BridgeTable */
} MacBridgePortBridgeTableDataObject;

/*! \brief _MacBridgePortBridgeTableDataObject is used internally to represent MacBridgePortBridgeTableDataObject */
typedef MacBridgePortBridgeTableDataObject _MacBridgePortBridgeTableDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortBridgeTableData.{i}.BridgeTable.{i}.
 *
 * MDMOID_BRIDGE_TABLE 251
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  bridgeEntry;	/**< BridgeEntry */
} BridgeTableObject;

/*! \brief _BridgeTableObject is used internally to represent BridgeTableObject */
typedef BridgeTableObject _BridgeTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MacBridgePortPmHistoryData.{i}.
 *
 * MDMOID_MAC_BRIDGE_PORT_PM_HISTORY_DATA 252
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    forwardFrameCounter;	/**< ForwardFrameCounter */
    UINT32    delayDiscardCounter;	/**< DelayDiscardCounter */
    UINT32    mtuDiscardCounter;	/**< MtuDiscardCounter */
    UINT32    receiveFrameCounter;	/**< ReceiveFrameCounter */
    UINT32    receiveDiscardCounter;	/**< ReceiveDiscardCounter */
} MacBridgePortPmHistoryDataObject;

/*! \brief _MacBridgePortPmHistoryDataObject is used internally to represent MacBridgePortPmHistoryDataObject */
typedef MacBridgePortPmHistoryDataObject _MacBridgePortPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MapperServiceProfile.{i}.
 *
 * MDMOID_MAPPER_SERVICE_PROFILE 253
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    tpPointer;	/**< TpPointer */
    UINT32    interworkTpPointerPriority0;	/**< InterworkTpPointerPriority0 */
    UINT32    interworkTpPointerPriority1;	/**< InterworkTpPointerPriority1 */
    UINT32    interworkTpPointerPriority2;	/**< InterworkTpPointerPriority2 */
    UINT32    interworkTpPointerPriority3;	/**< InterworkTpPointerPriority3 */
    UINT32    interworkTpPointerPriority4;	/**< InterworkTpPointerPriority4 */
    UINT32    interworkTpPointerPriority5;	/**< InterworkTpPointerPriority5 */
    UINT32    interworkTpPointerPriority6;	/**< InterworkTpPointerPriority6 */
    UINT32    interworkTpPointerPriority7;	/**< InterworkTpPointerPriority7 */
    UINT32    unmarkedFrameOption;	/**< UnmarkedFrameOption */
    HEXBINARY  dscpToPBitMapping;	/**< DscpToPBitMapping */
    UINT32    defaultPBitMarking;	/**< DefaultPBitMarking */
    UINT32    tpType;	/**< TpType */
} MapperServiceProfileObject;

/*! \brief _MapperServiceProfileObject is used internally to represent MapperServiceProfileObject */
typedef MapperServiceProfileObject _MapperServiceProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.X_BROADCOM_COM_MapperServiceProfile.{i}.
 *
 * MDMOID_BC_MAPPER_SERVICE_PROFILE 254
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    char *    bridgeName;	/**< BridgeName */
} BCM_MapperServiceProfileObject;

/*! \brief _BCM_MapperServiceProfileObject is used internally to represent BCM_MapperServiceProfileObject */
typedef BCM_MapperServiceProfileObject _BCM_MapperServiceProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.VlanTaggingFilterData.{i}.
 *
 * MDMOID_VLAN_TAGGING_FILTER_DATA 255
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  vlanFilterList;	/**< VlanFilterList */
    UINT32    forwardOperation;	/**< ForwardOperation */
    UINT32    numberOfEntries;	/**< NumberOfEntries */
} VlanTaggingFilterDataObject;

/*! \brief _VlanTaggingFilterDataObject is used internally to represent VlanTaggingFilterDataObject */
typedef VlanTaggingFilterDataObject _VlanTaggingFilterDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.VlanTaggingOperationConfigurationData.{i}.
 *
 * MDMOID_VLAN_TAGGING_OPERATION_CONFIGURATION_DATA 256
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    upstreamVlanTaggingOperationMode;	/**< UpstreamVlanTaggingOperationMode */
    UINT32    upstreamVlanTagTciValue;	/**< UpstreamVlanTagTciValue */
    UINT32    downstreamVlanTaggingOperationMode;	/**< DownstreamVlanTaggingOperationMode */
    UINT32    associationType;	/**< AssociationType */
    UINT32    associatedManagedEntityPointer;	/**< AssociatedManagedEntityPointer */
} VlanTaggingOperationConfigurationDataObject;

/*! \brief _VlanTaggingOperationConfigurationDataObject is used internally to represent VlanTaggingOperationConfigurationDataObject */
typedef VlanTaggingOperationConfigurationDataObject _VlanTaggingOperationConfigurationDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.ExtendedVlanTaggingOperationConfigurationData.{i}.
 *
 * MDMOID_EXTENDED_VLAN_TAGGING_OPERATION_CONFIGURATION_DATA 257
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    associationType;	/**< AssociationType */
    UINT32    receivedFrameVlanTaggingOperationTableMaxSize;	/**< ReceivedFrameVlanTaggingOperationTableMaxSize */
    UINT32    inputTpid;	/**< InputTpid */
    UINT32    outputTpid;	/**< OutputTpid */
    UINT32    downstreamMode;	/**< DownstreamMode */
    HEXBINARY  receivedFrameVlanTaggingOperationTable;	/**< ReceivedFrameVlanTaggingOperationTable */
    UINT32    associatedManagedEntityPointer;	/**< AssociatedManagedEntityPointer */
    HEXBINARY  dscpToPBitMapping;	/**< DscpToPBitMapping */
} ExtendedVlanTaggingOperationConfigurationDataObject;

/*! \brief _ExtendedVlanTaggingOperationConfigurationDataObject is used internally to represent ExtendedVlanTaggingOperationConfigurationDataObject */
typedef ExtendedVlanTaggingOperationConfigurationDataObject _ExtendedVlanTaggingOperationConfigurationDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.ExtendedVlanTaggingOperationConfigurationData.{i}.ReceivedFrameVlanTaggingOperationTable.{i}.
 *
 * MDMOID_RECEIVED_FRAME_VLAN_TAGGING_OPERATION_TABLE 258
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  taggingRule;	/**< TaggingRule */
} ReceivedFrameVlanTaggingOperationTableObject;

/*! \brief _ReceivedFrameVlanTaggingOperationTableObject is used internally to represent ReceivedFrameVlanTaggingOperationTableObject */
typedef ReceivedFrameVlanTaggingOperationTableObject _ReceivedFrameVlanTaggingOperationTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastOperationsProfile.{i}.
 *
 * MDMOID_MULTICAST_OPERATIONS_PROFILE 259
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    igmpVersion;	/**< IgmpVersion */
    UINT32    igmpFunction;	/**< IgmpFunction */
    UINT32    immediateLeave;	/**< ImmediateLeave */
    UINT32    upstreamIgmpTci;	/**< UpstreamIgmpTci */
    UINT32    upstreamIgmpTagControl;	/**< UpstreamIgmpTagControl */
    UINT32    upstreamIgmpRate;	/**< UpstreamIgmpRate */
    HEXBINARY  dynamicAccessControlListTable;	/**< DynamicAccessControlListTable */
    HEXBINARY  staticAccessControlListTable;	/**< StaticAccessControlListTable */
    HEXBINARY  lostGroupsListTable;	/**< LostGroupsListTable */
    UINT32    robustness;	/**< Robustness */
    UINT32    querierIpAddress;	/**< QuerierIpAddress */
    UINT32    queryInterval;	/**< QueryInterval */
    UINT32    queryMaxResponseTime;	/**< QueryMaxResponseTime */
    UINT32    lastMemberQueryInterval;	/**< LastMemberQueryInterval */
    UINT32    unauthorizedJoinRequestBehaviour;	/**< UnauthorizedJoinRequestBehaviour */
    HEXBINARY  downstreamIgmpTci;	/**< DownstreamIgmpTci */
} MulticastOperationsProfileObject;

/*! \brief _MulticastOperationsProfileObject is used internally to represent MulticastOperationsProfileObject */
typedef MulticastOperationsProfileObject _MulticastOperationsProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastOperationsProfile.{i}.DynamicAccessControlListTable.{i}.
 *
 * MDMOID_DYNAMIC_ACCESS_CONTROL_LIST_TABLE 260
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  dynamicAccessControlEntry;	/**< DynamicAccessControlEntry */
} DynamicAccessControlListTableObject;

/*! \brief _DynamicAccessControlListTableObject is used internally to represent DynamicAccessControlListTableObject */
typedef DynamicAccessControlListTableObject _DynamicAccessControlListTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastOperationsProfile.{i}.StaticAccessControlListTable.{i}.
 *
 * MDMOID_STATIC_ACCESS_CONTROL_LIST_TABLE 261
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  staticAccessControlEntry;	/**< StaticAccessControlEntry */
} StaticAccessControlListTableObject;

/*! \brief _StaticAccessControlListTableObject is used internally to represent StaticAccessControlListTableObject */
typedef StaticAccessControlListTableObject _StaticAccessControlListTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastOperationsProfile.{i}.LostGroupsListTable.{i}.
 *
 * MDMOID_LOST_GROUPS_LIST_TABLE 262
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  lostGroupsListEntry;	/**< LostGroupsListEntry */
} LostGroupsListTableObject;

/*! \brief _LostGroupsListTableObject is used internally to represent LostGroupsListTableObject */
typedef LostGroupsListTableObject _LostGroupsListTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastSubscriberConfigInfo.{i}.
 *
 * MDMOID_MULTICAST_SUBSCRIBER_CONFIG_INFO 263
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    meType;	/**< MeType */
    UINT32    multicastOperationsProfilePointer;	/**< MulticastOperationsProfilePointer */
    UINT32    maxSimultaneousGroups;	/**< MaxSimultaneousGroups */
    UINT32    maxMulticastBandwidth;	/**< MaxMulticastBandwidth */
    UINT32    bandwidthEnforcement;	/**< BandwidthEnforcement */
} MulticastSubscriberConfigInfoObject;

/*! \brief _MulticastSubscriberConfigInfoObject is used internally to represent MulticastSubscriberConfigInfoObject */
typedef MulticastSubscriberConfigInfoObject _MulticastSubscriberConfigInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastSubscriberMonitor.{i}.
 *
 * MDMOID_MULTICAST_SUBSCRIBER_MONITOR 264
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    meType;	/**< MeType */
    UINT32    currentMulticastBandwidth;	/**< CurrentMulticastBandwidth */
    UINT32    joinMessagesCounter;	/**< JoinMessagesCounter */
    UINT32    bandwidthExceededCounter;	/**< BandwidthExceededCounter */
    HEXBINARY  activeGroupsListTable;	/**< ActiveGroupsListTable */
} MulticastSubscriberMonitorObject;

/*! \brief _MulticastSubscriberMonitorObject is used internally to represent MulticastSubscriberMonitorObject */
typedef MulticastSubscriberMonitorObject _MulticastSubscriberMonitorObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.MulticastSubscriberMonitor.{i}.ActiveGroupsListTable.{i}.
 *
 * MDMOID_ACTIVE_GROUPS_LIST_TABLE 265
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  activeGroupsListEntry;	/**< ActiveGroupsListEntry */
} ActiveGroupsListTableObject;

/*! \brief _ActiveGroupsListTableObject is used internally to represent ActiveGroupsListTableObject */
typedef ActiveGroupsListTableObject _ActiveGroupsListTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.X_BROADCOM_COM_MulticastSubscriberMonitor.{i}.
 *
 * MDMOID_BC_MULTICAST_SUBSCRIBER_MONITOR 266
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    objectId;	/**< ObjectId */
    UINT32    currentMulticastBandwidth;	/**< CurrentMulticastBandwidth */
    UINT32    joinMessagesCounter;	/**< JoinMessagesCounter */
    UINT32    bandwidthExceededCounter;	/**< BandwidthExceededCounter */
    UINT32    numberOfSubscribers;	/**< NumberOfSubscribers */
} BCM_MulticastSubscriberMonitorObject;

/*! \brief _BCM_MulticastSubscriberMonitorObject is used internally to represent BCM_MulticastSubscriberMonitorObject */
typedef BCM_MulticastSubscriberMonitorObject _BCM_MulticastSubscriberMonitorObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.X_BROADCOM_COM_MulticastSubscriberMonitor.{i}.MulticastSubscriber.{i}.
 *
 * MDMOID_MULTICAST_SUBSCRIBER 267
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    tci;	/**< Tci */
    UINT32    sourceIpAddress;	/**< SourceIpAddress */
    UINT32    groupIpAddress;	/**< GroupIpAddress */
    UINT32    clientIpAddress;	/**< ClientIpAddress */
    UINT32    joinedTime;	/**< JoinedTime */
} MulticastSubscriberObject;

/*! \brief _MulticastSubscriberObject is used internally to represent MulticastSubscriberObject */
typedef MulticastSubscriberObject _MulticastSubscriberObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.UpstreamEthernetFramePmHistoryData.{i}.
 *
 * MDMOID_UPSTREAM_ETHERNET_FRAME_PM_HISTORY_DATA 268
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    dropEvents;	/**< DropEvents */
    UINT32    octets;	/**< Octets */
    UINT32    packets;	/**< Packets */
    UINT32    broadcastPackets;	/**< BroadcastPackets */
    UINT32    multicastPackets;	/**< MulticastPackets */
    UINT32    crcErroredPackets;	/**< CrcErroredPackets */
    UINT32    undersizePackets;	/**< UndersizePackets */
    UINT32    oversizePackets;	/**< OversizePackets */
    UINT32    packets64Octets;	/**< Packets64Octets */
    UINT32    packets127Octets;	/**< Packets127Octets */
    UINT32    packets255Octets;	/**< Packets255Octets */
    UINT32    packets511Octets;	/**< Packets511Octets */
    UINT32    packets1023Octets;	/**< Packets1023Octets */
    UINT32    packets1518Octets;	/**< Packets1518Octets */
} UpstreamEthernetFramePmHistoryDataObject;

/*! \brief _UpstreamEthernetFramePmHistoryDataObject is used internally to represent UpstreamEthernetFramePmHistoryDataObject */
typedef UpstreamEthernetFramePmHistoryDataObject _UpstreamEthernetFramePmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer2DataServices.DownstreamEthernetFramePmHistoryData.{i}.
 *
 * MDMOID_DOWNSTREAM_ETHERNET_FRAME_PM_HISTORY_DATA 269
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    dropEvents;	/**< DropEvents */
    UINT32    octets;	/**< Octets */
    UINT32    packets;	/**< Packets */
    UINT32    broadcastPackets;	/**< BroadcastPackets */
    UINT32    multicastPackets;	/**< MulticastPackets */
    UINT32    crcErroredPackets;	/**< CrcErroredPackets */
    UINT32    undersizePackets;	/**< UndersizePackets */
    UINT32    oversizePackets;	/**< OversizePackets */
    UINT32    packets64Octets;	/**< Packets64Octets */
    UINT32    packets127Octets;	/**< Packets127Octets */
    UINT32    packets255Octets;	/**< Packets255Octets */
    UINT32    packets511Octets;	/**< Packets511Octets */
    UINT32    packets1023Octets;	/**< Packets1023Octets */
    UINT32    packets1518Octets;	/**< Packets1518Octets */
} DownstreamEthernetFramePmHistoryDataObject;

/*! \brief _DownstreamEthernetFramePmHistoryDataObject is used internally to represent DownstreamEthernetFramePmHistoryDataObject */
typedef DownstreamEthernetFramePmHistoryDataObject _DownstreamEthernetFramePmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.
 *
 * MDMOID_LAYER3_DATA_SERVICES 270
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} Layer3DataServicesObject;

/*! \brief _Layer3DataServicesObject is used internally to represent Layer3DataServicesObject */
typedef Layer3DataServicesObject _Layer3DataServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.IpHostConfigData.{i}.
 *
 * MDMOID_IP_HOST_CONFIG_DATA 271
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    ipOptions;	/**< IpOptions */
    HEXBINARY  macAddress;	/**< MacAddress */
    HEXBINARY  ontId;	/**< OntId */
    UINT32    ipAddress;	/**< IpAddress */
    UINT32    mask;	/**< Mask */
    UINT32    gateway;	/**< Gateway */
    UINT32    primaryDns;	/**< PrimaryDns */
    UINT32    secondaryDns;	/**< SecondaryDns */
    UINT32    currentAddress;	/**< CurrentAddress */
    UINT32    currentMask;	/**< CurrentMask */
    UINT32    currentGateway;	/**< CurrentGateway */
    UINT32    currentPrimaryDns;	/**< CurrentPrimaryDns */
    UINT32    currentSecondaryDns;	/**< CurrentSecondaryDns */
    HEXBINARY  domainName;	/**< DomainName */
    HEXBINARY  hostName;	/**< HostName */
} IpHostConfigDataObject;

/*! \brief _IpHostConfigDataObject is used internally to represent IpHostConfigDataObject */
typedef IpHostConfigDataObject _IpHostConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.X_BROADCOM_COM_IpHostConfigData.{i}.
 *
 * MDMOID_BC_IP_HOST_CONFIG_DATA 272
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    connectionStatus;	/**< ConnectionStatus */
    UINT32    dhcpcPid;	/**< DhcpcPid */
    char *    interfaceName;	/**< InterfaceName */
} BCM_IpHostConfigDataObject;

/*! \brief _BCM_IpHostConfigDataObject is used internally to represent BCM_IpHostConfigDataObject */
typedef BCM_IpHostConfigDataObject _BCM_IpHostConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.IpHostPmHistoryData.{i}.
 *
 * MDMOID_IP_HOST_PM_HISTORY_DATA 273
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    icmpErrors;	/**< IcmpErrors */
    UINT32    dnsErrors;	/**< DnsErrors */
} IpHostPmHistoryDataObject;

/*! \brief _IpHostPmHistoryDataObject is used internally to represent IpHostPmHistoryDataObject */
typedef IpHostPmHistoryDataObject _IpHostPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.Ipv6HostConfigData.{i}.
 *
 * MDMOID_IPV6_HOST_CONFIG_DATA 274
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    ipOptions;	/**< IpOptions */
    HEXBINARY  macAddress;	/**< MacAddress */
    HEXBINARY  onuId;	/**< OnuId */
    HEXBINARY  ipv6LinkLocalAddress;	/**< Ipv6LinkLocalAddress */
    HEXBINARY  ipv6Address;	/**< Ipv6Address */
    HEXBINARY  defaultRouter;	/**< DefaultRouter */
    HEXBINARY  primaryDns;	/**< PrimaryDns */
    HEXBINARY  secondaryDns;	/**< SecondaryDns */
    HEXBINARY  currentAddressTable;	/**< CurrentAddressTable */
    HEXBINARY  currentDefaultRouterTable;	/**< CurrentDefaultRouterTable */
    HEXBINARY  currentDnsTable;	/**< CurrentDnsTable */
    HEXBINARY  duid;	/**< Duid */
    HEXBINARY  onlinkPrefix;	/**< OnlinkPrefix */
    HEXBINARY  currentOnlinkPrefixTable;	/**< CurrentOnlinkPrefixTable */
} Ipv6HostConfigDataObject;

/*! \brief _Ipv6HostConfigDataObject is used internally to represent Ipv6HostConfigDataObject */
typedef Ipv6HostConfigDataObject _Ipv6HostConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.Ipv6HostConfigData.{i}.CurrentAddressTable.{i}.
 *
 * MDMOID_IPV6_CURRENT_ADDRESS_TABLE 275
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  currentAddressEntry;	/**< CurrentAddressEntry */
} Ipv6CurrentAddressTableObject;

/*! \brief _Ipv6CurrentAddressTableObject is used internally to represent Ipv6CurrentAddressTableObject */
typedef Ipv6CurrentAddressTableObject _Ipv6CurrentAddressTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.Ipv6HostConfigData.{i}.CurrentDefaultRouterTable.{i}.
 *
 * MDMOID_IPV6_CURRENT_DEFAULT_ROUTER_TABLE 276
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  currentDefaultRouterEntry;	/**< CurrentDefaultRouterEntry */
} Ipv6CurrentDefaultRouterTableObject;

/*! \brief _Ipv6CurrentDefaultRouterTableObject is used internally to represent Ipv6CurrentDefaultRouterTableObject */
typedef Ipv6CurrentDefaultRouterTableObject _Ipv6CurrentDefaultRouterTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.Ipv6HostConfigData.{i}.CurrentDnsTable.{i}.
 *
 * MDMOID_IPV6_CURRENT_DNS_TABLE 277
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  currentDnsEntry;	/**< CurrentDnsEntry */
} Ipv6CurrentDnsTableObject;

/*! \brief _Ipv6CurrentDnsTableObject is used internally to represent Ipv6CurrentDnsTableObject */
typedef Ipv6CurrentDnsTableObject _Ipv6CurrentDnsTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.Ipv6HostConfigData.{i}.CurrentOnlinkPrefixTable.{i}.
 *
 * MDMOID_IPV6_CURRENT_ONLINK_PREFIX_TABLE 278
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  currentOnlinkPrefixTableEntry;	/**< CurrentOnlinkPrefixTableEntry */
} Ipv6CurrentOnlinkPrefixTableObject;

/*! \brief _Ipv6CurrentOnlinkPrefixTableObject is used internally to represent Ipv6CurrentOnlinkPrefixTableObject */
typedef Ipv6CurrentOnlinkPrefixTableObject _Ipv6CurrentOnlinkPrefixTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.X_BROADCOM_COM_Ipv6HostConfigData.{i}.
 *
 * MDMOID_BC_IPV6_HOST_CONFIG_DATA 279
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    connectionStatus;	/**< ConnectionStatus */
    UINT32    dhcpcPid;	/**< DhcpcPid */
    char *    interfaceName;	/**< InterfaceName */
    UBOOL8    MFlag;	/**< MFlag */
    UBOOL8    OFlag;	/**< OFlag */
} BCM_Ipv6HostConfigDataObject;

/*! \brief _BCM_Ipv6HostConfigDataObject is used internally to represent BCM_Ipv6HostConfigDataObject */
typedef BCM_Ipv6HostConfigDataObject _BCM_Ipv6HostConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.Layer3DataServices.TcpUdpConfigData.{i}.
 *
 * MDMOID_TCP_UDP_CONFIG_DATA 280
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    portId;	/**< PortId */
    UINT32    protocol;	/**< Protocol */
    UINT32    tos;	/**< Tos */
    UINT32    ipHostPointer;	/**< IpHostPointer */
} TcpUdpConfigDataObject;

/*! \brief _TcpUdpConfigDataObject is used internally to represent TcpUdpConfigDataObject */
typedef TcpUdpConfigDataObject _TcpUdpConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EthernetServices.
 *
 * MDMOID_ETHERNET_SERVICES 281
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} EthernetServicesObject;

/*! \brief _EthernetServicesObject is used internally to represent EthernetServicesObject */
typedef EthernetServicesObject _EthernetServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EthernetServices.PptpEthernetUni.{i}.
 *
 * MDMOID_PPTP_ETHERNET_UNI 282
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    expectedType;	/**< ExpectedType */
    UINT32    sensedType;	/**< SensedType */
    UINT32    autoDetectionConfiguration;	/**< AutoDetectionConfiguration */
    UINT32    loopbackConfiguration;	/**< LoopbackConfiguration */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
    UINT32    configurationInd;	/**< ConfigurationInd */
    UINT32    maxFrameSize;	/**< MaxFrameSize */
    UINT32    dteDceInd;	/**< DteDceInd */
    UINT32    pauseTime;	/**< PauseTime */
    UINT32    bridgedIpInd;	/**< BridgedIpInd */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
    UBOOL8    pppoeFilter;	/**< PppoeFilter */
    UINT32    powerControl;	/**< PowerControl */
} PptpEthernetUniObject;

/*! \brief _PptpEthernetUniObject is used internally to represent PptpEthernetUniObject */
typedef PptpEthernetUniObject _PptpEthernetUniObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EthernetServices.EthernetPmHistoryData.{i}.
 *
 * MDMOID_ETHERNET_PM_HISTORY_DATA 283
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    fcsErrors;	/**< FcsErrors */
    UINT32    excessiveCollisionCounter;	/**< ExcessiveCollisionCounter */
    UINT32    lateCollisionCounter;	/**< LateCollisionCounter */
    UINT32    frameTooLongs;	/**< FrameTooLongs */
    UINT32    bufferOverflowsOnReceive;	/**< BufferOverflowsOnReceive */
    UINT32    bufferOverflowsOnTransmit;	/**< BufferOverflowsOnTransmit */
    UINT32    singleCollisionFrameCounter;	/**< SingleCollisionFrameCounter */
    UINT32    multipleCollisionsFrameCounter;	/**< MultipleCollisionsFrameCounter */
    UINT32    sqeCounter;	/**< SqeCounter */
    UINT32    deferredTransmissionCounter;	/**< DeferredTransmissionCounter */
    UINT32    internalMacTransmitErrorCounter;	/**< InternalMacTransmitErrorCounter */
    UINT32    carrierSenseErrorCounter;	/**< CarrierSenseErrorCounter */
    UINT32    alignmentErrorCounter;	/**< AlignmentErrorCounter */
    UINT32    internalMacReceiveErrorCounter;	/**< InternalMacReceiveErrorCounter */
} EthernetPmHistoryDataObject;

/*! \brief _EthernetPmHistoryDataObject is used internally to represent EthernetPmHistoryDataObject */
typedef EthernetPmHistoryDataObject _EthernetPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EthernetServices.EthernetPmHistoryData2.{i}.
 *
 * MDMOID_ETHERNET_PM_HISTORY_DATA2 284
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    pppoeFilterFrameCounter;	/**< PppoeFilterFrameCounter */
} EthernetPmHistoryData2Object;

/*! \brief _EthernetPmHistoryData2Object is used internally to represent EthernetPmHistoryData2Object */
typedef EthernetPmHistoryData2Object _EthernetPmHistoryData2Object;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EthernetServices.EthernetPmHistoryData3.{i}.
 *
 * MDMOID_ETHERNET_PM_HISTORY_DATA3 285
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    dropEvents;	/**< DropEvents */
    UINT32    octets;	/**< Octets */
    UINT32    packets;	/**< Packets */
    UINT32    broadcastPackets;	/**< BroadcastPackets */
    UINT32    multicastPackets;	/**< MulticastPackets */
    UINT32    undersizePackets;	/**< UndersizePackets */
    UINT32    fragments;	/**< Fragments */
    UINT32    jabbers;	/**< Jabbers */
    UINT32    packets64Octets;	/**< Packets64Octets */
    UINT32    packets127Octets;	/**< Packets127Octets */
    UINT32    packets255Octets;	/**< Packets255Octets */
    UINT32    packets511Octets;	/**< Packets511Octets */
    UINT32    packets1023Octets;	/**< Packets1023Octets */
    UINT32    packets1518Octets;	/**< Packets1518Octets */
} EthernetPmHistoryData3Object;

/*! \brief _EthernetPmHistoryData3Object is used internally to represent EthernetPmHistoryData3Object */
typedef EthernetPmHistoryData3Object _EthernetPmHistoryData3Object;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.EthernetServices.VirtualEthernetInterfacePoint.{i}.
 *
 * MDMOID_VIRTUAL_ETHERNET_INTERFACE_POINT 286
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
    HEXBINARY  interDomainName;	/**< InterDomainName */
    UINT32    tcpUdpPointer;	/**< TcpUdpPointer */
    UINT32    ianaAssignedPort;	/**< IanaAssignedPort */
} VirtualEthernetInterfacePointObject;

/*! \brief _VirtualEthernetInterfacePointObject is used internally to represent VirtualEthernetInterfacePointObject */
typedef VirtualEthernetInterfacePointObject _VirtualEthernetInterfacePointObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.
 *
 * MDMOID_VOICE_SERVICES 287
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} VoiceServicesObject;

/*! \brief _VoiceServicesObject is used internally to represent VoiceServicesObject */
typedef VoiceServicesObject _VoiceServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.PptpPotsUni.{i}.
 *
 * MDMOID_PPTP_POTS_UNI 288
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    interworkingTpPointer;	/**< InterworkingTpPointer */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
    UINT32    impedance;	/**< Impedance */
    UINT32    transmissionPath;	/**< TransmissionPath */
    UINT32    rxGain;	/**< RxGain */
    UINT32    txGain;	/**< TxGain */
    UINT32    operationalState;	/**< OperationalState */
    UINT32    hookState;	/**< HookState */
    UINT32    potsHoldoverTime;	/**< PotsHoldoverTime */
} PptpPotsUniObject;

/*! \brief _PptpPotsUniObject is used internally to represent PptpPotsUniObject */
typedef PptpPotsUniObject _PptpPotsUniObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.SipUserData.{i}.
 *
 * MDMOID_SIP_USER_DATA 289
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    sipAgentPointer;	/**< SipAgentPointer */
    UINT32    userPartAor;	/**< UserPartAor */
    HEXBINARY  sipDisplayName;	/**< SipDisplayName */
    UINT32    usernamePassword;	/**< UsernamePassword */
    UINT32    voiceMailServerSipUri;	/**< VoiceMailServerSipUri */
    UINT32    voiceMailExpTime;	/**< VoiceMailExpTime */
    UINT32    networkDialPlanPointer;	/**< NetworkDialPlanPointer */
    UINT32    appServiceProfilePointer;	/**< AppServiceProfilePointer */
    UINT32    featureCodePointer;	/**< FeatureCodePointer */
    UINT32    pptpPointer;	/**< PptpPointer */
    UINT32    releaseTimer;	/**< ReleaseTimer */
    UINT32    rohTimer;	/**< RohTimer */
} SipUserDataObject;

/*! \brief _SipUserDataObject is used internally to represent SipUserDataObject */
typedef SipUserDataObject _SipUserDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.SipAgentConfigData.{i}.
 *
 * MDMOID_SIP_AGENT_CONFIG_DATA 290
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    proxyServerAddressPointer;	/**< ProxyServerAddressPointer */
    UINT32    outboundProxyAddressPointer;	/**< OutboundProxyAddressPointer */
    UINT32    primarySipDns;	/**< PrimarySipDns */
    UINT32    secondarySipDns;	/**< SecondarySipDns */
    UINT32    tcpUdpPointer;	/**< TcpUdpPointer */
    UINT32    sipRegExpTime;	/**< SipRegExpTime */
    UINT32    sipRegRegHeadStartTime;	/**< SipRegRegHeadStartTime */
    UINT32    hostPartUri;	/**< HostPartUri */
    UINT32    sipStatus;	/**< SipStatus */
    UINT32    sipRegistrar;	/**< SipRegistrar */
    HEXBINARY  softswitch;	/**< Softswitch */
    HEXBINARY  sipResponseTable;	/**< SipResponseTable */
    UINT32    sipOptionTransmitControl;	/**< SipOptionTransmitControl */
    UINT32    sipUriFormat;	/**< SipUriFormat */
} SipAgentConfigDataObject;

/*! \brief _SipAgentConfigDataObject is used internally to represent SipAgentConfigDataObject */
typedef SipAgentConfigDataObject _SipAgentConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoIpVoiceCtp.{i}.
 *
 * MDMOID_VO_IP_VOICE_CTP 291
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    userProtocolPointer;	/**< UserProtocolPointer */
    UINT32    pptpPointer;	/**< PptpPointer */
    UINT32    voIpMediaProfilePointer;	/**< VoIpMediaProfilePointer */
    UINT32    signallingCode;	/**< SignallingCode */
} VoIpVoiceCtpObject;

/*! \brief _VoIpVoiceCtpObject is used internally to represent VoIpVoiceCtpObject */
typedef VoIpVoiceCtpObject _VoIpVoiceCtpObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoIpMediaProfile.{i}.
 *
 * MDMOID_VO_IP_MEDIA_PROFILE 292
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    faxMode;	/**< FaxMode */
    UINT32    voiceServiceProfilePointer;	/**< VoiceServiceProfilePointer */
    UINT32    codecSelection1;	/**< CodecSelection1 */
    UINT32    packetPeriodSelection1;	/**< PacketPeriodSelection1 */
    UINT32    silenceSuppression1;	/**< SilenceSuppression1 */
    UINT32    codecSelection2;	/**< CodecSelection2 */
    UINT32    packetPeriodSelection2;	/**< PacketPeriodSelection2 */
    UINT32    silenceSuppression2;	/**< SilenceSuppression2 */
    UINT32    codecSelection3;	/**< CodecSelection3 */
    UINT32    packetPeriodSelection3;	/**< PacketPeriodSelection3 */
    UINT32    silenceSuppression3;	/**< SilenceSuppression3 */
    UINT32    codecSelection4;	/**< CodecSelection4 */
    UINT32    packetPeriodSelection4;	/**< PacketPeriodSelection4 */
    UINT32    silenceSuppression4;	/**< SilenceSuppression4 */
    UINT32    oobDtmf;	/**< OobDtmf */
    UINT32    rtpProfilePointer;	/**< RtpProfilePointer */
} VoIpMediaProfileObject;

/*! \brief _VoIpMediaProfileObject is used internally to represent VoIpMediaProfileObject */
typedef VoIpMediaProfileObject _VoIpMediaProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoiceServiceProfile.{i}.
 *
 * MDMOID_VOICE_SERVICE 293
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    announcementType;	/**< AnnouncementType */
    UINT32    jitterTarget;	/**< JitterTarget */
    UINT32    jitterBufferMax;	/**< JitterBufferMax */
    UBOOL8    echoCancel;	/**< EchoCancel */
    UINT32    pstnProtocolVariant;	/**< PstnProtocolVariant */
    UINT32    dtmfDigitLevels;	/**< DtmfDigitLevels */
    UINT32    dtmfDigitDuration;	/**< DtmfDigitDuration */
    UINT32    hookFlashMinTime;	/**< HookFlashMinTime */
    UINT32    hookFlashMaxTime;	/**< HookFlashMaxTime */
    HEXBINARY  tonePatternTable;	/**< TonePatternTable */
    HEXBINARY  toneEventTable;	/**< ToneEventTable */
    HEXBINARY  ringingPatternTable;	/**< RingingPatternTable */
    HEXBINARY  ringingEventTable;	/**< RingingEventTable */
} VoiceServiceObject;

/*! \brief _VoiceServiceObject is used internally to represent VoiceServiceObject */
typedef VoiceServiceObject _VoiceServiceObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.RtpProfileData.{i}.
 *
 * MDMOID_RTP_PROFILE_DATA 294
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    localPortMin;	/**< LocalPortMin */
    UINT32    localPortMax;	/**< LocalPortMax */
    UINT32    dscpMark;	/**< DscpMark */
    UBOOL8    piggybackEvents;	/**< PiggybackEvents */
    UBOOL8    toneEvents;	/**< ToneEvents */
    UBOOL8    dtmfEvents;	/**< DtmfEvents */
    UBOOL8    casEvents;	/**< CasEvents */
} RtpProfileDataObject;

/*! \brief _RtpProfileDataObject is used internally to represent RtpProfileDataObject */
typedef RtpProfileDataObject _RtpProfileDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoIpAppServiceProfile.{i}.
 *
 * MDMOID_VO_IP_APP_SERVICE_PROFILE 295
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    cidFeatures;	/**< CidFeatures */
    UINT32    callWaitingFeatures;	/**< CallWaitingFeatures */
    UINT32    callProgressFeatures;	/**< CallProgressFeatures */
    UINT32    callPresentationFeatures;	/**< CallPresentationFeatures */
    UINT32    directConnectFeature;	/**< DirectConnectFeature */
    UINT32    directConnectUriPointer;	/**< DirectConnectUriPointer */
    UINT32    bridgedLineAgentUriPointer;	/**< BridgedLineAgentUriPointer */
    UINT32    conferenceFactoryUriPointer;	/**< ConferenceFactoryUriPointer */
} VoIpAppServiceProfileObject;

/*! \brief _VoIpAppServiceProfileObject is used internally to represent VoIpAppServiceProfileObject */
typedef VoIpAppServiceProfileObject _VoIpAppServiceProfileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoiceFeatureAccessCodes.{i}.
 *
 * MDMOID_VOICE_FEATURE_ACCESS_CODES 296
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  cancelCallWaiting;	/**< CancelCallWaiting */
    HEXBINARY  callHold;	/**< CallHold */
    HEXBINARY  callPark;	/**< CallPark */
    HEXBINARY  callerIdActivate;	/**< CallerIdActivate */
    HEXBINARY  callerIdDeactivate;	/**< CallerIdDeactivate */
    HEXBINARY  doNotDisturdActivation;	/**< DoNotDisturdActivation */
    HEXBINARY  doNotDisturdDeactivation;	/**< DoNotDisturdDeactivation */
    HEXBINARY  doNotDisturdPinChange;	/**< DoNotDisturdPinChange */
    HEXBINARY  emergencyServiceNumber;	/**< EmergencyServiceNumber */
    HEXBINARY  intercomService;	/**< IntercomService */
    HEXBINARY  unattendedCallTransfer;	/**< UnattendedCallTransfer */
    HEXBINARY  attendedCallTransfer;	/**< AttendedCallTransfer */
} VoiceFeatureAccessCodesObject;

/*! \brief _VoiceFeatureAccessCodesObject is used internally to represent VoiceFeatureAccessCodesObject */
typedef VoiceFeatureAccessCodesObject _VoiceFeatureAccessCodesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.NetworkDialPlanTable.{i}.
 *
 * MDMOID_NETWORK_DIAL_PLAN_TABLE 297
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    dialPlanNumber;	/**< DialPlanNumber */
    UINT32    dialPlanTableMaxSize;	/**< DialPlanTableMaxSize */
    UINT32    criticalDialTimeout;	/**< CriticalDialTimeout */
    UINT32    partialDialTimeout;	/**< PartialDialTimeout */
    UINT32    dialPlanFormat;	/**< DialPlanFormat */
    HEXBINARY  dialPlanTable;	/**< DialPlanTable */
} NetworkDialPlanTableObject;

/*! \brief _NetworkDialPlanTableObject is used internally to represent NetworkDialPlanTableObject */
typedef NetworkDialPlanTableObject _NetworkDialPlanTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.NetworkDialPlanTable.{i}.DialPlanTable.{i}.
 *
 * MDMOID_DIAL_PLAN_TABLE 298
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    dialPlanId;	/**< DialPlanId */
    UINT32    action;	/**< Action */
    HEXBINARY  dialPlanTable;	/**< DialPlanTable */
} DialPlanTableObject;

/*! \brief _DialPlanTableObject is used internally to represent DialPlanTableObject */
typedef DialPlanTableObject _DialPlanTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoIpLineStatus.{i}.
 *
 * MDMOID_VO_IP_LINE_STATUS 299
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    voIpCodecUsed;	/**< VoIpCodecUsed */
    UINT32    voIpVoiceServerStatus;	/**< VoIpVoiceServerStatus */
    UINT32    voIpPortSessionType;	/**< VoIpPortSessionType */
    UINT32    voIpCall1PacketPeriod;	/**< VoIpCall1PacketPeriod */
    UINT32    voIpCall2PacketPeriod;	/**< VoIpCall2PacketPeriod */
    HEXBINARY  voIpCall1DstAddr;	/**< VoIpCall1DstAddr */
    HEXBINARY  voIpCall2DstAddr;	/**< VoIpCall2DstAddr */
} VoIpLineStatusObject;

/*! \brief _VoIpLineStatusObject is used internally to represent VoIpLineStatusObject */
typedef VoIpLineStatusObject _VoIpLineStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.CallControlPmHistoryData.{i}.
 *
 * MDMOID_CALL_CONTROL_PM_HISTORY_DATA 300
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    callSetupFailures;	/**< CallSetupFailures */
    UINT32    callSetupTimer;	/**< CallSetupTimer */
    UINT32    callTerminateFailures;	/**< CallTerminateFailures */
    UINT32    analogPortReleases;	/**< AnalogPortReleases */
    UINT32    analogPortOffHookTimer;	/**< AnalogPortOffHookTimer */
} CallControlPmHistoryDataObject;

/*! \brief _CallControlPmHistoryDataObject is used internally to represent CallControlPmHistoryDataObject */
typedef CallControlPmHistoryDataObject _CallControlPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.RtpPmHistoryData.{i}.
 *
 * MDMOID_RTP_PM_HISTORY_DATA 301
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    rtpErrors;	/**< RtpErrors */
    UINT32    packetLoss;	/**< PacketLoss */
    UINT32    maxJitter;	/**< MaxJitter */
    UINT32    maxTimeBetweenRtcpPackets;	/**< MaxTimeBetweenRtcpPackets */
    UINT32    bufferUnderflows;	/**< BufferUnderflows */
    UINT32    bufferOverflows;	/**< BufferOverflows */
} RtpPmHistoryDataObject;

/*! \brief _RtpPmHistoryDataObject is used internally to represent RtpPmHistoryDataObject */
typedef RtpPmHistoryDataObject _RtpPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.SipAgentPmHistoryData.{i}.
 *
 * MDMOID_SIP_AGENT_PM_HISTORY_DATA 302
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    transactions;	/**< Transactions */
    UINT32    rxInviteReqs;	/**< RxInviteReqs */
    UINT32    rxInviteRetrans;	/**< RxInviteRetrans */
    UINT32    rxNonInviteReqs;	/**< RxNonInviteReqs */
    UINT32    rxNonInviteRetrans;	/**< RxNonInviteRetrans */
    UINT32    rxResponse;	/**< RxResponse */
    UINT32    rxResponseRetrans;	/**< RxResponseRetrans */
    UINT32    txInviteReqs;	/**< TxInviteReqs */
    UINT32    txInviteRetrans;	/**< TxInviteRetrans */
    UINT32    txNonInviteReqs;	/**< TxNonInviteReqs */
    UINT32    txNonInviteRetrans;	/**< TxNonInviteRetrans */
    UINT32    txResponse;	/**< TxResponse */
    UINT32    txResponseRetrans;	/**< TxResponseRetrans */
} SipAgentPmHistoryDataObject;

/*! \brief _SipAgentPmHistoryDataObject is used internally to represent SipAgentPmHistoryDataObject */
typedef SipAgentPmHistoryDataObject _SipAgentPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.SipCallInitPmHistoryData.{i}.
 *
 * MDMOID_SIP_CALL_INIT_PM_HISTORY_DATA 303
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    failToConnectCounter;	/**< FailToConnectCounter */
    UINT32    failToValidateCounter;	/**< FailToValidateCounter */
    UINT32    timeoutCounter;	/**< TimeoutCounter */
    UINT32    failureReceivedCounter;	/**< FailureReceivedCounter */
    UINT32    failToAuthenticateCounter;	/**< FailToAuthenticateCounter */
} SipCallInitPmHistoryDataObject;

/*! \brief _SipCallInitPmHistoryDataObject is used internally to represent SipCallInitPmHistoryDataObject */
typedef SipCallInitPmHistoryDataObject _SipCallInitPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.MgcConfigData.{i}.
 *
 * MDMOID_MGC_CONFIG_DATA 304
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    primaryMgc;	/**< PrimaryMgc */
    UINT32    secondaryMgc;	/**< SecondaryMgc */
    UINT32    tcpUdpPointer;	/**< TcpUdpPointer */
    UINT32    version;	/**< Version */
    UINT32    messageFormat;	/**< MessageFormat */
    UINT32    maxRetryTime;	/**< MaxRetryTime */
    UINT32    maxRetryAttempts;	/**< MaxRetryAttempts */
    UINT32    serviceChangeDelay;	/**< ServiceChangeDelay */
    HEXBINARY  terminationIdBase;	/**< TerminationIdBase */
    HEXBINARY  softswitch;	/**< Softswitch */
} MgcConfigDataObject;

/*! \brief _MgcConfigDataObject is used internally to represent MgcConfigDataObject */
typedef MgcConfigDataObject _MgcConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.MgcPmHistoryData.{i}.
 *
 * MDMOID_MGC_PM_HISTORY_DATA 305
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    receivedMessages;	/**< ReceivedMessages */
    UINT32    receivedOctets;	/**< ReceivedOctets */
    UINT32    sentMessages;	/**< SentMessages */
    UINT32    sentOctets;	/**< SentOctets */
    UINT32    protocolErrors;	/**< ProtocolErrors */
    UINT32    transportLosses;	/**< TransportLosses */
    UINT32    lastDetectedEvent;	/**< LastDetectedEvent */
    UINT32    lastDetectedEventTime;	/**< LastDetectedEventTime */
    UINT32    lastDetectedResetTime;	/**< LastDetectedResetTime */
} MgcPmHistoryDataObject;

/*! \brief _MgcPmHistoryDataObject is used internally to represent MgcPmHistoryDataObject */
typedef MgcPmHistoryDataObject _MgcPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.VoiceServices.VoIpConfigData.{i}.
 *
 * MDMOID_VO_IP_CONFIG_DATA 306
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    availableSignalProtocol;	/**< AvailableSignalProtocol */
    UINT32    usedSignalProtocol;	/**< UsedSignalProtocol */
    UINT32    availableVoIpConfigMethods;	/**< AvailableVoIpConfigMethods */
    UINT32    usedVoIpConfigMethods;	/**< UsedVoIpConfigMethods */
    UINT32    voIpConfigAddrPointer;	/**< VoIpConfigAddrPointer */
    UINT32    voIpConfigState;	/**< VoIpConfigState */
    UINT32    retrieveProfile;	/**< RetrieveProfile */
    HEXBINARY  profileVersion;	/**< ProfileVersion */
} VoIpConfigDataObject;

/*! \brief _VoIpConfigDataObject is used internally to represent VoIpConfigDataObject */
typedef VoIpConfigDataObject _VoIpConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.
 *
 * MDMOID_MOCA_SERVICES 307
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} MocaServicesObject;

/*! \brief _MocaServicesObject is used internally to represent MocaServicesObject */
typedef MocaServicesObject _MocaServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.PptpMocaUni.{i}.
 *
 * MDMOID_PPTP_MOCA_UNI 308
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    loopbackConfiguration;	/**< LoopbackConfiguration */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    operationalState;	/**< OperationalState */
    UINT32    maxFrameSize;	/**< MaxFrameSize */
    UBOOL8    alarmReportingControl;	/**< AlarmReportingControl */
    UINT32    alarmReportingControlInterval;	/**< AlarmReportingControlInterval */
    UBOOL8    pppoeFilter;	/**< PppoeFilter */
    UINT32    networkStatus;	/**< NetworkStatus */
    HEXBINARY  password;	/**< Password */
    UBOOL8    privacy;	/**< Privacy */
    UINT32    minBandwidthAlarmThreshold;	/**< MinBandwidthAlarmThreshold */
    UINT32    frequencyMask;	/**< FrequencyMask */
    UINT32    rfChannel;	/**< RfChannel */
    UINT32    lastOperationalFrequency;	/**< LastOperationalFrequency */
} PptpMocaUniObject;

/*! \brief _PptpMocaUniObject is used internally to represent PptpMocaUniObject */
typedef PptpMocaUniObject _PptpMocaUniObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.X_BROADCOM_COM_PptpMocaUni.{i}.
 *
 * MDMOID_BRCM_PPTP_MOCA_UNI 309
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    ncMode;	/**< NcMode */
    UBOOL8    autoNwSearch;	/**< AutoNwSearch */
    UBOOL8    txPwrControl;	/**< TxPwrControl */
    UINT32    continuousPowerMode;	/**< ContinuousPowerMode */
    UINT32    mcastMode;	/**< McastMode */
    UBOOL8    labMode;	/**< LabMode */
    UBOOL8    eclQTagMode;	/**< EclQTagMode */
    UINT32    maxTransmitTime;	/**< MaxTransmitTime */
    SINT32    maxTransmitPower;	/**< MaxTransmitPower */
    UINT32    snrMargin;	/**< SnrMargin */
    UINT32    outOfOrderLmo;	/**< OutOfOrderLmo */
    UBOOL8    lmoReportEnable;	/**< LmoReportEnable */
    UINT32    tabooMaskStart;	/**< TabooMaskStart */
    UINT32    tabooChannelMask;	/**< TabooChannelMask */
    UBOOL8    continuousIerrInsert;	/**< ContinuousIerrInsert */
    UBOOL8    continuousIeMapInsert;	/**< ContinuousIeMapInsert */
    UINT32    maxPktAggr;	/**< MaxPktAggr */
    UINT32    maxConstellationNode;	/**< MaxConstellationNode */
    UINT32    maxConstellation;	/**< MaxConstellation */
    UBOOL8    preferedNetworkController;	/**< PreferedNetworkController */
    UINT32    pmkExchangeInterval;	/**< PmkExchangeInterval */
    UINT32    tekExchangeInterval;	/**< TekExchangeInterval */
} BrcmPptpMocaUniObject;

/*! \brief _BrcmPptpMocaUniObject is used internally to represent BrcmPptpMocaUniObject */
typedef BrcmPptpMocaUniObject _BrcmPptpMocaUniObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.X_BROADCOM_COM_MocaStatus.{i}.
 *
 * MDMOID_MOCA_STATUS 310
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    vendorId;	/**< VendorId */
    UINT32    hwVersion;	/**< HwVersion */
    UINT32    softwareVersion;	/**< SoftwareVersion */
    UINT32    selfMoCAVersion;	/**< SelfMoCAVersion */
    UINT32    networkVersionNumber;	/**< NetworkVersionNumber */
    UINT32    qam256Support;	/**< Qam256Support */
    UINT32    operationalStatus;	/**< OperationalStatus */
    UINT32    linkStatus;	/**< LinkStatus */
    UINT32    connectedNodes;	/**< ConnectedNodes */
    UINT32    nodeId;	/**< NodeId */
    UINT32    networkControllerNodeId;	/**< NetworkControllerNodeId */
    UINT32    upTime;	/**< UpTime */
    UINT32    linkUpTime;	/**< LinkUpTime */
    UINT32    backupNetworkControllerNodeId;	/**< BackupNetworkControllerNodeId */
    UINT32    rfChannel;	/**< RfChannel */
    UINT32    bwStatus;	/**< BwStatus */
} MocaStatusObject;

/*! \brief _MocaStatusObject is used internally to represent MocaStatusObject */
typedef MocaStatusObject _MocaStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.X_BROADCOM_COM_MocaStats.{i}.
 *
 * MDMOID_MOCA_STATS 311
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    inUcPkts;	/**< InUcPkts */
    UINT32    inDiscardPktsEcl;	/**< InDiscardPktsEcl */
    UINT32    inDiscardPktsMac;	/**< InDiscardPktsMac */
    UINT32    inUnKnownPkts;	/**< InUnKnownPkts */
    UINT32    inMcPkts;	/**< InMcPkts */
    UINT32    inBcPkts;	/**< InBcPkts */
    UINT32    inOctetsLow;	/**< InOctetsLow */
    UINT32    outUcPkts;	/**< OutUcPkts */
    UINT32    outDiscardPkts;	/**< OutDiscardPkts */
    UINT32    outBcPkts;	/**< OutBcPkts */
    UINT32    outOctetsLow;	/**< OutOctetsLow */
    UINT32    networkControllerHandOffs;	/**< NetworkControllerHandOffs */
    UINT32    networkControllerBackups;	/**< NetworkControllerBackups */
} MocaStatsObject;

/*! \brief _MocaStatsObject is used internally to represent MocaStatsObject */
typedef MocaStatsObject _MocaStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.MocaEthernetPmHistoryData.{i}.
 *
 * MDMOID_MOCA_ETHERNET_PM_HISTORY_DATA 312
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    incomingUnicastPackets;	/**< IncomingUnicastPackets */
    UINT32    incomingDiscardedPackets;	/**< IncomingDiscardedPackets */
    UINT32    incomingErroredPackets;	/**< IncomingErroredPackets */
    UINT32    incomingUnknownPackets;	/**< IncomingUnknownPackets */
    UINT32    incomingMulticastPackets;	/**< IncomingMulticastPackets */
    UINT32    incomingBroadcastPackets;	/**< IncomingBroadcastPackets */
    UINT32    incomingOctets;	/**< IncomingOctets */
    UINT32    outgoingUnicastPackets;	/**< OutgoingUnicastPackets */
    UINT32    outgoingDiscardedPackets;	/**< OutgoingDiscardedPackets */
    UINT32    outgoingErroredPackets;	/**< OutgoingErroredPackets */
    UINT32    outgoingUnknownPackets;	/**< OutgoingUnknownPackets */
    UINT32    outgoingMulticastPackets;	/**< OutgoingMulticastPackets */
    UINT32    outgoingBroadcastPackets;	/**< OutgoingBroadcastPackets */
    UINT32    outgoingOctets;	/**< OutgoingOctets */
} MocaEthernetPmHistoryDataObject;

/*! \brief _MocaEthernetPmHistoryDataObject is used internally to represent MocaEthernetPmHistoryDataObject */
typedef MocaEthernetPmHistoryDataObject _MocaEthernetPmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.MocaInterfacePmHistoryData.{i}.
 *
 * MDMOID_MOCA_INTERFACE_PM_HISTORY_DATA 313
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    intervalEndTime;	/**< IntervalEndTime */
    UINT32    thresholdDataId;	/**< ThresholdDataId */
    UINT32    phyTxBroadcastRate;	/**< PhyTxBroadcastRate */
} MocaInterfacePmHistoryDataObject;

/*! \brief _MocaInterfacePmHistoryDataObject is used internally to represent MocaInterfacePmHistoryDataObject */
typedef MocaInterfacePmHistoryDataObject _MocaInterfacePmHistoryDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.MocaServices.MocaInterfacePmHistoryData.{i}.NodeTable.{i}.
 *
 * MDMOID_MOCA_INTERFACE_PM_HISTORY_DATA_NODE_TABLE 314
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    HEXBINARY  macAddress;	/**< MacAddress */
    UINT32    phyTxRate;	/**< PhyTxRate */
    UINT32    txPowerControlReduction;	/**< TxPowerControlReduction */
    UINT32    phyRxRate;	/**< PhyRxRate */
    UINT32    rxPowerLevel;	/**< RxPowerLevel */
    UINT32    phyRxBroadcastRate;	/**< PhyRxBroadcastRate */
    UINT32    rxBroadcastPowerLevel;	/**< RxBroadcastPowerLevel */
    UINT32    txPackets;	/**< TxPackets */
    UINT32    rxPackets;	/**< RxPackets */
    UINT32    erroredMissedRxPackets;	/**< ErroredMissedRxPackets */
    UINT32    erroredRxPackets;	/**< ErroredRxPackets */
} MocaInterfacePmHistoryDataNodeTableObject;

/*! \brief _MocaInterfacePmHistoryDataNodeTableObject is used internally to represent MocaInterfacePmHistoryDataNodeTableObject */
typedef MocaInterfacePmHistoryDataNodeTableObject _MocaInterfacePmHistoryDataNodeTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.TrafficManagement.
 *
 * MDMOID_TRAFFIC_MANAGEMENT 315
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} TrafficManagementObject;

/*! \brief _TrafficManagementObject is used internally to represent TrafficManagementObject */
typedef TrafficManagementObject _TrafficManagementObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.TrafficManagement.PriorityQueueG.{i}.
 *
 * MDMOID_PRIORITY_QUEUE_G 316
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    queueConfigurationOption;	/**< QueueConfigurationOption */
    UINT32    maxQueueSize;	/**< MaxQueueSize */
    UINT32    allocatedQueueSize;	/**< AllocatedQueueSize */
    UINT32    discardBlockCounterResetInterval;	/**< DiscardBlockCounterResetInterval */
    UINT32    bufferOverFlowsDiscardBlockThreshold;	/**< BufferOverFlowsDiscardBlockThreshold */
    UINT32    relatedPort;	/**< RelatedPort */
    UINT32    trafficSchedulerGPointer;	/**< TrafficSchedulerGPointer */
    UINT32    weight;	/**< Weight */
    UINT32    backPressureOperation;	/**< BackPressureOperation */
    UINT32    backPressureTime;	/**< BackPressureTime */
    UINT32    backPressureOccurQueueThreshold;	/**< BackPressureOccurQueueThreshold */
    UINT32    backPressureClearQueueThreshold;	/**< BackPressureClearQueueThreshold */
    HEXBINARY  packetDropQueueThresholds;	/**< PacketDropQueueThresholds */
    UINT32    packetDropMaxP;	/**< PacketDropMaxP */
    UINT32    queueDropWQ;	/**< QueueDropWQ */
    UINT32    dropPrecedenceColourMarking;	/**< DropPrecedenceColourMarking */
} PriorityQueueGObject;

/*! \brief _PriorityQueueGObject is used internally to represent PriorityQueueGObject */
typedef PriorityQueueGObject _PriorityQueueGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.TrafficManagement.TrafficSchedulerG.{i}.
 *
 * MDMOID_TRAFFIC_SCHEDULER_G 317
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    TContPointer;	/**< TContPointer */
    UINT32    trafficSchedulerGPointer;	/**< TrafficSchedulerGPointer */
    UINT32    policy;	/**< Policy */
    UINT32    priority;	/**< Priority */
} TrafficSchedulerGObject;

/*! \brief _TrafficSchedulerGObject is used internally to represent TrafficSchedulerGObject */
typedef TrafficSchedulerGObject _TrafficSchedulerGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.TrafficManagement.GemTrafficDescriptor.{i}.
 *
 * MDMOID_GEM_TRAFFIC_DESCRIPTOR 318
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    CIR;	/**< CIR */
    UINT32    PIR;	/**< PIR */
    UINT32    CBS;	/**< CBS */
    UINT32    PBS;	/**< PBS */
    UINT32    colourMode;	/**< ColourMode */
    UINT32    ingressColourMarking;	/**< IngressColourMarking */
    UINT32    egressColourMarking;	/**< EgressColourMarking */
    UINT32    meterType;	/**< MeterType */
} GemTrafficDescriptorObject;

/*! \brief _GemTrafficDescriptorObject is used internally to represent GemTrafficDescriptorObject */
typedef GemTrafficDescriptorObject _GemTrafficDescriptorObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.
 *
 * MDMOID_GENERAL 319
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} GeneralObject;

/*! \brief _GeneralObject is used internally to represent GeneralObject */
typedef GeneralObject _GeneralObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.UniG.{i}.
 *
 * MDMOID_UNI_G 320
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    configurationOptionStatus;	/**< ConfigurationOptionStatus */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    managementCapability;	/**< ManagementCapability */
    UINT32    nonOmciManagementId;	/**< NonOmciManagementId */
} UniGObject;

/*! \brief _UniGObject is used internally to represent UniGObject */
typedef UniGObject _UniGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.OltG.
 *
 * MDMOID_OLT_G 321
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  oltVendorId;	/**< OltVendorId */
    HEXBINARY  equipmentId;	/**< EquipmentId */
    HEXBINARY  version;	/**< Version */
    HEXBINARY  timeInfo;	/**< TimeInfo */
} OltGObject;

/*! \brief _OltGObject is used internally to represent OltGObject */
typedef OltGObject _OltGObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.NetworkAddress.{i}.
 *
 * MDMOID_NETWORK_ADDRESS 322
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    securityPointer;	/**< SecurityPointer */
    UINT32    addressPointer;	/**< AddressPointer */
} NetworkAddressObject;

/*! \brief _NetworkAddressObject is used internally to represent NetworkAddressObject */
typedef NetworkAddressObject _NetworkAddressObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.AuthenticationSecurityMethod.{i}.
 *
 * MDMOID_AUTHENTICATION_SECURITY_METHOD 323
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    validationScheme;	/**< ValidationScheme */
    HEXBINARY  username1;	/**< Username1 */
    HEXBINARY  password;	/**< Password */
    HEXBINARY  realm;	/**< Realm */
    HEXBINARY  username2;	/**< Username2 */
} AuthenticationSecurityMethodObject;

/*! \brief _AuthenticationSecurityMethodObject is used internally to represent AuthenticationSecurityMethodObject */
typedef AuthenticationSecurityMethodObject _AuthenticationSecurityMethodObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.LargeString.{i}.
 *
 * MDMOID_LARGE_STRING 324
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    numberOfParts;	/**< NumberOfParts */
    char *    part1;	/**< Part1 */
    char *    part2;	/**< Part2 */
    char *    part3;	/**< Part3 */
    char *    part4;	/**< Part4 */
    char *    part5;	/**< Part5 */
    char *    part6;	/**< Part6 */
    char *    part7;	/**< Part7 */
    char *    part8;	/**< Part8 */
    char *    part9;	/**< Part9 */
    char *    part10;	/**< Part10 */
    char *    part11;	/**< Part11 */
    char *    part12;	/**< Part12 */
    char *    part13;	/**< Part13 */
    char *    part14;	/**< Part14 */
    char *    part15;	/**< Part15 */
} LargeStringObject;

/*! \brief _LargeStringObject is used internally to represent LargeStringObject */
typedef LargeStringObject _LargeStringObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.ThresholdData1.{i}.
 *
 * MDMOID_THRESHOLD_DATA1 325
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    thresholdValue1;	/**< ThresholdValue1 */
    UINT32    thresholdValue2;	/**< ThresholdValue2 */
    UINT32    thresholdValue3;	/**< ThresholdValue3 */
    UINT32    thresholdValue4;	/**< ThresholdValue4 */
    UINT32    thresholdValue5;	/**< ThresholdValue5 */
    UINT32    thresholdValue6;	/**< ThresholdValue6 */
    UINT32    thresholdValue7;	/**< ThresholdValue7 */
} ThresholdData1Object;

/*! \brief _ThresholdData1Object is used internally to represent ThresholdData1Object */
typedef ThresholdData1Object _ThresholdData1Object;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.ThresholdData2.{i}.
 *
 * MDMOID_THRESHOLD_DATA2 326
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    thresholdValue8;	/**< ThresholdValue8 */
    UINT32    thresholdValue9;	/**< ThresholdValue9 */
    UINT32    thresholdValue10;	/**< ThresholdValue10 */
    UINT32    thresholdValue11;	/**< ThresholdValue11 */
    UINT32    thresholdValue12;	/**< ThresholdValue12 */
    UINT32    thresholdValue13;	/**< ThresholdValue13 */
    UINT32    thresholdValue14;	/**< ThresholdValue14 */
} ThresholdData2Object;

/*! \brief _ThresholdData2Object is used internally to represent ThresholdData2Object */
typedef ThresholdData2Object _ThresholdData2Object;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.Omci.
 *
 * MDMOID_OMCI 327
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    HEXBINARY  meTypeTable;	/**< MeTypeTable */
    HEXBINARY  messageTypeTable;	/**< MessageTypeTable */
} OmciObject;

/*! \brief _OmciObject is used internally to represent OmciObject */
typedef OmciObject _OmciObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ITU_T_ORG.G_984_4.General.TR069ManagementServer.{i}.
 *
 * MDMOID_TR069_MANAGEMENT_SERVER 328
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ManagedEntityId */
    UINT32    administrativeState;	/**< AdministrativeState */
    UINT32    acsNetworkAddress;	/**< AcsNetworkAddress */
    UINT32    associatedTag;	/**< AssociatedTag */
} Tr069ManagementServerObject;

/*! \brief _Tr069ManagementServerObject is used internally to represent Tr069ManagementServerObject */
typedef Tr069ManagementServerObject _Tr069ManagementServerObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OmciSystem.
 *
 * MDMOID_OMCI_SYSTEM 329
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    tcontManagedEntityId;	/**< TcontManagedEntityId */
    UINT32    numberOfTConts;	/**< NumberOfTConts */
    UINT32    tcontPolicies;	/**< TcontPolicies */
    UINT32    ethernetManagedEntityId1;	/**< EthernetManagedEntityId1 */
    UINT32    ethernetManagedEntityId2;	/**< EthernetManagedEntityId2 */
    UINT32    ethernetManagedEntityId3;	/**< EthernetManagedEntityId3 */
    UINT32    ethernetManagedEntityId4;	/**< EthernetManagedEntityId4 */
    UINT32    ethernetManagedEntityId5;	/**< EthernetManagedEntityId5 */
    UINT32    ethernetManagedEntityId6;	/**< EthernetManagedEntityId6 */
    UINT32    ethernetManagedEntityId7;	/**< EthernetManagedEntityId7 */
    UINT32    ethernetManagedEntityId8;	/**< EthernetManagedEntityId8 */
    UINT32    numberOfEthernetPorts;	/**< NumberOfEthernetPorts */
    UINT32    ethernetTypes;	/**< EthernetTypes */
    UINT32    veipPptpUni0;	/**< VeipPptpUni0 */
    UINT32    mocaManagedEntityId1;	/**< MocaManagedEntityId1 */
    UINT32    mocaManagedEntityId2;	/**< MocaManagedEntityId2 */
    UINT32    numberOfMocaPorts;	/**< NumberOfMocaPorts */
    UINT32    potsManagedEntityId1;	/**< PotsManagedEntityId1 */
    UINT32    potsManagedEntityId2;	/**< PotsManagedEntityId2 */
    UINT32    numberOfPotsPorts;	/**< NumberOfPotsPorts */
    UINT32    veipManagedEntityId1;	/**< VeipManagedEntityId1 */
    UINT32    numberOfVeipPorts;	/**< NumberOfVeipPorts */
    UINT32    numberOfDownstreamPriorityQueues;	/**< NumberOfDownstreamPriorityQueues */
    UINT32    debugFlags;	/**< DebugFlags */
    UINT32    dataPathMode;	/**< DataPathMode */
    UINT32    promiscMode;	/**< PromiscMode */
#ifdef DMP_X_BROADCOM_COM_GPONRG_OMCI_LIGHT_1
    UBOOL8    compatibleRGOmciLight;	/**< CompatibleRGOmciLight */
#endif
#ifdef DMP_X_BROADCOM_COM_GPONRG_OMCI_FULL_1
    UBOOL8    compatibleRGOmciFull;	/**< CompatibleRGOmciFull */
#endif
#ifdef DMP_X_BROADCOM_COM_GPONONT_1
    UBOOL8    compatibleOnt;	/**< CompatibleOnt */
#endif
} OmciSystemObject;

/*! \brief _OmciSystemObject is used internally to represent OmciSystemObject */
typedef OmciSystemObject _OmciSystemObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_GponOmciStats.
 *
 * MDMOID_GPON_OMCI_STATS 330
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    rxGoodPackets;	/**< RxGoodPackets */
    UINT32    rxLengthErrors;	/**< RxLengthErrors */
    UINT32    rxCrcErrors;	/**< RxCrcErrors */
    UINT32    rxOtherErrors;	/**< RxOtherErrors */
    UINT32    txAvcPackets;	/**< TxAvcPackets */
    UINT32    txResponsePackets;	/**< TxResponsePackets */
    UINT32    txRetransmissions;	/**< TxRetransmissions */
    UINT32    txErrors;	/**< TxErrors */
} GponOmciStatsObject;

/*! \brief _GponOmciStatsObject is used internally to represent GponOmciStatsObject */
typedef GponOmciStatsObject _GponOmciStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.
 *
 * MDMOID_CTOAM 331
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    UINT32    portID;	/**< PortID */
#endif
} CTOAMObject;

/*! \brief _CTOAMObject is used internally to represent CTOAMObject */
typedef CTOAMObject _CTOAMObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.IADInfo.
 *
 * MDMOID_OAMIAD_INFO 332
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< Branch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< Leaf */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< VariableWidth */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  MACAddress;	/**< MACAddress */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    protocolSupported;	/**< ProtocolSupported */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  iadSoftwareVersion;	/**< IadSoftwareVersion */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  iadSoftwaretime;	/**< IadSoftwaretime */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voipUserCount;	/**< VoipUserCount */
#endif
} OAMIADInfoObject;

/*! \brief _OAMIADInfoObject is used internally to represent OAMIADInfoObject */
typedef OAMIADInfoObject _OAMIADInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.GlobalParameterConfig.
 *
 * MDMOID_OAM_GLB_PARAM_CFG 333
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< Branch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< Leaf */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< VariableWidth */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceIpMode;	/**< VoiceIpMode */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    ipAddr;	/**< iadIpAddr */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    netMask;	/**< iadNetMask */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    defaultGW;	/**< iadDefaultGW */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    PPPoEMode;	/**< PPPoEMode */
#endif
#ifdef DMP_ENDPOINT_1
    char *    PPPOEusername;	/**< PPPOEusername */
#endif
#ifdef DMP_ENDPOINT_1
    BASE64    PPPOEpassword;	/**< PPPOEpassword */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    taggedflag;	/**< Taggedflag */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceCVlan;	/**< VoiceCVlan */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceSVlan;	/**< VoiceSVlan */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voicePriority;	/**< VoicePriority */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    status;	/**< Status */
#endif
} OAMGlbParamCfgObject;

/*! \brief _OAMGlbParamCfgObject is used internally to represent OAMGlbParamCfgObject */
typedef OAMGlbParamCfgObject _OAMGlbParamCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.SIPParameterConfig.
 *
 * MDMOID_OAMSIP_PARAM_CFG 334
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< Branch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< Leaf */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< VariableWidth */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    MGPortNo;	/**< MGPortNo */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipProxyServIp;	/**< SipProxyServIp */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipProxyServComPortNo;	/**< SipProxyServComPortNo */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backupSipProxyServIp;	/**< BackupSipProxyServIp */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backUpSipProxyServComPortNo;	/**< BackUpSipProxyServComPortNo */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    activeSipProxyServer;	/**< ActiveSipProxyServer */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipRegServIP;	/**< SipRegServIP */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipRegServComPortNo;	/**< SipRegServComPortNo */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backupSipRegServIp;	/**< BackupSipRegServIp */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backupSipRegServComPortNo;	/**< BackupSipRegServComPortNo */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    outBoundServPortIP;	/**< OutBoundServPortIP */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    outBoundServPortNo;	/**< OutBoundServPortNo */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipRegIntervalSIP;	/**< SipRegIntervalSIP */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    heartbeatSwitch;	/**< HeartbeatSwitch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    heartbeatCycle;	/**< HeartbeatCycle */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    heartbeatCount;	/**< HeartbeatCount */
#endif
} OAMSIPParamCfgObject;

/*! \brief _OAMSIPParamCfgObject is used internally to represent OAMSIPParamCfgObject */
typedef OAMSIPParamCfgObject _OAMSIPParamCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.SIPUserParameterConfig.
 *
 * MDMOID_OAMSIP_USR_PARAM_CFG 335
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< Branch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< Leaf */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< VariableWidth */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  userAccount;	/**< UserAccount */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  username;	/**< Username */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  userPassword;	/**< UserPassword */
#endif
} OAMSIPUsrParamCfgObject;

/*! \brief _OAMSIPUsrParamCfgObject is used internally to represent OAMSIPUsrParamCfgObject */
typedef OAMSIPUsrParamCfgObject _OAMSIPUsrParamCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.FAXModemConfig.
 *
 * MDMOID_OAMFAXMD_CFG 336
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< Branch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< Leaf */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< VariableWidth */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceT38Enable;	/**< VoiceT38Enable */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceFaxModemControl;	/**< VoiceFaxModemControl */
#endif
} OAMFAXMDCfgObject;

/*! \brief _OAMFAXMDCfgObject is used internally to represent OAMFAXMDCfgObject */
typedef OAMFAXMDCfgObject _OAMFAXMDCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.POTSStatus.
 *
 * MDMOID_OAMPOTS_STS 337
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< Branch */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< Leaf */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< VariableWidth */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    IADPortStatus;	/**< IADPortStatus */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    portServiceState;	/**< iadPortServiceState */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    portCodecMode;	/**< iadPortCodecMode */
#endif
} OAMPOTSStsObject;

/*! \brief _OAMPOTSStsObject is used internally to represent OAMPOTSStsObject */
typedef OAMPOTSStsObject _OAMPOTSStsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.IADOperation.
 *
 * MDMOID_OAMIAD_OP 338
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    UINT32    operation;	/**< iadOperation */
#endif
} OAMIADOpObject;

/*! \brief _OAMIADOpObject is used internally to represent OAMIADOpObject */
typedef OAMIADOpObject _OAMIADOpObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.SIPDigitMap.
 *
 * MDMOID_OAMSIP_DGT_MP 339
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    char *    SIPDigitalMap;	/**< SIPDigitalMap */
#endif
} OAMSIPDgtMpObject;

/*! \brief _OAMSIPDgtMpObject is used internally to represent OAMSIPDgtMpObject */
typedef OAMSIPDgtMpObject _OAMSIPDgtMpObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.
 *
 * MDMOID_SW_MODULES 340
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    execEnvNumberOfEntries;	/**< ExecEnvNumberOfEntries */
    UINT32    deploymentUnitNumberOfEntries;	/**< DeploymentUnitNumberOfEntries */
    UINT32    executionUnitNumberOfEntries;	/**< ExecutionUnitNumberOfEntries */
} SwModulesObject;

/*! \brief _SwModulesObject is used internally to represent SwModulesObject */
typedef SwModulesObject _SwModulesObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.
 *
 * MDMOID_EU 341
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    EUID;	/**< EUID */
    char *    alias;	/**< Alias */
    char *    name;	/**< Name */
    char *    execEnvLabel;	/**< ExecEnvLabel */
    char *    status;	/**< Status */
    char *    requestedState;	/**< RequestedState */
    char *    executionFaultCode;	/**< ExecutionFaultCode */
    char *    executionFaultMessage;	/**< ExecutionFaultMessage */
    UBOOL8    autoStart;	/**< AutoStart */
    UINT32    runLevel;	/**< RunLevel */
    char *    vendor;	/**< Vendor */
    char *    version;	/**< Version */
    char *    description;	/**< Description */
    SINT32    diskSpaceInUse;	/**< DiskSpaceInUse */
    SINT32    memoryInUse;	/**< MemoryInUse */
    char *    vendorLogList;	/**< VendorLogList */
    char *    vendorConfigList;	/**< VendorConfigList */
    char *    executionEnvRef;	/**< ExecutionEnvRef */
} EUObject;

/*! \brief _EUObject is used internally to represent EUObject */
typedef EUObject _EUObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.
 *
 * MDMOID_EXTENSIONS 342
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} ExtensionsObject;

/*! \brief _ExtensionsObject is used internally to represent ExtensionsObject */
typedef ExtensionsObject _ExtensionsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.
 *
 * MDMOID_EXEC_ENV 343
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    UBOOL8    reset;	/**< Reset */
    char *    alias;	/**< Alias */
    char *    name;	/**< Name */
    char *    type;	/**< Type */
    UINT32    initialRunLevel;	/**< InitialRunLevel */
    SINT32    requestedRunLevel;	/**< RequestedRunLevel */
    SINT32    currentRunLevel;	/**< CurrentRunLevel */
    char *    vendor;	/**< Vendor */
    char *    version;	/**< Version */
    char *    parentExecEnv;	/**< ParentExecEnv */
    SINT32    allocatedDiskSpace;	/**< AllocatedDiskSpace */
    SINT32    availableDiskSpace;	/**< AvailableDiskSpace */
    SINT32    allocatedMemory;	/**< AllocatedMemory */
    SINT32    availableMemory;	/**< AvailableMemory */
    char *    associatedExecutionUnits;	/**< AssociatedExecutionUnits */
    char *    activeExecutionUnits;	/**< ActiveExecutionUnits */
} ExecEnvObject;

/*! \brief _ExecEnvObject is used internally to represent ExecEnvObject */
typedef ExecEnvObject _ExecEnvObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.DeploymentUnit.{i}.
 *
 * MDMOID_DU 344
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    UUID;	/**< UUID */
    char *    DUID;	/**< DUID */
    char *    alias;	/**< Alias */
    char *    name;	/**< Name */
    char *    status;	/**< Status */
    UBOOL8    resolved;	/**< Resolved */
    char *    URL;	/**< URL */
    char *    description;	/**< Description */
    char *    vendor;	/**< Vendor */
    char *    version;	/**< Version */
    char *    vendorLogList;	/**< VendorLogList */
    char *    vendorConfigList;	/**< VendorConfigList */
    char *    executionUnitList;	/**< ExecutionUnitList */
    char *    executionEnvref;	/**< ExecutionEnvref */
    char *    faultMessage;	/**< FaultMessage */
    DATETIME  X_BROADCOM_COM_startTime;	/**< X_BROADCOM_COM_startTime */
    DATETIME  X_BROADCOM_COM_completeTime;	/**< X_BROADCOM_COM_completeTime */
} DUObject;

/*! \brief _DUObject is used internally to represent DUObject */
typedef DUObject _DUObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.
 *
 * MDMOID_DEVICE 345
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} DeviceObject;

/*! \brief _DeviceObject is used internally to represent DeviceObject */
typedef DeviceObject _DeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Optical.
 *
 * MDMOID_DEVICE_OPTICAL 346
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    interfaceNumberOfEntries;	/**< InterfaceNumberOfEntries */
} DeviceOpticalObject;

/*! \brief _DeviceOpticalObject is used internally to represent DeviceOpticalObject */
typedef DeviceOpticalObject _DeviceOpticalObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Optical.Interface.{i}.
 *
 * MDMOID_OPTICAL_INTERFACE 347
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    enable;	/**< Enable */
    char *    status;	/**< Status */
    char *    name;	/**< Name */
    SINT32    opticalSignalLevel;	/**< OpticalSignalLevel */
    SINT32    transmitOpticalLevel;	/**< TransmitOpticalLevel */
} OpticalInterfaceObject;

/*! \brief _OpticalInterfaceObject is used internally to represent OpticalInterfaceObject */
typedef OpticalInterfaceObject _OpticalInterfaceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Optical.Interface.{i}.Stats.
 *
 * MDMOID_OPTICAL_INTERFACE_STATS 348
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT64    bytesSent;	/**< BytesSent */
    UINT64    bytesReceived;	/**< BytesReceived */
    UINT64    packetsSent;	/**< PacketsSent */
    UINT64    packetsReceived;	/**< PacketsReceived */
    UINT32    errorsSent;	/**< ErrorsSent */
    UINT32    errorsReceived;	/**< ErrorsReceived */
    UINT32    discardPacketsSent;	/**< DiscardPacketsSent */
    UINT32    discardPacketsReceived;	/**< DiscardPacketsReceived */
} OpticalInterfaceStatsObject;

/*! \brief _OpticalInterfaceStatsObject is used internally to represent OpticalInterfaceStatsObject */
typedef OpticalInterfaceStatsObject _OpticalInterfaceStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_AppImageInfo.
 *
 * MDMOID_APP_IMAGE_INFO 349
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    nbrAppPartitions;	/**< NbrAppPartitions */
    UBOOL8    appImage1Valid;	/**< AppImage1Valid */
    char *    appImage1Name;	/**< AppImage1Name */
    char *    appImage1Version;	/**< AppImage1Version */
    char *    appImage1MD5Sum;	/**< AppImage1MD5Sum */
    UBOOL8    appImage2Valid;	/**< AppImage2Valid */
    char *    appImage2Name;	/**< AppImage2Name */
    char *    appImage2Version;	/**< AppImage2Version */
    char *    appImage2MD5Sum;	/**< AppImage2MD5Sum */
    UBOOL8    bootableAppPartition;	/**< BootableAppPartition */
    UINT32    bootedAppPartition;	/**< BootedAppPartition */
    char *    runningAppImage;	/**< RunningAppImage */
    char *    startupConfig;	/**< StartupConfig */
    UINT32    userCfgSeqNbr;	/**< UserCfgSeqNbr */
    UINT32    smdMinUpTime;	/**< SmdMinUpTime */
    UBOOL8    disableDefaultButton;	/**< DisableDefaultButton */
    char *    deleteConfigFile;	/**< DeleteConfigFile */
    char *    recoveryServer;	/**< RecoveryServer */
    char *    recoveryFilename;	/**< RecoveryFilename */
    char *    recoveryCrc;	/**< RecoveryCrc */
    char *    recoveryVlan;	/**< RecoveryVlan */
} AppImageInfoObject;

/*! \brief _AppImageInfoObject is used internally to represent AppImageInfoObject */
typedef AppImageInfoObject _AppImageInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_CliCommand.
 *
 * MDMOID_CLI_COMMAND 350
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    linuxCliCommand;	/**< LinuxCliCommand */
} CliCommandObject;

/*! \brief _CliCommandObject is used internally to represent CliCommandObject */
typedef CliCommandObject _CliCommandObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_SmokingGun.
 *
 * MDMOID_SMOKING_GUN 351
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    nvramParams;	/**< NvramParams */
    char *    bcmVersion;	/**< BcmVersion */
} SmokingGunObject;

/*! \brief _SmokingGunObject is used internally to represent SmokingGunObject */
typedef SmokingGunObject _SmokingGunObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_LoginCfg.
 *
 * MDMOID_ATI_LOGIN_CFG 352
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    privilegePwd;	/**< PrivilegePwd */
    UINT32    timeOut;	/**< TimeOut */
    UINT32    timeOutSeconds;	/**< TimeOutSeconds */
    UBOOL8    disableSlaveUSBConsole;	/**< DisableSlaveUSBConsole */
    char *    slaveUSBConsoleIPAddress;	/**< SlaveUSBConsoleIPAddress */
    UBOOL8    usbMasterEnabled;	/**< UsbMasterEnabled */
#ifdef DMP_X_ALLIEDTELESIS_COM_SFPPLUGGABLE_1
    UBOOL8    atiSfpDisable;	/**< AtiSfpDisable */
#endif
} AtiLoginCfgObject;

/*! \brief _AtiLoginCfgObject is used internally to represent AtiLoginCfgObject */
typedef AtiLoginCfgObject _AtiLoginCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_LoginCfg.UserCfg.{i}.
 *
 * MDMOID_USER_CFG 353
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    username;	/**< Username */
    char *    password;	/**< Password */
    UINT32    privilege;	/**< Privilege */
} UserCfgObject;

/*! \brief _UserCfgObject is used internally to represent UserCfgObject */
typedef UserCfgObject _UserCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_AvailableServicesCfg.
 *
 * MDMOID_ATI_SERVICE_CFG 354
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
} AtiServiceCfgObject;

/*! \brief _AtiServiceCfgObject is used internally to represent AtiServiceCfgObject */
typedef AtiServiceCfgObject _AtiServiceCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_AvailableServicesCfg.PortCfg.{i}.
 *
 * MDMOID_PORT_CFG 355
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    port;	/**< Port */
    UBOOL8    enable;	/**< Enable */
} PortCfgObject;

/*! \brief _PortCfgObject is used internally to represent PortCfgObject */
typedef PortCfgObject _PortCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_AccessRestriction.
 *
 * MDMOID_ACC_REST 356
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    isTCPMSSSet;	/**< IsTCPMSSSet */
    char *    mgmtSubnetList;	/**< MgmtSubnetList */
} AccRestObject;

/*! \brief _AccRestObject is used internally to represent AccRestObject */
typedef AccRestObject _AccRestObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_AccessRestriction.AccessList.{i}.
 *
 * MDMOID_ACC_LIST 357
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    SINT32    name;	/**< Name */
    char *    protocol;	/**< Protocol */
    UINT32    port;	/**< Port */
    char *    IPAddress;	/**< IPAddress */
    char *    netMask;	/**< NetMask */
    char *    vlanIdList;	/**< VlanIdList */
    UINT32    srcStartPort;	/**< SrcStartPort */
    UINT32    srcEndPort;	/**< SrcEndPort */
    UINT32    dstStartPort;	/**< DstStartPort */
    UINT32    dstEndPort;	/**< DstEndPort */
    char *    srcIPAddress;	/**< SrcIPAddress */
    char *    srcNetMask;	/**< SrcNetMask */
    char *    dstIPAddress;	/**< DstIPAddress */
    char *    dstNetMask;	/**< DstNetMask */
} AccListObject;

/*! \brief _AccListObject is used internally to represent AccListObject */
typedef AccListObject _AccListObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_AccessRestriction.Ipv6AccessList.{i}.
 *
 * MDMOID_IPV6_ACL 358
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    name;	/**< Name */
    char *    protocol;	/**< Protocol */
    UINT32    srcStartPort;	/**< SrcStartPort */
    UINT32    srcEndPort;	/**< SrcEndPort */
    UINT32    dstStartPort;	/**< DstStartPort */
    UINT32    dstEndPort;	/**< DstEndPort */
    char *    srcIPAddr;	/**< SrcIPAddr */
    char *    dstIPAddr;	/**< DstIPAddr */
} Ipv6AclObject;

/*! \brief _Ipv6AclObject is used internally to represent Ipv6AclObject */
typedef Ipv6AclObject _Ipv6AclObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_HpnaNetwork.
 *
 * MDMOID_HPNA_NETWORK 359
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    updateEndpointList;	/**< UpdateEndpointList */
    UBOOL8    runCert;	/**< RunCert */
    UINT32    certFrames;	/**< CertFrames */
    char *    certNodeMac;	/**< CertNodeMac */
    UBOOL8    certError;	/**< CertError */
    UINT32    hpnaNetworkNodeNumberOfEntries;	/**< HpnaNetworkNodeNumberOfEntries */
    UINT64    endpointUpdateTime;	/**< EndpointUpdateTime */
    UINT64    certUpdateTime;	/**< CertUpdateTime */
    char *    ifName;	/**< IfName */
    UBOOL8    accessVlanPortMode;	/**< AccessVlanPortMode */
} HpnaNetworkObject;

/*! \brief _HpnaNetworkObject is used internally to represent HpnaNetworkObject */
typedef HpnaNetworkObject _HpnaNetworkObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_HpnaNetwork.HpnaNetworkNode.{i}.
 *
 * MDMOID_HPNA_NETWORK_NODE 360
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    macAddress;	/**< MacAddress */
    UINT32    hpnaCertResultNumberOfEntries;	/**< HpnaCertResultNumberOfEntries */
    UBOOL8    master;	/**< Master */
    char *    version;	/**< Version */
    UBOOL8    link;	/**< Link */
    UBOOL8    sync;	/**< Sync */
    char *    hwProfile;	/**< HwProfile */
} HpnaNetworkNodeObject;

/*! \brief _HpnaNetworkNodeObject is used internally to represent HpnaNetworkNodeObject */
typedef HpnaNetworkNodeObject _HpnaNetworkNodeObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_HpnaNetwork.HpnaNetworkNode.{i}.HpnaCertResult.{i}.
 *
 * MDMOID_HPNA_CERT_RESULT 361
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    rxMacAddress;	/**< RxMacAddress */
    UINT32    framesSent;	/**< FramesSent */
    UINT32    framesReceived;	/**< FramesReceived */
    SINT32    signalToNoiseRatio;	/**< SignalToNoiseRatio */
    SINT32    rxPower;	/**< RxPower */
    UINT32    rate;	/**< Rate */
} HpnaCertResultObject;

/*! \brief _HpnaCertResultObject is used internally to represent HpnaCertResultObject */
typedef HpnaCertResultObject _HpnaCertResultObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_HpnaNetwork.HpnaNetworkNode.{i}.HpnaStats.
 *
 * MDMOID_HPNA_STATS 362
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UBOOL8    updateStatistics;	/**< UpdateStatistics */
    UBOOL8    resetStatistics;	/**< ResetStatistics */
    UINT32    txPkt;	/**< TxPkt */
    UINT32    txPktBase;	/**< TxPktBase */
    UINT32    rxPkt;	/**< RxPkt */
    UINT32    rxPktBase;	/**< RxPktBase */
    UINT32    txBroadcast;	/**< TxBroadcast */
    UINT32    txBroadcastBase;	/**< TxBroadcastBase */
    UINT32    rxBroadcast;	/**< RxBroadcast */
    UINT32    rxBroadcastBase;	/**< RxBroadcastBase */
    UINT32    txMulticast;	/**< TxMulticast */
    UINT32    txMulticastBase;	/**< TxMulticastBase */
    UINT32    rxMulticast;	/**< RxMulticast */
    UINT32    rxMulticastBase;	/**< RxMulticastBase */
    UINT32    rxCrc;	/**< RxCrc */
    UINT32    rxCrcBase;	/**< RxCrcBase */
    UINT32    rxHostCrc;	/**< RxHostCrc */
    UINT32    rxHostCrcBase;	/**< RxHostCrcBase */
    UINT32    rxShort;	/**< RxShort */
    UINT32    rxShortBase;	/**< RxShortBase */
    UINT32    txShort;	/**< TxShort */
    UINT32    txShortBase;	/**< TxShortBase */
    UINT32    txDropped;	/**< TxDropped */
    UINT32    txDroppedBase;	/**< TxDroppedBase */
    UINT32    rxDropped;	/**< RxDropped */
    UINT32    rxDroppedBase;	/**< RxDroppedBase */
    UINT32    ctlReqPkt;	/**< CtlReqPkt */
    UINT32    ctlReqPktBase;	/**< CtlReqPktBase */
    UINT32    ctlReplPkt;	/**< CtlReplPkt */
    UINT32    ctlReplPktBase;	/**< CtlReplPktBase */
    UINT32    ctlRemoteReqPkt;	/**< CtlRemoteReqPkt */
    UINT32    ctlRemoteReqPktBase;	/**< CtlRemoteReqPktBase */
    UINT32    ctlRemoteReplPkt;	/**< CtlRemoteReplPkt */
    UINT32    ctlRemoteReplPktBase;	/**< CtlRemoteReplPktBase */
    UINT32    txPercentPerCycle;	/**< TxPercentPerCycle */
    UINT32    idlePercentPerCycle;	/**< IdlePercentPerCycle */
    UINT32    txPercentAvg;	/**< TxPercentAvg */
    UINT32    idlePercentAvg;	/**< IdlePercentAvg */
    UINT64    txByte;	/**< TxByte */
    UINT64    txByteBase;	/**< TxByteBase */
    UINT64    rxByte;	/**< RxByte */
    UINT64    rxByteBase;	/**< RxByteBase */
} HpnaStatsObject;

/*! \brief _HpnaStatsObject is used internally to represent HpnaStatsObject */
typedef HpnaStatsObject _HpnaStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_SharedMemory.
 *
 * MDMOID_SHM 363
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    extraSize;	/**< ExtraSize */
} ShmObject;

/*! \brief _ShmObject is used internally to represent ShmObject */
typedef ShmObject _ShmObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_802dot11Config.
 *
 * MDMOID_DOT11_CONFIG 364
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT32    dot11RadioNumberOfEntries;	/**< Dot11RadioNumberOfEntries */
    UINT32    globalSSIDNumberOfEntries;	/**< GlobalSSIDNumberOfEntries */
    UBOOL8    wirelessButtonStatus;	/**< WirelessButtonStatus */
    UBOOL8    splitMgtEnableWEP;	/**< SplitMgtEnableWEP */
} Dot11ConfigObject;

/*! \brief _Dot11ConfigObject is used internally to represent Dot11ConfigObject */
typedef Dot11ConfigObject _Dot11ConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_802dot11Config.Radio.{i}.
 *
 * MDMOID_DOT11_RADIO 365
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    ifName;	/**< IfName */
    UINT32    channel;	/**< Channel */
    char *    radio;	/**< Radio */
    char *    driverVersion;	/**< DriverVersion */
    char *    hostapdVersion;	/**< HostapdVersion */
    UBOOL8    radioEnabled;	/**< RadioEnabled */
    char *    countryList;	/**< CountryList */
    char *    possibleChannels;	/**< PossibleChannels */
    char *    regulatoryDomain;	/**< RegulatoryDomain */
    char *    WEPEncryptionLevel;	/**< WEPEncryptionLevel */
    char *    currentStandard;	/**< CurrentStandard */
    char *    supportedStandards;	/**< SupportedStandards */
    UBOOL8    autoChannelEnable;	/**< AutoChannelEnable */
} Dot11RadioObject;

/*! \brief _Dot11RadioObject is used internally to represent Dot11RadioObject */
typedef Dot11RadioObject _Dot11RadioObject;



/*! \brief Obj struct for InternetGatewayDevice.X_ALLIEDTELESIS_COM_802dot11Config.GlobalSSID.{i}.
 *
 * MDMOID_SSI_D 366
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    char *    SSID;	/**< SSID */
    char *    beaconType;	/**< BeaconType */
    char *    basicAuthenticationMode;	/**< BasicAuthenticationMode */
    char *    WPAAuthenticationMode;	/**< WPAAuthenticationMode */
    char *    IEEE11iAuthenticationMode;	/**< IEEE11iAuthenticationMode */
    char *    macAddrControl;	/**< MacAddrControl */
    char *    macBlackList;	/**< MacBlackList */
    char *    macWhiteList;	/**< MacWhiteList */
    UBOOL8    isolateClients;	/**< IsolateClients */
    SINT32    maxAssociations;	/**< MaxAssociations */
    UBOOL8    hideSSID;	/**< HideSSID */
    UINT32    VLANID;	/**< VLANID */
    char *    preSharedKey;	/**< PreSharedKey */
    char *    keyPassphrase;	/**< KeyPassphrase */
} Dot11SSIDObject;

/*! \brief _Dot11SSIDObject is used internally to represent Dot11SSIDObject */
typedef Dot11SSIDObject _Dot11SSIDObject;





#endif /* __MDM_OBJECT_H__ */
