#ifndef OS_ATI_CLIENT_h
#define OS_ATI_CLIENT_h

/// 
/// @file os_ati_client.h
/// 
/// This file declares the functions used to communicate with the ATI Voice server
/// 

#ifndef GWA_OS_CLIENT_PORT
#define GWA_OS_CLIENT_PORT 54321
#endif

#ifndef GWA_OS_STR_CLIENT_PORT
#define GWA_OS_STR_CLIENT_PORT1_(x) #x
#define GWA_OS_STR_CLIENT_PORT_(x)  GWA_OS_STR_CLIENT_PORT1_(x)
#define GWA_OS_STR_CLIENT_PORT      GWA_OS_STR_CLIENT_PORT_(GWA_OS_CLIENT_PORT)
#endif

/// 
/// Enumeration defining the return values
/// 
typedef enum
{
    Eati_voiceClient_SERVER_CMD_FATAL     = -3,
    Eati_voiceClient_SERVER_FATAL         = -2,
    Eati_voiceClient_CLIENT_FATAL         = -1,
    Eati_voiceClient_SUCCESS              = 0,
    Eati_voiceClient_DISCONNECTED         = 1,
    Eati_voiceClient_SERVER_CMD_NON_FATAL = 2,
} Tati_voiceClient_ErrorCode;

/***************************************************************************//**
 *
 * This function opens and initializes the connection with the voice server.
 *
 * @return
 *    ZERO - SUCCESS
 * @return
 *    NON-ZERO - Failure
 *
 ******************************************************************************/
int Fati_voiceOpenConnection(void);

/***************************************************************************//**
 *
 * This function closes the connection with the voice server. It also closes
 * down the socket.
 *
 * @return
 *    ZERO - SUCCESS
 * @return
 *    NON-ZERO - Failure
 *
 ******************************************************************************/
int Fati_voiceCloseConnection(void);

/***************************************************************************//**
 *
 * This function sends a command to over the supplied socket and waits for a
 * response
 *
 * @param s
 *    The socket over which to send the command
 * @param cmd
 *    A buffer containing the requested command
 * @param rsp
 *    A buffer where the response can be placed
 * @param rspLen
 *    The length of the response buffer
 * @param useEom
 *    Utilize the end of message marker
 *
 * @return
 *    ZERO - SUCCESS
 * @return
 *    < 0  - FATAL Error
 * @return
 *    > 0  - NON-FATAL Error
 *
 ******************************************************************************/
int Fati_voiceSendRecv(int s, const char* cmd, char* rsp, int rspLen, int useEom);

/***************************************************************************//**
 *
 * This function submits a command to the voice server and waits for the result.
 *
 * @param cmd
 *    The command to transmit to the voice server
 * @param rspBuffer
 *    A buffer in which we can store the response from the voice server
 * @param rspBufferSize
 *    The byte size of the response buffer
 *
 * @return
 *    ZERO - SUCCESS
 * @return
 *    < 0  - FATAL Error
 * @return
 *    > 0  - NON-FATAL Error
 *
 ******************************************************************************/
Tati_voiceClient_ErrorCode Fati_voiceSubmitCommand(const char* cmd, char* rspBuffer, unsigned int rspBufferSize);

/***************************************************************************//**
 *
 * This function returns the general severity of a response from the TR104 module
 *
 * @param rspBuffer
 *    A string containing the response
 *
 * @return
 *    ZERO - SUCCESS
 * @return
 *    < 0  - FATAL Error
 * @return
 *    > 0  - NON-FATAL Error
 *
 ******************************************************************************/
Tati_voiceClient_ErrorCode Fati_voiceGetCmdResponseCat( const char* rspBuffer );

#endif
